/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.FeatureList;
import jogamp.graph.font.typecast.ot.table.LigatureSubst;
import jogamp.graph.font.typecast.ot.table.LookupList;
import jogamp.graph.font.typecast.ot.table.LookupSubtable;
import jogamp.graph.font.typecast.ot.table.LookupSubtableFactory;
import jogamp.graph.font.typecast.ot.table.ScriptList;
import jogamp.graph.font.typecast.ot.table.SingleSubst;
import jogamp.graph.font.typecast.ot.table.Table;

public class GsubTable
implements Table,
LookupSubtableFactory {
    private final DirectoryEntry _de;
    private final ScriptList _scriptList;
    private final FeatureList _featureList;
    private final LookupList _lookupList;

    protected GsubTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        byte[] byArray = new byte[directoryEntry.getLength()];
        dataInput.readFully(byArray);
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        dataInputStream.readInt();
        int n2 = dataInputStream.readUnsignedShort();
        int n3 = dataInputStream.readUnsignedShort();
        int n4 = dataInputStream.readUnsignedShort();
        this._scriptList = new ScriptList(dataInputStream, n2);
        this._featureList = new FeatureList(dataInputStream, n3);
        this._lookupList = new LookupList(dataInputStream, n4, this);
    }

    @Override
    public LookupSubtable read(int n2, DataInputStream dataInputStream, int n3) throws IOException {
        LookupSubtable lookupSubtable = null;
        switch (n2) {
            case 1: {
                lookupSubtable = SingleSubst.read(dataInputStream, n3);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                lookupSubtable = LigatureSubst.read(dataInputStream, n3);
                break;
            }
            case 5: {
                break;
            }
        }
        return lookupSubtable;
    }

    @Override
    public int getType() {
        return 1196643650;
    }

    public ScriptList getScriptList() {
        return this._scriptList;
    }

    public FeatureList getFeatureList() {
        return this._featureList;
    }

    public LookupList getLookupList() {
        return this._lookupList;
    }

    public String toString() {
        return "GSUB";
    }

    public static String lookupTypeAsString(int n2) {
        switch (n2) {
            case 1: {
                return "Single";
            }
            case 2: {
                return "Multiple";
            }
            case 3: {
                return "Alternate";
            }
            case 4: {
                return "Ligature";
            }
            case 5: {
                return "Context";
            }
            case 6: {
                return "Chaining";
            }
        }
        return "Unknown";
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

