/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;

public class LangSys {
    private final int _lookupOrder;
    private final int _reqFeatureIndex;
    private final int _featureCount;
    private final int[] _featureIndex;

    protected LangSys(DataInput dataInput) throws IOException {
        this._lookupOrder = dataInput.readUnsignedShort();
        this._reqFeatureIndex = dataInput.readUnsignedShort();
        this._featureCount = dataInput.readUnsignedShort();
        this._featureIndex = new int[this._featureCount];
        for (int i2 = 0; i2 < this._featureCount; ++i2) {
            this._featureIndex[i2] = dataInput.readUnsignedShort();
        }
    }

    public int getLookupOrder() {
        return this._lookupOrder;
    }

    public int getReqFeatureIndex() {
        return this._reqFeatureIndex;
    }

    public int getFeatureCount() {
        return this._featureCount;
    }

    public int getFeatureIndex(int n2) {
        return this._featureIndex[n2];
    }

    protected boolean isFeatureIndexed(int n2) {
        for (int i2 = 0; i2 < this._featureCount; ++i2) {
            if (this._featureIndex[i2] != n2) continue;
            return true;
        }
        return false;
    }
}

