/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Coverage;
import jogamp.graph.font.typecast.ot.table.SingleSubst;

public class SingleSubstFormat2
extends SingleSubst {
    private final int _coverageOffset;
    private final int _glyphCount;
    private final int[] _substitutes;
    private final Coverage _coverage;

    protected SingleSubstFormat2(DataInputStream dataInputStream, int n2) throws IOException {
        this._coverageOffset = dataInputStream.readUnsignedShort();
        this._glyphCount = dataInputStream.readUnsignedShort();
        this._substitutes = new int[this._glyphCount];
        for (int i2 = 0; i2 < this._glyphCount; ++i2) {
            this._substitutes[i2] = dataInputStream.readUnsignedShort();
        }
        dataInputStream.reset();
        dataInputStream.skipBytes(n2 + this._coverageOffset);
        this._coverage = Coverage.read(dataInputStream);
    }

    @Override
    public int getFormat() {
        return 2;
    }

    @Override
    public int substitute(int n2) {
        int n3 = this._coverage.findGlyph(n2);
        if (n3 > -1) {
            return this._substitutes[n3];
        }
        return n2;
    }

    @Override
    public String getTypeAsString() {
        return "SingleSubstFormat2";
    }
}

