/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.ScalableSurface;
import com.jogamp.nativewindow.UpstreamSurfaceHook;
import com.jogamp.nativewindow.UpstreamSurfaceHookMutableSize;
import jogamp.nativewindow.ProxySurfaceImpl;
import jogamp.nativewindow.SurfaceScaleUtils;

public class WrappedSurface
extends ProxySurfaceImpl
implements ScalableSurface {
    private final float[] hasPixelScale = new float[]{1.0f, 1.0f};
    private long surfaceHandle;

    public WrappedSurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l2, int n2, int n3, boolean bl) {
        super(abstractGraphicsConfiguration, new UpstreamSurfaceHookMutableSize(n2, n3), bl);
        this.surfaceHandle = l2;
    }

    public WrappedSurface(AbstractGraphicsConfiguration abstractGraphicsConfiguration, long l2, UpstreamSurfaceHook upstreamSurfaceHook, boolean bl) {
        super(abstractGraphicsConfiguration, upstreamSurfaceHook, bl);
        this.surfaceHandle = l2;
    }

    @Override
    protected void invalidateImpl() {
        this.surfaceHandle = 0L;
        this.hasPixelScale[0] = 1.0f;
        this.hasPixelScale[1] = 1.0f;
    }

    @Override
    public final long getSurfaceHandle() {
        return this.surfaceHandle;
    }

    @Override
    public final void setSurfaceHandle(long l2) {
        this.surfaceHandle = l2;
    }

    @Override
    protected final int lockSurfaceImpl() {
        return 3;
    }

    @Override
    protected final void unlockSurfaceImpl() {
    }

    @Override
    public final int[] convertToWindowUnits(int[] nArray) {
        return SurfaceScaleUtils.scaleInv(nArray, nArray, this.hasPixelScale);
    }

    @Override
    public final int[] convertToPixelUnits(int[] nArray) {
        return SurfaceScaleUtils.scale(nArray, nArray, this.hasPixelScale);
    }

    @Override
    public final boolean setSurfaceScale(float[] fArray) {
        boolean bl = this.hasPixelScale[0] != fArray[0] || this.hasPixelScale[1] != fArray[1];
        System.arraycopy(fArray, 0, this.hasPixelScale, 0, 2);
        return bl;
    }

    @Override
    public final float[] getRequestedSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getCurrentSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public float[] getMinimumSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }

    @Override
    public final float[] getMaximumSurfaceScale(float[] fArray) {
        System.arraycopy(this.hasPixelScale, 0, fArray, 0, 2);
        return fArray;
    }
}

