/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.jawt.macosx;

import com.jogamp.common.util.PropertyAccess;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.Capabilities;
import com.jogamp.nativewindow.MutableSurface;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.awt.JAWTWindow;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.nio.Buffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import jogamp.nativewindow.Debug;
import jogamp.nativewindow.awt.AWTMisc;
import jogamp.nativewindow.jawt.JAWT;
import jogamp.nativewindow.jawt.JAWTUtil;
import jogamp.nativewindow.jawt.JAWT_DrawingSurface;
import jogamp.nativewindow.jawt.JAWT_DrawingSurfaceInfo;
import jogamp.nativewindow.jawt.macosx.JAWT_MacOSXDrawingSurfaceInfo;
import jogamp.nativewindow.macosx.OSXUtil;

public class MacOSXJAWTWindow
extends JAWTWindow
implements MutableSurface {
    private static final boolean DEBUG_CALAYER_POS_CRITICAL;
    private JAWT_DrawingSurface ds;
    private boolean dsLocked;
    private JAWT_DrawingSurfaceInfo dsi;
    private long jawtSurfaceLayersHandle;
    private JAWT_MacOSXDrawingSurfaceInfo macosxdsi;
    private volatile long rootSurfaceLayer = 0L;
    private long windowHandle = 0L;
    private long offscreenSurfaceDrawable = 0L;
    private boolean offscreenSurfaceDrawableSet = false;
    private boolean firstLock = true;

    public MacOSXJAWTWindow(Object object, AbstractGraphicsConfiguration abstractGraphicsConfiguration) {
        super(object, abstractGraphicsConfiguration);
        if (DEBUG) {
            this.dumpInfo();
        }
    }

    @Override
    protected void invalidateNative() {
        if (DEBUG) {
            System.err.println("MacOSXJAWTWindow.invalidateNative(): osh-enabled " + this.isOffscreenLayerSurfaceEnabled() + ", osd-set " + this.offscreenSurfaceDrawableSet + ", osd " + MacOSXJAWTWindow.toHexString(this.offscreenSurfaceDrawable) + ", osl " + MacOSXJAWTWindow.toHexString(this.getAttachedSurfaceLayer()) + ", rsl " + MacOSXJAWTWindow.toHexString(this.rootSurfaceLayer) + ", wh " + MacOSXJAWTWindow.toHexString(this.windowHandle) + " - " + Thread.currentThread().getName());
        }
        this.offscreenSurfaceDrawable = 0L;
        this.offscreenSurfaceDrawableSet = false;
        if (this.isOffscreenLayerSurfaceEnabled()) {
            if (0L != this.windowHandle) {
                OSXUtil.DestroyNSWindow(this.windowHandle);
            }
            OSXUtil.RunOnMainThread(false, true, new Runnable(){

                @Override
                public void run() {
                    if (0L != MacOSXJAWTWindow.this.rootSurfaceLayer) {
                        if (0L != MacOSXJAWTWindow.this.jawtSurfaceLayersHandle) {
                            MacOSXJAWTWindow.UnsetJAWTRootSurfaceLayer0(MacOSXJAWTWindow.this.jawtSurfaceLayersHandle, MacOSXJAWTWindow.this.rootSurfaceLayer);
                        }
                        OSXUtil.DestroyCALayer(MacOSXJAWTWindow.this.rootSurfaceLayer);
                        MacOSXJAWTWindow.this.rootSurfaceLayer = 0L;
                    }
                    MacOSXJAWTWindow.this.jawtSurfaceLayersHandle = 0L;
                }
            });
        }
        this.windowHandle = 0L;
    }

    @Override
    public boolean setSurfaceScale(float[] fArray) {
        super.setSurfaceScale(fArray);
        if (0L != this.getWindowHandle() && this.setReqPixelScale()) {
            if (0L != this.getAttachedSurfaceLayer()) {
                OSXUtil.RunOnMainThread(false, false, new Runnable(){

                    @Override
                    public void run() {
                        long l2 = MacOSXJAWTWindow.this.getAttachedSurfaceLayer();
                        if (0L != l2) {
                            OSXUtil.SetCALayerPixelScale(MacOSXJAWTWindow.this.rootSurfaceLayer, l2, MacOSXJAWTWindow.this.getPixelScaleX());
                        }
                    }
                });
            }
            return true;
        }
        return false;
    }

    @Override
    protected void attachSurfaceLayerImpl(final long l2) {
        OSXUtil.RunOnMainThread(false, false, new Runnable(){

            @Override
            public void run() {
                com.jogamp.nativewindow.util.Point point = new com.jogamp.nativewindow.util.Point();
                Component component = AWTMisc.getLocationOnScreenNonBlocking(point, MacOSXJAWTWindow.this.component, DEBUG);
                Insets insets = AWTMisc.getInsets(component, true);
                com.jogamp.nativewindow.util.Point point2 = (com.jogamp.nativewindow.util.Point)point.cloneMutable();
                point2.translate(-component.getX(), -component.getY());
                if (null != insets) {
                    point2.translate(-insets.left, -insets.top);
                }
                if (DEBUG_CALAYER_POS_CRITICAL) {
                    Point point3 = MacOSXJAWTWindow.this.component.getLocationOnScreen();
                    com.jogamp.nativewindow.util.Point point4 = new com.jogamp.nativewindow.util.Point(point3.x, point3.y);
                    point4.translate(-component.getX(), -component.getY());
                    if (null != insets) {
                        point4.translate(-insets.left, -insets.top);
                    }
                    System.err.println("JAWTWindow.attachSurfaceLayerImpl: " + MacOSXJAWTWindow.toHexString(l2) + ", [ins " + insets + "], pA " + point3 + " -> " + point4 + ", p0 " + point + " -> " + point2 + ", bounds " + MacOSXJAWTWindow.this.bounds);
                } else if (DEBUG) {
                    System.err.println("JAWTWindow.attachSurfaceLayerImpl: " + MacOSXJAWTWindow.toHexString(l2) + ", [ins " + insets + "], p0 " + point + " -> " + point2 + ", bounds " + MacOSXJAWTWindow.this.bounds);
                }
                OSXUtil.AddCASublayer(MacOSXJAWTWindow.this.rootSurfaceLayer, l2, point2.getX(), point2.getY(), MacOSXJAWTWindow.this.getWidth(), MacOSXJAWTWindow.this.getHeight(), MacOSXJAWTWindow.this.getPixelScaleX(), JAWTUtil.getOSXCALayerQuirks());
            }
        });
    }

    @Override
    protected void layoutSurfaceLayerImpl(long l2, boolean bl) {
        int n2 = JAWTUtil.getOSXCALayerQuirks();
        com.jogamp.nativewindow.util.Point point = new com.jogamp.nativewindow.util.Point();
        Component component = AWTMisc.getLocationOnScreenNonBlocking(point, this.component, DEBUG);
        Insets insets = AWTMisc.getInsets(component, true);
        com.jogamp.nativewindow.util.Point point2 = (com.jogamp.nativewindow.util.Point)point.cloneMutable();
        point2.translate(-component.getX(), -component.getY());
        if (null != insets) {
            point2.translate(-insets.left, -insets.top);
        }
        if (DEBUG_CALAYER_POS_CRITICAL) {
            Point point3 = this.component.getLocationOnScreen();
            com.jogamp.nativewindow.util.Point point4 = new com.jogamp.nativewindow.util.Point(point3.x, point3.y);
            point4.translate(-component.getX(), -component.getY());
            if (null != insets) {
                point4.translate(-insets.left, -insets.top);
            }
            System.err.println("JAWTWindow.layoutSurfaceLayerImpl: " + MacOSXJAWTWindow.toHexString(l2) + ", quirks " + n2 + ", visible " + bl + ", [ins " + insets + "], pA " + point3 + " -> " + point4 + ", p0 " + point + " -> " + point2 + ", bounds " + this.bounds);
        } else if (DEBUG) {
            System.err.println("JAWTWindow.layoutSurfaceLayerImpl: " + MacOSXJAWTWindow.toHexString(l2) + ", quirks " + n2 + ", visible " + bl + ", [ins " + insets + "], p0 " + point + " -> " + point2 + ", bounds " + this.bounds);
        }
        OSXUtil.FixCALayerLayout(this.rootSurfaceLayer, l2, bl, point2.getX(), point2.getY(), this.getWidth(), this.getHeight(), n2);
    }

    @Override
    protected void detachSurfaceLayerImpl(final long l2, final Runnable runnable) {
        OSXUtil.RunOnMainThread(false, true, new Runnable(){

            @Override
            public void run() {
                runnable.run();
                OSXUtil.RemoveCASublayer(MacOSXJAWTWindow.this.rootSurfaceLayer, l2);
            }
        });
    }

    @Override
    public final long getWindowHandle() {
        return this.windowHandle;
    }

    @Override
    public final long getSurfaceHandle() {
        return this.offscreenSurfaceDrawableSet ? this.offscreenSurfaceDrawable : this.drawable;
    }

    @Override
    public void setSurfaceHandle(long l2) {
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            throw new UnsupportedOperationException("Not using CALAYER");
        }
        if (DEBUG) {
            System.err.println("MacOSXJAWTWindow.setSurfaceHandle(): " + MacOSXJAWTWindow.toHexString(l2));
        }
        this.offscreenSurfaceDrawable = l2;
        this.offscreenSurfaceDrawableSet = true;
    }

    @Override
    protected JAWT fetchJAWTImpl() throws NativeWindowException {
        return JAWTUtil.getJAWT(this.getShallUseOffscreenLayer() || this.isApplet());
    }

    @Override
    protected int lockSurfaceImpl() throws NativeWindowException {
        int n2 = 1;
        this.ds = this.getJAWT().GetDrawingSurface(this.component);
        if (this.ds == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        int n3 = this.ds.Lock();
        boolean bl = this.dsLocked = 0 == (n3 & 1);
        if (!this.dsLocked) {
            this.unlockSurfaceImpl();
            throw new NativeWindowException("Unable to lock surface");
        }
        if ((n3 & 8) != 0) {
            n2 = 2;
        }
        if (this.firstLock) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    MacOSXJAWTWindow.this.dsi = MacOSXJAWTWindow.this.ds.GetDrawingSurfaceInfo();
                    return null;
                }
            });
        } else {
            this.dsi = this.ds.GetDrawingSurfaceInfo();
        }
        if (this.dsi == null) {
            this.unlockSurfaceImpl();
            return 1;
        }
        this.updateLockedData(this.dsi.getBounds());
        if (DEBUG && this.firstLock) {
            this.dumpInfo();
        }
        this.firstLock = false;
        if (!this.isOffscreenLayerSurfaceEnabled()) {
            this.macosxdsi = (JAWT_MacOSXDrawingSurfaceInfo)this.dsi.platformInfo(this.getJAWT());
            if (this.macosxdsi == null) {
                this.unlockSurfaceImpl();
                return 1;
            }
            this.drawable = this.macosxdsi.getCocoaViewRef();
            if (this.drawable == 0L) {
                this.unlockSurfaceImpl();
                return 1;
            }
            this.windowHandle = OSXUtil.GetNSWindow(this.drawable);
            n2 = 3;
        } else {
            String string = null;
            if (0L == this.drawable) {
                this.windowHandle = OSXUtil.CreateNSWindow(0, 0, 64, 64);
                if (0L == this.windowHandle) {
                    string = "Unable to create dummy NSWindow (layered case)";
                } else {
                    this.drawable = OSXUtil.GetNSView(this.windowHandle);
                    if (0L == this.drawable) {
                        string = "Null NSView of NSWindow " + MacOSXJAWTWindow.toHexString(this.windowHandle);
                    }
                }
                if (null == string) {
                    Capabilities capabilities = (Capabilities)this.getGraphicsConfiguration().getChosenCapabilities().cloneMutable();
                    capabilities.setOnscreen(false);
                    this.setChosenCapabilities(capabilities);
                }
            }
            if (null == string) {
                this.jawtSurfaceLayersHandle = MacOSXJAWTWindow.GetJAWTSurfaceLayersHandle0(this.dsi.getBuffer());
                OSXUtil.RunOnMainThread(false, false, new Runnable(){

                    @Override
                    public void run() {
                        String string = null;
                        if (0L == MacOSXJAWTWindow.this.rootSurfaceLayer && 0L != MacOSXJAWTWindow.this.jawtSurfaceLayersHandle) {
                            MacOSXJAWTWindow.this.rootSurfaceLayer = OSXUtil.CreateCALayer(MacOSXJAWTWindow.this.bounds.getWidth(), MacOSXJAWTWindow.this.bounds.getHeight(), MacOSXJAWTWindow.this.getPixelScaleX());
                            if (0L == MacOSXJAWTWindow.this.rootSurfaceLayer) {
                                string = "Could not create root CALayer";
                            } else {
                                try {
                                    MacOSXJAWTWindow.SetJAWTRootSurfaceLayer0(MacOSXJAWTWindow.this.jawtSurfaceLayersHandle, MacOSXJAWTWindow.this.rootSurfaceLayer);
                                }
                                catch (Exception exception) {
                                    string = "Could not set JAWT rootSurfaceLayerHandle " + MacOSXJAWTWindow.toHexString(MacOSXJAWTWindow.this.rootSurfaceLayer) + ", cause: " + exception.getMessage();
                                }
                            }
                            if (null != string) {
                                if (0L != MacOSXJAWTWindow.this.rootSurfaceLayer) {
                                    OSXUtil.DestroyCALayer(MacOSXJAWTWindow.this.rootSurfaceLayer);
                                    MacOSXJAWTWindow.this.rootSurfaceLayer = 0L;
                                }
                                throw new NativeWindowException(string + ": " + MacOSXJAWTWindow.this);
                            }
                        }
                    }
                });
            }
            if (null != string) {
                if (0L != this.windowHandle) {
                    OSXUtil.DestroyNSWindow(this.windowHandle);
                    this.windowHandle = 0L;
                }
                this.drawable = 0L;
                this.unlockSurfaceImpl();
                throw new NativeWindowException(string + ": " + this);
            }
            n2 = 3;
        }
        return n2;
    }

    @Override
    protected void unlockSurfaceImpl() throws NativeWindowException {
        if (null != this.ds) {
            if (null != this.dsi) {
                this.ds.FreeDrawingSurfaceInfo(this.dsi);
            }
            if (this.dsLocked) {
                this.ds.Unlock();
            }
            this.getJAWT().FreeDrawingSurface(this.ds);
        }
        this.ds = null;
        this.dsi = null;
    }

    private void dumpInfo() {
        System.err.println("MaxOSXJAWTWindow: 0x" + Integer.toHexString(this.hashCode()) + " - thread: " + Thread.currentThread().getName());
        this.dumpJAWTInfo();
    }

    @Override
    public com.jogamp.nativewindow.util.Point getLocationOnScreen(com.jogamp.nativewindow.util.Point point) {
        if (null == point) {
            point = new com.jogamp.nativewindow.util.Point();
        }
        AWTMisc.getLocationOnScreenNonBlocking(point, this.component, DEBUG);
        return point;
    }

    @Override
    protected com.jogamp.nativewindow.util.Point getLocationOnScreenNativeImpl(int n2, int n3) {
        return null;
    }

    private static native long GetJAWTSurfaceLayersHandle0(Buffer var0);

    private static native void SetJAWTRootSurfaceLayer0(long var0, long var2);

    private static native void UnsetJAWTRootSurfaceLayer0(long var0, long var2);

    static {
        Debug.initSingleton();
        DEBUG_CALAYER_POS_CRITICAL = PropertyAccess.isPropertyDefined("nativewindow.debug.JAWT.OSXCALayerPos", true);
    }
}

