/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.CapabilitiesChooser;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.x11.X11GraphicsConfiguration;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import jogamp.nativewindow.x11.X11Capabilities;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.XVisualInfo;

public class X11GraphicsConfigurationFactory
extends GraphicsConfigurationFactory {
    public static void registerFactory() {
        GraphicsConfigurationFactory.registerFactory(X11GraphicsDevice.class, CapabilitiesImmutable.class, new X11GraphicsConfigurationFactory());
    }

    private X11GraphicsConfigurationFactory() {
    }

    @Override
    protected AbstractGraphicsConfiguration chooseGraphicsConfigurationImpl(CapabilitiesImmutable capabilitiesImmutable, CapabilitiesImmutable capabilitiesImmutable2, CapabilitiesChooser capabilitiesChooser, AbstractGraphicsScreen abstractGraphicsScreen, int n2) throws IllegalArgumentException, NativeWindowException {
        if (!(abstractGraphicsScreen instanceof X11GraphicsScreen)) {
            throw new NativeWindowException("Only valid X11GraphicsScreen are allowed");
        }
        X11Capabilities x11Capabilities = 0 == n2 ? new X11Capabilities(X11GraphicsConfigurationFactory.getXVisualInfo(abstractGraphicsScreen, capabilitiesImmutable)) : new X11Capabilities(X11GraphicsConfigurationFactory.getXVisualInfo(abstractGraphicsScreen, n2));
        X11GraphicsConfiguration x11GraphicsConfiguration = new X11GraphicsConfiguration((X11GraphicsScreen)abstractGraphicsScreen, x11Capabilities, capabilitiesImmutable2, x11Capabilities.getXVisualInfo());
        if (DEBUG) {
            System.err.println("X11GraphicsConfigurationFactory.chooseGraphicsConfigurationImpl(visualID 0x" + Integer.toHexString(n2) + ", " + abstractGraphicsScreen + "," + capabilitiesImmutable + "): " + x11GraphicsConfiguration);
        }
        return x11GraphicsConfiguration;
    }

    public static XVisualInfo getXVisualInfo(AbstractGraphicsScreen abstractGraphicsScreen, int n2) {
        XVisualInfo xVisualInfo = XVisualInfo.create();
        xVisualInfo.setVisualid(n2);
        xVisualInfo.setScreen(abstractGraphicsScreen.getIndex());
        int[] nArray = new int[]{-1};
        long l2 = abstractGraphicsScreen.getDevice().getHandle();
        XVisualInfo[] xVisualInfoArray = X11Lib.XGetVisualInfo(l2, 3L, xVisualInfo, nArray, 0);
        if (xVisualInfoArray == null || nArray[0] < 1) {
            return null;
        }
        return XVisualInfo.create(xVisualInfoArray[0]);
    }

    public static XVisualInfo getXVisualInfo(AbstractGraphicsScreen abstractGraphicsScreen, CapabilitiesImmutable capabilitiesImmutable) {
        XVisualInfo xVisualInfo = X11GraphicsConfigurationFactory.getXVisualInfoImpl(abstractGraphicsScreen, capabilitiesImmutable, 4);
        if (null != xVisualInfo) {
            return xVisualInfo;
        }
        return X11GraphicsConfigurationFactory.getXVisualInfoImpl(abstractGraphicsScreen, capabilitiesImmutable, 5);
    }

    private static XVisualInfo getXVisualInfoImpl(AbstractGraphicsScreen abstractGraphicsScreen, CapabilitiesImmutable capabilitiesImmutable, int n2) {
        XVisualInfo xVisualInfo = null;
        int[] nArray = new int[]{-1};
        XVisualInfo xVisualInfo2 = XVisualInfo.create();
        xVisualInfo2.setScreen(abstractGraphicsScreen.getIndex());
        xVisualInfo2.setC_class(n2);
        long l2 = abstractGraphicsScreen.getDevice().getHandle();
        XVisualInfo[] xVisualInfoArray = X11Lib.XGetVisualInfo(l2, 2L, xVisualInfo2, nArray, 0);
        XVisualInfo xVisualInfo3 = null;
        int n3 = capabilitiesImmutable.getRedBits() + capabilitiesImmutable.getGreenBits() + capabilitiesImmutable.getBlueBits() + capabilitiesImmutable.getAlphaBits();
        for (int i2 = 0; xVisualInfoArray != null && i2 < nArray[0] && (xVisualInfo3 != null && xVisualInfo3.getDepth() >= xVisualInfoArray[i2].getDepth() || n3 > (xVisualInfo3 = xVisualInfoArray[i2]).getDepth()); ++i2) {
        }
        if (null != xVisualInfo3 && (n3 <= xVisualInfo3.getDepth() || 24 == xVisualInfo3.getDepth())) {
            xVisualInfo = XVisualInfo.create(xVisualInfo3);
        }
        xVisualInfo3 = null;
        return xVisualInfo;
    }
}

