/*
 * Decompiled with CFR 0.152.
 */
package jogamp.nativewindow.x11;

import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.util.Point;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import jogamp.nativewindow.x11.XRenderPictFormat;
import jogamp.nativewindow.x11.XVisualInfo;

public class X11Lib {
    public static final int PictFormatAlpha = 512;
    public static final int PictFormatAlphaMask = 1024;
    public static final int PictFormatBlue = 128;
    public static final int PictFormatBlueMask = 256;
    public static final int PictFormatColormap = 2048;
    public static final int PictFormatDepth = 4;
    public static final int PictFormatGreen = 32;
    public static final int PictFormatGreenMask = 64;
    public static final int PictFormatID = 1;
    public static final int PictFormatRed = 8;
    public static final int PictFormatRedMask = 16;
    public static final int PictFormatType = 2;
    public static final int VisualAllMask = 511;
    public static final int VisualBitsPerRGBMask = 256;
    public static final int VisualBlueMaskMask = 64;
    public static final int VisualClassMask = 8;
    public static final int VisualColormapSizeMask = 128;
    public static final int VisualDepthMask = 4;
    public static final int VisualGreenMaskMask = 32;
    public static final int VisualIDMask = 1;
    public static final int VisualNoMask = 0;
    public static final int VisualRedMaskMask = 16;
    public static final int VisualScreenMask = 2;

    public static native int DefaultScreen(long var0);

    public static native long RootWindow(long var0, int var2);

    public static native int ScreenCount(long var0);

    public static native long XCreatePixmap(long var0, long var2, int var4, int var5, int var6);

    public static native String XDisplayString(long var0);

    public static boolean XF86VidModeGetGammaRamp(long l2, int n2, int n3, ShortBuffer shortBuffer, ShortBuffer shortBuffer2, ShortBuffer shortBuffer3) {
        boolean bl = Buffers.isDirect(shortBuffer);
        boolean bl2 = Buffers.isDirect(shortBuffer2);
        boolean bl3 = Buffers.isDirect(shortBuffer3);
        return X11Lib.XF86VidModeGetGammaRamp1(l2, n2, n3, bl ? shortBuffer : Buffers.getArray(shortBuffer), bl ? Buffers.getDirectBufferByteOffset(shortBuffer) : Buffers.getIndirectBufferByteOffset(shortBuffer), bl, bl2 ? shortBuffer2 : Buffers.getArray(shortBuffer2), bl2 ? Buffers.getDirectBufferByteOffset(shortBuffer2) : Buffers.getIndirectBufferByteOffset(shortBuffer2), bl2, bl3 ? shortBuffer3 : Buffers.getArray(shortBuffer3), bl3 ? Buffers.getDirectBufferByteOffset(shortBuffer3) : Buffers.getIndirectBufferByteOffset(shortBuffer3), bl3);
    }

    private static native boolean XF86VidModeGetGammaRamp1(long var0, int var2, int var3, Object var4, int var5, boolean var6, Object var7, int var8, boolean var9, Object var10, int var11, boolean var12);

    public static boolean XF86VidModeGetGammaRamp(long l2, int n2, int n3, short[] sArray, int n4, short[] sArray2, int n5, short[] sArray3, int n6) {
        if (sArray != null && sArray.length <= n4) {
            throw new RuntimeException("array offset argument \"red_array_offset\" (" + n4 + ") equals or exceeds array length (" + sArray.length + ")");
        }
        if (sArray2 != null && sArray2.length <= n5) {
            throw new RuntimeException("array offset argument \"green_array_offset\" (" + n5 + ") equals or exceeds array length (" + sArray2.length + ")");
        }
        if (sArray3 != null && sArray3.length <= n6) {
            throw new RuntimeException("array offset argument \"blue_array_offset\" (" + n6 + ") equals or exceeds array length (" + sArray3.length + ")");
        }
        return X11Lib.XF86VidModeGetGammaRamp1(l2, n2, n3, sArray, 2 * n4, false, sArray2, 2 * n5, false, sArray3, 2 * n6, false);
    }

    public static boolean XF86VidModeGetGammaRampSize(long l2, int n2, IntBuffer intBuffer) {
        boolean bl = Buffers.isDirect(intBuffer);
        return X11Lib.XF86VidModeGetGammaRampSize1(l2, n2, bl ? intBuffer : Buffers.getArray(intBuffer), bl ? Buffers.getDirectBufferByteOffset(intBuffer) : Buffers.getIndirectBufferByteOffset(intBuffer), bl);
    }

    private static native boolean XF86VidModeGetGammaRampSize1(long var0, int var2, Object var3, int var4, boolean var5);

    public static boolean XF86VidModeGetGammaRampSize(long l2, int n2, int[] nArray, int n3) {
        if (nArray != null && nArray.length <= n3) {
            throw new RuntimeException("array offset argument \"size_offset\" (" + n3 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        return X11Lib.XF86VidModeGetGammaRampSize1(l2, n2, nArray, 4 * n3, false);
    }

    public static boolean XF86VidModeSetGammaRamp(long l2, int n2, int n3, ShortBuffer shortBuffer, ShortBuffer shortBuffer2, ShortBuffer shortBuffer3) {
        boolean bl = Buffers.isDirect(shortBuffer);
        boolean bl2 = Buffers.isDirect(shortBuffer2);
        boolean bl3 = Buffers.isDirect(shortBuffer3);
        return X11Lib.XF86VidModeSetGammaRamp1(l2, n2, n3, bl ? shortBuffer : Buffers.getArray(shortBuffer), bl ? Buffers.getDirectBufferByteOffset(shortBuffer) : Buffers.getIndirectBufferByteOffset(shortBuffer), bl, bl2 ? shortBuffer2 : Buffers.getArray(shortBuffer2), bl2 ? Buffers.getDirectBufferByteOffset(shortBuffer2) : Buffers.getIndirectBufferByteOffset(shortBuffer2), bl2, bl3 ? shortBuffer3 : Buffers.getArray(shortBuffer3), bl3 ? Buffers.getDirectBufferByteOffset(shortBuffer3) : Buffers.getIndirectBufferByteOffset(shortBuffer3), bl3);
    }

    private static native boolean XF86VidModeSetGammaRamp1(long var0, int var2, int var3, Object var4, int var5, boolean var6, Object var7, int var8, boolean var9, Object var10, int var11, boolean var12);

    public static boolean XF86VidModeSetGammaRamp(long l2, int n2, int n3, short[] sArray, int n4, short[] sArray2, int n5, short[] sArray3, int n6) {
        if (sArray != null && sArray.length <= n4) {
            throw new RuntimeException("array offset argument \"red_array_offset\" (" + n4 + ") equals or exceeds array length (" + sArray.length + ")");
        }
        if (sArray2 != null && sArray2.length <= n5) {
            throw new RuntimeException("array offset argument \"green_array_offset\" (" + n5 + ") equals or exceeds array length (" + sArray2.length + ")");
        }
        if (sArray3 != null && sArray3.length <= n6) {
            throw new RuntimeException("array offset argument \"blue_array_offset\" (" + n6 + ") equals or exceeds array length (" + sArray3.length + ")");
        }
        return X11Lib.XF86VidModeSetGammaRamp1(l2, n2, n3, sArray, 2 * n4, false, sArray2, 2 * n5, false, sArray3, 2 * n6, false);
    }

    public static native int XFlush(long var0);

    public static native int XFree(long var0);

    public static native int XFreePixmap(long var0, long var2);

    public static native long XOpenDisplay(String var0);

    public static XRenderPictFormat XRenderFindVisualFormat(long l2, long l3) {
        ByteBuffer byteBuffer = X11Lib.XRenderFindVisualFormat1(l2, l3);
        if (byteBuffer == null) {
            return null;
        }
        return XRenderPictFormat.create(Buffers.nativeOrder(byteBuffer));
    }

    private static native ByteBuffer XRenderFindVisualFormat1(long var0, long var2);

    public static native int XSync(long var0, boolean var2);

    public static native long XSynchronize(long var0, boolean var2);

    public static native long XineramaGetLibHandle();

    public static native long XineramaGetQueryFunc(long var0);

    public static native boolean XineramaIsEnabled(long var0, long var2);

    public static native boolean XineramaReleaseLibHandle(long var0);

    public static boolean XRenderFindVisualFormat(long l2, long l3, XRenderPictFormat xRenderPictFormat) {
        if (xRenderPictFormat == null) {
            throw new RuntimeException("dest is null");
        }
        ByteBuffer byteBuffer = xRenderPictFormat.getBuffer();
        if (!Buffers.isDirect(byteBuffer)) {
            throw new RuntimeException("dest buffer is not direct");
        }
        return X11Lib.XRenderFindVisualFormat1(l2, l3, byteBuffer);
    }

    private static native boolean XRenderFindVisualFormat1(long var0, long var2, ByteBuffer var4);

    public static XVisualInfo[] XGetVisualInfo(long l2, long l3, XVisualInfo xVisualInfo, int[] nArray, int n2) {
        if (nArray != null && nArray.length <= n2) {
            throw new RuntimeException("array offset argument \"arg3_offset\" (" + n2 + ") equals or exceeds array length (" + nArray.length + ")");
        }
        ByteBuffer byteBuffer = X11Lib.XGetVisualInfo1(l2, l3, xVisualInfo == null ? null : xVisualInfo.getBuffer(), nArray, 4 * n2);
        if (byteBuffer == null) {
            return null;
        }
        Buffers.nativeOrder(byteBuffer);
        XVisualInfo[] xVisualInfoArray = new XVisualInfo[X11Lib.getFirstElement(nArray, n2)];
        for (int i2 = 0; i2 < X11Lib.getFirstElement(nArray, n2); ++i2) {
            byteBuffer.position(i2 * XVisualInfo.size());
            byteBuffer.limit((1 + i2) * XVisualInfo.size());
            ByteBuffer byteBuffer2 = byteBuffer.slice();
            byteBuffer.position(0);
            byteBuffer.limit(byteBuffer.capacity());
            xVisualInfoArray[i2] = XVisualInfo.create(byteBuffer2);
        }
        return xVisualInfoArray;
    }

    private static native ByteBuffer XGetVisualInfo1(long var0, long var2, ByteBuffer var4, Object var5, int var6);

    public static native int GetVisualIDFromWindow(long var0, long var2);

    public static native int DefaultVisualID(long var0, int var2);

    public static native long CreateWindow(long var0, long var2, int var4, int var5, int var6, int var7, boolean var8, boolean var9);

    public static native void DestroyWindow(long var0, long var2);

    public static native void SetWindowPosSize(long var0, long var2, int var4, int var5, int var6, int var7);

    public static Point GetRelativeLocation(long l2, int n2, long l3, long l4, int n3, int n4) {
        return (Point)X11Lib.GetRelativeLocation0(l2, n2, l3, l4, n3, n4);
    }

    private static native Object GetRelativeLocation0(long var0, int var2, long var3, long var5, int var7, int var8);

    public static boolean QueryExtension(long l2, String string) {
        return X11Lib.QueryExtension0(l2, string);
    }

    private static native boolean QueryExtension0(long var0, String var2);

    public static native int XCloseDisplay(long var0);

    public static native void XUnlockDisplay(long var0);

    public static native void XLockDisplay(long var0);

    private static int getFirstElement(IntBuffer intBuffer) {
        return intBuffer.get(intBuffer.position());
    }

    private static int getFirstElement(int[] nArray, int n2) {
        return nArray[n2];
    }
}

