/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.SurfaceSize;
import com.jogamp.newt.MonitorDevice;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.Screen;
import com.jogamp.opengl.math.FloatUtil;
import java.util.ArrayList;
import java.util.List;
import jogamp.newt.MonitorDeviceImpl;
import jogamp.newt.ScreenImpl;

public class MonitorModeProps {
    public static final int NUM_RESOLUTION_PROPERTIES = 2;
    public static final int NUM_SURFACE_SIZE_PROPERTIES = 1;
    public static final int NUM_SIZEANDRATE_PROPERTIES = 2;
    public static final int NUM_MONITOR_MODE_PROPERTIES = 2;
    public static final int NUM_MONITOR_MODE_PROPERTIES_ALL = 8;
    public static final int IDX_MONITOR_MODE_BPP = 3;
    public static final int IDX_MONITOR_MODE_ROT = 7;
    public static final int MIN_MONITOR_DEVICE_PROPERTIES = 17;
    public static final int IDX_MONITOR_DEVICE_VIEWPORT = 6;

    private static DimensionImmutable streamInResolution(int[] nArray, int n2) {
        Dimension dimension = new Dimension(nArray[n2++], nArray[n2++]);
        return dimension;
    }

    private static SurfaceSize streamInSurfaceSize(DimensionImmutable dimensionImmutable, int[] nArray, int n2) {
        return new SurfaceSize(dimensionImmutable, nArray[n2]);
    }

    private static MonitorMode.SizeAndRRate streamInSizeAndRRate(SurfaceSize surfaceSize, int[] nArray, int n2) {
        float f2 = (float)nArray[n2++] / 100.0f;
        int n3 = nArray[n2++];
        return new MonitorMode.SizeAndRRate(surfaceSize, f2, n3);
    }

    private static MonitorMode streamInMonitorMode0(MonitorMode.SizeAndRRate sizeAndRRate, int[] nArray, int n2) {
        int n3 = nArray[n2++];
        int n4 = nArray[n2++];
        return new MonitorMode(n3, sizeAndRRate, n4);
    }

    public static MonitorMode streamInMonitorMode(int[] nArray, Cache cache, int[] nArray2, int n2) {
        int n3 = nArray2[n2];
        if (8 != n3) {
            throw new RuntimeException("property count should be 8, but is " + n3 + ", len " + (nArray2.length - n2));
        }
        if (8 > nArray2.length - n2) {
            throw new RuntimeException("properties array too short, should be >= 8, is " + (nArray2.length - n2));
        }
        DimensionImmutable dimensionImmutable = MonitorModeProps.streamInResolution(nArray2, ++n2);
        n2 += 2;
        if (null != cache) {
            dimensionImmutable = cache.resolutions.getOrAdd(dimensionImmutable);
        }
        SurfaceSize surfaceSize = MonitorModeProps.streamInSurfaceSize(dimensionImmutable, nArray2, n2);
        ++n2;
        if (null != cache) {
            surfaceSize = cache.surfaceSizes.getOrAdd(surfaceSize);
        }
        MonitorMode.SizeAndRRate sizeAndRRate = MonitorModeProps.streamInSizeAndRRate(surfaceSize, nArray2, n2);
        n2 += 2;
        if (null != cache) {
            sizeAndRRate = cache.sizeAndRates.getOrAdd(sizeAndRRate);
        }
        MonitorMode monitorMode = MonitorModeProps.streamInMonitorMode0(sizeAndRRate, nArray2, n2);
        if (null != cache) {
            monitorMode = cache.monitorModes.getOrAdd(monitorMode);
        }
        if (null != nArray && null != cache) {
            int n4 = cache.monitorModes.indexOf(monitorMode);
            if (0 > n4) {
                throw new InternalError("Invalid index of current unified mode " + monitorMode);
            }
            nArray[0] = n4;
        }
        return monitorMode;
    }

    public static int[] streamOutMonitorMode(MonitorMode monitorMode) {
        int[] nArray = new int[8];
        int n2 = 0;
        nArray[n2++] = 8;
        nArray[n2++] = monitorMode.getSurfaceSize().getResolution().getWidth();
        nArray[n2++] = monitorMode.getSurfaceSize().getResolution().getHeight();
        nArray[n2++] = monitorMode.getSurfaceSize().getBitsPerPixel();
        nArray[n2++] = (int)(monitorMode.getRefreshRate() * 100.0f);
        nArray[n2++] = monitorMode.getFlags();
        nArray[n2++] = monitorMode.getId();
        nArray[n2++] = monitorMode.getRotation();
        if (8 != n2) {
            throw new InternalError("wrong number of attributes: got " + n2 + " != should " + 8);
        }
        return nArray;
    }

    public static MonitorDevice streamInMonitorDevice(Cache cache, ScreenImpl screenImpl, float[] fArray, int[] nArray, int n2, int[] nArray2) {
        int n3;
        int n4 = nArray[n2];
        if (17 > n4) {
            throw new RuntimeException("property count should be >= 17, but is " + n4 + ", len " + (nArray.length - n2));
        }
        if (17 > nArray.length - n2) {
            throw new RuntimeException("properties array too short (min), should be >= 17, is " + (nArray.length - n2));
        }
        if (n4 > nArray.length - n2) {
            throw new RuntimeException("properties array too short (count), should be >= " + n4 + ", is " + (nArray.length - n2));
        }
        int n5 = n2 + n4;
        ArrayList<MonitorMode> arrayList = cache.monitorModes.getData();
        int n6 = ++n2;
        int n7 = nArray[n6];
        int n8 = ++n2;
        ++n2;
        boolean bl = 0 != nArray[n8];
        boolean bl2 = 0 != nArray[n2++];
        DimensionImmutable dimensionImmutable = MonitorModeProps.streamInResolution(nArray, n2);
        n2 += 2;
        Rectangle rectangle = new Rectangle(nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++]);
        Rectangle rectangle2 = new Rectangle(nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++]);
        int n9 = nArray[n2++];
        int n10 = nArray[n2++];
        MonitorMode monitorMode = MonitorModeProps.getByNativeIdAndRotation(arrayList, n9, n10);
        ArrayHashSet<MonitorMode> arrayHashSet = new ArrayHashSet<MonitorMode>();
        while (n2 < n5) {
            n10 = nArray[n2++];
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                MonitorMode monitorMode2 = (MonitorMode)arrayList.get(n3);
                if (monitorMode2.getId() != n10) continue;
                arrayHashSet.add(monitorMode2);
            }
        }
        MonitorDevice monitorDevice = new MonitorDeviceImpl(screenImpl, n7, bl, bl2, dimensionImmutable, monitorMode, fArray, rectangle, rectangle2, arrayHashSet);
        if (null != cache && (monitorDevice = cache.monitorDevices.getOrAdd(monitorDevice)).isPrimary()) {
            cache.setPrimary(monitorDevice);
        }
        if (null != nArray2) {
            n3 = cache.monitorDevices.indexOf(monitorDevice);
            if (0 > n3) {
                throw new InternalError("Invalid index of current unified mode " + monitorDevice);
            }
            nArray2[0] = n3;
        }
        return monitorDevice;
    }

    private static MonitorMode getByNativeIdAndRotation(List<MonitorMode> list, int n2, int n3) {
        if (null != list && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                MonitorMode monitorMode = list.get(i2);
                if (monitorMode.getId() != n2 || monitorMode.getRotation() != n3) continue;
                return monitorMode;
            }
        }
        return null;
    }

    public static MonitorDevice streamInMonitorDevice(Cache cache, ScreenImpl screenImpl, MonitorMode monitorMode, float[] fArray, ArrayHashSet<MonitorMode> arrayHashSet, int[] nArray, int n2, int[] nArray2) {
        int n3 = nArray[n2];
        if (14 != n3) {
            throw new RuntimeException("property count should be == 14, but is " + n3 + ", len " + (nArray.length - n2));
        }
        if (14 > nArray.length - n2) {
            throw new RuntimeException("properties array too short (min), should be >= 14, is " + (nArray.length - n2));
        }
        if (n3 > nArray.length - n2) {
            throw new RuntimeException("properties array too short (count), should be >= " + n3 + ", is " + (nArray.length - n2));
        }
        int n4 = ++n2;
        int n5 = nArray[n4];
        int n6 = ++n2;
        ++n2;
        boolean bl = 0 != nArray[n6];
        boolean bl2 = 0 != nArray[n2++];
        DimensionImmutable dimensionImmutable = MonitorModeProps.streamInResolution(nArray, n2);
        n2 += 2;
        Rectangle rectangle = new Rectangle(nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++]);
        Rectangle rectangle2 = new Rectangle(nArray[n2++], nArray[n2++], nArray[n2++], nArray[n2++]);
        MonitorDevice monitorDevice = new MonitorDeviceImpl(screenImpl, n5, bl, bl2, dimensionImmutable, monitorMode, fArray, rectangle, rectangle2, arrayHashSet);
        if (null != cache && (monitorDevice = cache.monitorDevices.getOrAdd(monitorDevice)).isPrimary()) {
            cache.setPrimary(monitorDevice);
        }
        if (null != nArray2) {
            int n7 = cache.monitorDevices.indexOf(monitorDevice);
            if (0 > n7) {
                throw new InternalError("Invalid index of current unified mode " + monitorDevice);
            }
            nArray2[0] = n7;
        }
        return monitorDevice;
    }

    public static int[] streamOutMonitorDevice(MonitorDevice monitorDevice) {
        int n2 = monitorDevice.getSupportedModes().size();
        if (0 == n2) {
            throw new RuntimeException("no supported modes: " + monitorDevice);
        }
        int[] nArray = new int[17 + n2 - 1];
        int n3 = 0;
        nArray[n3++] = nArray.length;
        nArray[n3++] = monitorDevice.getId();
        nArray[n3++] = monitorDevice.isClone() ? 1 : 0;
        nArray[n3++] = monitorDevice.isPrimary() ? 1 : 0;
        nArray[n3++] = monitorDevice.getSizeMM().getWidth();
        nArray[n3++] = monitorDevice.getSizeMM().getHeight();
        nArray[n3++] = monitorDevice.getViewport().getX();
        nArray[n3++] = monitorDevice.getViewport().getY();
        nArray[n3++] = monitorDevice.getViewport().getWidth();
        nArray[n3++] = monitorDevice.getViewport().getHeight();
        nArray[n3++] = monitorDevice.getViewportInWindowUnits().getX();
        nArray[n3++] = monitorDevice.getViewportInWindowUnits().getY();
        nArray[n3++] = monitorDevice.getViewportInWindowUnits().getWidth();
        nArray[n3++] = monitorDevice.getViewportInWindowUnits().getHeight();
        nArray[n3++] = monitorDevice.getCurrentMode().getId();
        nArray[n3++] = monitorDevice.getCurrentMode().getRotation();
        List<MonitorMode> list = monitorDevice.getSupportedModes();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            nArray[n3++] = list.get(i2).getId();
        }
        if (nArray.length != n3) {
            throw new InternalError("wrong number of attributes: got " + n3 + " != should " + nArray.length);
        }
        return nArray;
    }

    static void identifyMonitorDevices(Cache cache) {
        ArrayList<MonitorDevice> arrayList = cache.monitorDevices.toArrayList();
        int n2 = arrayList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            MonitorDevice monitorDevice = arrayList.get(i2);
            if (monitorDevice.isClone()) continue;
            for (int i3 = i2 + 1; i3 < n2; ++i3) {
                MonitorDevice monitorDevice2 = arrayList.get(i3);
                if (monitorDevice2.isClone()) continue;
                float f2 = monitorDevice2.getViewport().coverage(monitorDevice.getViewport());
                if (FloatUtil.isZero(1.0f - f2, 1.1920929E-7f)) {
                    ((MonitorDeviceImpl)monitorDevice2).setIsClone(true);
                    if (!Screen.DEBUG) continue;
                    System.err.printf("MonitorCloneTest[%d of %d]: %f -> _is_ covered%n", i3, i2, Float.valueOf(f2));
                    System.err.printf("  Monitor[%d] %s%n", i3, monitorDevice2.toString());
                    System.err.printf("  Monitor[%d] %s%n", i2, monitorDevice.toString());
                    continue;
                }
                if (!Screen.DEBUG) continue;
                System.err.printf("MonitorDevice-CloneTest[%d of %d]: %f -> not covered%n", i3, i2, Float.valueOf(f2));
                System.err.printf("  Monitor[%d] %s%n", i3, monitorDevice2.toString());
                System.err.printf("  Monitor[%d] %s%n", i2, monitorDevice.toString());
            }
        }
    }

    public static final void swapRotatePair(int n2, int[] nArray, int n3, int n4) {
        if (0 == n2 || 180 == n2) {
            return;
        }
        int n5 = 0;
        while (n5 < n4) {
            int n6 = nArray[n3];
            nArray[n3] = nArray[n3 + 1];
            nArray[n3 + 1] = n6;
            ++n5;
            n3 += 2;
        }
    }

    public static class Cache {
        public final ArrayHashSet<DimensionImmutable> resolutions = new ArrayHashSet();
        public final ArrayHashSet<SurfaceSize> surfaceSizes = new ArrayHashSet();
        public final ArrayHashSet<MonitorMode.SizeAndRRate> sizeAndRates = new ArrayHashSet();
        public final ArrayHashSet<MonitorMode> monitorModes = new ArrayHashSet();
        public final ArrayHashSet<MonitorDevice> monitorDevices = new ArrayHashSet();
        private MonitorDevice primary = null;

        public final void setPrimary(MonitorDevice monitorDevice) {
            this.primary = monitorDevice;
        }

        public final MonitorDevice getPrimary() {
            return this.primary;
        }
    }
}

