/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt;

import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.nativewindow.util.PixelRectangle;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.newt.Display;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import jogamp.newt.DisplayImpl;

public class PointerIconImpl
implements Display.PointerIcon {
    private final DisplayImpl display;
    private final PixelFormat pixelformat;
    private final DimensionImmutable size;
    private final ByteBuffer pixels;
    private final PointImmutable hotspot;
    private long handle;
    private int hashCode = 0;
    private volatile boolean hashCodeComputed = false;

    public PointerIconImpl(DisplayImpl displayImpl, PixelFormat pixelFormat, DimensionImmutable dimensionImmutable, ByteBuffer byteBuffer, PointImmutable pointImmutable, long l2) {
        this.display = displayImpl;
        this.pixelformat = pixelFormat;
        this.size = dimensionImmutable;
        this.pixels = byteBuffer;
        this.hotspot = pointImmutable;
        this.handle = l2;
    }

    public PointerIconImpl(DisplayImpl displayImpl, PixelRectangle pixelRectangle, PointImmutable pointImmutable, long l2) {
        this.display = displayImpl;
        this.pixelformat = pixelRectangle.getPixelformat();
        this.size = pixelRectangle.getSize();
        this.pixels = pixelRectangle.getPixels();
        this.hotspot = pointImmutable;
        this.handle = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        if (!this.hashCodeComputed) {
            PointerIconImpl pointerIconImpl = this;
            synchronized (pointerIconImpl) {
                if (!this.hashCodeComputed) {
                    int n2 = 31 + this.display.getFQName().hashCode();
                    n2 = (n2 << 5) - n2 + this.pixelformat.hashCode();
                    n2 = (n2 << 5) - n2 + this.size.hashCode();
                    n2 = (n2 << 5) - n2 + this.getStride();
                    n2 = (n2 << 5) - n2 + (this.isGLOriented() ? 1 : 0);
                    n2 = (n2 << 5) - n2 + this.pixels.hashCode();
                    this.hashCode = (n2 << 5) - n2 + this.hotspot.hashCode();
                }
            }
        }
        return this.hashCode;
    }

    public final synchronized long getHandle() {
        return this.handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized long validatedHandle() {
        ArrayList<PointerIconImpl> arrayList = this.display.pointerIconList;
        synchronized (arrayList) {
            if (!this.display.pointerIconList.contains(this)) {
                this.display.pointerIconList.add(this);
            }
        }
        if (0L == this.handle) {
            try {
                this.handle = this.display.createPointerIconImpl(this.pixelformat, this.size.getWidth(), this.size.getHeight(), this.pixels, this.hotspot.getX(), this.hotspot.getY());
                return this.handle;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return 0L;
            }
        }
        return this.handle;
    }

    @Override
    public final Display getDisplay() {
        return this.display;
    }

    @Override
    public final PixelFormat getPixelformat() {
        return this.pixelformat;
    }

    @Override
    public final ByteBuffer getPixels() {
        return this.pixels;
    }

    @Override
    public final synchronized boolean isValid() {
        return 0L != this.handle;
    }

    @Override
    public final synchronized boolean validate() {
        if (0L == this.handle) {
            return 0L != this.validatedHandle();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void destroy() {
        if (Display.DEBUG) {
            System.err.println("PointerIcon.destroy: " + this + ", " + this.display + ", " + Display.getThreadName());
        }
        if (0L != this.handle) {
            ArrayList<PointerIconImpl> arrayList = this.display.pointerIconList;
            synchronized (arrayList) {
                this.display.pointerIconList.remove(this);
            }
            this.display.runOnEDTIfAvail(false, new Runnable(){

                @Override
                public void run() {
                    if (!PointerIconImpl.this.display.isNativeValidAsync()) {
                        PointerIconImpl.this.destroyOnEDT(PointerIconImpl.this.display.getHandle());
                    }
                }
            });
        }
    }

    synchronized void destroyOnEDT(long l2) {
        long l3 = this.handle;
        this.handle = 0L;
        try {
            this.display.destroyPointerIconImpl(l2, l3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public final DimensionImmutable getSize() {
        return this.size;
    }

    @Override
    public final int getStride() {
        return this.size.getWidth() * this.pixelformat.comp.bytesPerPixel();
    }

    @Override
    public final boolean isGLOriented() {
        return false;
    }

    @Override
    public final PointImmutable getHotspot() {
        return this.hotspot;
    }

    @Override
    public final String toString() {
        return "PointerIcon[obj 0x" + Integer.toHexString(super.hashCode()) + ", " + this.display.getFQName() + ", 0x" + Long.toHexString(this.handle) + ", " + (Object)((Object)this.pixelformat) + ", " + this.size + ", " + this.hotspot + ", pixels " + this.pixels + "]";
    }
}

