/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.macosx;

import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.MutableSurface;
import com.jogamp.nativewindow.NativeWindow;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.ScalableSurface;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MonitorEvent;
import com.jogamp.opengl.math.FloatUtil;
import jogamp.nativewindow.SurfaceScaleUtils;
import jogamp.nativewindow.macosx.OSXUtil;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.ScreenImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.DriverClearFocus;
import jogamp.newt.driver.DriverUpdatePosition;
import jogamp.newt.driver.macosx.DisplayDriver;
import jogamp.newt.driver.macosx.MacKeyUtil;

public class WindowDriver
extends WindowImpl
implements MutableSurface,
DriverClearFocus,
DriverUpdatePosition {
    private static final int NSBorderlessWindowMask = 0;
    private static final int NSTitledWindowMask = 1;
    private static final int NSClosableWindowMask = 2;
    private static final int NSMiniaturizableWindowMask = 4;
    private static final int NSResizableWindowMask = 8;
    private static final int NSBackingStoreRetained = 0;
    private static final int NSBackingStoreNonretained = 1;
    private static final int NSBackingStoreBuffered = 2;
    private volatile long surfaceHandle = 0L;
    private long sscSurfaceHandle = 0L;
    private boolean isOffscreenInstance = false;

    private boolean updatePixelScale(boolean bl, boolean bl2, boolean bl3, float f2, float f3) {
        float f4;
        float f5 = FloatUtil.isZero(f2, 1.1920929E-7f) ? 1.0f : f2;
        float[] fArray = new float[]{f5, f5};
        this.maxPixelScale[0] = f4 = FloatUtil.isZero(f3, 1.1920929E-7f) ? 1.0f : f3;
        this.maxPixelScale[1] = f4;
        if (SurfaceScaleUtils.setNewPixelScale(this.hasPixelScale, this.hasPixelScale, fArray, this.minPixelScale, this.maxPixelScale, DEBUG_IMPLEMENTATION ? this.getClass().getName() : null)) {
            if (bl) {
                if (bl3) {
                    this.superSizeChangedOffThread(bl2, this.getWidth(), this.getHeight(), true);
                } else {
                    super.sizeChanged(bl2, this.getWidth(), this.getHeight(), true);
                }
            } else {
                this.defineSize(this.getWidth(), this.getHeight());
            }
            return true;
        }
        return false;
    }

    private boolean updatePixelScaleByDisplayID(boolean bl) {
        float f2 = (float)OSXUtil.GetPixelScaleByDisplayID(this.getDisplayID());
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowDriver.updatePixelScale.1: " + this.hasPixelScale[0] + ", " + f2 + " (max)");
        }
        return this.updatePixelScale(bl, true, false, f2, f2);
    }

    private boolean updatePixelScaleByWindowHandle(boolean bl) {
        long l2 = this.getWindowHandle();
        if (0L != l2) {
            float f2 = (float)OSXUtil.GetPixelScale(l2);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("WindowDriver.updatePixelScale.2: " + this.hasPixelScale[0] + ", " + f2 + " (max)");
            }
            return this.updatePixelScale(bl, true, false, f2, f2);
        }
        return false;
    }

    protected void updatePixelScale(boolean bl, float f2, float f3) {
        long l2 = this.getWindowHandle();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowDriver.updatePixelScale.3: " + this.hasPixelScale[0] + " (has) -> " + f2 + " (new), " + f3 + " (max), drop " + (0L == l2));
        }
        if (0L != l2) {
            this.updatePixelScale(true, bl, true, f2, f3);
        }
    }

    @Override
    protected final void instantiationFinished() {
        this.updatePixelScaleByDisplayID(false);
    }

    @Override
    protected void setScreen(ScreenImpl screenImpl) {
        super.setScreen(screenImpl);
        this.updatePixelScaleByDisplayID(false);
    }

    @Override
    protected void monitorModeChanged(MonitorEvent monitorEvent, boolean bl) {
        this.updatePixelScaleByWindowHandle(false);
    }

    @Override
    public final boolean setSurfaceScale(float[] fArray) {
        super.setSurfaceScale(fArray);
        boolean bl = false;
        if (this.isNativeValid()) {
            if (this.isOffscreenInstance) {
                NativeWindow nativeWindow = this.getParent();
                if (nativeWindow instanceof ScalableSurface) {
                    ScalableSurface scalableSurface = (ScalableSurface)((Object)nativeWindow);
                    scalableSurface.setSurfaceScale(this.reqPixelScale);
                    scalableSurface.getMaximumSurfaceScale(this.maxPixelScale);
                    scalableSurface.getMinimumSurfaceScale(this.minPixelScale);
                    float[] fArray2 = scalableSurface.getCurrentSurfaceScale(new float[2]);
                    bl = this.updatePixelScale(true, true, true, fArray2[0], this.maxPixelScale[0]);
                } else {
                    bl = this.updatePixelScale(true, true, true, this.reqPixelScale[0], this.maxPixelScale[0]);
                }
            } else {
                final float[] fArray3 = new float[2];
                System.arraycopy(this.hasPixelScale, 0, fArray3, 0, 2);
                if (SurfaceScaleUtils.setNewPixelScale(fArray3, fArray3, this.reqPixelScale, this.minPixelScale, this.maxPixelScale, DEBUG_IMPLEMENTATION ? this.getClass().getName() : null)) {
                    OSXUtil.RunOnMainThread(true, false, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.setPixelScale0(WindowDriver.this.getWindowHandle(), WindowDriver.this.surfaceHandle, fArray3[0]);
                        }
                    });
                    bl = true;
                }
            }
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowDriver.setPixelScale: min[" + this.minPixelScale[0] + ", " + this.minPixelScale[1] + "], max[" + this.maxPixelScale[0] + ", " + this.maxPixelScale[1] + "], req[" + this.reqPixelScale[0] + ", " + this.reqPixelScale[1] + "] -> result[" + this.hasPixelScale[0] + ", " + this.hasPixelScale[1] + "] - changed " + bl + ", realized " + this.isNativeValid());
        }
        return bl;
    }

    @Override
    protected void createNativeImpl() {
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(this.getScreen().getDisplay().getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, this.getScreen().getGraphicsScreen(), 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        this.reconfigureWindowImpl(this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.getReconfigureFlags(16, true));
        if (0L == this.getWindowHandle()) {
            throw new NativeWindowException("Error creating window");
        }
    }

    @Override
    protected void closeNativeImpl() {
        block4: {
            try {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.CloseAction " + Thread.currentThread().getName());
                }
                final long l2 = this.getWindowHandle();
                this.visibleChanged(true, false);
                this.setWindowHandle(0L);
                this.surfaceHandle = 0L;
                this.sscSurfaceHandle = 0L;
                this.isOffscreenInstance = false;
                if (0L != l2) {
                    OSXUtil.RunOnMainThread(false, true, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.close0(l2);
                        }
                    });
                }
            }
            catch (Throwable throwable) {
                if (!DEBUG_IMPLEMENTATION) break block4;
                Exception exception = new Exception("Warning: closeNative failed - " + Thread.currentThread().getName(), throwable);
                exception.printStackTrace();
            }
        }
    }

    @Override
    protected int lockSurfaceImpl() {
        long l2 = this.getWindowHandle();
        long l3 = this.surfaceHandle;
        if (0L != l3 && 0L != l2) {
            return this.lockSurface0(l2, l3) ? 3 : 1;
        }
        return 1;
    }

    @Override
    protected void unlockSurfaceImpl() {
        long l2 = this.getWindowHandle();
        long l3 = this.surfaceHandle;
        if (0L != l2 && 0L != l3 && !this.unlockSurface0(l2, l3)) {
            throw new NativeWindowException("Failed to unlock surface, probably not locked!");
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return 0L != this.sscSurfaceHandle ? this.sscSurfaceHandle : this.surfaceHandle;
    }

    @Override
    public void setSurfaceHandle(long l2) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.setSurfaceHandle(): 0x" + Long.toHexString(l2));
        }
        this.sscSurfaceHandle = l2;
        if (this.isNativeValid() && 0L != this.sscSurfaceHandle) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.orderOut0(0L != WindowDriver.this.getParentWindowHandle() ? WindowDriver.this.getParentWindowHandle() : WindowDriver.this.getWindowHandle());
                }
            });
        }
    }

    @Override
    protected void setTitleImpl(final String string) {
        OSXUtil.RunOnMainThread(false, false, new Runnable(){

            @Override
            public void run() {
                WindowDriver.this.setTitle0(WindowDriver.this.getWindowHandle(), string);
            }
        });
    }

    @Override
    protected void requestFocusImpl(final boolean bl) {
        final boolean bl2 = this.isFullscreen();
        boolean bl3 = this.isOffscreenInstance;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow: requestFocusImpl(), isOffscreenInstance " + bl3 + ", isFullscreen " + bl2);
        }
        if (!bl3) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.requestFocus0(WindowDriver.this.getWindowHandle(), bl);
                    if (bl2) {
                        WindowDriver.this.focusChanged(false, true);
                    }
                }
            });
        } else {
            this.focusChanged(false, true);
        }
    }

    @Override
    public final void clearFocus() {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow: clearFocus(), isOffscreenInstance " + this.isOffscreenInstance);
        }
        if (!this.isOffscreenInstance) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.resignFocus0(WindowDriver.this.getWindowHandle());
                }
            });
        } else {
            this.focusChanged(false, false);
        }
    }

    private boolean useParent(NativeWindow nativeWindow) {
        return null != nativeWindow && 0L != nativeWindow.getWindowHandle();
    }

    @Override
    public void updatePosition(int n2, int n3) {
        final long l2 = this.getWindowHandle();
        if (0L != l2 && !this.isOffscreenInstance) {
            NativeWindow nativeWindow = this.getParent();
            boolean bl = this.useParent(nativeWindow);
            int n4 = nativeWindow.getX();
            int n5 = nativeWindow.getY();
            final Point point = this.getLocationOnScreenImpl(n2, n3, nativeWindow, bl);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("MacWindow: updatePosition() parent[" + bl + " " + n4 + "/" + n5 + "] " + n2 + "/" + n3 + " ->  " + n2 + "/" + n3 + " rel-client-pos, " + point + " screen-client-pos");
            }
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.setWindowClientTopLeftPoint0(l2, point.getX(), point.getY(), WindowDriver.this.isVisible());
                }
            });
            this.positionChanged(true, n2, n3);
        }
    }

    @Override
    protected void sizeChanged(boolean bl, int n2, int n3, boolean bl2) {
        NativeWindow nativeWindow;
        boolean bl3;
        long l2 = this.getWindowHandle();
        if (0L != l2 && !this.isOffscreenInstance && (bl3 = this.useParent(nativeWindow = this.getParent())) && (this.getWidth() != n2 || this.getHeight() != n3)) {
            int n4 = this.getX();
            int n5 = this.getY();
            final Point point = this.getLocationOnScreenImpl(n4, n5, nativeWindow, bl3);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("MacWindow: sizeChanged() parent[" + bl3 + " " + n4 + "/" + n5 + "] " + this.getX() + "/" + this.getY() + " " + n2 + "x" + n3 + " ->  " + point + " screen-client-pos");
            }
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.setWindowClientTopLeftPoint0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY(), WindowDriver.this.isVisible());
                }
            });
        }
        this.superSizeChangedOffThread(bl, n2, n3, bl2);
    }

    private void superSizeChangedOffThread(boolean bl, final int n2, final int n3, final boolean bl2) {
        if (bl) {
            new Thread(){

                @Override
                public void run() {
                    WindowDriver.super.sizeChanged(false, n2, n3, bl2);
                }
            }.start();
        } else {
            WindowDriver.super.sizeChanged(false, n2, n3, bl2);
        }
    }

    @Override
    protected boolean reconfigureWindowImpl(int n2, int n3, final int n4, final int n5, int n6) {
        boolean bl;
        Point point;
        boolean bl2 = WindowDriver.isOffscreenInstance(this, this.getParent());
        boolean bl3 = this.isOffscreenInstance = 0L != this.sscSurfaceHandle || bl2;
        if (this.isOffscreenInstance) {
            n2 = 0;
            n3 = 0;
            point = new Point(0, 0);
        } else {
            NativeWindow nativeWindow = this.getParent();
            bl = this.useParent(nativeWindow);
            point = bl ? this.getLocationOnScreenImpl(n2, n3, nativeWindow, bl) : new Point(n2, n3);
        }
        final boolean bl4 = 0 != (0x2000 & n6);
        bl = this.hasFocus();
        if (DEBUG_IMPLEMENTATION) {
            AbstractGraphicsConfiguration abstractGraphicsConfiguration = this.getGraphicsConfiguration();
            NativeWindow nativeWindow = this.getParent();
            AbstractGraphicsConfiguration abstractGraphicsConfiguration2 = null != nativeWindow ? nativeWindow.getGraphicsConfiguration() : null;
            System.err.println("MacWindow reconfig.0: " + n2 + "/" + n3 + " -> clientPos " + point + " - " + n4 + "x" + n5 + ",\n\t parent type " + (null != nativeWindow ? nativeWindow.getClass().getName() : null) + ",\n\t   this-chosenCaps " + (null != abstractGraphicsConfiguration ? abstractGraphicsConfiguration.getChosenCapabilities() : null) + ",\n\t parent-chosenCaps " + (null != abstractGraphicsConfiguration2 ? abstractGraphicsConfiguration2.getChosenCapabilities() : null) + ", isOffscreenInstance(sscSurfaceHandle " + WindowDriver.toHexString(this.sscSurfaceHandle) + ", ioi: " + bl2 + ") -> " + this.isOffscreenInstance + "\n\t, " + WindowDriver.getReconfigureFlagsAsString(null, n6) + ", setVisible " + bl4 + ", hasFocus " + bl);
        }
        if (0 != (0x10 & n6) && !bl4) {
            if (!this.isOffscreenInstance) {
                OSXUtil.RunOnMainThread(false, false, new Runnable(){

                    @Override
                    public void run() {
                        WindowDriver.this.orderOut0(WindowDriver.this.getWindowHandle());
                        WindowDriver.this.visibleChanged(true, false);
                    }
                });
            } else {
                this.visibleChanged(true, false);
            }
        }
        if (0L == this.getWindowHandle() && bl4 || 0 != (2 & n6) || 0 != (1 & n6) || 0 != (4 & n6)) {
            if (this.isOffscreenInstance) {
                this.createWindow(true, 0L != this.getWindowHandle(), point, 64, 64, false, bl4, false);
            } else {
                this.createWindow(false, 0L != this.getWindowHandle(), point, n4, n5, 0 != (0x400 & n6), bl4, 0 != (0x1000 & n6));
            }
            this.positionChanged(false, n2, n3);
            this.updatePixelScaleByWindowHandle(false);
            super.sizeChanged(false, n4, n5, true);
            this.visibleChanged(false, bl4);
            if (bl) {
                this.requestFocusImpl(true);
            }
        } else {
            if (n4 > 0 && n5 > 0) {
                if (!this.isOffscreenInstance) {
                    OSXUtil.RunOnMainThread(false, false, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.setWindowClientTopLeftPointAndSize0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY(), n4, n5, bl4);
                        }
                    });
                }
                this.positionChanged(true, n2, n3);
                super.sizeChanged(true, n4, n5, false);
            }
            if (0 != (0x10 & n6) && bl4) {
                if (!this.isOffscreenInstance) {
                    OSXUtil.RunOnMainThread(false, false, new Runnable(){

                        @Override
                        public void run() {
                            WindowDriver.this.orderFront0(WindowDriver.this.getWindowHandle());
                            WindowDriver.this.visibleChanged(true, true);
                        }
                    });
                } else {
                    this.visibleChanged(true, true);
                }
            }
            if (!this.isOffscreenInstance) {
                this.setAlwaysOnTop0(this.getWindowHandle(), 0 != (0x1000 & n6));
            }
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow reconfig.X: clientPos " + point + ", " + n4 + "x" + n5 + " -> clientPos " + this.getLocationOnScreenImpl(0, 0) + ", insets: " + this.getInsets());
        }
        return true;
    }

    @Override
    protected Point getLocationOnScreenImpl(int n2, int n3) {
        NativeWindow nativeWindow = this.getParent();
        boolean bl = this.useParent(nativeWindow);
        return this.getLocationOnScreenImpl(n2, n3, nativeWindow, bl);
    }

    private Point getLocationOnScreenImpl(int n2, int n3, NativeWindow nativeWindow, boolean bl) {
        if (!bl && !this.isOffscreenInstance && 0L != this.surfaceHandle) {
            return OSXUtil.GetLocationOnScreen(this.surfaceHandle, n2, n3);
        }
        Point point = new Point(n2, n3);
        if (bl) {
            point.translate(nativeWindow.getLocationOnScreen(null));
        }
        return point;
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    protected void screenPositionChanged(boolean bl, int n2, int n3) {
        if (this.getWindowHandle() != 0L) {
            NativeWindow nativeWindow = this.getParent();
            if (null == nativeWindow || this.isOffscreenInstance) {
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.positionChanged.0 (Screen Pos - TOP): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> " + n2 + "/" + n3);
                }
                this.positionChanged(bl, n2, n3);
            } else {
                Point point = new Point(n2, n3);
                Point point2 = nativeWindow.getLocationOnScreen(null);
                point.translate(point2.scale(-1, -1));
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("MacWindow.positionChanged.1 (Screen Pos - CHILD): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> absPos " + n2 + "/" + n3 + ", parentOnScreen " + point2 + " -> " + point);
                }
                this.positionChanged(bl, point.getX(), point.getY());
            }
        } else if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.positionChanged.2 (Screen Pos - IGN): (" + WindowDriver.getThreadName() + "): (defer: " + bl + ") " + this.getX() + "/" + this.getY() + " -> " + n2 + "/" + n3);
        }
    }

    @Override
    protected void setPointerIconImpl(PointerIconImpl pointerIconImpl) {
        if (!this.isOffscreenInstance) {
            final long l2 = null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L;
            OSXUtil.RunOnMainThread(true, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.setPointerIcon0(WindowDriver.this.getWindowHandle(), l2);
                }
            });
        }
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        if (!this.isOffscreenInstance) {
            OSXUtil.RunOnMainThread(false, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.setPointerVisible0(WindowDriver.this.getWindowHandle(), WindowDriver.this.hasFocus(), bl);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    protected boolean confinePointerImpl(boolean bl) {
        if (!this.isOffscreenInstance) {
            WindowDriver.confinePointer0(this.getWindowHandle(), bl);
            return true;
        }
        return false;
    }

    @Override
    protected void warpPointerImpl(int n2, int n3) {
        if (!this.isOffscreenInstance) {
            WindowDriver.warpPointer0(this.getWindowHandle(), SurfaceScaleUtils.scaleInv(n2, this.getPixelScaleX()), SurfaceScaleUtils.scaleInv(n3, this.getPixelScaleY()));
        }
    }

    @Override
    protected final void doMouseEvent(boolean bl, boolean bl2, short s, int n2, int n3, int n4, short s2, float[] fArray, float f2) {
        super.doMouseEvent(bl, bl2, s, n2, SurfaceScaleUtils.scale(n3, this.getPixelScaleX()), SurfaceScaleUtils.scale(n4, this.getPixelScaleY()), s2, fArray, f2);
    }

    @Override
    public final void sendKeyEvent(short s, int n2, short s2, short s3, char c2) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    @Override
    public final void enqueueKeyEvent(boolean bl, short s, int n2, short s2, short s3, char c2) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    protected final void enqueueKeyEvent(boolean bl, short s, int n2, short s2, char c2, char c3) {
        short s3 = MacKeyUtil.validateKeyCode(s2, c2);
        short s4 = '\u0000' != c3 ? KeyEvent.utf16ToVKey(c3) : (short)0;
        short s5 = 0 != s4 ? s4 : s3;
        switch (s) {
            case 301: {
                if (!this.isKeyCodeTracked(s3)) break;
                this.setKeyPressed(s3, false);
                break;
            }
            case 300: {
                if (!this.isKeyCodeTracked(s3) || !this.setKeyPressed(s3, true)) break;
                super.enqueueKeyEvent(bl, (short)301, n2 |= 0x20000000, s3, s5, c2);
            }
        }
        super.enqueueKeyEvent(bl, s, n2, s3, s5, c2);
    }

    protected int getDisplayID() {
        long l2;
        if (!this.isOffscreenInstance && 0L != (l2 = this.getWindowHandle())) {
            return this.getDisplayID0(l2);
        }
        return 0;
    }

    private void createWindow(final boolean bl, boolean bl2, final PointImmutable pointImmutable, final int n2, final int n3, boolean bl3, final boolean bl4, final boolean bl5) {
        final long l2 = this.getParentWindowHandle();
        final long l3 = this.getWindowHandle();
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("MacWindow.createWindow on thread " + Thread.currentThread().getName() + ": offscreen " + bl + ", recreate " + bl2 + ", pS " + pointImmutable + ", " + n2 + "x" + n3 + ", fullscreen " + bl3 + ", visible " + bl4 + ", alwaysOnTop " + bl5 + ", preWinHandle " + WindowDriver.toHexString(l3) + ", parentWin " + WindowDriver.toHexString(l2) + ", surfaceHandle " + WindowDriver.toHexString(this.surfaceHandle));
        }
        try {
            if (0L != l3) {
                this.setWindowHandle(0L);
                if (0L == this.surfaceHandle) {
                    throw new NativeWindowException("Internal Error - create w/ window, but no Newt NSView");
                }
                OSXUtil.RunOnMainThread(false, false, new Runnable(){

                    @Override
                    public void run() {
                        WindowDriver.this.changeContentView0(l2, l3, 0L);
                        WindowDriver.this.close0(l3);
                    }
                });
            } else {
                if (0L != this.surfaceHandle) {
                    throw new NativeWindowException("Internal Error - create w/o window, but has Newt NSView");
                }
                this.surfaceHandle = this.createView0(pointImmutable.getX(), pointImmutable.getY(), n2, n3);
                if (0L == this.surfaceHandle) {
                    throw new NativeWindowException("Could not create native view " + Thread.currentThread().getName() + " " + this);
                }
            }
            final long l4 = this.createWindow0(pointImmutable.getX(), pointImmutable.getY(), n2, n3, bl3, this.isUndecorated() || bl ? 0 : 15, 2, this.surfaceHandle);
            if (l4 == 0L) {
                throw new NativeWindowException("Could not create native window " + Thread.currentThread().getName() + " " + this);
            }
            this.setWindowHandle(l4);
            final boolean bl6 = this.getGraphicsConfiguration().getChosenCapabilities().isBackgroundOpaque() && !bl;
            OSXUtil.RunOnMainThread(true, false, new Runnable(){

                @Override
                public void run() {
                    WindowDriver.this.initWindow0(l2, l4, pointImmutable.getX(), pointImmutable.getY(), n2, n3, WindowDriver.this.reqPixelScale[0], bl6, bl4 && !bl, WindowDriver.this.surfaceHandle);
                    if (bl) {
                        WindowDriver.this.orderOut0(0L != l2 ? l2 : l4);
                    } else {
                        WindowDriver.this.setTitle0(l4, WindowDriver.this.getTitle());
                        WindowDriver.this.setAlwaysOnTop0(WindowDriver.this.getWindowHandle(), bl5);
                    }
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected static native boolean initIDs0();

    private native long createView0(int var1, int var2, int var3, int var4);

    private native long createWindow0(int var1, int var2, int var3, int var4, boolean var5, int var6, int var7, long var8);

    private native void initWindow0(long var1, long var3, int var5, int var6, int var7, int var8, float var9, boolean var10, boolean var11, long var12);

    private native int getDisplayID0(long var1);

    private native void setPixelScale0(long var1, long var3, float var5);

    private native boolean lockSurface0(long var1, long var3);

    private native boolean unlockSurface0(long var1, long var3);

    private native void requestFocus0(long var1, boolean var3);

    private native void resignFocus0(long var1);

    private native void orderOut0(long var1);

    private native void orderFront0(long var1);

    private native void close0(long var1);

    private native void setTitle0(long var1, String var3);

    private native long contentView0(long var1);

    private native void changeContentView0(long var1, long var3, long var5);

    private native void setWindowClientTopLeftPointAndSize0(long var1, int var3, int var4, int var5, int var6, boolean var7);

    private native void setWindowClientTopLeftPoint0(long var1, int var3, int var4, boolean var5);

    private native void setAlwaysOnTop0(long var1, boolean var3);

    private static native Object getLocationOnScreen0(long var0, int var2, int var3);

    private static native void setPointerIcon0(long var0, long var2);

    private static native void setPointerVisible0(long var0, boolean var2, boolean var3);

    private static native void confinePointer0(long var0, boolean var2);

    private static native void warpPointer0(long var0, int var2, int var3);

    static {
        DisplayDriver.initSingleton();
    }
}

