/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.windows;

import com.jogamp.common.os.Platform;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.newt.event.KeyEvent;
import com.jogamp.newt.event.MouseEvent;
import java.nio.ByteBuffer;
import jogamp.nativewindow.windows.GDI;
import jogamp.nativewindow.windows.GDIUtil;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.windows.DisplayDriver;
import jogamp.newt.driver.windows.ScreenDriver;

public class WindowDriver
extends WindowImpl {
    private long hmon;
    private long hdc;
    private long hdc_old;
    private long windowHandleClose;
    private short repeatedKey = 0;

    @Override
    protected int lockSurfaceImpl() {
        if (0L != this.hdc) {
            throw new InternalError("surface not released");
        }
        long l2 = this.getWindowHandle();
        this.hdc = GDI.GetDC(l2);
        if (0L == this.hdc) {
            return 1;
        }
        this.hmon = this.MonitorFromWindow0(l2);
        return 3;
    }

    @Override
    protected void unlockSurfaceImpl() {
        if (0L != this.hdc) {
            GDI.ReleaseDC(this.getWindowHandle(), this.hdc);
            this.hdc_old = this.hdc;
            this.hdc = 0L;
        }
    }

    @Override
    public final long getSurfaceHandle() {
        return this.hdc;
    }

    @Override
    public boolean hasDeviceChanged() {
        long l2;
        if (0L != this.getWindowHandle() && this.hmon != (l2 = this.MonitorFromWindow0(this.getWindowHandle()))) {
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("Info: Window Device Changed " + Thread.currentThread().getName() + ", HMON " + WindowDriver.toHexString(this.hmon) + " -> " + WindowDriver.toHexString(l2));
            }
            this.hmon = l2;
            return true;
        }
        return false;
    }

    @Override
    protected void createNativeImpl() {
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)screenDriver.getDisplay();
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = GraphicsConfigurationFactory.getFactory(displayDriver.getGraphicsDevice(), this.capsRequested).chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, screenDriver.getGraphicsScreen(), 0);
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        VersionNumber versionNumber = Platform.getOSVersionNumber();
        int n2 = this.getReconfigureFlags(0, true) & 0x1200;
        long l2 = this.CreateWindow0(DisplayDriver.getHInstance(), displayDriver.getWindowClassName(), displayDriver.getWindowClassName(), versionNumber.getMajor(), versionNumber.getMinor(), this.getParentWindowHandle(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.autoPosition(), n2);
        if (0L == l2) {
            throw new NativeWindowException("Error creating window");
        }
        this.setWindowHandle(l2);
        this.windowHandleClose = l2;
        if (DEBUG_IMPLEMENTATION) {
            Exception exception = new Exception("Info: Window new window handle " + Thread.currentThread().getName() + " (Parent HWND " + WindowDriver.toHexString(this.getParentWindowHandle()) + ") : HWND " + WindowDriver.toHexString(l2) + ", " + Thread.currentThread());
            exception.printStackTrace();
        }
    }

    @Override
    protected void closeNativeImpl() {
        block7: {
            if (0L != this.windowHandleClose) {
                Exception exception;
                block6: {
                    if (0L != this.hdc) {
                        try {
                            GDI.ReleaseDC(this.windowHandleClose, this.hdc);
                        }
                        catch (Throwable throwable) {
                            if (!DEBUG_IMPLEMENTATION) break block6;
                            exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                            exception.printStackTrace();
                        }
                    }
                }
                try {
                    GDI.DestroyWindow(this.windowHandleClose);
                }
                catch (Throwable throwable) {
                    if (!DEBUG_IMPLEMENTATION) break block7;
                    exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
        }
        this.windowHandleClose = 0L;
        this.hdc = 0L;
        this.hdc_old = 0L;
    }

    @Override
    protected boolean reconfigureWindowImpl(int n2, int n3, int n4, int n5, int n6) {
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("WindowsWindow reconfig: " + n2 + "/" + n3 + " " + n4 + "x" + n5 + ", " + WindowDriver.getReconfigureFlagsAsString(null, n6));
        }
        if (0 == (0x200 & n6)) {
            InsetsImmutable insetsImmutable = this.getInsets();
            n2 -= insetsImmutable.getLeftWidth();
            n3 -= insetsImmutable.getTopHeight();
            if (0 < n4 && 0 < n5) {
                n4 += insetsImmutable.getTotalWidth();
                n5 += insetsImmutable.getTotalHeight();
            }
        }
        this.reconfigureWindow0(this.getParentWindowHandle(), this.getWindowHandle(), n2, n3, n4, n5, n6);
        if (0 != (0x10 & n6)) {
            this.visibleChanged(false, 0 != (0x2000 & n6));
        }
        return true;
    }

    @Override
    protected void requestFocusImpl(boolean bl) {
        this.requestFocus0(this.getWindowHandle(), bl);
    }

    @Override
    protected void setTitleImpl(String string) {
        WindowDriver.setTitle0(this.getWindowHandle(), string);
    }

    @Override
    protected void setPointerIconImpl(PointerIconImpl pointerIconImpl) {
        WindowDriver.setPointerIcon0(this.getWindowHandle(), null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L);
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        final boolean[] blArray = new boolean[]{false};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                blArray[0] = WindowDriver.setPointerVisible0(WindowDriver.this.getWindowHandle(), bl);
            }
        });
        return blArray[0];
    }

    @Override
    protected boolean confinePointerImpl(final boolean bl) {
        final Boolean[] booleanArray = new Boolean[]{Boolean.FALSE};
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                Point point = WindowDriver.this.convertToPixelUnits(WindowDriver.this.getLocationOnScreenImpl(0, 0));
                booleanArray[0] = WindowDriver.confinePointer0(WindowDriver.this.getWindowHandle(), bl, point.getX(), point.getY(), point.getX() + WindowDriver.this.getSurfaceWidth(), point.getY() + WindowDriver.this.getSurfaceHeight());
            }
        });
        return booleanArray[0];
    }

    @Override
    protected void warpPointerImpl(final int n2, final int n3) {
        this.runOnEDTIfAvail(true, new Runnable(){

            @Override
            public void run() {
                Point point = WindowDriver.this.convertToPixelUnits(WindowDriver.this.getLocationOnScreenImpl(n2, n3));
                WindowDriver.warpPointer0(WindowDriver.this.getWindowHandle(), point.getX(), point.getY());
            }
        });
    }

    @Override
    protected Point getLocationOnScreenImpl(int n2, int n3) {
        return GDIUtil.GetRelativeLocation(this.getWindowHandle(), 0L, n2, n3);
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    public final void sendTouchScreenEvent(short s, int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, float[] fArray, float f2) {
        int n4 = nArray.length;
        MouseEvent.PointerType[] pointerTypeArray = new MouseEvent.PointerType[n4];
        for (int i2 = n4 - 1; i2 >= 0; --i2) {
            pointerTypeArray[i2] = MouseEvent.PointerType.TouchScreen;
        }
        this.doPointerEvent(false, false, pointerTypeArray, s, n2, n3, false, nArray, nArray2, nArray3, fArray, f2, new float[]{0.0f, 0.0f, 0.0f}, 1.0f);
    }

    private final boolean handlePressTypedAutoRepeat(boolean bl, int n2, short s, short s2, char c2) {
        if (this.setKeyPressed(s, true)) {
            boolean bl2 = this.repeatedKey == s;
            this.repeatedKey = s;
            if (!bl) {
                n2 |= 0x20000000;
                if (bl2) {
                    super.sendKeyEvent((short)300, n2, s, s2, c2);
                }
                super.sendKeyEvent((short)301, n2, s, s2, c2);
            }
            return true;
        }
        return false;
    }

    @Override
    public final void sendKeyEvent(short s, int n2, short s2, short s3, char c2) {
        boolean bl = KeyEvent.isModifierKey(s3);
        switch (s) {
            case 301: {
                if (this.isKeyCodeTracked(s2)) {
                    if (this.repeatedKey == s2 && !bl) {
                        super.sendKeyEvent((short)300, n2 | 0x20000000, s2, s3, c2);
                    }
                    this.setKeyPressed(s2, false);
                    this.repeatedKey = 0;
                }
                super.sendKeyEvent((short)301, n2, s2, s3, c2);
                break;
            }
            case 300: {
                if (this.handlePressTypedAutoRepeat(bl, n2, s2, s3, c2)) break;
                super.sendKeyEvent((short)300, n2, s2, s3, c2);
            }
        }
    }

    @Override
    public final void enqueueKeyEvent(boolean bl, short s, int n2, short s2, short s3, char c2) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    protected static native long getNewtWndProc0();

    protected static native boolean initIDs0(long var0);

    private native long CreateWindow0(long var1, String var3, String var4, int var5, int var6, long var7, int var9, int var10, int var11, int var12, boolean var13, int var14);

    private native long MonitorFromWindow0(long var1);

    private native void reconfigureWindow0(long var1, long var3, int var5, int var6, int var7, int var8, int var9);

    private static native void setTitle0(long var0, String var2);

    private native void requestFocus0(long var1, boolean var3);

    private static native boolean setPointerVisible0(long var0, boolean var2);

    private static native boolean confinePointer0(long var0, boolean var2, int var3, int var4, int var5, int var6);

    private static native void warpPointer0(long var0, int var2, int var3);

    private static native ByteBuffer newDirectByteBuffer(long var0, long var2);

    private static native void setPointerIcon0(long var0, long var2);

    static {
        DisplayDriver.initSingleton();
    }
}

