/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.x11;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.nio.Buffers;
import com.jogamp.nativewindow.AbstractGraphicsConfiguration;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.util.Insets;
import com.jogamp.nativewindow.util.InsetsImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.newt.NewtFactory;
import com.jogamp.newt.event.KeyEvent;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.X11Util;
import jogamp.newt.DisplayImpl;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.WindowImpl;
import jogamp.newt.driver.PNGIcon;
import jogamp.newt.driver.x11.DisplayDriver;
import jogamp.newt.driver.x11.ScreenDriver;

public class WindowDriver
extends WindowImpl {
    private static final String WINDOW_CLASS_NAME = "NewtWindow";
    private static final int X11_WHEEL_ONE_UP_BUTTON = 4;
    private static final int X11_WHEEL_ONE_DOWN_BUTTON = 5;
    private static final int X11_WHEEL_TWO_UP_BUTTON = 6;
    private static final int X11_WHEEL_TWO_DOWN_BUTTON = 7;
    private static final int defaultIconDataSize;
    private static final Buffer defaultIconData;
    volatile boolean tempFSAlwaysOnTop = false;
    private long windowHandleClose;
    private X11GraphicsDevice renderDevice;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void createNativeImpl() {
        ScreenDriver screenDriver = (ScreenDriver)this.getScreen();
        DisplayDriver displayDriver = (DisplayDriver)screenDriver.getDisplay();
        AbstractGraphicsDevice abstractGraphicsDevice = displayDriver.getGraphicsDevice();
        long l2 = X11Util.openDisplay(abstractGraphicsDevice.getConnection());
        if (0L == l2) {
            throw new RuntimeException("Error creating display(GfxCfg/Render): " + abstractGraphicsDevice.getConnection());
        }
        this.renderDevice = new X11GraphicsDevice(l2, 0, true);
        X11GraphicsScreen x11GraphicsScreen = new X11GraphicsScreen(this.renderDevice, screenDriver.getIndex());
        GraphicsConfigurationFactory graphicsConfigurationFactory = GraphicsConfigurationFactory.getFactory(displayDriver.getGraphicsDevice(), this.capsRequested);
        AbstractGraphicsConfiguration abstractGraphicsConfiguration = graphicsConfigurationFactory.chooseGraphicsConfiguration(this.capsRequested, this.capsRequested, this.capabilitiesChooser, x11GraphicsScreen, 0);
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window.createNativeImpl() factory: " + graphicsConfigurationFactory + ", chosen config: " + abstractGraphicsConfiguration);
        }
        if (null == abstractGraphicsConfiguration) {
            throw new NativeWindowException("Error choosing GraphicsConfiguration creating window: " + this);
        }
        int n2 = abstractGraphicsConfiguration.getVisualID(VisualIDHolder.VIDType.NATIVE);
        if (0 == n2) {
            throw new NativeWindowException("Chosen Configuration w/o native visual ID: " + abstractGraphicsConfiguration);
        }
        this.setGraphicsConfiguration(abstractGraphicsConfiguration);
        int n3 = this.getReconfigureFlags(0, true) & 0x1200;
        abstractGraphicsDevice.lock();
        try {
            this.setWindowHandle(this.CreateWindow(this.getParentWindowHandle(), abstractGraphicsDevice.getHandle(), screenDriver.getIndex(), n2, displayDriver.getJavaObjectAtom(), displayDriver.getWindowDeleteAtom(), this.getX(), this.getY(), this.getWidth(), this.getHeight(), this.autoPosition(), n3, defaultIconDataSize, defaultIconData));
        }
        finally {
            abstractGraphicsDevice.unlock();
        }
        this.windowHandleClose = this.getWindowHandle();
        if (0L == this.windowHandleClose) {
            throw new NativeWindowException("Error creating window");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closeNativeImpl() {
        if (0L != this.windowHandleClose && null != this.getScreen()) {
            DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
            AbstractGraphicsDevice abstractGraphicsDevice = displayDriver.getGraphicsDevice();
            abstractGraphicsDevice.lock();
            try {
                this.CloseWindow0(abstractGraphicsDevice.getHandle(), this.windowHandleClose, displayDriver.getJavaObjectAtom(), displayDriver.getWindowDeleteAtom(), displayDriver.getRandREventBase(), displayDriver.getRandRErrorBase());
            }
            catch (Throwable throwable) {
                if (DEBUG_IMPLEMENTATION) {
                    Exception exception = new Exception("Warning: closeNativeImpl failed - " + Thread.currentThread().getName(), throwable);
                    exception.printStackTrace();
                }
            }
            finally {
                abstractGraphicsDevice.unlock();
                this.windowHandleClose = 0L;
            }
        }
        if (null != this.renderDevice) {
            this.renderDevice.close();
            this.renderDevice = null;
        }
    }

    @Override
    protected boolean isReconfigureFlagSupported(int n2) {
        return true;
    }

    @Override
    protected boolean reconfigureWindowImpl(int n2, int n3, final int n4, final int n5, int n6) {
        int n7;
        int n8;
        InsetsImmutable insetsImmutable;
        if (0 == (0x200 & n6)) {
            insetsImmutable = this.getInsets();
            n8 = n2 - insetsImmutable.getLeftWidth();
            n7 = n3 - insetsImmutable.getTopHeight();
        } else {
            insetsImmutable = null;
            n8 = n2;
            n7 = n3;
        }
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("X11Window reconfig: " + n2 + "/" + n3 + " -> " + n8 + "/" + n7 + " " + n4 + "x" + n5 + ", insets " + insetsImmutable + ", " + WindowDriver.getReconfigureFlagsAsString(null, n6));
        }
        if (0 != (4 & n6)) {
            if (0 != (0x400 & n6) && 0 == (0x1000 & n6)) {
                this.tempFSAlwaysOnTop = true;
                n6 |= 0x1000;
                if (DEBUG_IMPLEMENTATION) {
                    System.err.println("X11Window reconfig.2: temporary " + WindowDriver.getReconfigureFlagsAsString(null, n6));
                }
            } else {
                this.tempFSAlwaysOnTop = false;
            }
        }
        final int n9 = n6;
        final DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l2) {
                WindowDriver.this.reconfigureWindow0(l2, WindowDriver.this.getScreenIndex(), WindowDriver.this.getParentWindowHandle(), WindowDriver.this.getWindowHandle(), displayDriver.getWindowDeleteAtom(), n8, n7, n4, n5, n9);
                return null;
            }
        });
        return true;
    }

    @Override
    protected void focusChanged(boolean bl, boolean bl2) {
        if (this.isNativeValid() && this.isFullscreen() && this.tempFSAlwaysOnTop && this.hasFocus() != bl2) {
            final int n2 = this.getReconfigureFlags(8, this.isVisible()) | (bl2 ? 4096 : 0);
            if (DEBUG_IMPLEMENTATION) {
                System.err.println("X11Window reconfig.3 (focus): temporary " + WindowDriver.getReconfigureFlagsAsString(null, n2));
            }
            final DisplayDriver displayDriver = (DisplayDriver)this.getScreen().getDisplay();
            this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

                @Override
                public Object run(long l2) {
                    WindowDriver.this.reconfigureWindow0(l2, WindowDriver.this.getScreenIndex(), WindowDriver.this.getParentWindowHandle(), WindowDriver.this.getWindowHandle(), displayDriver.getWindowDeleteAtom(), WindowDriver.this.getX(), WindowDriver.this.getY(), WindowDriver.this.getWidth(), WindowDriver.this.getHeight(), n2);
                    return null;
                }
            });
        }
        super.focusChanged(bl, bl2);
    }

    protected void reparentNotify(long l2) {
        if (DEBUG_IMPLEMENTATION) {
            long l3 = this.getParentWindowHandle();
            System.err.println("Window.reparentNotify (" + WindowDriver.getThreadName() + "): " + WindowDriver.toHexString(l3) + " -> " + WindowDriver.toHexString(l2));
        }
    }

    @Override
    protected void requestFocusImpl(final boolean bl) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l2) {
                WindowDriver.this.requestFocus0(l2, WindowDriver.this.getWindowHandle(), bl);
                return null;
            }
        });
    }

    @Override
    protected void setTitleImpl(final String string) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l2) {
                WindowDriver.setTitle0(l2, WindowDriver.this.getWindowHandle(), string);
                return null;
            }
        });
    }

    @Override
    protected void setPointerIconImpl(final PointerIconImpl pointerIconImpl) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l2) {
                try {
                    WindowDriver.setPointerIcon0(l2, WindowDriver.this.getWindowHandle(), null != pointerIconImpl ? pointerIconImpl.validatedHandle() : 0L);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return null;
            }
        });
    }

    @Override
    protected boolean setPointerVisibleImpl(final boolean bl) {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l2) {
                boolean bl2;
                PointerIconImpl pointerIconImpl = (PointerIconImpl)WindowDriver.this.getPointerIcon();
                if (bl && null != pointerIconImpl) {
                    WindowDriver.setPointerIcon0(l2, WindowDriver.this.getWindowHandle(), pointerIconImpl.validatedHandle());
                    bl2 = true;
                } else {
                    bl2 = WindowDriver.setPointerVisible0(l2, WindowDriver.this.getWindowHandle(), bl);
                }
                return bl2;
            }
        });
    }

    @Override
    protected boolean confinePointerImpl(final boolean bl) {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Boolean>(){

            @Override
            public Boolean run(long l2) {
                return WindowDriver.confinePointer0(l2, WindowDriver.this.getWindowHandle(), bl);
            }
        });
    }

    @Override
    protected void warpPointerImpl(final int n2, final int n3) {
        this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Object>(){

            @Override
            public Object run(long l2) {
                WindowDriver.warpPointer0(l2, WindowDriver.this.getWindowHandle(), n2, n3);
                return null;
            }
        });
    }

    @Override
    protected Point getLocationOnScreenImpl(final int n2, final int n3) {
        return this.runWithLockedDisplayDevice(new DisplayImpl.DisplayRunnable<Point>(){

            @Override
            public Point run(long l2) {
                return X11Lib.GetRelativeLocation(l2, WindowDriver.this.getScreenIndex(), WindowDriver.this.getWindowHandle(), 0L, n2, n3);
            }
        });
    }

    @Override
    protected void updateInsetsImpl(Insets insets) {
    }

    @Override
    protected final void doMouseEvent(boolean bl, boolean bl2, short s, int n2, int n3, int n4, short s2, float[] fArray, float f2) {
        block0 : switch (s) {
            case 203: {
                switch (s2) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        return;
                    }
                }
                break;
            }
            case 204: {
                boolean bl3 = 0 != (n2 & 1);
                switch (s2) {
                    case 4: {
                        s = (short)207;
                        s2 = 1;
                        fArray[bl3 ? 0 : 1] = 1.0f;
                        break block0;
                    }
                    case 5: {
                        s = (short)207;
                        s2 = 1;
                        fArray[bl3 ? 0 : 1] = -1.0f;
                        break block0;
                    }
                    case 6: {
                        s = (short)207;
                        s2 = 1;
                        fArray[0] = 1.0f;
                        n2 |= 1;
                        break block0;
                    }
                    case 7: {
                        s = (short)207;
                        s2 = 1;
                        fArray[0] = -1.0f;
                        n2 |= 1;
                    }
                }
            }
        }
        super.doMouseEvent(bl, bl2, s, n2, n3, n4, s2, fArray, f2);
    }

    protected final void sendKeyEvent(short s, int n2, short s2, short s3, char c2, String string) {
        char c3;
        boolean bl = KeyEvent.isModifierKey(s2);
        boolean bl2 = 0 != (0x20000000 & n2);
        char c4 = c3 = null != string ? string.charAt(0) : c2;
        if (!bl2 || !bl) {
            switch (s) {
                case 300: {
                    super.sendKeyEvent((short)300, n2, s2, s3, c3);
                    break;
                }
                case 301: {
                    super.sendKeyEvent((short)301, n2, s2, s3, c3);
                }
            }
        }
    }

    @Override
    public final void sendKeyEvent(short s, int n2, short s2, short s3, char c2) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    @Override
    public final void enqueueKeyEvent(boolean bl, short s, int n2, short s2, short s3, char c2) {
        throw new InternalError("XXX: Adapt Java Code to Native Code Changes");
    }

    private static final String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    private static final void dumpStack() {
        ExceptionUtils.dumpStack(System.err);
    }

    private final <T> T runWithLockedDisplayDevice(DisplayImpl.DisplayRunnable<T> displayRunnable) {
        return ((DisplayDriver)this.getScreen().getDisplay()).runWithLockedDisplayDevice(displayRunnable);
    }

    protected static native boolean initIDs0();

    private long CreateWindow(long l2, long l3, int n2, int n3, long l4, long l5, int n4, int n5, int n6, int n7, boolean bl, int n8, int n9, Buffer buffer) {
        if (!Buffers.isDirect(buffer)) {
            throw new IllegalArgumentException("data buffer is not direct " + buffer);
        }
        return this.CreateWindow0(l2, l3, n2, n3, l4, l5, n4, n5, n6, n7, bl, n8, n9, buffer, Buffers.getDirectBufferByteOffset(buffer), true);
    }

    private native long CreateWindow0(long var1, long var3, int var5, int var6, long var7, long var9, int var11, int var12, int var13, int var14, boolean var15, int var16, int var17, Object var18, int var19, boolean var20);

    private native void CloseWindow0(long var1, long var3, long var5, long var7, int var9, int var10);

    private native void reconfigureWindow0(long var1, int var3, long var4, long var6, long var8, int var10, int var11, int var12, int var13, int var14);

    private native void requestFocus0(long var1, long var3, boolean var5);

    private static native void setTitle0(long var0, long var2, String var4);

    private static native void setPointerIcon0(long var0, long var2, long var4);

    private static native long getParentWindow0(long var0, long var2);

    private static native boolean setPointerVisible0(long var0, long var2, boolean var4);

    private static native boolean confinePointer0(long var0, long var2, boolean var4);

    private static native void warpPointer0(long var0, long var2, int var4, int var5);

    static {
        ScreenDriver.initSingleton();
        int n2 = 0;
        int n3 = 0;
        ByteBuffer byteBuffer = null;
        if (PNGIcon.isAvailable()) {
            try {
                int[] nArray = new int[]{0};
                int[] nArray2 = new int[]{0};
                byteBuffer = PNGIcon.arrayToX11BGRAImages(NewtFactory.getWindowIcons(), nArray, nArray2);
                n2 = nArray[0];
                n3 = nArray2[0];
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        defaultIconDataSize = n2;
        defaultIconData = byteBuffer;
        if (DEBUG_IMPLEMENTATION) {
            System.err.println("Def. Icon: data_size " + defaultIconDataSize + " * elem_size " + n3 + " = data " + defaultIconData);
        }
    }
}

