/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.VersionNumber;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLContext;
import java.util.HashMap;
import java.util.StringTokenizer;
import jogamp.opengl.GLContextImpl;

final class ExtensionAvailabilityCache {
    protected static final boolean DEBUG = GLContextImpl.DEBUG;
    private boolean initialized = false;
    private String glExtensions = null;
    private int glExtensionCount = 0;
    private String glXExtensions = null;
    private int glXExtensionCount = 0;
    private final HashMap<String, String> availableExtensionCache = new HashMap(100);

    ExtensionAvailabilityCache() {
        this.flush();
    }

    final void flush() {
        this.initialized = false;
        this.glExtensions = null;
        this.glExtensionCount = 0;
        this.glXExtensions = null;
        this.glXExtensionCount = 0;
        this.availableExtensionCache.clear();
    }

    final void reset(GLContextImpl gLContextImpl) {
        this.flush();
        this.initAvailableExtensions(gLContextImpl);
    }

    final boolean isInitialized() {
        return this.initialized;
    }

    final int getTotalExtensionCount() {
        this.validateInitialization();
        return this.availableExtensionCache.size();
    }

    final boolean isExtensionAvailable(String string) {
        this.validateInitialization();
        return null != this.availableExtensionCache.get(string);
    }

    final int getPlatformExtensionCount() {
        this.validateInitialization();
        return this.glXExtensionCount;
    }

    final String getPlatformExtensionsString() {
        this.validateInitialization();
        return this.glXExtensions;
    }

    final int getGLExtensionCount() {
        this.validateInitialization();
        return this.glExtensionCount;
    }

    final String getGLExtensionsString() {
        this.validateInitialization();
        if (DEBUG) {
            System.err.println("ExtensionAvailabilityCache: getGLExtensions() called");
        }
        return this.glExtensions;
    }

    private final void validateInitialization() {
        if (!this.isInitialized()) {
            throw new InternalError("ExtensionAvailabilityCache not initialized!");
        }
    }

    private final void initAvailableExtensions(GLContextImpl gLContextImpl) {
        String string;
        int n2;
        Object object;
        Object object2;
        GL gL = gLContextImpl.getGL();
        if (this.isInitialized()) {
            throw new InternalError("ExtensionAvailabilityCache already initialized!");
        }
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Pre-caching init " + gL + ", OpenGL " + gLContextImpl.getGLVersion());
        }
        boolean bl = false;
        if (gLContextImpl.isGL3()) {
            if (!gLContextImpl.isFunctionAvailable("glGetStringi")) {
                if (DEBUG) {
                    System.err.println("GLContext: GL >= 3.1 usage, but no glGetStringi");
                }
            } else {
                bl = true;
            }
        }
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Pre-caching extension availability OpenGL " + gLContextImpl.getGLVersion() + ", use " + (bl ? "glGetStringi" : "glGetString"));
        }
        if (bl) {
            object2 = gL.getGL2GL3();
            object = new int[]{0};
            object2.glGetIntegerv(33309, (int[])object, 0);
            n2 = object[0];
            object = new StringBuilder();
            for (int i2 = 0; i2 < n2; ++i2) {
                string = object2.glGetStringi(7939, i2);
                if (null != this.availableExtensionCache.put(string, string)) continue;
                if (0 < i2) {
                    ((StringBuilder)object).append(" ");
                }
                ((StringBuilder)object).append(string);
            }
            if (0 == n2 || ((StringBuilder)object).length() == 0) {
                bl = false;
            } else {
                this.glExtensions = ((StringBuilder)object).toString();
                this.glExtensionCount = n2;
            }
        }
        if (!bl) {
            this.glExtensions = gL.glGetString(7939);
            if (null != this.glExtensions) {
                object2 = new StringTokenizer(this.glExtensions);
                n2 = 0;
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    object = ((StringTokenizer)object2).nextToken().trim();
                    if (null != this.availableExtensionCache.put((String)object, (String)object)) continue;
                    ++n2;
                }
                this.glExtensionCount = n2;
            }
        }
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GL_EXTENSIONS: " + this.glExtensionCount + ", used " + (bl ? "glGetStringi" : "glGetString"));
        }
        object2 = new StringBuilder();
        Object object3 = new StringTokenizer(gLContextImpl.getPlatformExtensionsStringImpl().toString());
        int n3 = 0;
        while (((StringTokenizer)object3).hasMoreTokens()) {
            String string2 = ((StringTokenizer)object3).nextToken().trim();
            if (null != this.availableExtensionCache.put(string2, string2)) continue;
            if (0 < n3) {
                ((StringBuilder)object2).append(" ");
            }
            ((StringBuilder)object2).append(string2);
            ++n3;
        }
        this.glXExtensions = ((StringBuilder)object2).toString();
        this.glXExtensionCount = n3;
        if (DEBUG) {
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GLX_EXTENSIONS: " + this.glXExtensionCount);
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: GL vendor: " + gL.glGetString(7936));
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: ALL EXTENSIONS: " + this.availableExtensionCache.size());
        }
        int n4 = gLContextImpl.getCtxOptions();
        object3 = gLContextImpl.getGLVersionNumber();
        int[] nArray = new int[]{((VersionNumber)object3).getMajor()};
        int[] nArray2 = new int[]{((VersionNumber)object3).getMinor()};
        do {
            string = (gLContextImpl.isGLES() ? "GL_ES_VERSION_" : "GL_VERSION_") + nArray[0] + "_" + nArray2[0];
            this.availableExtensionCache.put(string, string);
            if (!DEBUG) continue;
            System.err.println(ExtensionAvailabilityCache.getThreadName() + ":ExtensionAvailabilityCache: Added " + string + " to known extensions");
        } while (GLContext.decrementGLVersion(n4, nArray, nArray2));
        this.availableExtensionCache.put("<INTERNAL_DUMMY_PLACEHOLDER>", "<INTERNAL_DUMMY_PLACEHOLDER>");
        this.initialized = true;
    }

    static String getThreadName() {
        return Thread.currentThread().getName();
    }
}

