/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.util.locks.RecursiveLock;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.WindowClosingProtocol;
import com.jogamp.opengl.FPSCounter;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLAnimatorControl;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLEventListenerState;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.GLRunnable;
import com.jogamp.opengl.GLSharedContextSetter;
import com.jogamp.opengl.GLStateKeeper;
import java.io.PrintStream;
import java.util.List;
import jogamp.opengl.FPSCounterImpl;
import jogamp.opengl.GLContextImpl;
import jogamp.opengl.GLDrawableHelper;
import jogamp.opengl.GLDrawableImpl;

public abstract class GLAutoDrawableBase
implements GLAutoDrawable,
GLStateKeeper,
FPSCounter,
GLSharedContextSetter {
    public static final boolean DEBUG = GLDrawableImpl.DEBUG;
    protected final GLDrawableHelper helper = new GLDrawableHelper();
    protected final FPSCounterImpl fpsCounter = new FPSCounterImpl();
    protected volatile GLDrawableImpl drawable;
    protected volatile GLContextImpl context;
    protected boolean preserveGLELSAtDestroy;
    protected GLEventListenerState glels;
    protected GLStateKeeper.Listener glStateKeeperListener;
    protected final boolean ownsDevice;
    protected int additionalCtxCreationFlags = 0;
    protected volatile boolean sendReshape = false;
    protected volatile boolean sendDestroy = false;
    protected final Runnable defaultInitAction = new Runnable(){

        @Override
        public final void run() {
            GLAutoDrawableBase.this.helper.init(GLAutoDrawableBase.this, !GLAutoDrawableBase.this.sendReshape);
            GLAutoDrawableBase.this.resetFPSCounter();
        }
    };
    protected final Runnable defaultDisplayAction = new Runnable(){

        @Override
        public final void run() {
            if (GLAutoDrawableBase.this.sendReshape) {
                GLAutoDrawableBase.this.helper.reshape(GLAutoDrawableBase.this, 0, 0, GLAutoDrawableBase.this.getSurfaceWidth(), GLAutoDrawableBase.this.getSurfaceHeight());
                GLAutoDrawableBase.this.sendReshape = false;
            }
            GLAutoDrawableBase.this.helper.display(GLAutoDrawableBase.this);
            GLAutoDrawableBase.this.fpsCounter.tickFPS();
        }
    };

    public GLAutoDrawableBase(GLDrawableImpl gLDrawableImpl, GLContextImpl gLContextImpl, boolean bl) {
        this.drawable = gLDrawableImpl;
        this.context = gLContextImpl;
        this.preserveGLELSAtDestroy = false;
        this.glels = null;
        this.glStateKeeperListener = null;
        this.ownsDevice = bl;
        if (null != gLContextImpl && null != gLDrawableImpl) {
            gLContextImpl.setGLDrawable(gLDrawableImpl, false);
        }
        this.resetFPSCounter();
    }

    @Override
    public final void setSharedContext(GLContext gLContext) throws IllegalStateException {
        this.helper.setSharedContext(this.context, gLContext);
    }

    @Override
    public final void setSharedAutoDrawable(GLAutoDrawable gLAutoDrawable) throws IllegalStateException {
        this.helper.setSharedAutoDrawable(this, gLAutoDrawable);
    }

    @Override
    public final GLStateKeeper.Listener setGLStateKeeperListener(GLStateKeeper.Listener listener) {
        GLStateKeeper.Listener listener2 = this.glStateKeeperListener;
        this.glStateKeeperListener = listener;
        return listener2;
    }

    @Override
    public final boolean preserveGLStateAtDestroy(boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = this.isGLStatePreservationSupported();
        if (bl2) {
            if (DEBUG) {
                long l2 = null != this.getNativeSurface() ? this.getNativeSurface().getSurfaceHandle() : 0L;
                System.err.println("GLAutoDrawableBase.setPreserveGLStateAtDestroy: (" + GLAutoDrawableBase.getThreadName() + "): " + this.preserveGLELSAtDestroy + " -> " + bl + " - surfaceHandle 0x" + Long.toHexString(l2));
            }
            this.preserveGLELSAtDestroy = bl;
        }
        return bl2;
    }

    @Override
    public boolean isGLStatePreservationSupported() {
        return false;
    }

    @Override
    public final GLEventListenerState getPreservedGLState() {
        return this.glels;
    }

    @Override
    public final GLEventListenerState clearPreservedGLState() {
        GLEventListenerState gLEventListenerState = this.glels;
        this.glels = null;
        return gLEventListenerState;
    }

    protected final boolean preserveGLEventListenerState() throws IllegalStateException {
        if (null != this.glels) {
            throw new IllegalStateException("GLEventListenerState already pulled");
        }
        if (null != this.context && this.context.isCreated()) {
            if (null != this.glStateKeeperListener) {
                this.glStateKeeperListener.glStatePreserveNotify(this);
            }
            this.glels = GLEventListenerState.moveFrom(this);
            return null != this.glels;
        }
        return false;
    }

    protected final boolean restoreGLEventListenerState() {
        if (null != this.glels) {
            this.glels.moveTo(this);
            this.glels = null;
            if (null != this.glStateKeeperListener) {
                this.glStateKeeperListener.glStateRestored(this);
            }
            return true;
        }
        return false;
    }

    protected final void defaultWindowRepaintOp() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        if (null != gLDrawableImpl && gLDrawableImpl.isRealized() && !gLDrawableImpl.getNativeSurface().isSurfaceLockedByOtherThread() && !this.helper.isAnimatorAnimatingOnOtherThread()) {
            this.display();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void defaultWindowResizedOp(int n2, int n3) throws NativeWindowException, GLException {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        if (null != gLDrawableImpl) {
            if (DEBUG) {
                long l2 = null != this.getNativeSurface() ? this.getNativeSurface().getSurfaceHandle() : 0L;
                System.err.println("GLAutoDrawableBase.sizeChanged: (" + GLAutoDrawableBase.getThreadName() + "): " + n2 + "x" + n3 + " - surfaceHandle 0x" + Long.toHexString(l2));
            }
            if (!gLDrawableImpl.getChosenGLCapabilities().isOnscreen()) {
                RecursiveLock recursiveLock = this.getUpstreamLock();
                recursiveLock.lock();
                try {
                    GLDrawableImpl gLDrawableImpl2 = GLDrawableHelper.resizeOffscreenDrawable(gLDrawableImpl, this.context, n2, n3);
                    if (gLDrawableImpl != gLDrawableImpl2) {
                        gLDrawableImpl = gLDrawableImpl2;
                        this.drawable = gLDrawableImpl2;
                    }
                }
                finally {
                    recursiveLock.unlock();
                }
            }
            this.sendReshape = true;
            if (gLDrawableImpl.isRealized() && !gLDrawableImpl.getNativeSurface().isSurfaceLockedByOtherThread() && !this.helper.isAnimatorAnimatingOnOtherThread()) {
                this.display();
            }
        }
    }

    protected final void defaultWindowDestroyNotifyOp() {
        NativeSurface nativeSurface = this.getNativeSurface();
        boolean bl = nativeSurface instanceof WindowClosingProtocol ? WindowClosingProtocol.WindowClosingMode.DISPOSE_ON_CLOSE == ((WindowClosingProtocol)((Object)nativeSurface)).getDefaultCloseOperation() : true;
        if (bl) {
            try {
                this.destroyAvoidAwareOfLocking();
            }
            catch (Throwable throwable) {
                ExceptionUtils.dumpThrowable("ignored", throwable);
            }
        }
    }

    protected final void destroyAvoidAwareOfLocking() {
        NativeSurface nativeSurface = this.getNativeSurface();
        GLAnimatorControl gLAnimatorControl = this.helper.getAnimator();
        if (this.helper.isAnimatorStartedOnOtherThread()) {
            boolean bl = gLAnimatorControl.pause();
            this.destroy();
            if (bl) {
                gLAnimatorControl.resume();
            }
        } else if (null != nativeSurface && nativeSurface.isSurfaceLockedByOtherThread()) {
            this.sendDestroy = true;
        } else {
            this.destroy();
        }
    }

    protected final void defaultDestroy() {
        RecursiveLock recursiveLock = this.getUpstreamLock();
        recursiveLock.lock();
        try {
            this.destroyImplInLock();
        }
        finally {
            recursiveLock.unlock();
        }
    }

    protected void destroyImplInLock() {
        if (this.preserveGLELSAtDestroy) {
            this.preserveGLStateAtDestroy(false);
            this.preserveGLEventListenerState();
        }
        GLException gLException = null;
        if (null != this.context) {
            if (this.context.isCreated()) {
                try {
                    this.helper.disposeGL(this, this.context, true);
                }
                catch (GLException gLException2) {
                    gLException = gLException2;
                }
            }
            this.context = null;
        }
        Throwable throwable = null;
        Throwable throwable2 = null;
        if (null != this.drawable) {
            AbstractGraphicsDevice abstractGraphicsDevice = this.drawable.getNativeSurface().getGraphicsConfiguration().getScreen().getDevice();
            try {
                this.drawable.setRealized(false);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
            }
            this.drawable = null;
            try {
                if (this.ownsDevice) {
                    abstractGraphicsDevice.close();
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
            }
        }
        if (null != gLException) {
            throw gLException;
        }
        if (null != throwable) {
            throw GLException.newGLException(throwable);
        }
        if (null != throwable2) {
            throw GLException.newGLException(throwable2);
        }
    }

    public final void defaultSwapBuffers() throws GLException {
        RecursiveLock recursiveLock = this.getUpstreamLock();
        recursiveLock.lock();
        try {
            if (null != this.drawable) {
                this.drawable.swapBuffers();
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void defaultDisplay() {
        if (this.sendDestroy) {
            this.sendDestroy = false;
            this.destroy();
            return;
        }
        RecursiveLock recursiveLock = this.getUpstreamLock();
        recursiveLock.lock();
        try {
            if (null == this.context) {
                GLContext[] gLContextArray;
                boolean bl = false;
                GLDrawableImpl gLDrawableImpl = this.drawable;
                if (null != gLDrawableImpl && gLDrawableImpl.isRealized() && 0 < gLDrawableImpl.getSurfaceWidth() * gLDrawableImpl.getSurfaceHeight() && !this.helper.isSharedGLContextPending(gLContextArray = new GLContext[]{null}) && !this.restoreGLEventListenerState()) {
                    this.context = (GLContextImpl)gLDrawableImpl.createContext(gLContextArray[0]);
                    this.context.setContextCreationFlags(this.additionalCtxCreationFlags);
                    bl = true;
                    this.helper.invokeGL(gLDrawableImpl, this.context, this.defaultDisplayAction, this.defaultInitAction);
                }
                if (DEBUG) {
                    System.err.println("GLAutoDrawableBase.defaultDisplay: contextCreated " + bl);
                }
            } else {
                this.helper.invokeGL(this.drawable, this.context, this.defaultDisplayAction, this.defaultInitAction);
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final GLEventListener defaultDisposeGLEventListener(GLEventListener gLEventListener, boolean bl) {
        RecursiveLock recursiveLock = this.getUpstreamLock();
        recursiveLock.lock();
        try {
            GLEventListener gLEventListener2 = this.helper.disposeGLEventListener(this, this.drawable, this.context, gLEventListener, bl);
            return gLEventListener2;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final GLDrawable getDelegatedDrawable() {
        return this.drawable;
    }

    @Override
    public final GLContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLContext setContext(GLContext gLContext, boolean bl) {
        RecursiveLock recursiveLock = this.getUpstreamLock();
        recursiveLock.lock();
        try {
            GLContextImpl gLContextImpl = this.context;
            GLDrawableHelper.switchContext(this.drawable, gLContextImpl, bl, gLContext, this.additionalCtxCreationFlags);
            this.context = (GLContextImpl)gLContext;
            GLContextImpl gLContextImpl2 = gLContextImpl;
            return gLContextImpl2;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final GL getGL() {
        GLContextImpl gLContextImpl = this.context;
        if (gLContextImpl == null) {
            return null;
        }
        return ((GLContext)gLContextImpl).getGL();
    }

    @Override
    public final GL setGL(GL gL) {
        GLContextImpl gLContextImpl = this.context;
        if (gLContextImpl != null) {
            ((GLContext)gLContextImpl).setGL(gL);
            return gL;
        }
        return null;
    }

    @Override
    public final void addGLEventListener(GLEventListener gLEventListener) {
        this.helper.addGLEventListener(gLEventListener);
    }

    @Override
    public final void addGLEventListener(int n2, GLEventListener gLEventListener) throws IndexOutOfBoundsException {
        this.helper.addGLEventListener(n2, gLEventListener);
    }

    @Override
    public int getGLEventListenerCount() {
        return this.helper.getGLEventListenerCount();
    }

    @Override
    public GLEventListener getGLEventListener(int n2) throws IndexOutOfBoundsException {
        return this.helper.getGLEventListener(n2);
    }

    @Override
    public boolean areAllGLEventListenerInitialized() {
        return this.helper.areAllGLEventListenerInitialized();
    }

    @Override
    public boolean getGLEventListenerInitState(GLEventListener gLEventListener) {
        return this.helper.getGLEventListenerInitState(gLEventListener);
    }

    @Override
    public void setGLEventListenerInitState(GLEventListener gLEventListener, boolean bl) {
        this.helper.setGLEventListenerInitState(gLEventListener, bl);
    }

    @Override
    public GLEventListener disposeGLEventListener(GLEventListener gLEventListener, boolean bl) {
        return this.defaultDisposeGLEventListener(gLEventListener, bl);
    }

    @Override
    public final GLEventListener removeGLEventListener(GLEventListener gLEventListener) {
        return this.helper.removeGLEventListener(gLEventListener);
    }

    @Override
    public final void setAnimator(GLAnimatorControl gLAnimatorControl) throws GLException {
        this.helper.setAnimator(gLAnimatorControl);
    }

    @Override
    public final GLAnimatorControl getAnimator() {
        return this.helper.getAnimator();
    }

    @Override
    public final Thread setExclusiveContextThread(Thread thread) throws GLException {
        return this.helper.setExclusiveContextThread(thread, this.context);
    }

    @Override
    public final Thread getExclusiveContextThread() {
        return this.helper.getExclusiveContextThread();
    }

    @Override
    public final boolean invoke(boolean bl, GLRunnable gLRunnable) throws IllegalStateException {
        return this.helper.invoke((GLAutoDrawable)this, bl, gLRunnable);
    }

    @Override
    public boolean invoke(boolean bl, List<GLRunnable> list) throws IllegalStateException {
        return this.helper.invoke((GLAutoDrawable)this, bl, list);
    }

    @Override
    public void flushGLRunnables() {
        this.helper.flushGLRunnables();
    }

    @Override
    public final void setAutoSwapBufferMode(boolean bl) {
        this.helper.setAutoSwapBufferMode(bl);
    }

    @Override
    public final boolean getAutoSwapBufferMode() {
        return this.helper.getAutoSwapBufferMode();
    }

    @Override
    public final void setContextCreationFlags(int n2) {
        this.additionalCtxCreationFlags = n2;
        GLContextImpl gLContextImpl = this.context;
        if (null != gLContextImpl) {
            ((GLContext)gLContextImpl).setContextCreationFlags(this.additionalCtxCreationFlags);
        }
    }

    @Override
    public final int getContextCreationFlags() {
        return this.additionalCtxCreationFlags;
    }

    @Override
    public final boolean isThreadGLCapable() {
        return true;
    }

    @Override
    public final void setUpdateFPSFrames(int n2, PrintStream printStream) {
        this.fpsCounter.setUpdateFPSFrames(n2, printStream);
    }

    @Override
    public final void resetFPSCounter() {
        this.fpsCounter.resetFPSCounter();
    }

    @Override
    public final int getUpdateFPSFrames() {
        return this.fpsCounter.getUpdateFPSFrames();
    }

    @Override
    public final long getFPSStartTime() {
        return this.fpsCounter.getFPSStartTime();
    }

    @Override
    public final long getLastFPSUpdateTime() {
        return this.fpsCounter.getLastFPSUpdateTime();
    }

    @Override
    public final long getLastFPSPeriod() {
        return this.fpsCounter.getLastFPSPeriod();
    }

    @Override
    public final float getLastFPS() {
        return this.fpsCounter.getLastFPS();
    }

    @Override
    public final int getTotalFPSFrames() {
        return this.fpsCounter.getTotalFPSFrames();
    }

    @Override
    public final long getTotalFPSDuration() {
        return this.fpsCounter.getTotalFPSDuration();
    }

    @Override
    public final float getTotalFPS() {
        return this.fpsCounter.getTotalFPS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final GLContext createContext(GLContext gLContext) {
        RecursiveLock recursiveLock = this.getUpstreamLock();
        recursiveLock.lock();
        try {
            if (this.drawable != null) {
                GLContext gLContext2 = this.drawable.createContext(gLContext);
                gLContext2.setContextCreationFlags(this.additionalCtxCreationFlags);
                GLContext gLContext3 = gLContext2;
                return gLContext3;
            }
            GLContext gLContext4 = null;
            return gLContext4;
        }
        finally {
            recursiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setRealized(boolean bl) {
        RecursiveLock recursiveLock = this.getUpstreamLock();
        recursiveLock.lock();
        try {
            GLDrawableImpl gLDrawableImpl = this.drawable;
            if (null == gLDrawableImpl || bl && (0 >= gLDrawableImpl.getSurfaceWidth() || 0 >= gLDrawableImpl.getSurfaceHeight())) {
                return;
            }
            gLDrawableImpl.setRealized(bl);
            if (bl && gLDrawableImpl.isRealized()) {
                this.sendReshape = true;
            }
        }
        finally {
            recursiveLock.unlock();
        }
    }

    @Override
    public final boolean isRealized() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.isRealized() : false;
    }

    @Override
    public int getSurfaceWidth() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getSurfaceWidth() : 0;
    }

    @Override
    public int getSurfaceHeight() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getSurfaceHeight() : 0;
    }

    @Override
    public boolean isGLOriented() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.isGLOriented() : true;
    }

    @Override
    public final GLCapabilitiesImmutable getChosenGLCapabilities() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getChosenGLCapabilities() : null;
    }

    @Override
    public final GLCapabilitiesImmutable getRequestedGLCapabilities() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getRequestedGLCapabilities() : null;
    }

    @Override
    public final GLProfile getGLProfile() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getGLProfile() : null;
    }

    @Override
    public final NativeSurface getNativeSurface() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getNativeSurface() : null;
    }

    @Override
    public final long getHandle() {
        GLDrawableImpl gLDrawableImpl = this.drawable;
        return null != gLDrawableImpl ? gLDrawableImpl.getHandle() : 0L;
    }

    protected static String getThreadName() {
        return Thread.currentThread().getName();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[ \n\tHelper: " + this.helper + ", \n\tDrawable: " + this.drawable + ", \n\tContext: " + this.context + "]";
    }
}

