/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl;

import com.jogamp.common.util.IntIntHashMap;
import com.jogamp.common.util.PropertyAccess;
import com.jogamp.opengl.GL;
import com.jogamp.opengl.GLException;
import jogamp.opengl.Debug;

public class GLBufferStateTracker {
    protected static final boolean DEBUG;
    private final IntIntHashMap bindingMap;
    private static final int bindingNotFound = -1;
    private final int[] bufTmp = new int[1];

    public GLBufferStateTracker() {
        this.bindingMap = new IntIntHashMap();
        this.bindingMap.setKeyNotFoundValue(-1);
        this.setBoundBufferObject(34962, 0);
        this.setBoundBufferObject(36671, 0);
        this.setBoundBufferObject(34963, 0);
        this.setBoundBufferObject(35051, 0);
        this.setBoundBufferObject(35052, 0);
    }

    private static final int getQueryName(int n2) {
        switch (n2) {
            case 34962: {
                return 34964;
            }
            case 37568: {
                return 37569;
            }
            case 36662: {
                return 36662;
            }
            case 36663: {
                return 36663;
            }
            case 36671: {
                return 36675;
            }
            case 37102: {
                return 37103;
            }
            case 34963: {
                return 34965;
            }
            case 35051: {
                return 35053;
            }
            case 35052: {
                return 35055;
            }
            case 37266: {
                return 37267;
            }
            case 37074: {
                return 37075;
            }
            case 35882: {
                return 35884;
            }
            case 35982: {
                return 35983;
            }
            case 35345: {
                return 35368;
            }
            case 34229: {
                return 34229;
            }
        }
        throw new GLException(String.format("GL_INVALID_ENUM\u200b: Invalid binding target 0x%X", n2));
    }

    private static final void checkTargetName(int n2) {
        switch (n2) {
            case 34229: 
            case 34962: 
            case 34963: 
            case 35051: 
            case 35052: 
            case 35345: 
            case 35882: 
            case 35982: 
            case 36662: 
            case 36663: 
            case 36671: 
            case 37074: 
            case 37102: 
            case 37266: 
            case 37568: {
                return;
            }
        }
        throw new GLException(String.format("GL_INVALID_ENUM\u200b: Invalid binding target 0x%X", n2));
    }

    public final void setBoundBufferObject(int n2, int n3) {
        GLBufferStateTracker.checkTargetName(n2);
        int n4 = this.bindingMap.put(n2, n3);
        if (DEBUG) {
            System.err.println("GLBufferStateTracker.setBoundBufferObject() target " + this.toHexString(n2) + ": " + this.toHexString(n4) + " -> " + this.toHexString(n3));
        }
    }

    public final int getBoundBufferObject(int n2, GL gL) {
        int n3 = this.bindingMap.get(n2);
        if (-1 == n3) {
            int n4 = GLBufferStateTracker.getQueryName(n2);
            if (0 != n4) {
                int n5 = gL.glGetError();
                gL.glGetIntegerv(n4, this.bufTmp, 0);
                int n6 = gL.glGetError();
                n3 = 0 == n6 ? this.bufTmp[0] : 0;
                if (DEBUG) {
                    System.err.println("GLBufferStateTracker.getBoundBufferObject() glerr[pre " + this.toHexString(n5) + ", post " + this.toHexString(n6) + "], [queried value]: target " + this.toHexString(n2) + " / query " + this.toHexString(n4) + " -> mapped bound buffer " + this.toHexString(n3));
                }
                this.setBoundBufferObject(n2, n3);
                return n3;
            }
            return 0;
        }
        if (DEBUG) {
            System.err.println("GLBufferStateTracker.getBoundBufferObject() [mapped value]: target 0x" + Integer.toHexString(n2) + " -> mapped bound buffer 0x" + Integer.toHexString(n3));
        }
        return n3;
    }

    public final void clear() {
        if (DEBUG) {
            System.err.println("GLBufferStateTracker.clear() - Thread " + Thread.currentThread().getName());
        }
        this.bindingMap.clear();
    }

    private final String toHexString(int n2) {
        return Integer.toHexString(n2);
    }

    static {
        Debug.initSingleton();
        DEBUG = PropertyAccess.isPropertyDefined("jogl.debug.GLBufferStateTracker", true);
    }
}

