/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.egl;

import com.jogamp.nativewindow.ProxySurface;
import com.jogamp.nativewindow.UpstreamSurfaceHookMutableSize;
import com.jogamp.nativewindow.egl.EGLGraphicsDevice;
import com.jogamp.opengl.egl.EGL;
import jogamp.opengl.egl.EGLDrawableFactory;
import jogamp.opengl.egl.EGLGraphicsConfiguration;

public class EGLDummyUpstreamSurfaceHook
extends UpstreamSurfaceHookMutableSize {
    public EGLDummyUpstreamSurfaceHook(int n2, int n3) {
        super(n2, n3);
    }

    @Override
    public final void create(ProxySurface proxySurface) {
        EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)proxySurface.getGraphicsConfiguration().getScreen().getDevice();
        eGLGraphicsDevice.lock();
        try {
            if (0L == eGLGraphicsDevice.getHandle()) {
                eGLGraphicsDevice.open();
                proxySurface.addUpstreamOptionBits(128);
            }
            if (0L == proxySurface.getSurfaceHandle()) {
                proxySurface.setSurfaceHandle(EGLDrawableFactory.createPBufferSurfaceImpl((EGLGraphicsConfiguration)proxySurface.getGraphicsConfiguration(), 64, 64, false));
                proxySurface.addUpstreamOptionBits(64);
            }
            proxySurface.addUpstreamOptionBits(256);
        }
        finally {
            eGLGraphicsDevice.unlock();
        }
    }

    @Override
    public final void destroy(ProxySurface proxySurface) {
        if (proxySurface.containsUpstreamOptionBits(64)) {
            EGLGraphicsDevice eGLGraphicsDevice = (EGLGraphicsDevice)proxySurface.getGraphicsConfiguration().getScreen().getDevice();
            if (0L == proxySurface.getSurfaceHandle()) {
                throw new InternalError("Owns upstream surface, but no EGL surface: " + proxySurface);
            }
            eGLGraphicsDevice.lock();
            try {
                EGL.eglDestroySurface(eGLGraphicsDevice.getHandle(), proxySurface.getSurfaceHandle());
                proxySurface.setSurfaceHandle(0L);
                proxySurface.clearUpstreamOptionBits(64);
            }
            finally {
                eGLGraphicsDevice.unlock();
            }
        }
    }
}

