/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.glu.nurbs;

public class Knotvector {
    public static final float TOLERANCE = 1.0E-5f;
    private static final int MAXORDER = 24;
    int knotcount;
    int stride;
    int order;
    float[] knotlist;

    public Knotvector(int n2, int n3, int n4, float[] fArray) {
        this.init(n2, n3, n4, fArray);
    }

    public void init(int n2, int n3, int n4, float[] fArray) {
        this.knotcount = n2;
        this.stride = n3;
        this.order = n4;
        this.knotlist = new float[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.knotlist[i2] = fArray[i2];
        }
    }

    public int validate() {
        int n2;
        int n3 = this.knotcount - 1;
        if (this.order < 1 || this.order > 24) {
            return 1;
        }
        if (this.knotcount < 2 * this.order) {
            return 2;
        }
        if (Knotvector.identical(this.knotlist[n3 - (this.order - 1)], this.knotlist[this.order - 1])) {
            return 3;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!(this.knotlist[n2] > this.knotlist[n2 + 1])) continue;
            return 4;
        }
        n2 = 1;
        while (n3 >= 1) {
            if (this.knotlist[n3] - this.knotlist[n3 - 1] < 1.0E-5f) {
                ++n2;
            } else {
                if (n2 > this.order) {
                    return 5;
                }
                n2 = 1;
            }
            --n3;
        }
        if (n2 > this.order) {
            return 5;
        }
        return 0;
    }

    public void show(String string) {
    }

    public static boolean identical(float f2, float f3) {
        return f2 - f3 < 1.0E-5f;
    }
}

