/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.jpeg;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.Bitstream;
import com.jogamp.common.util.VersionNumber;
import com.jogamp.opengl.util.texture.TextureData;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import jogamp.opengl.Debug;

public class JPEGDecoder {
    private static final boolean DEBUG = Debug.debug("JPEGImage");
    private static final boolean DEBUG_IN = false;
    private static final int M_SOI = 65496;
    private static final int M_EOI = 65497;
    private static final int M_SOF0 = 65472;
    private static final int M_SOF2 = 65474;
    private static final int M_DHT = 65476;
    private static final int M_SOS = 65498;
    private static final int M_QTT = 65499;
    private static final int M_DRI = 65501;
    private static final int M_APP00 = 65504;
    private static final int M_APP01 = 65505;
    private static final int M_APP02 = 65506;
    private static final int M_APP03 = 65507;
    private static final int M_APP04 = 65508;
    private static final int M_APP05 = 65509;
    private static final int M_APP06 = 65510;
    private static final int M_APP07 = 65511;
    private static final int M_APP08 = 65512;
    private static final int M_APP09 = 65513;
    private static final int M_APP10 = 65514;
    private static final int M_APP11 = 65515;
    private static final int M_APP12 = 65516;
    private static final int M_APP13 = 65517;
    private static final int M_APP14 = 65518;
    private static final int M_APP15 = 65519;
    private static final int M_ANO = 65534;
    static final int[] dctZigZag = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};
    static final int dctCos1 = 4017;
    static final int dctSin1 = 799;
    static final int dctCos3 = 3406;
    static final int dctSin3 = 2276;
    static final int dctCos6 = 1567;
    static final int dctSin6 = 3784;
    static final int dctSqrt2 = 5793;
    static final int dctSqrt1d2 = 2896;
    private final Bitstream<InputStream> bstream = new Bitstream<InputStream>(new Bitstream.ByteInputStream(null), false);
    private int width = 0;
    private int height = 0;
    private JFIF jfif = null;
    private EXIF exif = null;
    private Adobe adobe = null;
    private ComponentOut[] components = null;
    private final Output output = new Output();
    private final Decoder decoder = new Decoder();

    public String toString() {
        String string = null != this.jfif ? this.jfif.toString() : "JFIF nil";
        String string2 = null != this.exif ? this.exif.toString() : "Exif nil";
        String string3 = null != this.adobe ? this.adobe.toString() : "Adobe nil";
        String string4 = null != this.components ? Arrays.asList(this.components).toString() : "nil";
        return "JPEG[size " + this.width + "x" + this.height + ", compOut " + string4 + ", " + string + ", " + string2 + ", " + string3 + "]";
    }

    public final JFIF getJFIFHeader() {
        return this.jfif;
    }

    public final EXIF getEXIFHeader() {
        return this.exif;
    }

    public final Adobe getAdobeHeader() {
        return this.adobe;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    private final void setStream(InputStream inputStream) {
        try {
            this.bstream.setStream(inputStream, false);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private final int readUInt8() throws IOException {
        return this.bstream.readUInt8();
    }

    private final int readUInt16() throws IOException {
        return this.bstream.readUInt16(true);
    }

    private final int readNumber() throws IOException {
        int n2 = this.readUInt16();
        if (n2 != 4) {
            throw new CodecException("ERROR: Define number format error [Len!=4, but " + n2 + "]");
        }
        return this.readUInt16();
    }

    private final byte[] readDataBlock() throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = this.readUInt16();
        n2 += 2;
        byte[] byArray = new byte[n4 - 2];
        while (n2 < n4) {
            byArray[n3++] = (byte)this.readUInt8();
            ++n2;
        }
        return byArray;
    }

    static final void dumpData(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            System.err.print(n4 % 8 + ": ");
            for (int i2 = 0; i2 < 8 && n4 < n3; ++i2, ++n4) {
                System.err.print(JPEGDecoder.toHexString(0xFF & byArray[n2 + n4]) + ", ");
            }
            System.err.println("");
        }
    }

    public synchronized void clear(InputStream inputStream) {
        this.setStream(inputStream);
        this.width = 0;
        this.height = 0;
        this.jfif = null;
        this.exif = null;
        this.adobe = null;
        this.components = null;
    }

    public synchronized JPEGDecoder parse(InputStream inputStream) throws IOException {
        int n2;
        this.clear(inputStream);
        int[][] nArrayArray = new int[15][];
        BinObj[] binObjArray = new BinObj[15];
        BinObj[] binObjArray2 = new BinObj[15];
        Frame frame = null;
        int n3 = 0;
        int n4 = this.readUInt16();
        if (n4 != 65496) {
            throw new CodecException("SOI not found, but has marker " + JPEGDecoder.toHexString(n4));
        }
        n4 = this.readUInt16();
        while (n4 != 65497) {
            if (DEBUG) {
                System.err.println("JPG.parse got marker " + JPEGDecoder.toHexString(n4));
            }
            switch (n4) {
                case 65504: 
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65509: 
                case 65510: 
                case 65511: 
                case 65512: 
                case 65513: 
                case 65514: 
                case 65515: 
                case 65516: 
                case 65517: 
                case 65518: 
                case 65519: 
                case 65534: {
                    byte[] byArray = this.readDataBlock();
                    if (n4 == 65504) {
                        this.jfif = JFIF.get(byArray);
                    }
                    if (n4 == 65505) {
                        this.exif = EXIF.get(byArray);
                    }
                    if (n4 == 65518) {
                        this.adobe = Adobe.get(byArray);
                    }
                    n4 = 0;
                    break;
                }
                case 65499: {
                    int n5;
                    int n6;
                    int n7;
                    int n8 = 0;
                    n2 = this.readUInt16();
                    n8 += 2;
                    while (n8 < n2) {
                        int n9;
                        n7 = this.readUInt8();
                        ++n8;
                        int n10 = n7 >> 4;
                        n6 = n7 & 0xF;
                        int[] nArray = new int[64];
                        if (n10 == 0) {
                            for (n5 = 0; n5 < 64; ++n5) {
                                n9 = dctZigZag[n5];
                                nArray[n9] = this.readUInt8();
                                ++n8;
                            }
                        } else if (n10 == 1) {
                            for (n5 = 0; n5 < 64; ++n5) {
                                n9 = dctZigZag[n5];
                                nArray[n9] = this.readUInt16();
                                n8 += 2;
                            }
                        } else {
                            throw new CodecException("DQT: invalid table precision " + n10 + ", quantizationTableSpec " + n7 + ", idx " + n6);
                        }
                        nArrayArray[n6] = nArray;
                        if (!DEBUG) continue;
                        System.err.println("JPEG.parse.QTT[" + n6 + "]: spec " + n7 + ", precision " + n10 + ", data " + n8 + "/" + n2);
                    }
                    if (n8 != n2) {
                        throw new CodecException("ERROR: QTT format error [count!=Length]: " + n8 + "/" + n2);
                    }
                    n4 = 0;
                    break;
                }
                case 65472: 
                case 65474: {
                    if (null != frame) {
                        throw new CodecException("only single frame JPEGs supported");
                    }
                    int n11 = 0;
                    n2 = this.readUInt16();
                    n11 += 2;
                    int n12 = n4 == 65474 ? 1 : 0;
                    int n6 = this.readUInt8();
                    ++n11;
                    int n13 = this.readUInt16();
                    n11 += 2;
                    int n5 = this.readUInt16();
                    n11 += 2;
                    int n7 = this.readUInt8();
                    ++n11;
                    frame = new Frame(n12 != 0, n6, n13, n5, n7, nArrayArray);
                    this.width = frame.samplesPerLine;
                    this.height = frame.scanLines;
                    for (n12 = 0; n12 < n7; ++n12) {
                        n6 = this.readUInt8();
                        ++n11;
                        n13 = this.readUInt8();
                        ++n11;
                        n5 = n13 >> 4;
                        int n14 = n13 & 0xF;
                        int n15 = this.readUInt8();
                        ++n11;
                        ComponentIn componentIn = new ComponentIn(n5, n14, n15);
                        frame.putOrdered(n6, componentIn);
                    }
                    if (n11 != n2) {
                        throw new CodecException("ERROR: SOF format error [count!=Length]");
                    }
                    this.prepareComponents(frame);
                    if (DEBUG) {
                        System.err.println("JPG.parse.SOF[02]: Got frame " + frame);
                    }
                    n4 = 0;
                    break;
                }
                case 65476: {
                    int n5;
                    int n6;
                    int n7;
                    int n16 = 0;
                    n2 = this.readUInt16();
                    int n17 = 0;
                    for (n7 = n16 += 2; n7 < n2; n7 += 17 + n5) {
                        n6 = this.readUInt8();
                        ++n16;
                        int[] nArray = new int[16];
                        n5 = 0;
                        for (int i2 = 0; i2 < 16; ++i2) {
                            nArray[i2] = this.readUInt8();
                            n5 += nArray[i2];
                            ++n16;
                        }
                        byte[] byArray = new byte[n5];
                        for (int i3 = 0; i3 < n5; ++i3) {
                            byArray[i3] = (byte)this.readUInt8();
                            ++n16;
                        }
                        n17 += n5;
                        BinObj[] binObjArray3 = n6 >> 4 == 0 ? binObjArray2 : binObjArray;
                        binObjArray3[n6 & 0xF] = this.buildHuffmanTable(nArray, byArray);
                    }
                    if (n16 != n2 || n7 != n16) {
                        throw new CodecException("ERROR: Huffman table format error [count!=Length]");
                    }
                    if (DEBUG) {
                        System.err.println("JPG.parse.DHT: Got Huffman CodeLengthTotal " + n17);
                    }
                    n4 = 0;
                    break;
                }
                case 65501: {
                    n3 = this.readNumber();
                    if (DEBUG) {
                        System.err.println("JPG.parse.DRI: Got Reset Interval " + n3);
                    }
                    n4 = 0;
                    break;
                }
                case 65498: {
                    int n18;
                    int n6;
                    int n19 = 0;
                    n2 = this.readUInt16();
                    n19 += 2;
                    int n7 = this.readUInt8();
                    ++n19;
                    ArrayList<ComponentIn> arrayList = new ArrayList<ComponentIn>();
                    if (DEBUG) {
                        System.err.println("JPG.parse.SOS: selectorCount [0.." + (n7 - 1) + "]: " + frame);
                    }
                    for (n6 = 0; n6 < n7; ++n6) {
                        n18 = this.readUInt8();
                        ++n19;
                        ComponentIn componentIn = frame.getCompByID(n18);
                        int n20 = this.readUInt8();
                        ++n19;
                        componentIn.huffmanTableDC = binObjArray2[n20 >> 4];
                        componentIn.huffmanTableAC = binObjArray[n20 & 0xF];
                        arrayList.add(componentIn);
                    }
                    n6 = this.readUInt8();
                    ++n19;
                    n18 = this.readUInt8();
                    ++n19;
                    int n5 = this.readUInt8();
                    if (++n19 != n2) {
                        throw new CodecException("ERROR: scan header format error [count!=Length]");
                    }
                    n4 = this.decoder.decodeScan(frame, arrayList, n3, n6, n18, n5 >> 4, n5 & 0xF);
                    if (!DEBUG) break;
                    System.err.println("JPG.parse.SOS.decode result " + JPEGDecoder.toHexString(n4));
                    break;
                }
                default: {
                    throw new CodecException("unknown JPEG marker " + JPEGDecoder.toHexString(n4) + ", " + this.bstream);
                }
            }
            if (0 != n4) continue;
            n4 = this.readUInt16();
        }
        if (DEBUG) {
            System.err.println("JPG.parse.2: End of parsing input " + this);
        }
        if (null == frame) {
            throw new CodecException("no single frame found in stream " + this);
        }
        frame.validateComponents();
        int n21 = frame.getCompCount();
        this.components = new ComponentOut[n21];
        for (n2 = 0; n2 < n21; ++n2) {
            ComponentIn componentIn = frame.getCompByIndex(n2);
            this.components[n2] = new ComponentOut(this.output.buildComponentData(frame, componentIn), (float)componentIn.h / (float)frame.maxH, (float)componentIn.v / (float)frame.maxV);
        }
        if (DEBUG) {
            System.err.println("JPG.parse.X: End of processing input " + this);
        }
        return this;
    }

    private void prepareComponents(Frame frame) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = frame.getCompCount();
        for (n2 = 0; n2 < n5; ++n2) {
            ComponentIn componentIn = frame.getCompByIndex(n2);
            if (n3 < componentIn.h) {
                n3 = componentIn.h;
            }
            if (n4 >= componentIn.v) continue;
            n4 = componentIn.v;
        }
        n2 = (int)Math.ceil((float)frame.samplesPerLine / 8.0f / (float)n3);
        int n6 = (int)Math.ceil((float)frame.scanLines / 8.0f / (float)n4);
        for (int i2 = 0; i2 < n5; ++i2) {
            ComponentIn componentIn = frame.getCompByIndex(i2);
            int n7 = (int)Math.ceil(Math.ceil((float)frame.samplesPerLine / 8.0f) * (double)componentIn.h / (double)n3);
            int n8 = (int)Math.ceil(Math.ceil((float)frame.scanLines / 8.0f) * (double)componentIn.v / (double)n4);
            int n9 = n2 * componentIn.h;
            int n10 = n6 * componentIn.v;
            componentIn.allocateBlocks(n8, n10, n7, n9);
        }
        frame.maxH = n3;
        frame.maxV = n4;
        frame.mcusPerLine = n2;
        frame.mcusPerColumn = n6;
    }

    private BinObj buildHuffmanTable(int[] nArray, byte[] byArray) {
        int n2;
        int n3 = 0;
        ArrayList<BinObjIdxed> arrayList = new ArrayList<BinObjIdxed>();
        for (n2 = 16; n2 > 0 && 0 == nArray[n2 - 1]; --n2) {
        }
        arrayList.add(new BinObjIdxed());
        BinObjIdxed binObjIdxed = (BinObjIdxed)arrayList.get(0);
        for (int i2 = 0; i2 < n2; ++i2) {
            BinObjIdxed binObjIdxed2;
            for (int i3 = 0; i3 < nArray[i2]; ++i3) {
                binObjIdxed = (BinObjIdxed)arrayList.remove(arrayList.size() - 1);
                binObjIdxed.children.set(binObjIdxed.index, byArray[n3]);
                while (binObjIdxed.index > 0) {
                    binObjIdxed = (BinObjIdxed)arrayList.remove(arrayList.size() - 1);
                }
                binObjIdxed.index = (byte)(binObjIdxed.index + 1);
                arrayList.add(binObjIdxed);
                while (arrayList.size() <= i2) {
                    binObjIdxed2 = new BinObjIdxed();
                    arrayList.add(binObjIdxed2);
                    binObjIdxed.children.set(binObjIdxed.index, binObjIdxed2.children);
                    binObjIdxed = binObjIdxed2;
                }
                ++n3;
            }
            if (i2 + 1 >= n2) continue;
            binObjIdxed2 = new BinObjIdxed();
            arrayList.add(binObjIdxed2);
            binObjIdxed.children.set(binObjIdxed.index, binObjIdxed2.children);
            binObjIdxed = binObjIdxed2;
        }
        return ((BinObjIdxed)arrayList.get((int)0)).children;
    }

    public synchronized void getPixel(ColorSink colorSink, int n2, int n3) {
        int n4;
        int n5 = this.width / n2;
        int n6 = this.height / n3;
        TextureData.ColorSpace colorSpace = null != this.adobe ? this.adobe.colorSpace : TextureData.ColorSpace.YCbCr;
        TextureData.ColorSpace colorSpace2 = colorSink.allocate(n2, n3, colorSpace, n4 = this.components.length);
        if (TextureData.ColorSpace.RGB != colorSpace2 && TextureData.ColorSpace.YCbCr != colorSpace2) {
            throw new IllegalArgumentException("Unsupported storage color space: " + (Object)((Object)colorSpace2));
        }
        switch (n4) {
            case 1: {
                ComponentOut componentOut = this.components[0];
                for (int i2 = 0; i2 < n3; ++i2) {
                    byte[] byArray = componentOut.getLine((int)((float)i2 * componentOut.scaleY * (float)n6));
                    for (int i3 = 0; i3 < n2; ++i3) {
                        byte by = byArray[(int)((float)i3 * componentOut.scaleX * (float)n5)];
                        if (TextureData.ColorSpace.YCbCr == colorSpace2) {
                            colorSink.storeYCbCr(i3, i2, by, (byte)0, (byte)0);
                            continue;
                        }
                        colorSink.storeRGB(i3, i2, by, by, by);
                    }
                }
                break;
            }
            case 2: {
                ComponentOut componentOut = this.components[0];
                ComponentOut componentOut2 = this.components[1];
                for (int i4 = 0; i4 < n3; ++i4) {
                    int n7 = i4 * n6;
                    byte[] byArray = componentOut.getLine((int)((float)n7 * componentOut.scaleY));
                    byte[] byArray2 = componentOut.getLine((int)((float)n7 * componentOut2.scaleY));
                    for (int i5 = 0; i5 < n2; ++i5) {
                        int n8 = i5 * n5;
                        byte by = byArray[(int)((float)n8 * componentOut.scaleX)];
                        byte by2 = byArray2[(int)((float)n8 * componentOut2.scaleX)];
                        colorSink.store2(i5, i4, by, by2);
                    }
                }
                break;
            }
            case 3: {
                if (TextureData.ColorSpace.YCbCr != colorSpace) {
                    throw new CodecException("Unsupported source color space w 3 components: " + (Object)((Object)colorSpace));
                }
                ComponentOut componentOut = this.components[0];
                ComponentOut componentOut3 = this.components[1];
                ComponentOut componentOut4 = this.components[2];
                for (int i6 = 0; i6 < n3; ++i6) {
                    byte by;
                    byte by3;
                    byte by4;
                    int n9;
                    int n10;
                    int n11 = i6 * n6;
                    byte[] byArray = componentOut.getLine((int)((float)n11 * componentOut.scaleY));
                    byte[] byArray3 = componentOut3.getLine((int)((float)n11 * componentOut3.scaleY));
                    byte[] byArray4 = componentOut4.getLine((int)((float)n11 * componentOut4.scaleY));
                    if (TextureData.ColorSpace.YCbCr == colorSpace2) {
                        for (n10 = 0; n10 < n2; ++n10) {
                            n9 = n10 * n5;
                            by4 = byArray[(int)((float)n9 * componentOut.scaleX)];
                            by3 = byArray3[(int)((float)n9 * componentOut3.scaleX)];
                            by = byArray4[(int)((float)n9 * componentOut4.scaleX)];
                            colorSink.storeYCbCr(n10, i6, by4, by3, by);
                        }
                        continue;
                    }
                    for (n10 = 0; n10 < n2; ++n10) {
                        n9 = n10 * n5;
                        by4 = 0xFF & byArray[(int)((float)n9 * componentOut.scaleX)];
                        by3 = 0xFF & byArray3[(int)((float)n9 * componentOut3.scaleX)];
                        by = 0xFF & byArray4[(int)((float)n9 * componentOut4.scaleX)];
                        byte by5 = JPEGDecoder.clampTo8bit((float)by4 + 1.402f * ((float)by - 128.0f));
                        byte by6 = JPEGDecoder.clampTo8bit((float)by4 - 0.3441363f * ((float)by3 - 128.0f) - 0.71413636f * ((float)by - 128.0f));
                        byte by7 = JPEGDecoder.clampTo8bit((float)by4 + 1.772f * ((float)by3 - 128.0f));
                        colorSink.storeRGB(n10, i6, by5, by6, by7);
                    }
                }
                break;
            }
            case 4: {
                if (TextureData.ColorSpace.YCCK != colorSpace && TextureData.ColorSpace.CMYK != colorSpace) {
                    throw new CodecException("Unsupported source color space w 4 components: " + (Object)((Object)colorSpace));
                }
                ComponentOut componentOut = this.components[0];
                ComponentOut componentOut5 = this.components[1];
                ComponentOut componentOut6 = this.components[2];
                ComponentOut componentOut7 = this.components[3];
                for (int i7 = 0; i7 < n3; ++i7) {
                    int n12;
                    byte by;
                    byte by8;
                    byte by9;
                    int n13;
                    int n14;
                    int n15 = i7 * n6;
                    byte[] byArray = componentOut.getLine((int)((float)n15 * componentOut.scaleY));
                    byte[] byArray5 = componentOut5.getLine((int)((float)n15 * componentOut5.scaleY));
                    byte[] byArray6 = componentOut6.getLine((int)((float)n15 * componentOut6.scaleY));
                    byte[] byArray7 = componentOut7.getLine((int)((float)n15 * componentOut7.scaleY));
                    if (TextureData.ColorSpace.YCbCr == colorSpace2) {
                        if (TextureData.ColorSpace.YCCK != colorSpace) {
                            throw new CodecException("Unsupported storage color space " + (Object)((Object)colorSpace2) + " with source color space " + (Object)((Object)colorSpace));
                        }
                        for (n14 = 0; n14 < n2; ++n14) {
                            n13 = n14 * n5;
                            by9 = byArray[(int)((float)n13 * componentOut.scaleX)];
                            by8 = byArray5[(int)((float)n13 * componentOut5.scaleX)];
                            by = byArray6[(int)((float)n13 * componentOut6.scaleX)];
                            colorSink.storeYCbCr(n14, i7, by9, by8, by);
                        }
                        continue;
                    }
                    if (TextureData.ColorSpace.CMYK == colorSpace) {
                        for (n14 = 0; n14 < n2; ++n14) {
                            n13 = n14 * n5;
                            by9 = 0xFF & byArray[(int)((float)n13 * componentOut.scaleX)];
                            by8 = 0xFF & byArray5[(int)((float)n13 * componentOut5.scaleX)];
                            by = 0xFF & byArray6[(int)((float)n13 * componentOut6.scaleX)];
                            n12 = 0xFF & byArray7[(int)((float)n13 * componentOut7.scaleX)];
                            byte by10 = JPEGDecoder.clampTo8bit((float)(by9 * n12) / 255.0f);
                            byte by11 = JPEGDecoder.clampTo8bit((float)(by8 * n12) / 255.0f);
                            byte by12 = JPEGDecoder.clampTo8bit((float)(by * n12) / 255.0f);
                            colorSink.storeRGB(n14, i7, by10, by11, by12);
                        }
                        continue;
                    }
                    for (n14 = 0; n14 < n2; ++n14) {
                        n13 = n14 * n5;
                        by9 = 0xFF & byArray[(int)((float)n13 * componentOut.scaleX)];
                        by8 = 0xFF & byArray5[(int)((float)n13 * componentOut5.scaleX)];
                        by = 0xFF & byArray6[(int)((float)n13 * componentOut6.scaleX)];
                        n12 = 0xFF & byArray7[(int)((float)n13 * componentOut7.scaleX)];
                        float f2 = 255.0f - ((float)by9 + 1.402f * ((float)by - 128.0f));
                        float f3 = 255.0f - ((float)by9 - 0.3441363f * ((float)by8 - 128.0f) - 0.71413636f * ((float)by - 128.0f));
                        float f4 = 255.0f - ((float)by9 + 1.772f * ((float)by8 - 128.0f));
                        byte by13 = JPEGDecoder.clampTo8bit(f2 * (float)n12 / 255.0f);
                        byte by14 = JPEGDecoder.clampTo8bit(f3 * (float)n12 / 255.0f);
                        byte by15 = JPEGDecoder.clampTo8bit(f4 * (float)n12 / 255.0f);
                        colorSink.storeRGB(n14, i7, by13, by14, by15);
                    }
                }
                break;
            }
            default: {
                throw new CodecException("Unsupported color model: Space " + (Object)((Object)colorSpace) + ", components " + n4);
            }
        }
    }

    private static byte clampTo8bit(float f2) {
        return (byte)(f2 < 0.0f ? 0.0f : (f2 > 255.0f ? 255.0f : f2));
    }

    private static String toHexString(int n2) {
        return "0x" + Integer.toHexString(n2);
    }

    class Decoder {
        private int mcusPerLine;
        private boolean progressive;
        private int spectralStart;
        private int spectralEnd;
        private int successive;
        private int eobrun;
        private int successiveACState;
        private int successiveACNextValue;
        final DecoderFunction decodeBaseline = new BaselineDecoder();
        final DecoderFunction decodeDCFirst = new DCFirstDecoder();
        final DecoderFunction decodeDCSuccessive = new DCSuccessiveDecoder();
        final DecoderFunction decodeACFirst = new ACFirstDecoder();
        final DecoderFunction decodeACSuccessive = new ACSuccessiveDecoder();

        Decoder() {
        }

        private int decodeScan(Frame frame, ArrayList<ComponentIn> arrayList, int n2, int n3, int n4, int n5, int n6) throws IOException {
            int n7;
            this.mcusPerLine = frame.mcusPerLine;
            this.progressive = frame.progressive;
            JPEGDecoder.this.bstream.skip(JPEGDecoder.this.bstream.getBitCount());
            this.spectralStart = n3;
            this.spectralEnd = n4;
            this.successive = n6;
            int n8 = arrayList.size();
            DecoderFunction decoderFunction = this.progressive ? (n3 == 0 ? (n5 == 0 ? this.decodeDCFirst : this.decodeDCSuccessive) : (n5 == 0 ? this.decodeACFirst : this.decodeACSuccessive)) : this.decodeBaseline;
            int n9 = 0;
            if (n8) {
                ComponentIn componentIn = arrayList.get(0);
                n7 = componentIn.blocksPerLine * componentIn.blocksPerColumn;
            } else {
                n7 = this.mcusPerLine * frame.mcusPerColumn;
            }
            if (0 == n2) {
                n2 = n7;
            }
            if (DEBUG) {
                System.err.println("JPEG.decodeScan.1 resetInterval " + n2 + ", mcuExpected " + n7 + ", sA " + n3 + ", sP " + n5 + ", sE " + n4 + ", suc " + n6 + ", decodeFn " + decoderFunction.getClass().getSimpleName());
            }
            int n10 = 0;
            while (n9 < n7) {
                int n11;
                for (n11 = 0; n11 < n8; n11 += 1) {
                    arrayList.get((int)n11).pred = 0;
                }
                this.eobrun = 0;
                try {
                    int n12;
                    if (n8) {
                        ComponentIn componentIn = arrayList.get(0);
                        for (n12 = 0; n12 < n2; ++n12) {
                            this.decodeBlock(componentIn, decoderFunction, n9);
                            ++n9;
                        }
                    } else {
                        for (n11 = 0; n11 < n2; n11 += 1) {
                            for (n12 = 0; n12 < n8; ++n12) {
                                ComponentIn componentIn = arrayList.get(n12);
                                int n13 = componentIn.h;
                                int n14 = componentIn.v;
                                for (int i2 = 0; i2 < n14; ++i2) {
                                    for (int i3 = 0; i3 < n13; ++i3) {
                                        this.decodeMcu(componentIn, decoderFunction, n9, i2, i3);
                                    }
                                }
                            }
                            ++n9;
                        }
                    }
                }
                catch (MarkerException markerException) {
                    if (DEBUG) {
                        System.err.println("JPEG.decodeScan: Marker exception: " + markerException.getMessage());
                        markerException.printStackTrace();
                    }
                    return markerException.getMarker();
                }
                catch (CodecException codecException) {
                    if (DEBUG) {
                        System.err.println("JPEG.decodeScan: Codec exception: " + codecException.getMessage());
                        codecException.printStackTrace();
                    }
                    JPEGDecoder.this.bstream.skip(JPEGDecoder.this.bstream.getBitCount());
                    return 65497;
                }
                JPEGDecoder.this.bstream.skip(JPEGDecoder.this.bstream.getBitCount());
                JPEGDecoder.this.bstream.mark(2);
                n10 = JPEGDecoder.this.readUInt16();
                if (n10 < 65280) {
                    JPEGDecoder.this.bstream.reset();
                    throw new CodecException("marker not found @ mcu " + n9 + "/" + n7 + ", u16: " + JPEGDecoder.toHexString(n10));
                }
                int n15 = n11 = 65488 <= n10 && n10 <= 65495 ? 1 : 0;
                if (DEBUG) {
                    System.err.println("JPEG.decodeScan: MCUs " + n9 + "/" + n7 + ", u16 " + JPEGDecoder.toHexString(n10) + ", RSTx " + (n11 != 0) + ", " + frame);
                }
                if (n11) continue;
                break;
            }
            return n10;
        }

        private final int readBit() throws MarkerException, IOException {
            int n2 = JPEGDecoder.this.bstream.readBit(true);
            if (-1 == n2 || 7 != JPEGDecoder.this.bstream.getBitCount()) {
                return n2;
            }
            int n3 = JPEGDecoder.this.bstream.getBitBuffer();
            if (255 == n3) {
                int n4 = JPEGDecoder.this.bstream.getStream().read();
                if (-1 == n4) {
                    throw new CodecException("marked prefix 0xFF, then EOF");
                }
                if (0 != n4) {
                    int n5 = n3 << 8 | n4;
                    throw new MarkerException(n5, "Marker at readBit pos " + JPEGDecoder.this.bstream);
                }
            }
            return n2;
        }

        private int decodeHuffman(BinObj binObj) throws IOException {
            int n2;
            BinObj binObj2 = binObj;
            while ((n2 = this.readBit()) != -1) {
                binObj2 = binObj2.get(n2);
                if (!binObj2.isValue) continue;
                return 0xFF & binObj2.getValue();
            }
            throw new CodecException("EOF reached at " + JPEGDecoder.this.bstream);
        }

        private int receive(int n2) throws IOException {
            int n3 = 0;
            while (n2 > 0) {
                int n4 = this.readBit();
                if (n4 == -1) {
                    return -1;
                }
                n3 = n3 << 1 | n4;
                --n2;
            }
            return n3;
        }

        private int receiveAndExtend(int n2) throws IOException {
            int n3 = this.receive(n2);
            if (n3 >= 1 << n2 - 1) {
                return n3;
            }
            return n3 + (-1 << n2) + 1;
        }

        void decodeMcu(ComponentIn componentIn, DecoderFunction decoderFunction, int n2, int n3, int n4) throws IOException {
            int n5 = n2 / this.mcusPerLine | 0;
            int n6 = n2 % this.mcusPerLine;
            int n7 = n5 * componentIn.v + n3;
            int n8 = n6 * componentIn.h + n4;
            decoderFunction.decode(componentIn, componentIn.getBlock(n7, n8));
        }

        void decodeBlock(ComponentIn componentIn, DecoderFunction decoderFunction, int n2) throws IOException {
            int n3 = n2 / componentIn.blocksPerLine | 0;
            int n4 = n2 % componentIn.blocksPerLine;
            decoderFunction.decode(componentIn, componentIn.getBlock(n3, n4));
        }

        class ACSuccessiveDecoder
        implements DecoderFunction {
            ACSuccessiveDecoder() {
            }

            @Override
            public void decode(ComponentIn componentIn, int[] nArray) throws IOException {
                int n2 = Decoder.this.spectralStart;
                int n3 = Decoder.this.spectralEnd;
                int n4 = 0;
                block6: while (n2 <= n3) {
                    int n5 = dctZigZag[n2];
                    switch (Decoder.this.successiveACState) {
                        case 0: {
                            int n6 = Decoder.this.decodeHuffman(componentIn.huffmanTableAC);
                            int n7 = n6 & 0xF;
                            n4 = n6 >> 4;
                            if (n7 == 0) {
                                if (n4 < 15) {
                                    Decoder.this.eobrun = Decoder.this.receive(n4) + (1 << n4);
                                    Decoder.this.successiveACState = 4;
                                    continue block6;
                                }
                                n4 = 16;
                                Decoder.this.successiveACState = 1;
                                continue block6;
                            }
                            if (n7 != 1) {
                                throw new CodecException("invalid ACn encoding");
                            }
                            Decoder.this.successiveACNextValue = Decoder.this.receiveAndExtend(n7);
                            Decoder.this.successiveACState = n4 != 0 ? 2 : 3;
                            continue block6;
                        }
                        case 1: 
                        case 2: {
                            if (nArray[n5] != 0) {
                                int n8 = n5;
                                nArray[n8] = nArray[n8] + (Decoder.this.readBit() << Decoder.this.successive);
                                break;
                            }
                            if (--n4 != 0) break;
                            Decoder.this.successiveACState = Decoder.this.successiveACState == 2 ? 3 : 0;
                            break;
                        }
                        case 3: {
                            if (nArray[n5] != 0) {
                                int n9 = n5;
                                nArray[n9] = nArray[n9] + (Decoder.this.readBit() << Decoder.this.successive);
                                break;
                            }
                            nArray[n5] = Decoder.this.successiveACNextValue << Decoder.this.successive;
                            Decoder.this.successiveACState = 0;
                            break;
                        }
                        case 4: {
                            if (nArray[n5] == 0) break;
                            int n10 = n5;
                            nArray[n10] = nArray[n10] + (Decoder.this.readBit() << Decoder.this.successive);
                        }
                    }
                    ++n2;
                }
                if (Decoder.this.successiveACState == 4) {
                    Decoder.this.eobrun--;
                    if (Decoder.this.eobrun == 0) {
                        Decoder.this.successiveACState = 0;
                    }
                }
            }
        }

        class ACFirstDecoder
        implements DecoderFunction {
            ACFirstDecoder() {
            }

            @Override
            public void decode(ComponentIn componentIn, int[] nArray) throws IOException {
                if (Decoder.this.eobrun > 0) {
                    Decoder.this.eobrun--;
                    return;
                }
                int n2 = Decoder.this.spectralStart;
                int n3 = Decoder.this.spectralEnd;
                while (n2 <= n3) {
                    int n4 = Decoder.this.decodeHuffman(componentIn.huffmanTableAC);
                    int n5 = n4 & 0xF;
                    int n6 = n4 >> 4;
                    if (n5 == 0) {
                        if (n6 < 15) {
                            Decoder.this.eobrun = Decoder.this.receive(n6) + (1 << n6) - 1;
                            break;
                        }
                        n2 += 16;
                        continue;
                    }
                    int n7 = dctZigZag[n2 += n6];
                    nArray[n7] = Decoder.this.receiveAndExtend(n5) * (1 << Decoder.this.successive);
                    ++n2;
                }
            }
        }

        class DCSuccessiveDecoder
        implements DecoderFunction {
            DCSuccessiveDecoder() {
            }

            @Override
            public void decode(ComponentIn componentIn, int[] nArray) throws IOException {
                nArray[0] = nArray[0] | Decoder.this.readBit() << Decoder.this.successive;
            }
        }

        class DCFirstDecoder
        implements DecoderFunction {
            DCFirstDecoder() {
            }

            @Override
            public void decode(ComponentIn componentIn, int[] nArray) throws IOException {
                int n2 = Decoder.this.decodeHuffman(componentIn.huffmanTableDC);
                int n3 = n2 == 0 ? 0 : Decoder.this.receiveAndExtend(n2) << Decoder.this.successive;
                nArray[0] = componentIn.pred += n3;
            }
        }

        class BaselineDecoder
        implements DecoderFunction {
            BaselineDecoder() {
            }

            @Override
            public void decode(ComponentIn componentIn, int[] nArray) throws IOException {
                int n2 = Decoder.this.decodeHuffman(componentIn.huffmanTableDC);
                int n3 = n2 == 0 ? 0 : Decoder.this.receiveAndExtend(n2);
                nArray[0] = componentIn.pred += n3;
                int n4 = 1;
                while (n4 < 64) {
                    int n5 = Decoder.this.decodeHuffman(componentIn.huffmanTableAC);
                    int n6 = n5 & 0xF;
                    int n7 = n5 >> 4;
                    if (n6 == 0) {
                        if (n7 < 15) break;
                        n4 += 16;
                        continue;
                    }
                    int n8 = dctZigZag[n4 += n7];
                    nArray[n8] = Decoder.this.receiveAndExtend(n6);
                    ++n4;
                }
            }
        }
    }

    static interface DecoderFunction {
        public void decode(ComponentIn var1, int[] var2) throws IOException;
    }

    static class Output {
        private int blocksPerLine;
        private int blocksPerColumn;
        private int samplesPerLine;

        Output() {
        }

        private ArrayList<byte[]> buildComponentData(Frame frame, ComponentIn componentIn) {
            ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
            this.blocksPerLine = componentIn.blocksPerLine;
            this.blocksPerColumn = componentIn.blocksPerColumn;
            this.samplesPerLine = this.blocksPerLine << 3;
            int[] nArray = new int[64];
            byte[] byArray = new byte[64];
            for (int i2 = 0; i2 < this.blocksPerColumn; ++i2) {
                int n2;
                int n3 = i2 << 3;
                for (n2 = 0; n2 < 8; ++n2) {
                    arrayList.add(new byte[this.samplesPerLine]);
                }
                for (n2 = 0; n2 < this.blocksPerLine; ++n2) {
                    this.quantizeAndInverse(componentIn.getBlock(i2, n2), byArray, nArray, frame.qtt[componentIn.qttIdx]);
                    int n4 = n2 << 3;
                    int n5 = 0;
                    for (int i3 = 0; i3 < 8; ++i3) {
                        byte[] byArray2 = arrayList.get(n3 + i3);
                        for (int i4 = 0; i4 < 8; ++i4) {
                            byArray2[n4 + i4] = byArray[n5++];
                        }
                    }
                }
            }
            return arrayList;
        }

        private void quantizeAndInverse(int[] nArray, byte[] byArray, int[] nArray2, int[] nArray3) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int[] nArray4 = nArray2;
            for (n12 = 0; n12 < 64; ++n12) {
                nArray4[n12] = nArray[n12] * nArray3[n12];
            }
            for (n12 = 0; n12 < 8; ++n12) {
                n11 = 8 * n12;
                if (nArray4[1 + n11] == 0 && nArray4[2 + n11] == 0 && nArray4[3 + n11] == 0 && nArray4[4 + n11] == 0 && nArray4[5 + n11] == 0 && nArray4[6 + n11] == 0 && nArray4[7 + n11] == 0) {
                    nArray4[0 + n11] = n10 = 5793 * nArray4[0 + n11] + 512 >> 10;
                    nArray4[1 + n11] = n10;
                    nArray4[2 + n11] = n10;
                    nArray4[3 + n11] = n10;
                    nArray4[4 + n11] = n10;
                    nArray4[5 + n11] = n10;
                    nArray4[6 + n11] = n10;
                    nArray4[7 + n11] = n10;
                    continue;
                }
                n9 = 5793 * nArray4[0 + n11] + 128 >> 8;
                n8 = 5793 * nArray4[4 + n11] + 128 >> 8;
                n7 = nArray4[2 + n11];
                n6 = nArray4[6 + n11];
                n5 = 2896 * (nArray4[1 + n11] - nArray4[7 + n11]) + 128 >> 8;
                n4 = 2896 * (nArray4[1 + n11] + nArray4[7 + n11]) + 128 >> 8;
                n3 = nArray4[3 + n11] << 4;
                n2 = nArray4[5 + n11] << 4;
                n10 = n9 - n8 + 1 >> 1;
                n9 = n9 + n8 + 1 >> 1;
                n8 = n10;
                n10 = n7 * 3784 + n6 * 1567 + 128 >> 8;
                n7 = n7 * 1567 - n6 * 3784 + 128 >> 8;
                n6 = n10;
                n10 = n5 - n2 + 1 >> 1;
                n5 = n5 + n2 + 1 >> 1;
                n2 = n10;
                n10 = n4 + n3 + 1 >> 1;
                n3 = n4 - n3 + 1 >> 1;
                n4 = n10;
                n10 = n9 - n6 + 1 >> 1;
                n9 = n9 + n6 + 1 >> 1;
                n6 = n10;
                n10 = n8 - n7 + 1 >> 1;
                n8 = n8 + n7 + 1 >> 1;
                n7 = n10;
                n10 = n5 * 2276 + n4 * 3406 + 2048 >> 12;
                n5 = n5 * 3406 - n4 * 2276 + 2048 >> 12;
                n4 = n10;
                n10 = n3 * 799 + n2 * 4017 + 2048 >> 12;
                n3 = n3 * 4017 - n2 * 799 + 2048 >> 12;
                n2 = n10;
                nArray4[0 + n11] = n9 + n4;
                nArray4[7 + n11] = n9 - n4;
                nArray4[1 + n11] = n8 + n2;
                nArray4[6 + n11] = n8 - n2;
                nArray4[2 + n11] = n7 + n3;
                nArray4[5 + n11] = n7 - n3;
                nArray4[3 + n11] = n6 + n5;
                nArray4[4 + n11] = n6 - n5;
            }
            for (n12 = 0; n12 < 8; ++n12) {
                n11 = n12;
                if (nArray4[8 + n11] == 0 && nArray4[16 + n11] == 0 && nArray4[24 + n11] == 0 && nArray4[32 + n11] == 0 && nArray4[40 + n11] == 0 && nArray4[48 + n11] == 0 && nArray4[56 + n11] == 0) {
                    nArray4[0 + n11] = n10 = 5793 * nArray2[n12 + 0] + 8192 >> 14;
                    nArray4[8 + n11] = n10;
                    nArray4[16 + n11] = n10;
                    nArray4[24 + n11] = n10;
                    nArray4[32 + n11] = n10;
                    nArray4[40 + n11] = n10;
                    nArray4[48 + n11] = n10;
                    nArray4[56 + n11] = n10;
                    continue;
                }
                n9 = 5793 * nArray4[0 + n11] + 2048 >> 12;
                n8 = 5793 * nArray4[32 + n11] + 2048 >> 12;
                n7 = nArray4[16 + n11];
                n6 = nArray4[48 + n11];
                n5 = 2896 * (nArray4[8 + n11] - nArray4[56 + n11]) + 2048 >> 12;
                n4 = 2896 * (nArray4[8 + n11] + nArray4[56 + n11]) + 2048 >> 12;
                n3 = nArray4[24 + n11];
                n2 = nArray4[40 + n11];
                n10 = n9 - n8 + 1 >> 1;
                n9 = n9 + n8 + 1 >> 1;
                n8 = n10;
                n10 = n7 * 3784 + n6 * 1567 + 2048 >> 12;
                n7 = n7 * 1567 - n6 * 3784 + 2048 >> 12;
                n6 = n10;
                n10 = n5 - n2 + 1 >> 1;
                n5 = n5 + n2 + 1 >> 1;
                n2 = n10;
                n10 = n4 + n3 + 1 >> 1;
                n3 = n4 - n3 + 1 >> 1;
                n4 = n10;
                n10 = n9 - n6 + 1 >> 1;
                n9 = n9 + n6 + 1 >> 1;
                n6 = n10;
                n10 = n8 - n7 + 1 >> 1;
                n8 = n8 + n7 + 1 >> 1;
                n7 = n10;
                n10 = n5 * 2276 + n4 * 3406 + 2048 >> 12;
                n5 = n5 * 3406 - n4 * 2276 + 2048 >> 12;
                n4 = n10;
                n10 = n3 * 799 + n2 * 4017 + 2048 >> 12;
                n3 = n3 * 4017 - n2 * 799 + 2048 >> 12;
                n2 = n10;
                nArray4[0 + n11] = n9 + n4;
                nArray4[56 + n11] = n9 - n4;
                nArray4[8 + n11] = n8 + n2;
                nArray4[48 + n11] = n8 - n2;
                nArray4[16 + n11] = n7 + n3;
                nArray4[40 + n11] = n7 - n3;
                nArray4[24 + n11] = n6 + n5;
                nArray4[32 + n11] = n6 - n5;
            }
            for (n12 = 0; n12 < 64; ++n12) {
                n11 = 128 + (nArray4[n12] + 8 >> 4);
                byArray[n12] = (byte)(n11 < 0 ? 0 : (n11 > 255 ? 255 : n11));
            }
        }
    }

    static class BinObj {
        final boolean isValue;
        final BinObj[] tree;
        final byte b;

        BinObj(byte by) {
            this.isValue = true;
            this.b = by;
            this.tree = null;
        }

        BinObj() {
            this.isValue = false;
            this.b = 0;
            this.tree = new BinObj[2];
        }

        final byte getValue() {
            return this.b;
        }

        final BinObj get(int n2) {
            return this.tree[n2];
        }

        final void set(byte by, byte by2) {
            this.tree[by] = new BinObj(by2);
        }

        final void set(byte by, BinObj binObj) {
            this.tree[by] = binObj;
        }
    }

    static class BinObjIdxed {
        final BinObj children = new BinObj();
        byte index = 0;

        BinObjIdxed() {
        }
    }

    static class ComponentOut {
        private final ArrayList<byte[]> lines;
        final float scaleX;
        final float scaleY;

        ComponentOut(ArrayList<byte[]> arrayList, float f2, float f3) {
            this.lines = arrayList;
            this.scaleX = f2;
            this.scaleY = f3;
        }

        public final byte[] getLine(int n2) {
            int n3 = this.lines.size();
            return this.lines.get(n2 < n3 ? n2 : n3 - 1);
        }

        public final String toString() {
            return "CompOut[lines " + this.lines.size() + ", scale " + this.scaleX + "x" + this.scaleY + "]";
        }
    }

    static class ComponentIn {
        final int h;
        final int v;
        final int qttIdx;
        int blocksPerColumn;
        int blocksPerColumnForMcu;
        int blocksPerLine;
        int blocksPerLineForMcu;
        int[][][] blocks;
        int pred;
        BinObj huffmanTableAC;
        BinObj huffmanTableDC;

        ComponentIn(int n2, int n3, int n4) {
            this.h = n2;
            this.v = n3;
            this.qttIdx = n4;
        }

        public final void allocateBlocks(int n2, int n3, int n4, int n5) {
            this.blocksPerColumn = n2;
            this.blocksPerColumnForMcu = n3;
            this.blocksPerLine = n4;
            this.blocksPerLineForMcu = n5;
            this.blocks = new int[n3][n5][64];
        }

        public final int[] getBlock(int n2, int n3) {
            if (n2 >= this.blocksPerColumnForMcu || n3 >= this.blocksPerLineForMcu) {
                throw new CodecException("Out of bounds given [" + n2 + "][" + n3 + "] - " + this);
            }
            return this.blocks[n2][n3];
        }

        public final String toString() {
            return "CompIn[h " + this.h + ", v " + this.v + ", qttIdx " + this.qttIdx + ", blocks[" + this.blocksPerColumn + ", mcu " + this.blocksPerColumnForMcu + "][" + this.blocksPerLine + ", mcu " + this.blocksPerLineForMcu + "][64]]";
        }
    }

    static class Frame {
        final boolean progressive;
        final int precision;
        final int scanLines;
        final int samplesPerLine;
        private final ArrayHashSet<Integer> compIDs;
        private final ComponentIn[] comps;
        private final int compCount;
        final int[][] qtt;
        int maxCompID;
        int maxH;
        int maxV;
        int mcusPerLine;
        int mcusPerColumn;

        Frame(boolean bl, int n2, int n3, int n4, int n5, int[][] nArray) {
            this.progressive = bl;
            this.precision = n2;
            this.scanLines = n3;
            this.samplesPerLine = n4;
            this.compIDs = new ArrayHashSet(n5);
            this.comps = new ComponentIn[n5];
            this.compCount = n5;
            this.qtt = nArray;
        }

        private final void checkBounds(int n2) {
            if (0 > n2 || n2 >= this.compCount) {
                throw new CodecException("Idx out of bounds " + n2 + ", " + this);
            }
        }

        public final void validateComponents() {
            for (int i2 = 0; i2 < this.compCount; ++i2) {
                ComponentIn componentIn = this.comps[i2];
                if (null == componentIn) {
                    throw new CodecException("Component[" + i2 + "] null");
                }
                if (null != this.qtt[componentIn.qttIdx]) continue;
                throw new CodecException("Component[" + i2 + "].qttIdx -> null QTT");
            }
        }

        public final int getCompCount() {
            return this.compCount;
        }

        public final int getMaxCompID() {
            return this.maxCompID;
        }

        public final void putOrdered(int n2, ComponentIn componentIn) {
            if (this.maxCompID < n2) {
                this.maxCompID = n2;
            }
            int n3 = this.compIDs.size();
            this.checkBounds(n3);
            this.compIDs.add(n2);
            this.comps[n3] = componentIn;
        }

        public final ComponentIn getCompByIndex(int n2) {
            this.checkBounds(n2);
            return this.comps[n2];
        }

        public final ComponentIn getCompByID(int n2) {
            return this.getCompByIndex(this.compIDs.indexOf(n2));
        }

        public final int getCompID(int n2) {
            return this.compIDs.get(n2);
        }

        public final boolean hasCompID(int n2) {
            return this.compIDs.contains(n2);
        }

        public final String toString() {
            return "Frame[progressive " + this.progressive + ", precision " + this.precision + ", scanLines " + this.scanLines + ", samplesPerLine " + this.samplesPerLine + ", components[count " + this.compCount + ", maxID " + this.maxCompID + ", componentIDs " + this.compIDs + ", comps " + Arrays.asList(this.comps) + "]]";
        }
    }

    public static class MarkerException
    extends CodecException {
        final int marker;

        MarkerException(int n2, String string) {
            super(string + " - Marker " + JPEGDecoder.toHexString(n2));
            this.marker = n2;
        }

        public int getMarker() {
            return this.marker;
        }
    }

    public static class CodecException
    extends RuntimeException {
        CodecException(String string) {
            super(string);
        }
    }

    public static class EXIF {
        private EXIF(byte[] byArray) {
        }

        public static final EXIF get(byte[] byArray) throws RuntimeException {
            if (byArray[0] == 69 && byArray[1] == 120 && byArray[2] == 105 && byArray[3] == 102 && byArray[4] == 0) {
                EXIF eXIF = new EXIF(byArray);
                return eXIF;
            }
            return null;
        }

        public final String toString() {
            return "EXIF[]";
        }
    }

    public static class Adobe {
        final short version;
        final short flags0;
        final short flags1;
        final short colorCode;
        final TextureData.ColorSpace colorSpace;

        private Adobe(byte[] byArray) {
            this.version = byArray[6];
            this.flags0 = (short)(byArray[7] << 8 & 0xFF00 | byArray[8] & 0xFF);
            this.flags1 = (short)(byArray[9] << 8 & 0xFF00 | byArray[10] & 0xFF);
            this.colorCode = byArray[11];
            switch (this.colorCode) {
                case 2: {
                    this.colorSpace = TextureData.ColorSpace.YCCK;
                    break;
                }
                case 1: {
                    this.colorSpace = TextureData.ColorSpace.YCbCr;
                    break;
                }
                default: {
                    this.colorSpace = TextureData.ColorSpace.CMYK;
                }
            }
        }

        public static final Adobe get(byte[] byArray) throws RuntimeException {
            if (byArray[0] == 65 && byArray[1] == 100 && byArray[2] == 111 && byArray[3] == 98 && byArray[4] == 101 && byArray[5] == 0) {
                Adobe adobe = new Adobe(byArray);
                return adobe;
            }
            return null;
        }

        public final String toString() {
            return "Adobe[ver " + this.version + ", flags[" + JPEGDecoder.toHexString(this.flags0) + ", " + JPEGDecoder.toHexString(this.flags1) + "], colorSpace/Code " + (Object)((Object)this.colorSpace) + "/" + JPEGDecoder.toHexString(this.colorCode) + "]";
        }
    }

    public static class JFIF {
        final VersionNumber version;
        final int densityUnits;
        final int xDensity;
        final int yDensity;
        final int thumbWidth;
        final int thumbHeight;
        final byte[] thumbData;

        private JFIF(byte[] byArray) {
            this.version = new VersionNumber(byArray[5], byArray[6], 0);
            this.densityUnits = byArray[7];
            this.xDensity = byArray[8] << 8 & 0xFF00 | byArray[9] & 0xFF;
            this.yDensity = byArray[10] << 8 & 0xFF00 | byArray[11] & 0xFF;
            this.thumbWidth = byArray[12];
            this.thumbHeight = byArray[13];
            if (0 < this.thumbWidth && 0 < this.thumbHeight) {
                int n2 = 14 + 3 * this.thumbWidth * this.thumbHeight;
                this.thumbData = new byte[n2];
                System.arraycopy(byArray, 14, this.thumbData, 0, n2);
            } else {
                this.thumbData = null;
            }
        }

        public static final JFIF get(byte[] byArray) throws RuntimeException {
            if (byArray[0] == 74 && byArray[1] == 70 && byArray[2] == 73 && byArray[3] == 70 && byArray[4] == 0) {
                JFIF jFIF = new JFIF(byArray);
                return jFIF;
            }
            return null;
        }

        public final String toString() {
            return "JFIF[ver " + this.version + ", density[units " + this.densityUnits + ", " + this.xDensity + "x" + this.yDensity + "], thumb " + this.thumbWidth + "x" + this.thumbHeight + "]";
        }
    }

    public static interface ColorSink {
        public TextureData.ColorSpace allocate(int var1, int var2, TextureData.ColorSpace var3, int var4) throws RuntimeException;

        public void store2(int var1, int var2, byte var3, byte var4);

        public void storeRGB(int var1, int var2, byte var3, byte var4, byte var5);

        public void storeYCbCr(int var1, int var2, byte var3, byte var4, byte var5);
    }
}

