/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.ImageLine;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.PngChunkPLTE;
import jogamp.opengl.util.pngj.chunks.PngChunkTRNS;

public class ImageLineHelper {
    private static final double BIG_VALUE = 8.988465674311579E307;
    private static final double BIG_VALUE_NEG = -8.988465674311579E307;

    public static int[] palette2rgb(ImageLine imageLine, PngChunkPLTE pngChunkPLTE, PngChunkTRNS pngChunkTRNS, int[] nArray) {
        boolean bl = pngChunkTRNS != null;
        int n2 = bl ? 4 : 3;
        int n3 = imageLine.imgInfo.cols * n2;
        if (nArray == null || nArray.length < n3) {
            nArray = new int[n3];
        }
        if (!imageLine.samplesUnpacked) {
            imageLine = imageLine.unpackToNewImageLine();
        }
        boolean bl2 = imageLine.sampleType == ImageLine.SampleType.BYTE;
        int n4 = pngChunkTRNS != null ? pngChunkTRNS.getPalletteAlpha().length : 0;
        for (int i2 = 0; i2 < imageLine.imgInfo.cols; ++i2) {
            int n5;
            int n6 = bl2 ? imageLine.scanlineb[i2] & 0xFF : imageLine.scanline[i2];
            pngChunkPLTE.getEntryRgb(n6, nArray, i2 * n2);
            if (!bl) continue;
            nArray[i2 * n2 + 3] = n5 = n6 < n4 ? pngChunkTRNS.getPalletteAlpha()[n6] : 255;
        }
        return nArray;
    }

    public static int[] palette2rgb(ImageLine imageLine, PngChunkPLTE pngChunkPLTE, int[] nArray) {
        return ImageLineHelper.palette2rgb(imageLine, pngChunkPLTE, null, nArray);
    }

    public static String infoFirstLastPixels(ImageLine imageLine) {
        return imageLine.imgInfo.channels == 1 ? String.format("first=(%d) last=(%d)", imageLine.scanline[0], imageLine.scanline[imageLine.scanline.length - 1]) : String.format("first=(%d %d %d) last=(%d %d %d)", imageLine.scanline[0], imageLine.scanline[1], imageLine.scanline[2], imageLine.scanline[imageLine.scanline.length - imageLine.imgInfo.channels], imageLine.scanline[imageLine.scanline.length - imageLine.imgInfo.channels + 1], imageLine.scanline[imageLine.scanline.length - imageLine.imgInfo.channels + 2]);
    }

    public static String infoFull(ImageLine imageLine) {
        ImageLineStats imageLineStats = new ImageLineStats(imageLine);
        return "row=" + imageLine.getRown() + " " + imageLineStats.toString() + "\n  " + ImageLineHelper.infoFirstLastPixels(imageLine);
    }

    public static int getPixelRGB8(ImageLine imageLine, int n2) {
        int n3 = n2 * imageLine.channels;
        return (imageLine.scanline[n3] << 16) + (imageLine.scanline[n3 + 1] << 8) + imageLine.scanline[n3 + 2];
    }

    public static int getPixelARGB8(ImageLine imageLine, int n2) {
        int n3 = n2 * imageLine.channels;
        return (imageLine.scanline[n3 + 3] << 24) + (imageLine.scanline[n3] << 16) + (imageLine.scanline[n3 + 1] << 8) + imageLine.scanline[n3 + 2];
    }

    public static void setPixelsRGB8(ImageLine imageLine, int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < imageLine.imgInfo.cols; ++i2) {
            imageLine.scanline[n2++] = nArray[i2] >> 16 & 0xFF;
            imageLine.scanline[n2++] = nArray[i2] >> 8 & 0xFF;
            imageLine.scanline[n2++] = nArray[i2] & 0xFF;
        }
    }

    public static void setPixelRGB8(ImageLine imageLine, int n2, int n3, int n4, int n5) {
        n2 *= imageLine.channels;
        imageLine.scanline[n2++] = n3;
        imageLine.scanline[n2++] = n4;
        imageLine.scanline[n2] = n5;
    }

    public static void setPixelRGB8(ImageLine imageLine, int n2, int n3) {
        ImageLineHelper.setPixelRGB8(imageLine, n2, n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF);
    }

    public static void setPixelsRGBA8(ImageLine imageLine, int[] nArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < imageLine.imgInfo.cols; ++i2) {
            imageLine.scanline[n2++] = nArray[i2] >> 16 & 0xFF;
            imageLine.scanline[n2++] = nArray[i2] >> 8 & 0xFF;
            imageLine.scanline[n2++] = nArray[i2] & 0xFF;
            imageLine.scanline[n2++] = nArray[i2] >> 24 & 0xFF;
        }
    }

    public static void setPixelRGBA8(ImageLine imageLine, int n2, int n3, int n4, int n5, int n6) {
        n2 *= imageLine.channels;
        imageLine.scanline[n2++] = n3;
        imageLine.scanline[n2++] = n4;
        imageLine.scanline[n2++] = n5;
        imageLine.scanline[n2] = n6;
    }

    public static void setPixelRGBA8(ImageLine imageLine, int n2, int n3) {
        ImageLineHelper.setPixelRGBA8(imageLine, n2, n3 >> 16 & 0xFF, n3 >> 8 & 0xFF, n3 & 0xFF, n3 >> 24 & 0xFF);
    }

    public static void setValD(ImageLine imageLine, int n2, double d2) {
        imageLine.scanline[n2] = ImageLineHelper.double2int(imageLine, d2);
    }

    public static int interpol(int n2, int n3, int n4, int n5, double d2, double d3) {
        double d4 = (double)n2 * (1.0 - d2) + (double)n3 * d2;
        double d5 = (double)n4 * (1.0 - d2) + (double)n5 * d2;
        return (int)(d4 * (1.0 - d3) + d5 * d3 + 0.5);
    }

    public static double int2double(ImageLine imageLine, int n2) {
        return imageLine.bitDepth == 16 ? (double)n2 / 65535.0 : (double)n2 / 255.0;
    }

    public static double int2doubleClamped(ImageLine imageLine, int n2) {
        double d2;
        double d3 = d2 = imageLine.bitDepth == 16 ? (double)n2 / 65535.0 : (double)n2 / 255.0;
        return d2 <= 0.0 ? 0.0 : (d2 >= 1.0 ? 1.0 : d2);
    }

    public static int double2int(ImageLine imageLine, double d2) {
        d2 = d2 <= 0.0 ? 0.0 : (d2 >= 1.0 ? 1.0 : d2);
        return imageLine.bitDepth == 16 ? (int)(d2 * 65535.0 + 0.5) : (int)(d2 * 255.0 + 0.5);
    }

    public static int double2intClamped(ImageLine imageLine, double d2) {
        d2 = d2 <= 0.0 ? 0.0 : (d2 >= 1.0 ? 1.0 : d2);
        return imageLine.bitDepth == 16 ? (int)(d2 * 65535.0 + 0.5) : (int)(d2 * 255.0 + 0.5);
    }

    public static int clampTo_0_255(int n2) {
        return n2 > 255 ? 255 : (n2 < 0 ? 0 : n2);
    }

    public static int clampTo_0_65535(int n2) {
        return n2 > 65535 ? 65535 : (n2 < 0 ? 0 : n2);
    }

    public static int clampTo_128_127(int n2) {
        return n2 > 127 ? 127 : (n2 < -128 ? -128 : n2);
    }

    public static int[] unpack(ImageInfo imageInfo, int[] nArray, int[] nArray2, boolean bl) {
        int n2 = imageInfo.samplesPerRow;
        int n3 = imageInfo.samplesPerRowPacked;
        if (nArray2 == null || nArray2.length < n2) {
            nArray2 = new int[n2];
        }
        if (imageInfo.packed) {
            ImageLine.unpackInplaceInt(imageInfo, nArray, nArray2, bl);
        } else {
            System.arraycopy(nArray, 0, nArray2, 0, n3);
        }
        return nArray2;
    }

    public static byte[] unpack(ImageInfo imageInfo, byte[] byArray, byte[] byArray2, boolean bl) {
        int n2 = imageInfo.samplesPerRow;
        int n3 = imageInfo.samplesPerRowPacked;
        if (byArray2 == null || byArray2.length < n2) {
            byArray2 = new byte[n2];
        }
        if (imageInfo.packed) {
            ImageLine.unpackInplaceByte(imageInfo, byArray, byArray2, bl);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, n3);
        }
        return byArray2;
    }

    public static int[] pack(ImageInfo imageInfo, int[] nArray, int[] nArray2, boolean bl) {
        int n2 = imageInfo.samplesPerRowPacked;
        if (nArray2 == null || nArray2.length < n2) {
            nArray2 = new int[n2];
        }
        if (imageInfo.packed) {
            ImageLine.packInplaceInt(imageInfo, nArray, nArray2, bl);
        } else {
            System.arraycopy(nArray, 0, nArray2, 0, n2);
        }
        return nArray2;
    }

    public static byte[] pack(ImageInfo imageInfo, byte[] byArray, byte[] byArray2, boolean bl) {
        int n2 = imageInfo.samplesPerRowPacked;
        if (byArray2 == null || byArray2.length < n2) {
            byArray2 = new byte[n2];
        }
        if (imageInfo.packed) {
            ImageLine.packInplaceByte(imageInfo, byArray, byArray2, bl);
        } else {
            System.arraycopy(byArray, 0, byArray2, 0, n2);
        }
        return byArray2;
    }

    static int getMaskForPackedFormats(int n2) {
        if (n2 == 4) {
            return 240;
        }
        if (n2 == 2) {
            return 192;
        }
        return 128;
    }

    static int getMaskForPackedFormatsLs(int n2) {
        if (n2 == 4) {
            return 15;
        }
        if (n2 == 2) {
            return 3;
        }
        return 1;
    }

    static class ImageLineStats {
        public double[] prom = new double[]{0.0, 0.0, 0.0, 0.0};
        public double[] maxv = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307};
        public double[] minv = new double[]{8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307, 8.988465674311579E307};
        public double promlum = 0.0;
        public double maxlum = -8.988465674311579E307;
        public double minlum = 8.988465674311579E307;
        public double[] maxdif = new double[]{-8.988465674311579E307, -8.988465674311579E307, -8.988465674311579E307, 8.988465674311579E307};
        public final int channels;

        public String toString() {
            return this.channels == 3 ? String.format("prom=%.1f (%.1f %.1f %.1f) max=%.1f (%.1f %.1f %.1f) min=%.1f (%.1f %.1f %.1f)", this.promlum, this.prom[0], this.prom[1], this.prom[2], this.maxlum, this.maxv[0], this.maxv[1], this.maxv[2], this.minlum, this.minv[0], this.minv[1], this.minv[2]) + String.format(" maxdif=(%.1f %.1f %.1f)", this.maxdif[0], this.maxdif[1], this.maxdif[2]) : String.format("prom=%.1f (%.1f %.1f %.1f %.1f) max=%.1f (%.1f %.1f %.1f %.1f) min=%.1f (%.1f %.1f %.1f %.1f)", this.promlum, this.prom[0], this.prom[1], this.prom[2], this.prom[3], this.maxlum, this.maxv[0], this.maxv[1], this.maxv[2], this.maxv[3], this.minlum, this.minv[0], this.minv[1], this.minv[2], this.minv[3]) + String.format(" maxdif=(%.1f %.1f %.1f %.1f)", this.maxdif[0], this.maxdif[1], this.maxdif[2], this.maxdif[3]);
        }

        public ImageLineStats(ImageLine imageLine) {
            this.channels = imageLine.channels;
            if (imageLine.channels < 3) {
                throw new PngjException("ImageLineStats only works for RGB - RGBA");
            }
            int n2 = 0;
            for (int i2 = 0; i2 < imageLine.imgInfo.cols; ++i2) {
                double d2 = 0.0;
                for (n2 = this.channels - 1; n2 >= 0; --n2) {
                    double d3;
                    double d4 = ImageLineHelper.int2double(imageLine, imageLine.scanline[i2 * this.channels]);
                    if (n2 < 3) {
                        d2 += d4;
                    }
                    int n3 = n2;
                    this.prom[n3] = this.prom[n3] + d4;
                    if (d4 > this.maxv[n2]) {
                        this.maxv[n2] = d4;
                    }
                    if (d4 < this.minv[n2]) {
                        this.minv[n2] = d4;
                    }
                    if (i2 < this.channels || !((d3 = Math.abs(d4 - ImageLineHelper.int2double(imageLine, imageLine.scanline[i2 - this.channels]))) > this.maxdif[n2])) continue;
                    this.maxdif[n2] = d3;
                }
                this.promlum += d2;
                if (d2 > this.maxlum) {
                    this.maxlum = d2;
                }
                if (!(d2 < this.minlum)) continue;
                this.minlum = d2;
            }
            n2 = 0;
            while (n2 < this.channels) {
                int n4 = n2++;
                this.prom[n4] = this.prom[n4] / (double)imageLine.imgInfo.cols;
            }
            this.promlum /= (double)imageLine.imgInfo.cols * 3.0;
            this.maxlum /= 3.0;
            this.minlum /= 3.0;
        }
    }
}

