/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.pngj.chunks;

import jogamp.opengl.util.pngj.ImageInfo;
import jogamp.opengl.util.pngj.PngHelperInternal;
import jogamp.opengl.util.pngj.PngjException;
import jogamp.opengl.util.pngj.chunks.ChunkHelper;
import jogamp.opengl.util.pngj.chunks.ChunkRaw;
import jogamp.opengl.util.pngj.chunks.PngChunk;
import jogamp.opengl.util.pngj.chunks.PngChunkSingle;

public class PngChunkICCP
extends PngChunkSingle {
    public static final String ID = "iCCP";
    private String profileName;
    private byte[] compressedProfile;

    public PngChunkICCP(ImageInfo imageInfo) {
        super(ID, imageInfo);
    }

    @Override
    public PngChunk.ChunkOrderingConstraint getOrderingConstraint() {
        return PngChunk.ChunkOrderingConstraint.BEFORE_PLTE_AND_IDAT;
    }

    @Override
    public ChunkRaw createRawChunk() {
        ChunkRaw chunkRaw = this.createEmptyChunk(this.profileName.length() + this.compressedProfile.length + 2, true);
        System.arraycopy(ChunkHelper.toBytes(this.profileName), 0, chunkRaw.data, 0, this.profileName.length());
        chunkRaw.data[this.profileName.length()] = 0;
        chunkRaw.data[this.profileName.length() + 1] = 0;
        System.arraycopy(this.compressedProfile, 0, chunkRaw.data, this.profileName.length() + 2, this.compressedProfile.length);
        return chunkRaw;
    }

    @Override
    public void parseFromRaw(ChunkRaw chunkRaw) {
        int n2 = ChunkHelper.posNullByte(chunkRaw.data);
        this.profileName = new String(chunkRaw.data, 0, n2, PngHelperInternal.charsetLatin1);
        int n3 = chunkRaw.data[n2 + 1] & 0xFF;
        if (n3 != 0) {
            throw new PngjException("bad compression for ChunkTypeICCP");
        }
        int n4 = chunkRaw.data.length - (n2 + 2);
        this.compressedProfile = new byte[n4];
        System.arraycopy(chunkRaw.data, n2 + 2, this.compressedProfile, 0, n4);
    }

    @Override
    public void cloneDataFromRead(PngChunk pngChunk) {
        PngChunkICCP pngChunkICCP = (PngChunkICCP)pngChunk;
        this.profileName = pngChunkICCP.profileName;
        this.compressedProfile = new byte[pngChunkICCP.compressedProfile.length];
        System.arraycopy(pngChunkICCP.compressedProfile, 0, this.compressedProfile, 0, pngChunkICCP.compressedProfile.length);
    }

    public void setProfileNameAndContent(String string, byte[] byArray) {
        this.profileName = string;
        this.compressedProfile = ChunkHelper.compressBytes(byArray, true);
    }

    public void setProfileNameAndContent(String string, String string2) {
        this.setProfileNameAndContent(string, string2.getBytes(PngHelperInternal.charsetLatin1));
    }

    public String getProfileName() {
        return this.profileName;
    }

    public byte[] getProfile() {
        return ChunkHelper.compressBytes(this.compressedProfile, false);
    }

    public String getProfileAsString() {
        return new String(this.getProfile(), PngHelperInternal.charsetLatin1);
    }
}

