/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.stereo;

import com.jogamp.nativewindow.util.Dimension;
import com.jogamp.nativewindow.util.DimensionImmutable;
import com.jogamp.nativewindow.util.Point;
import com.jogamp.nativewindow.util.PointImmutable;
import com.jogamp.nativewindow.util.Rectangle;
import com.jogamp.nativewindow.util.RectangleImmutable;
import com.jogamp.opengl.math.FovHVHalves;
import com.jogamp.opengl.util.stereo.EyeParameter;
import com.jogamp.opengl.util.stereo.StereoDevice;
import com.jogamp.opengl.util.stereo.StereoDeviceConfig;
import com.jogamp.opengl.util.stereo.StereoDeviceFactory;
import com.jogamp.opengl.util.stereo.StereoDeviceRenderer;
import com.jogamp.opengl.util.stereo.generic.GenericStereoDeviceConfig;
import com.jogamp.opengl.util.stereo.generic.GenericStereoDeviceFactory;
import jogamp.opengl.util.stereo.GenericStereoDeviceRenderer;

public class GenericStereoDevice
implements StereoDevice {
    public static final GenericStereoDeviceConfig config01Mono01;
    public static final GenericStereoDeviceConfig config01Mono02;
    public static final GenericStereoDeviceConfig config02StereoSBS01;
    public static final GenericStereoDeviceConfig config02StereoSBS02;
    public static final GenericStereoDeviceConfig config03StereoSBSLense01;
    public static final GenericStereoDeviceConfig config03StereoSBSLense02;
    private static final GenericStereoDeviceConfig[] configs;
    private final StereoDeviceFactory factory;
    public final int deviceIndex;
    public final GenericStereoDeviceConfig config;
    public final Point surfacePos;
    private final FovHVHalves[] defaultEyeFov;
    private boolean sensorsStarted = false;

    public GenericStereoDevice(StereoDeviceFactory stereoDeviceFactory, int n2, StereoDeviceConfig stereoDeviceConfig) {
        int n3;
        this.factory = stereoDeviceFactory;
        this.deviceIndex = n2;
        this.config = stereoDeviceConfig instanceof GenericStereoDeviceConfig ? (GenericStereoDeviceConfig)stereoDeviceConfig : (null != configs[n3 = Math.min(n2 % 10, configs.length - 1)] ? configs[n3] : config02StereoSBS01);
        this.config.init();
        this.surfacePos = new Point(0, 0);
        this.defaultEyeFov = new FovHVHalves[this.config.defaultEyeParam.length];
        for (n3 = 0; n3 < this.defaultEyeFov.length; ++n3) {
            this.defaultEyeFov[n3] = this.config.defaultEyeParam[n3].fovhv;
        }
    }

    @Override
    public final StereoDeviceFactory getFactory() {
        return this.factory;
    }

    public String toString() {
        return "GenericStereoDevice[" + this.config + ", surfacePos " + this.surfacePos + "]";
    }

    public void setSurfacePosition(int n2, int n3) {
        this.surfacePos.set(n2, n3);
    }

    @Override
    public final void dispose() {
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public final PointImmutable getPosition() {
        return this.surfacePos;
    }

    @Override
    public final DimensionImmutable getSurfaceSize() {
        return this.config.surfaceSizeInPixels;
    }

    @Override
    public int getRequiredRotation() {
        return 0;
    }

    @Override
    public float[] getDefaultEyePositionOffset() {
        return this.config.defaultEyeParam[0].positionOffset;
    }

    @Override
    public final FovHVHalves[] getDefaultFOV() {
        return this.defaultEyeFov;
    }

    @Override
    public final boolean startSensors(boolean bl) {
        if (bl && !this.sensorsStarted) {
            if (this.startSensorsImpl(true)) {
                this.sensorsStarted = true;
                return true;
            }
            this.sensorsStarted = false;
            return false;
        }
        if (this.sensorsStarted) {
            if (this.startSensorsImpl(false)) {
                this.sensorsStarted = false;
                return true;
            }
            this.sensorsStarted = true;
            return false;
        }
        return true;
    }

    private boolean startSensorsImpl(boolean bl) {
        return bl;
    }

    @Override
    public boolean getSensorsStarted() {
        return this.sensorsStarted;
    }

    @Override
    public int[] getEyeRenderOrder() {
        return this.config.eyeRenderOrder;
    }

    @Override
    public int getSupportedDistortionBits() {
        return this.config.supportedDistortionBits;
    }

    @Override
    public int getRecommendedDistortionBits() {
        return this.config.recommendedDistortionBits;
    }

    @Override
    public int getMinimumDistortionBits() {
        return this.config.minimumDistortionBits;
    }

    @Override
    public final StereoDeviceRenderer createRenderer(int n2, int n3, float[] fArray, FovHVHalves[] fovHVHalvesArray, float f2, int n4) {
        DimensionImmutable dimensionImmutable;
        RectangleImmutable[] rectangleImmutableArray;
        int n5;
        EyeParameter[] eyeParameterArray = new EyeParameter[fovHVHalvesArray.length];
        for (n5 = 0; n5 < eyeParameterArray.length; ++n5) {
            rectangleImmutableArray = this.config.defaultEyeParam[n5];
            eyeParameterArray[n5] = new EyeParameter(n5, fArray, fovHVHalvesArray[n5], rectangleImmutableArray.distNoseToPupilX, rectangleImmutableArray.distMiddleToPupilY, rectangleImmutableArray.eyeReliefZ);
        }
        n5 = null != this.config.distortionMeshProducer && 0 != n2 ? 1 : 0;
        rectangleImmutableArray = new RectangleImmutable[eyeParameterArray.length];
        if (1 < eyeParameterArray.length) {
            DimensionImmutable dimensionImmutable2 = this.config.eyeTextureSizes[0];
            DimensionImmutable dimensionImmutable3 = this.config.eyeTextureSizes[1];
            int n6 = Math.max(dimensionImmutable2.getHeight(), dimensionImmutable3.getHeight());
            dimensionImmutable = new Dimension(dimensionImmutable2.getWidth() + dimensionImmutable3.getWidth(), n6);
            if (1 == n3) {
                rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable2.getWidth(), n6);
                rectangleImmutableArray[1] = new Rectangle(dimensionImmutable2.getWidth(), 0, dimensionImmutable3.getWidth(), n6);
            } else if (n5 != 0) {
                rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable2.getWidth(), dimensionImmutable2.getHeight());
                rectangleImmutableArray[1] = new Rectangle(0, 0, dimensionImmutable3.getWidth(), dimensionImmutable3.getHeight());
            } else {
                rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable2.getWidth(), dimensionImmutable2.getHeight());
                rectangleImmutableArray[1] = new Rectangle(dimensionImmutable2.getWidth(), 0, dimensionImmutable3.getWidth(), dimensionImmutable3.getHeight());
            }
        } else {
            DimensionImmutable dimensionImmutable4;
            dimensionImmutable = dimensionImmutable4 = this.config.eyeTextureSizes[0];
            rectangleImmutableArray[0] = new Rectangle(0, 0, dimensionImmutable4.getWidth(), dimensionImmutable4.getHeight());
        }
        return new GenericStereoDeviceRenderer(this, n2, n3, fArray, eyeParameterArray, f2, n4, this.config.eyeTextureSizes, dimensionImmutable, rectangleImmutableArray);
    }

    static {
        float[] fArray = new float[]{0.0f, 1.6f, -5.0f};
        float[] fArray2 = new float[]{0.0f, 0.3f, 3.0f};
        float[] fArray3 = new float[]{0.0f, 0.0f, 3.0f};
        Dimension dimension = new Dimension(1280, 800);
        float[] fArray4 = new float[]{0.14976f, 0.0936f};
        Dimension dimension2 = new Dimension(1122, 1553);
        Dimension dimension3 = new Dimension(1920, 1080);
        float[] fArray5 = new float[]{0.12576f, 0.07074f};
        Dimension dimension4 = new Dimension(1182, 1461);
        config01Mono01 = GenericStereoDeviceFactory.createMono("Def01Mono01", dimension, fArray4, fArray3);
        config02StereoSBS01 = GenericStereoDeviceFactory.createStereoSBS("Def02StereoSBS01", dimension, fArray4, 0.0635f, 45.0f, fArray2);
        config03StereoSBSLense01 = GenericStereoDeviceFactory.createStereoSBSLense("Def03StereoSBSLense01", dimension, fArray4, 0.0635f, 129.0f, dimension2, fArray);
        config01Mono02 = GenericStereoDeviceFactory.createMono("Def01Mono02", dimension3, fArray5, fArray3);
        config02StereoSBS02 = GenericStereoDeviceFactory.createStereoSBS("Def02StereoSBS02", dimension3, fArray5, 0.0635f, 45.0f, fArray2);
        config03StereoSBSLense02 = GenericStereoDeviceFactory.createStereoSBSLense("Def03StereoSBSLense02", dimension3, fArray5, 0.0635f, 129.0f, dimension4, fArray);
        configs = new GenericStereoDeviceConfig[]{config01Mono01, config02StereoSBS01, config03StereoSBSLense01, config01Mono02, config02StereoSBS02, config03StereoSBSLense02};
    }
}

