/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.windows.wgl;

import com.jogamp.nativewindow.AbstractGraphicsScreen;
import com.jogamp.nativewindow.DefaultGraphicsScreen;
import com.jogamp.nativewindow.NativeSurface;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import jogamp.nativewindow.WrappedSurface;
import jogamp.nativewindow.windows.GDI;
import jogamp.opengl.GLContextShareSet;
import jogamp.opengl.windows.wgl.WGL;
import jogamp.opengl.windows.wgl.WGLUtil;
import jogamp.opengl.windows.wgl.WindowsWGLContext;
import jogamp.opengl.windows.wgl.WindowsWGLDrawable;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfiguration;
import jogamp.opengl.windows.wgl.WindowsWGLGraphicsConfigurationFactory;

public class WindowsExternalWGLContext
extends WindowsWGLContext {
    private WindowsExternalWGLContext(Drawable drawable, long l2, WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration) {
        super(drawable, null);
        this.contextHandle = l2;
        if (DEBUG) {
            System.err.println(WindowsExternalWGLContext.getThreadName() + ": Created external OpenGL context " + WindowsExternalWGLContext.toHexString(l2) + " for " + this);
        }
        GLContextShareSet.contextCreated(this);
        if (!this.setGLFunctionAvailability(false, 0, 0, 2, false, false)) {
            throw new InternalError("setGLFunctionAvailability !strictMatch failed");
        }
        this.getGLStateTracker().setEnabled(false);
    }

    protected static WindowsExternalWGLContext create(GLDrawableFactory gLDrawableFactory, GLProfile gLProfile) {
        WindowsWGLGraphicsConfiguration windowsWGLGraphicsConfiguration;
        long l2;
        if (DEBUG) {
            System.err.println("WindowsExternalWGLContext 0: werr: " + GDI.GetLastError());
        }
        if (0L == (l2 = WGL.wglGetCurrentContext())) {
            throw new GLException("Error: attempted to make an external GLContext without a context current, werr " + GDI.GetLastError());
        }
        long l3 = WGL.wglGetCurrentDC();
        if (0L == l3) {
            throw new GLException("Error: attempted to make an external GLDrawable without a drawable current, werr " + GDI.GetLastError());
        }
        AbstractGraphicsScreen abstractGraphicsScreen = DefaultGraphicsScreen.createDefault(NativeWindowFactory.TYPE_WINDOWS);
        int n2 = WGLUtil.GetPixelFormat(l3);
        if (0 == n2) {
            int n3 = GDI.GetLastError();
            windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfigurationFactory.createDefaultGraphicsConfiguration(new GLCapabilities(GLProfile.getDefault()), abstractGraphicsScreen);
            windowsWGLGraphicsConfiguration.markExternal();
            if (DEBUG) {
                System.err.println("WindowsExternalWGLContext invalid hdc/pfd werr " + n3 + ", using default cfg: " + windowsWGLGraphicsConfiguration);
            }
        } else {
            windowsWGLGraphicsConfiguration = WindowsWGLGraphicsConfiguration.createFromExternal(gLDrawableFactory, l3, n2, gLProfile, abstractGraphicsScreen, true);
            if (DEBUG) {
                System.err.println("WindowsExternalWGLContext valid hdc/pfd, retrieved cfg: " + windowsWGLGraphicsConfiguration);
            }
        }
        return new WindowsExternalWGLContext(new Drawable(gLDrawableFactory, new WrappedSurface(windowsWGLGraphicsConfiguration, l3, 64, 64, true)), l2, windowsWGLGraphicsConfiguration);
    }

    @Override
    protected void makeCurrentImpl() throws GLException {
    }

    @Override
    protected void releaseImpl() throws GLException {
    }

    @Override
    protected void destroyImpl() throws GLException {
    }

    static class Drawable
    extends WindowsWGLDrawable {
        Drawable(GLDrawableFactory gLDrawableFactory, NativeSurface nativeSurface) {
            super(gLDrawableFactory, nativeSurface, true);
        }

        @Override
        public GLContext createContext(GLContext gLContext) {
            throw new GLException("Should not call this");
        }

        @Override
        public int getSurfaceWidth() {
            throw new GLException("Should not call this");
        }

        @Override
        public int getSurfaceHeight() {
            throw new GLException("Should not call this");
        }

        public void setSize(int n2, int n3) {
            throw new GLException("Should not call this");
        }
    }
}

