/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.x11.glx;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.nio.PointerBuffer;
import com.jogamp.nativewindow.CapabilitiesImmutable;
import com.jogamp.nativewindow.GraphicsConfigurationFactory;
import com.jogamp.nativewindow.VisualIDHolder;
import com.jogamp.nativewindow.x11.X11GraphicsConfiguration;
import com.jogamp.nativewindow.x11.X11GraphicsDevice;
import com.jogamp.nativewindow.x11.X11GraphicsScreen;
import com.jogamp.opengl.DefaultGLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesChooser;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLDrawableFactory;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLProfile;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import jogamp.nativewindow.x11.X11Lib;
import jogamp.nativewindow.x11.XRenderDirectFormat;
import jogamp.nativewindow.x11.XRenderPictFormat;
import jogamp.nativewindow.x11.XVisualInfo;
import jogamp.opengl.GLGraphicsConfigurationUtil;
import jogamp.opengl.x11.glx.GLX;
import jogamp.opengl.x11.glx.X11GLCapabilities;
import jogamp.opengl.x11.glx.X11GLXDrawableFactory;

public class X11GLXGraphicsConfiguration
extends X11GraphicsConfiguration
implements Cloneable {
    public static final int MAX_ATTRIBS = 128;
    private final GLCapabilitiesChooser chooser;

    X11GLXGraphicsConfiguration(X11GraphicsScreen x11GraphicsScreen, X11GLCapabilities x11GLCapabilities, GLCapabilitiesImmutable gLCapabilitiesImmutable, GLCapabilitiesChooser gLCapabilitiesChooser) {
        super(x11GraphicsScreen, x11GLCapabilities, gLCapabilitiesImmutable, x11GLCapabilities.getXVisualInfo());
        this.chooser = gLCapabilitiesChooser;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    public final long getFBConfig() {
        return ((X11GLCapabilities)this.capabilitiesChosen).getFBConfig();
    }

    public final int getFBConfigID() {
        return ((X11GLCapabilities)this.capabilitiesChosen).getFBConfigID();
    }

    public final boolean hasFBConfig() {
        return ((X11GLCapabilities)this.capabilitiesChosen).hasFBConfig();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void updateGraphicsConfiguration() {
        CapabilitiesImmutable capabilitiesImmutable = this.getChosenCapabilities();
        if (!(capabilitiesImmutable instanceof X11GLCapabilities) || 0 == capabilitiesImmutable.getVisualID(VisualIDHolder.VIDType.X11_XVISUAL)) {
            X11GLXGraphicsConfiguration x11GLXGraphicsConfiguration = (X11GLXGraphicsConfiguration)GraphicsConfigurationFactory.getFactory(this.getScreen().getDevice(), capabilitiesImmutable).chooseGraphicsConfiguration(capabilitiesImmutable, this.getRequestedCapabilities(), this.chooser, this.getScreen(), 0);
            if (null == x11GLXGraphicsConfiguration) throw new GLException("No native VisualID pre-chosen and update failed: " + this);
            this.setXVisualInfo(x11GLXGraphicsConfiguration.getXVisualInfo());
            this.setChosenCapabilities(x11GLXGraphicsConfiguration.getChosenCapabilities());
            if (!DEBUG) return;
            System.err.println("X11GLXGraphicsConfiguration.updateGraphicsConfiguration updated:" + this);
            return;
        } else {
            if (!DEBUG) return;
            System.err.println("X11GLXGraphicsConfiguration.updateGraphicsConfiguration kept:" + this);
        }
    }

    static X11GLXGraphicsConfiguration create(GLProfile gLProfile, X11GraphicsScreen x11GraphicsScreen, int n2) {
        X11GLXDrawableFactory x11GLXDrawableFactory;
        X11GLCapabilities x11GLCapabilities;
        X11GraphicsDevice x11GraphicsDevice = (X11GraphicsDevice)x11GraphicsScreen.getDevice();
        long l2 = x11GraphicsDevice.getHandle();
        if (0L == l2) {
            throw new GLException("Display null of " + x11GraphicsScreen);
        }
        int n3 = x11GraphicsScreen.getIndex();
        long l3 = X11GLXGraphicsConfiguration.glXFBConfigID2FBConfig(l2, n3, n2);
        if (0L == l3) {
            throw new GLException("FBConfig null of " + X11GLXGraphicsConfiguration.toHexString(n2));
        }
        if (null == gLProfile) {
            gLProfile = GLProfile.getDefault(x11GraphicsScreen.getDevice());
        }
        if (null == (x11GLCapabilities = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(x11GraphicsDevice, gLProfile, l3, 15, (x11GLXDrawableFactory = (X11GLXDrawableFactory)GLDrawableFactory.getDesktopFactory()).isGLXMultisampleAvailable(x11GraphicsDevice)))) {
            throw new GLException("GLCapabilities null of " + X11GLXGraphicsConfiguration.toHexString(l3));
        }
        return new X11GLXGraphicsConfiguration(x11GraphicsScreen, x11GLCapabilities, x11GLCapabilities, new DefaultGLCapabilitiesChooser());
    }

    static IntBuffer GLCapabilities2AttribList(GLCapabilitiesImmutable gLCapabilitiesImmutable, boolean bl, boolean bl2, long l2, int n2) {
        int n3 = gLCapabilitiesImmutable.getRedBits() + gLCapabilitiesImmutable.getGreenBits() + gLCapabilitiesImmutable.getBlueBits();
        if (n3 < 15) {
            throw new GLException("Bit depths < 15 (i.e., non-true-color) not supported");
        }
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(128);
        int n4 = 0;
        if (bl) {
            int n5;
            intBuffer.put(n4++, 32784);
            if (gLCapabilitiesImmutable.isOnscreen()) {
                n5 = 1;
            } else if (gLCapabilitiesImmutable.isFBO()) {
                n5 = 1;
            } else if (gLCapabilitiesImmutable.isPBuffer()) {
                n5 = 4;
            } else if (gLCapabilitiesImmutable.isBitmap()) {
                n5 = 2;
            } else {
                throw new GLException("no surface type set in caps: " + gLCapabilitiesImmutable);
            }
            intBuffer.put(n4++, n5);
            intBuffer.put(n4++, 32785);
            intBuffer.put(n4++, 1);
        } else {
            intBuffer.put(n4++, 4);
        }
        if (bl) {
            intBuffer.put(n4++, 5);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getDoubleBuffered() ? 1 : 0);
            intBuffer.put(n4++, 6);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getStereo() ? 1 : 0);
            intBuffer.put(n4++, 35);
            intBuffer.put(n4++, 32768);
        } else {
            if (gLCapabilitiesImmutable.getDoubleBuffered()) {
                intBuffer.put(n4++, 5);
            }
            if (gLCapabilitiesImmutable.getStereo()) {
                intBuffer.put(n4++, 6);
            }
        }
        intBuffer.put(n4++, 8);
        intBuffer.put(n4++, gLCapabilitiesImmutable.getRedBits());
        intBuffer.put(n4++, 9);
        intBuffer.put(n4++, gLCapabilitiesImmutable.getGreenBits());
        intBuffer.put(n4++, 10);
        intBuffer.put(n4++, gLCapabilitiesImmutable.getBlueBits());
        if (gLCapabilitiesImmutable.getAlphaBits() > 0) {
            intBuffer.put(n4++, 11);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getAlphaBits());
        }
        if (gLCapabilitiesImmutable.getStencilBits() > 0) {
            intBuffer.put(n4++, 13);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getStencilBits());
        }
        intBuffer.put(n4++, 12);
        intBuffer.put(n4++, gLCapabilitiesImmutable.getDepthBits());
        if (gLCapabilitiesImmutable.getAccumRedBits() > 0 || gLCapabilitiesImmutable.getAccumGreenBits() > 0 || gLCapabilitiesImmutable.getAccumBlueBits() > 0 || gLCapabilitiesImmutable.getAccumAlphaBits() > 0) {
            intBuffer.put(n4++, 14);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getAccumRedBits());
            intBuffer.put(n4++, 15);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getAccumGreenBits());
            intBuffer.put(n4++, 16);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getAccumBlueBits());
            intBuffer.put(n4++, 17);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getAccumAlphaBits());
        }
        if (bl2 && gLCapabilitiesImmutable.getSampleBuffers()) {
            intBuffer.put(n4++, 100000);
            intBuffer.put(n4++, 1);
            intBuffer.put(n4++, 100001);
            intBuffer.put(n4++, gLCapabilitiesImmutable.getNumSamples());
        }
        intBuffer.put(n4++, 0);
        return intBuffer;
    }

    static boolean GLXFBConfigIDValid(long l2, int n2, int n3) {
        long l3 = X11GLXGraphicsConfiguration.glXFBConfigID2FBConfig(l2, n2, n3);
        return 0L != l3 ? X11GLXGraphicsConfiguration.GLXFBConfigValid(l2, l3) : false;
    }

    static boolean GLXFBConfigValid(long l2, long l3) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        return 2 != GLX.glXGetFBConfigAttrib(l2, l3, 32785, intBuffer);
    }

    static int FBCfgDrawableTypeBits(X11GraphicsDevice x11GraphicsDevice, long l2) {
        int n2 = 0;
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        if (!X11GLXGraphicsConfiguration.glXGetFBConfig(x11GraphicsDevice.getHandle(), l2, 32784, intBuffer)) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.FBCfgDrawableTypeBits: FBConfig invalid: fbcfg: " + X11GLXGraphicsConfiguration.toHexString(l2));
            }
            return 0;
        }
        int n3 = intBuffer.get(0);
        if (0 != (n3 & 1)) {
            n2 |= 9;
        }
        if (0 != (n3 & 2)) {
            n2 |= 2;
        }
        if (0 != (n3 & 4)) {
            n2 |= 4;
        }
        return n2;
    }

    static XRenderDirectFormat XVisual2XRenderMask(long l2, long l3) {
        XRenderPictFormat xRenderPictFormat = X11Lib.XRenderFindVisualFormat(l2, l3);
        if (null == xRenderPictFormat) {
            return null;
        }
        return xRenderPictFormat.getDirect();
    }

    static XRenderDirectFormat XVisual2XRenderMask(long l2, long l3, XRenderPictFormat xRenderPictFormat) {
        if (!X11Lib.XRenderFindVisualFormat(l2, l3, xRenderPictFormat)) {
            return null;
        }
        return xRenderPictFormat.getDirect();
    }

    static X11GLCapabilities GLXFBConfig2GLCapabilities(X11GraphicsDevice x11GraphicsDevice, GLProfile gLProfile, long l2, int n2, boolean bl) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        XRenderPictFormat xRenderPictFormat = XRenderPictFormat.create();
        return X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(x11GraphicsDevice, gLProfile, l2, n2, bl, intBuffer, xRenderPictFormat);
    }

    static List<GLCapabilitiesImmutable> GLXFBConfig2GLCapabilities(X11GraphicsDevice x11GraphicsDevice, GLProfile gLProfile, PointerBuffer pointerBuffer, int n2, boolean bl, boolean bl2) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        XRenderPictFormat xRenderPictFormat = XRenderPictFormat.create();
        ArrayList<GLCapabilitiesImmutable> arrayList = new ArrayList<GLCapabilitiesImmutable>();
        for (int i2 = 0; i2 < pointerBuffer.limit(); ++i2) {
            long l2 = pointerBuffer.get(i2);
            X11GLCapabilities x11GLCapabilities = X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities(x11GraphicsDevice, gLProfile, l2, n2, bl, intBuffer, xRenderPictFormat);
            if (null == x11GLCapabilities) continue;
            arrayList.add(x11GLCapabilities);
            if (bl2) break;
        }
        return arrayList;
    }

    static X11GLCapabilities GLXFBConfig2GLCapabilities(X11GraphicsDevice x11GraphicsDevice, GLProfile gLProfile, long l2, int n2, boolean bl, IntBuffer intBuffer, XRenderPictFormat xRenderPictFormat) {
        long l3 = x11GraphicsDevice.getHandle();
        int n3 = X11GLXGraphicsConfiguration.FBCfgDrawableTypeBits(x11GraphicsDevice, l2);
        int n4 = n2 & n3;
        if (0 == n3 || 0 == n4) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities: zero drawablebits: allDrawableTypeBits: " + X11GLXGraphicsConfiguration.toHexString(n3) + ", drawableTypeBits " + X11GLXGraphicsConfiguration.toHexString(n4));
            }
            return null;
        }
        int n5 = X11GLXGraphicsConfiguration.glXFBConfig2FBConfigID(l3, l2);
        if (0 == n5) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities: FBConfig invalid (0): fbcfg: " + X11GLXGraphicsConfiguration.toHexString(l2));
            }
            return null;
        }
        XVisualInfo xVisualInfo = GLX.glXGetVisualFromFBConfig(l3, l2);
        if (null == xVisualInfo) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities: Null XVisualInfo for FBConfigID 0x" + Integer.toHexString(n5));
            }
            n4 &= 0xFFFFFFF6;
        }
        if (0 == n4) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities: zero drawablebits: winattrmask: " + X11GLXGraphicsConfiguration.toHexString(n2) + ", offscreen " + (null == xVisualInfo));
            }
            return null;
        }
        if (2 == GLX.glXGetFBConfigAttrib(l3, l2, 32785, intBuffer)) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities: FBConfig invalid (1): fbcfg: " + X11GLXGraphicsConfiguration.toHexString(l2));
            }
            return null;
        }
        if (0 == (1 & intBuffer.get(0))) {
            if (DEBUG) {
                System.err.println("X11GLXGraphicsConfiguration.GLXFBConfig2GLCapabilities: FBConfig not RGBA (2): fbcfg: " + X11GLXGraphicsConfiguration.toHexString(l2));
            }
            return null;
        }
        X11GLCapabilities x11GLCapabilities = new X11GLCapabilities(xVisualInfo, l2, n5, gLProfile);
        XRenderDirectFormat xRenderDirectFormat = null != xVisualInfo ? X11GLXGraphicsConfiguration.XVisual2XRenderMask(l3, xVisualInfo.getVisual(), xRenderPictFormat) : null;
        int[] nArray = new int[]{100000, 100001, 5, 6, 32, 8, 9, 10, 11, 14, 15, 16, 17, 12, 13};
        int n6 = bl ? 0 : 2;
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(nArray);
        intBuffer2.position(n6);
        IntBuffer intBuffer3 = Buffers.newDirectIntBuffer(intBuffer2.remaining());
        int n7 = GLX.glXGetFBConfigAttributes(l3, l2, intBuffer2, intBuffer3);
        if (0 != n7) {
            throw new GLException("glXGetFBConfig(" + X11GLXGraphicsConfiguration.toHexString(intBuffer2.get(n6 + intBuffer3.get(0))) + ") failed: error code " + X11GLXGraphicsConfiguration.glXGetFBConfigErrorCode(n7));
        }
        int n8 = 0;
        if (bl) {
            x11GLCapabilities.setSampleBuffers(intBuffer3.get(n8++) != 0);
            x11GLCapabilities.setNumSamples(intBuffer3.get(n8++));
        }
        short s = null != xRenderDirectFormat ? xRenderDirectFormat.getAlphaMask() : (short)0;
        x11GLCapabilities.setBackgroundOpaque(0 >= s);
        if (!x11GLCapabilities.isBackgroundOpaque()) {
            x11GLCapabilities.setTransparentRedValue(xRenderDirectFormat.getRedMask());
            x11GLCapabilities.setTransparentGreenValue(xRenderDirectFormat.getGreenMask());
            x11GLCapabilities.setTransparentBlueValue(xRenderDirectFormat.getBlueMask());
            x11GLCapabilities.setTransparentAlphaValue(s);
        }
        x11GLCapabilities.setDoubleBuffered(intBuffer3.get(n8++) != 0);
        x11GLCapabilities.setStereo(intBuffer3.get(n8++) != 0);
        x11GLCapabilities.setHardwareAccelerated(intBuffer3.get(n8++) != 32769);
        x11GLCapabilities.setRedBits(intBuffer3.get(n8++));
        x11GLCapabilities.setGreenBits(intBuffer3.get(n8++));
        x11GLCapabilities.setBlueBits(intBuffer3.get(n8++));
        x11GLCapabilities.setAlphaBits(intBuffer3.get(n8++));
        x11GLCapabilities.setAccumRedBits(intBuffer3.get(n8++));
        x11GLCapabilities.setAccumGreenBits(intBuffer3.get(n8++));
        x11GLCapabilities.setAccumBlueBits(intBuffer3.get(n8++));
        x11GLCapabilities.setAccumAlphaBits(intBuffer3.get(n8++));
        x11GLCapabilities.setDepthBits(intBuffer3.get(n8++));
        x11GLCapabilities.setStencilBits(intBuffer3.get(n8++));
        return (X11GLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(x11GraphicsDevice, n4, x11GLCapabilities);
    }

    private static String glXGetFBConfigErrorCode(int n2) {
        switch (n2) {
            case 3: {
                return "GLX_NO_EXTENSION";
            }
            case 2: {
                return "GLX_BAD_ATTRIBUTE";
            }
        }
        return "Unknown error code " + n2;
    }

    static boolean glXGetFBConfig(long l2, long l3, int n2, IntBuffer intBuffer) {
        boolean bl;
        if (l2 == 0L) {
            throw new GLException("No display connection");
        }
        boolean bl2 = bl = 2 != GLX.glXGetFBConfigAttrib(l2, l3, n2, intBuffer);
        if (!bl && DEBUG) {
            System.err.println("X11GLXGraphicsConfiguration.glXGetFBConfig: FBConfig invalid: fbcfg: " + X11GLXGraphicsConfiguration.toHexString(l3));
        }
        return bl;
    }

    static int glXFBConfig2FBConfigID(long l2, long l3) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(1);
        if (X11GLXGraphicsConfiguration.glXGetFBConfig(l2, l3, 32787, intBuffer)) {
            return intBuffer.get(0);
        }
        return 0;
    }

    static long glXFBConfigID2FBConfig(long l2, int n2, int n3) {
        IntBuffer intBuffer = Buffers.newDirectIntBuffer(new int[]{32787, n3, 0});
        IntBuffer intBuffer2 = Buffers.newDirectIntBuffer(1);
        intBuffer2.put(0, -1);
        PointerBuffer pointerBuffer = GLX.glXChooseFBConfig(l2, n2, intBuffer, intBuffer2);
        if (pointerBuffer == null || pointerBuffer.limit() < 1) {
            return 0L;
        }
        return pointerBuffer.get(0);
    }

    static XVisualInfo XVisualID2XVisualInfo(long l2, long l3) {
        int[] nArray = new int[1];
        XVisualInfo xVisualInfo = XVisualInfo.create();
        xVisualInfo.setVisualid(l3);
        XVisualInfo[] xVisualInfoArray = X11Lib.XGetVisualInfo(l2, 1L, xVisualInfo, nArray, 0);
        if (xVisualInfoArray == null || xVisualInfoArray.length == 0) {
            return null;
        }
        XVisualInfo xVisualInfo2 = XVisualInfo.create(xVisualInfoArray[0]);
        if (DEBUG) {
            System.err.println("Fetched XVisualInfo for visual ID " + X11GLXGraphicsConfiguration.toHexString(l3));
            System.err.println("Resulting XVisualInfo: visualid = " + X11GLXGraphicsConfiguration.toHexString(xVisualInfo2.getVisualid()));
        }
        return xVisualInfo2;
    }

    static X11GLCapabilities XVisualInfo2GLCapabilities(X11GraphicsDevice x11GraphicsDevice, GLProfile gLProfile, XVisualInfo xVisualInfo, int n2, boolean bl) {
        IntBuffer intBuffer;
        int n3 = n2 & 0xB;
        if (0 == n3) {
            return null;
        }
        long l2 = x11GraphicsDevice.getHandle();
        int n4 = X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 1, intBuffer = Buffers.newDirectIntBuffer(1));
        if (n4 == 0) {
            if (DEBUG) {
                System.err.println("Visual (" + X11GLXGraphicsConfiguration.toHexString(xVisualInfo.getVisualid()) + ") does not support OpenGL");
            }
            return null;
        }
        n4 = X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 4, intBuffer);
        if (n4 == 0) {
            if (DEBUG) {
                System.err.println("Visual (" + X11GLXGraphicsConfiguration.toHexString(xVisualInfo.getVisualid()) + ") does not support RGBA");
            }
            return null;
        }
        X11GLCapabilities x11GLCapabilities = new X11GLCapabilities(xVisualInfo, gLProfile);
        x11GLCapabilities.setDoubleBuffered(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 5, intBuffer) != 0);
        x11GLCapabilities.setStereo(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 6, intBuffer) != 0);
        if (bl) {
            x11GLCapabilities.setSampleBuffers(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 100000, intBuffer) != 0);
            x11GLCapabilities.setNumSamples(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 100001, intBuffer));
        }
        XRenderDirectFormat xRenderDirectFormat = null != xVisualInfo ? X11GLXGraphicsConfiguration.XVisual2XRenderMask(l2, xVisualInfo.getVisual()) : null;
        short s = null != xRenderDirectFormat ? xRenderDirectFormat.getAlphaMask() : (short)0;
        x11GLCapabilities.setBackgroundOpaque(0 >= s);
        if (!x11GLCapabilities.isBackgroundOpaque()) {
            x11GLCapabilities.setTransparentRedValue(xRenderDirectFormat.getRedMask());
            x11GLCapabilities.setTransparentGreenValue(xRenderDirectFormat.getGreenMask());
            x11GLCapabilities.setTransparentBlueValue(xRenderDirectFormat.getBlueMask());
            x11GLCapabilities.setTransparentAlphaValue(s);
        }
        x11GLCapabilities.setHardwareAccelerated(true);
        x11GLCapabilities.setDepthBits(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 12, intBuffer));
        x11GLCapabilities.setStencilBits(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 13, intBuffer));
        x11GLCapabilities.setRedBits(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 8, intBuffer));
        x11GLCapabilities.setGreenBits(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 9, intBuffer));
        x11GLCapabilities.setBlueBits(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 10, intBuffer));
        x11GLCapabilities.setAlphaBits(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 11, intBuffer));
        x11GLCapabilities.setAccumRedBits(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 14, intBuffer));
        x11GLCapabilities.setAccumGreenBits(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 15, intBuffer));
        x11GLCapabilities.setAccumBlueBits(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 16, intBuffer));
        x11GLCapabilities.setAccumAlphaBits(X11GLXGraphicsConfiguration.glXGetConfig(l2, xVisualInfo, 17, intBuffer));
        return (X11GLCapabilities)GLGraphicsConfigurationUtil.fixWinAttribBitsAndHwAccel(x11GraphicsDevice, n3, x11GLCapabilities);
    }

    private static String glXGetConfigErrorCode(int n2) {
        switch (n2) {
            case 3: {
                return "GLX_NO_EXTENSION";
            }
            case 1: {
                return "GLX_BAD_SCREEN";
            }
            case 2: {
                return "GLX_BAD_ATTRIBUTE";
            }
            case 4: {
                return "GLX_BAD_VISUAL";
            }
        }
        return "Unknown error code " + n2;
    }

    static int glXGetConfig(long l2, XVisualInfo xVisualInfo, int n2, IntBuffer intBuffer) {
        if (l2 == 0L) {
            throw new GLException("No display connection");
        }
        int n3 = GLX.glXGetConfig(l2, xVisualInfo, n2, intBuffer);
        if (n3 != 0) {
            throw new GLException("glXGetConfig(" + X11GLXGraphicsConfiguration.toHexString(n2) + ") failed: error code " + X11GLXGraphicsConfiguration.glXGetConfigErrorCode(n3));
        }
        return intBuffer.get(intBuffer.position());
    }

    @Override
    public String toString() {
        return "X11GLXGraphicsConfiguration[" + this.getScreen() + ", visualID " + X11GLXGraphicsConfiguration.toHexString(this.getXVisualID()) + ", fbConfigID " + X11GLXGraphicsConfiguration.toHexString(this.getFBConfigID()) + ",\n\trequested " + this.getRequestedCapabilities() + ",\n\tchosen    " + this.getChosenCapabilities() + "]";
    }
}

