/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.layout;

import java.awt.Container;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jdesktop.layout.AquaLayoutStyle;
import org.jdesktop.layout.GnomeLayoutStyle;
import org.jdesktop.layout.MetalLayoutStyle;
import org.jdesktop.layout.SwingLayoutStyle;
import org.jdesktop.layout.WindowsLayoutStyle;

public class LayoutStyle {
    private static final boolean USE_CORE_LAYOUT_STYLE;
    public static final int RELATED = 0;
    public static final int UNRELATED = 1;
    public static final int INDENT = 3;
    private static LayoutStyle layoutStyle;
    private static LookAndFeel laf;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void setSharedInstance(LayoutStyle layoutStyle) {
        UIManager.getLookAndFeelDefaults().put("LayoutStyle.instance", layoutStyle);
    }

    public static LayoutStyle getSharedInstance() {
        Object object = UIManager.get("LayoutStyle.instance");
        if (object != null && object instanceof LayoutStyle) {
            return (LayoutStyle)object;
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (layoutStyle == null || lookAndFeel != laf) {
            laf = lookAndFeel;
            String string = laf.getID();
            layoutStyle = USE_CORE_LAYOUT_STYLE ? new SwingLayoutStyle() : ("Metal" == string ? new MetalLayoutStyle() : ("Windows" == string ? new WindowsLayoutStyle() : ("GTK" == string ? new GnomeLayoutStyle() : ("Aqua" == string ? new AquaLayoutStyle() : new LayoutStyle()))));
        }
        return layoutStyle;
    }

    public int getPreferredGap(JComponent jComponent, JComponent jComponent2, int n2, int n3, Container container) {
        if (n3 != 1 && n3 != 5 && n3 != 7 && n3 != 3) {
            throw new IllegalArgumentException("Invalid position");
        }
        if (jComponent == null || jComponent2 == null) {
            throw new IllegalArgumentException("Components must be non-null");
        }
        if (n2 == 0) {
            return 6;
        }
        if (n2 == 1) {
            return 12;
        }
        if (n2 == 3) {
            if (n3 == 3 || n3 == 7) {
                int n4 = this.getButtonChildIndent(jComponent, n3);
                if (n4 != 0) {
                    return n4;
                }
                return 6;
            }
            return 6;
        }
        throw new IllegalArgumentException("Invalid type");
    }

    public int getContainerGap(JComponent jComponent, int n2, Container container) {
        if (n2 != 1 && n2 != 5 && n2 != 7 && n2 != 3) {
            throw new IllegalArgumentException("Invalid position");
        }
        if (jComponent == null) {
            throw new IllegalArgumentException("Component must be non-null");
        }
        return 12;
    }

    boolean isDialog(JComponent jComponent) {
        String string = jComponent.getName();
        return string != null && string.endsWith(".contentPane");
    }

    int getCBRBPadding(JComponent jComponent, JComponent jComponent2, int n2, int n3) {
        if ((n3 -= this.getCBRBPadding(jComponent, n2)) > 0) {
            n3 -= this.getCBRBPadding(jComponent2, this.flipDirection(n2));
        }
        if (n3 < 0) {
            return 0;
        }
        return n3;
    }

    int getCBRBPadding(JComponent jComponent, int n2, int n3) {
        return Math.max(n3 -= this.getCBRBPadding(jComponent, n2), 0);
    }

    int flipDirection(int n2) {
        switch (n2) {
            case 1: {
                return 5;
            }
            case 5: {
                return 1;
            }
            case 3: {
                return 7;
            }
            case 7: {
                return 3;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    private int getCBRBPadding(JComponent jComponent, int n2) {
        Border border;
        if ((jComponent.getUIClassID() == "CheckBoxUI" || jComponent.getUIClassID() == "RadioButtonUI") && (border = jComponent.getBorder()) instanceof UIResource) {
            return this.getInset(jComponent, n2);
        }
        return 0;
    }

    private int getInset(JComponent jComponent, int n2) {
        Insets insets = jComponent.getInsets();
        switch (n2) {
            case 1: {
                return insets.top;
            }
            case 5: {
                return insets.bottom;
            }
            case 3: {
                return insets.right;
            }
            case 7: {
                return insets.left;
            }
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return 0;
    }

    private boolean isLeftAligned(AbstractButton abstractButton, int n2) {
        if (n2 == 7) {
            boolean bl = abstractButton.getComponentOrientation().isLeftToRight();
            int n3 = abstractButton.getHorizontalAlignment();
            return bl && (n3 == 2 || n3 == 10) || !bl && n3 == 11;
        }
        return false;
    }

    private boolean isRightAligned(AbstractButton abstractButton, int n2) {
        if (n2 == 3) {
            boolean bl = abstractButton.getComponentOrientation().isLeftToRight();
            int n3 = abstractButton.getHorizontalAlignment();
            return bl && (n3 == 4 || n3 == 11) || !bl && n3 == 10;
        }
        return false;
    }

    private Icon getIcon(AbstractButton abstractButton) {
        Object object;
        Icon icon = abstractButton.getIcon();
        if (icon != null) {
            return icon;
        }
        String string = null;
        if (abstractButton instanceof JCheckBox) {
            string = "CheckBox.icon";
        } else if (abstractButton instanceof JRadioButton) {
            string = "RadioButton.icon";
        }
        if (string != null && (object = UIManager.get(string)) instanceof Icon) {
            return (Icon)object;
        }
        return null;
    }

    int getButtonChildIndent(JComponent jComponent, int n2) {
        if (jComponent instanceof JRadioButton || jComponent instanceof JCheckBox) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            Insets insets = jComponent.getInsets();
            Icon icon = this.getIcon(abstractButton);
            int n3 = abstractButton.getIconTextGap();
            if (this.isLeftAligned(abstractButton, n2)) {
                return insets.left + icon.getIconWidth() + n3;
            }
            if (this.isRightAligned(abstractButton, n2)) {
                return insets.right + icon.getIconWidth() + n3;
            }
        }
        return 0;
    }

    static {
        $assertionsDisabled = !LayoutStyle.class.desiredAssertionStatus();
        boolean bl = false;
        try {
            Class.forName("javax.swing.LayoutStyle");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        USE_CORE_LAYOUT_STYLE = bl;
    }
}

