/*
 * Decompiled with CFR 0.152.
 */
package Hack.Gates;

import Hack.Gates.Gate;
import Hack.Gates.GateClass;
import Hack.Gates.Node;

public class CompositeGate
extends Gate {
    protected Node[] internalPins;
    protected Gate[] parts;

    protected void clockUp() {
        if (this.gateClass.isClocked) {
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i].tick();
            }
        }
    }

    protected void clockDown() {
        if (this.gateClass.isClocked) {
            for (int i = 0; i < this.parts.length; ++i) {
                this.parts[i].tock();
            }
        }
    }

    protected void reCompute() {
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].eval();
        }
    }

    public Node getNode(String string) {
        Node node = super.getNode(string);
        if (node == null) {
            byte by = this.gateClass.getPinType(string);
            int n = this.gateClass.getPinNumber(string);
            if (by == 3) {
                node = this.internalPins[n];
            }
        }
        return node;
    }

    public Node[] getInternalNodes() {
        return this.internalPins;
    }

    public Gate[] getParts() {
        return this.parts;
    }

    public void init(Node[] nodeArray, Node[] nodeArray2, Node[] nodeArray3, Gate[] gateArray, GateClass gateClass) {
        this.inputPins = nodeArray;
        this.outputPins = nodeArray2;
        this.internalPins = nodeArray3;
        this.parts = gateArray;
        this.gateClass = gateClass;
        this.setDirty();
    }
}

