/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import HackGUI.FileChooserComponent;
import HackGUI.FilesTypeEvent;
import HackGUI.FilesTypeListener;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;

public class ChipLoaderFileChooser
extends JFrame {
    private FileChooserComponent workingDir = new FileChooserComponent();
    private FileChooserComponent builtInDir = new FileChooserComponent();
    private ImageIcon okIcon = new ImageIcon("bin/images/ok.gif");
    private ImageIcon cancelIcon = new ImageIcon("bin/images/cancel.gif");
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    private Vector listeners = new Vector();

    public ChipLoaderFileChooser() {
        super("Directories Selection");
        this.setSelectionToDirectory();
        this.setNames();
        this.jbInit();
    }

    public void showWindow() {
        this.setVisible(true);
        this.workingDir.getTextField().requestFocus();
    }

    public void addListener(FilesTypeListener filesTypeListener) {
        this.listeners.addElement(filesTypeListener);
    }

    public void removeListener(FilesTypeListener filesTypeListener) {
        this.listeners.removeElement(filesTypeListener);
    }

    public void notifyListeners(String string, String string2) {
        FilesTypeEvent filesTypeEvent = new FilesTypeEvent((Object)this, string, string2, null);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((FilesTypeListener)this.listeners.elementAt(i)).filesNamesChanged(filesTypeEvent);
        }
    }

    public void setWorkingDir(File file) {
        this.workingDir.setCurrentFileName(file.getName());
        this.workingDir.showCurrentFileName();
    }

    public void setBuiltInDir(File file) {
        this.builtInDir.setCurrentFileName(file.getName());
        this.builtInDir.showCurrentFileName();
    }

    private void setSelectionToDirectory() {
        this.workingDir.setSelectionToDirectories();
        this.builtInDir.setSelectionToDirectories();
    }

    private void setNames() {
        this.workingDir.setName("Working Dir :");
        this.builtInDir.setName("BuiltIn Dir :");
    }

    private void jbInit() {
        this.getContentPane().setLayout(null);
        this.workingDir.setBounds(new Rectangle(5, 2, 485, 48));
        this.builtInDir.setBounds(new Rectangle(5, 38, 485, 48));
        this.okButton.setToolTipText("OK");
        this.okButton.setIcon(this.okIcon);
        this.okButton.setBounds(new Rectangle(90, 95, 63, 44));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChipLoaderFileChooser.this.okButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.setBounds(new Rectangle(265, 95, 63, 44));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChipLoaderFileChooser.this.cancelButton_actionPerformed(actionEvent);
            }
        });
        this.cancelButton.setToolTipText("CANCEL");
        this.cancelButton.setIcon(this.cancelIcon);
        this.getContentPane().add((Component)this.workingDir, null);
        this.getContentPane().add((Component)this.builtInDir, null);
        this.getContentPane().add((Component)this.okButton, null);
        this.getContentPane().add((Component)this.cancelButton, null);
        this.setSize(470, 210);
        this.setLocation(250, 250);
    }

    public void okButton_actionPerformed(ActionEvent actionEvent) {
        String string = null;
        String string2 = null;
        if (this.workingDir.isFileNameChanged()) {
            string = this.workingDir.getFileName();
            this.workingDir.setCurrentFileName(string);
            this.workingDir.showCurrentFileName();
        }
        if (this.builtInDir.isFileNameChanged()) {
            string2 = this.builtInDir.getFileName();
            this.builtInDir.setCurrentFileName(string2);
            this.builtInDir.showCurrentFileName();
        }
        if (string != null || string2 != null) {
            this.notifyListeners(string, string2);
        }
        this.setVisible(false);
    }

    public void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.workingDir.showCurrentFileName();
        this.builtInDir.showCurrentFileName();
        this.setVisible(false);
    }
}

