/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import Hack.ComputerParts.ComputerPartEvent;
import Hack.ComputerParts.ComputerPartEventListener;
import Hack.ComputerParts.ComputerPartGUI;
import Hack.ComputerParts.MemorySegmentGUI;
import Hack.Events.ErrorEvent;
import Hack.Events.ErrorEventListener;
import HackGUI.Format;
import HackGUI.MemoryChangeListener;
import HackGUI.MemoryComponent;
import HackGUI.Utilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class MemorySegmentComponent
extends JPanel
implements MemorySegmentGUI,
MemoryChangeListener {
    public int dataFormat = 0;
    protected MemoryComponent memory;
    protected int startAddress = 0;
    protected JTable segmentTable;
    protected MemorySegmentTableModel model;
    protected JScrollPane scrollPane;
    protected JLabel nameLbl = new JLabel();
    protected Vector highlightIndex;
    private Vector listeners;
    private Vector errorEventListeners;
    protected int flashIndex = -1;
    protected Point topLevelLocation;
    private BorderLayout borderLayout = new BorderLayout();
    private Component topLevelComponent;
    protected boolean isEnabled = true;
    protected short nullValue;
    protected boolean hideNullValue;
    protected int startEnabling;
    protected int endEnabling;
    protected boolean hideDisabledRange;

    public MemorySegmentComponent() {
        this.listeners = new Vector();
        this.errorEventListeners = new Vector();
        this.highlightIndex = new Vector();
        this.segmentTable = new JTable(this.getTableModel());
        this.segmentTable.setDefaultRenderer(this.segmentTable.getColumnClass(0), this.getCellRenderer());
        this.startEnabling = -1;
        this.endEnabling = -1;
        JTextField jTextField = new JTextField();
        jTextField.setFont(Utilities.bigBoldValueFont);
        jTextField.setBorder(null);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
        this.segmentTable.getColumnModel().getColumn(this.getColumnValue()).setCellEditor(defaultCellEditor);
        this.jbInit();
    }

    public void setNullValue(short s, boolean bl) {
        this.nullValue = s;
        this.hideNullValue = bl;
    }

    public void enableUserInput() {
        this.isEnabled = true;
    }

    public void disableUserInput() {
        this.isEnabled = false;
    }

    protected int getColumnValue() {
        return 1;
    }

    public void setTopLevelLocation() {
        this.topLevelLocation = Utilities.getTopLevelLocation(this.topLevelComponent, this.segmentTable);
    }

    public void setTopLevelLocation(Component component) {
        this.topLevelComponent = component;
        this.setTopLevelLocation();
    }

    protected TableModel getTableModel() {
        return new MemorySegmentTableModel();
    }

    protected DefaultTableCellRenderer getCellRenderer() {
        return new MemorySegmentTableCellRenderer();
    }

    public void addListener(ComputerPartEventListener computerPartEventListener) {
        this.listeners.addElement(computerPartEventListener);
    }

    public void removeListener(ComputerPartEventListener computerPartEventListener) {
        this.listeners.removeElement(computerPartEventListener);
    }

    public void notifyListeners(int n, short s) {
        ComputerPartEvent computerPartEvent = new ComputerPartEvent((ComputerPartGUI)this, n, s);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ComputerPartEventListener)this.listeners.elementAt(i)).valueChanged(computerPartEvent);
        }
    }

    public void notifyListeners() {
        ComputerPartEvent computerPartEvent = new ComputerPartEvent((ComputerPartGUI)this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ComputerPartEventListener)this.listeners.elementAt(i)).guiGainedFocus();
        }
    }

    public void addErrorListener(ErrorEventListener errorEventListener) {
        this.errorEventListeners.addElement(errorEventListener);
    }

    public void removeErrorListener(ErrorEventListener errorEventListener) {
        this.errorEventListeners.removeElement(errorEventListener);
    }

    public void notifyErrorListeners(String string) {
        ErrorEvent errorEvent = new ErrorEvent((Object)this, string);
        for (int i = 0; i < this.errorEventListeners.size(); ++i) {
            ((ErrorEventListener)this.errorEventListeners.elementAt(i)).errorOccured(errorEvent);
        }
    }

    public void setValueAt(int n, short s) {
        Rectangle rectangle = this.segmentTable.getCellRect(n, 0, true);
        this.segmentTable.scrollRectToVisible(rectangle);
        this.repaint();
    }

    public void setStartAddress(int n) {
        this.startAddress = n;
        this.segmentTable.revalidate();
    }

    public void reset() {
        this.segmentTable.clearSelection();
        this.hideFlash();
        this.hideHighlight();
    }

    public String getValueAsString(int n) {
        return Format.translateValueToString(this.memory.getValueAsShort((short)(n + this.startAddress)), this.dataFormat);
    }

    public Point getCoordinates(int n) {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        Rectangle rectangle = this.segmentTable.getCellRect(n, 1, true);
        this.segmentTable.scrollRectToVisible(rectangle);
        this.setTopLevelLocation();
        return new Point((int)(rectangle.getX() + this.topLevelLocation.getX()), (int)(rectangle.getY() + this.topLevelLocation.getY()));
    }

    public void hideHighlight() {
        this.highlightIndex.removeAllElements();
        this.repaint();
    }

    public void highlight(int n) {
        this.highlightIndex.addElement(new Integer(n));
        this.repaint();
    }

    public void hideFlash() {
        this.flashIndex = -1;
        this.repaint();
    }

    public void flash(int n) {
        this.flashIndex = n;
        Utilities.tableCenterScroll(this, this.segmentTable, n);
    }

    public void setEnabledRange(int n, int n2, boolean bl) {
        this.startEnabling = n;
        this.endEnabling = n2;
        this.hideDisabledRange = bl;
        this.repaint();
    }

    public void setMemoryComponent(MemoryComponent memoryComponent) {
        this.memory = memoryComponent;
    }

    public void repaintChange() {
        this.repaint();
    }

    public void revalidateChange() {
        this.segmentTable.revalidate();
        this.repaint();
    }

    protected void determineColumnWidth() {
        if (this.segmentTable.getColumnCount() == 2) {
            TableColumn tableColumn = null;
            for (int i = 0; i < 2; ++i) {
                tableColumn = this.segmentTable.getColumnModel().getColumn(i);
                if (i == 0) {
                    tableColumn.setPreferredWidth(30);
                    continue;
                }
                tableColumn.setPreferredWidth(100);
            }
        }
    }

    public void setSegmentName(String string) {
        this.nameLbl.setText(string);
    }

    public void setNumericFormat(int n) {
        this.dataFormat = n;
    }

    public void hideSelect() {
        this.segmentTable.clearSelection();
    }

    public void scrollTo(int n) {
        Utilities.tableCenterScroll(this, this.segmentTable, n);
    }

    public int getTableWidth() {
        return 193;
    }

    public void setVisibleRows(int n) {
        int n2 = n * this.segmentTable.getRowHeight();
        this.scrollPane.setSize(this.getTableWidth(), n2 + 3);
        this.setPreferredSize(new Dimension(this.getTableWidth(), n2 + 30));
        this.setSize(this.getTableWidth(), n2 + 30);
    }

    private void jbInit() {
        this.segmentTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                MemorySegmentComponent.this.segmentTable_focusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                MemorySegmentComponent.this.segmentTable_focusLost(focusEvent);
            }
        });
        this.segmentTable.setTableHeader(null);
        this.scrollPane = new JScrollPane(this.segmentTable);
        this.scrollPane.setMinimumSize(new Dimension(this.getTableWidth(), 0));
        this.setLayout(new BorderLayout(0, 0));
        this.determineColumnWidth();
        this.nameLbl.setPreferredSize(new Dimension(this.getTableWidth(), 25));
        this.nameLbl.setMinimumSize(new Dimension(this.getTableWidth(), 0));
        this.nameLbl.setFont(Utilities.labelsFont);
        this.segmentTable.setFont(Utilities.valueFont);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setMinimumSize(new Dimension(this.getTableWidth(), 0));
        this.add((Component)this.nameLbl, "North");
        this.add((Component)this.scrollPane, "Center");
    }

    public void segmentTable_focusGained(FocusEvent focusEvent) {
        this.segmentTable.clearSelection();
        this.notifyListeners();
    }

    public void segmentTable_focusLost(FocusEvent focusEvent) {
        this.segmentTable.clearSelection();
    }

    private String getStrAt(int n) {
        short s = this.memory.getValueAsShort((short)(n + this.startAddress));
        if (s == this.nullValue && this.hideNullValue) {
            return "";
        }
        return Format.translateValueToString(s, this.dataFormat);
    }

    public JTable getTable() {
        return this.segmentTable;
    }

    class MemorySegmentTableCellRenderer
    extends DefaultTableCellRenderer {
        MemorySegmentTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setForeground(null);
            this.setBackground(null);
            this.setRenderer(n, n2);
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }

        public void setRenderer(int n, int n2) {
            if (n2 == 0) {
                this.setHorizontalAlignment(0);
            } else if (n2 == 1) {
                this.setHorizontalAlignment(4);
                for (int i = 0; i < MemorySegmentComponent.this.highlightIndex.size(); ++i) {
                    if (n != (Integer)MemorySegmentComponent.this.highlightIndex.elementAt(i)) continue;
                    this.setForeground(Color.blue);
                    break;
                }
                if (n == MemorySegmentComponent.this.flashIndex) {
                    this.setBackground(Color.orange);
                }
            }
            this.setEnabledRange(n);
        }

        public void setEnabledRange(int n) {
            if ((n + MemorySegmentComponent.this.startAddress < MemorySegmentComponent.this.startEnabling || n + MemorySegmentComponent.this.startAddress > MemorySegmentComponent.this.endEnabling) && MemorySegmentComponent.this.hideDisabledRange) {
                this.setForeground(Color.white);
            }
        }
    }

    class MemorySegmentTableModel
    extends AbstractTableModel {
        MemorySegmentTableModel() {
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            if (MemorySegmentComponent.this.memory != null) {
                return Math.max(MemorySegmentComponent.this.memory.getMemorySize() - MemorySegmentComponent.this.startAddress, 0);
            }
            return 0;
        }

        public String getColumnName(int n) {
            return "";
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return String.valueOf(n);
            }
            return MemorySegmentComponent.this.getStrAt(n);
        }

        public boolean isCellEditable(int n, int n2) {
            boolean bl = false;
            if (MemorySegmentComponent.this.isEnabled && n2 == 1 && (MemorySegmentComponent.this.endEnabling == -1 || n + MemorySegmentComponent.this.startAddress >= MemorySegmentComponent.this.startEnabling && n + MemorySegmentComponent.this.startAddress <= MemorySegmentComponent.this.endEnabling)) {
                bl = true;
            }
            return bl;
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = ((String)object).trim();
            if (!MemorySegmentComponent.this.getStrAt(n).equals(string)) {
                try {
                    short s = string.equals("") && MemorySegmentComponent.this.hideNullValue ? MemorySegmentComponent.this.nullValue : Format.translateValueToShort(string, MemorySegmentComponent.this.memory.dataFormat);
                    MemorySegmentComponent.this.notifyListeners((short)n, s);
                }
                catch (NumberFormatException numberFormatException) {
                    MemorySegmentComponent.this.notifyErrorListeners("Illegal value");
                }
                MemorySegmentComponent.this.repaint();
            }
        }
    }
}

