/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import Hack.ComputerParts.ComputerPartEvent;
import Hack.ComputerParts.ComputerPartEventListener;
import Hack.ComputerParts.ComputerPartGUI;
import Hack.ComputerParts.RegisterGUI;
import Hack.Events.ErrorEvent;
import Hack.Events.ErrorEventListener;
import HackGUI.Format;
import HackGUI.Utilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RegisterComponent
extends JPanel
implements RegisterGUI {
    protected JLabel registerName = new JLabel();
    protected JTextField registerValue = new JTextField();
    private Vector listeners = new Vector();
    private Vector errorEventListeners = new Vector();
    protected short value = 0;
    protected String oldValue;
    protected int dataFormat = 0;
    protected short nullValue;
    protected boolean hideNullValue;

    public RegisterComponent() {
        this.registerValue.setText(this.translateValueToString(this.value));
        this.jbInit();
        this.setVisible(true);
    }

    public void setNullValue(short s, boolean bl) {
        this.nullValue = s;
        this.hideNullValue = bl;
        if (this.value == this.nullValue && bl) {
            this.oldValue = "";
        }
    }

    public void addListener(ComputerPartEventListener computerPartEventListener) {
        this.listeners.addElement(computerPartEventListener);
    }

    public void removeListener(ComputerPartEventListener computerPartEventListener) {
        this.listeners.removeElement(computerPartEventListener);
    }

    public void notifyListeners(int n, short s) {
        ComputerPartEvent computerPartEvent = new ComputerPartEvent((ComputerPartGUI)this, 0, s);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ComputerPartEventListener)this.listeners.elementAt(i)).valueChanged(computerPartEvent);
        }
    }

    public void notifyListeners() {
        ComputerPartEvent computerPartEvent = new ComputerPartEvent((ComputerPartGUI)this);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ComputerPartEventListener)this.listeners.elementAt(i)).guiGainedFocus();
        }
    }

    public void addErrorListener(ErrorEventListener errorEventListener) {
        this.errorEventListeners.addElement(errorEventListener);
    }

    public void removeErrorListener(ErrorEventListener errorEventListener) {
        this.errorEventListeners.removeElement(errorEventListener);
    }

    public void notifyErrorListeners(String string) {
        ErrorEvent errorEvent = new ErrorEvent((Object)this, string);
        for (int i = 0; i < this.errorEventListeners.size(); ++i) {
            ((ErrorEventListener)this.errorEventListeners.elementAt(i)).errorOccured(errorEvent);
        }
    }

    public void enableUserInput() {
        this.registerValue.setEnabled(true);
    }

    public void disableUserInput() {
        this.registerValue.setEnabled(false);
    }

    protected String translateValueToString(short s) {
        if (this.hideNullValue) {
            if (s == this.nullValue) {
                return "";
            }
            return Format.translateValueToString(s, this.dataFormat);
        }
        return Format.translateValueToString(s, this.dataFormat);
    }

    public void setValueAt(int n, short s) {
        String string = this.translateValueToString(s);
        this.value = s;
        this.registerValue.setText(string);
    }

    public void reset() {
        this.value = this.nullValue;
        if (this.hideNullValue) {
            this.oldValue = "";
        }
        this.registerValue.setText(this.translateValueToString(this.nullValue));
        this.hideFlash();
        this.hideHighlight();
    }

    public Point getCoordinates(int n) {
        Point point = this.getLocation();
        return new Point((int)point.getX() + this.registerValue.getX(), (int)point.getY() + this.registerValue.getY());
    }

    public void hideHighlight() {
        this.registerValue.setForeground(Color.black);
    }

    public void highlight(int n) {
        this.registerValue.setForeground(Color.blue);
    }

    public void flash(int n) {
        this.registerValue.setBackground(Color.orange);
    }

    public void hideFlash() {
        this.registerValue.setBackground(Color.white);
    }

    public void setEnabledRange(int n, int n2, boolean bl) {
    }

    public String getValueAsString(int n) {
        return this.registerValue.getText();
    }

    public void setNumericFormat(int n) {
        this.dataFormat = n;
        this.registerValue.setText(Format.translateValueToString(this.value, n));
    }

    private void valueChanged() {
        String string = this.registerValue.getText();
        if (!string.equals(this.oldValue)) {
            try {
                this.value = Format.translateValueToShort(string, this.dataFormat);
                this.notifyListeners(0, this.value);
                this.oldValue = string;
            }
            catch (NumberFormatException numberFormatException) {
                this.notifyErrorListeners("Illegal value");
                this.registerValue.setText(this.translateValueToString(this.value));
            }
        }
    }

    public void setName(String string) {
        this.registerName.setText(string);
    }

    private void jbInit() {
        this.registerValue.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                RegisterComponent.this.registerValue_focusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                RegisterComponent.this.registerValue_focusLost(focusEvent);
            }
        });
        this.registerName.setFont(Utilities.labelsFont);
        this.registerName.setBounds(new Rectangle(8, 3, 41, 18));
        this.setLayout(null);
        this.registerValue.setFont(Utilities.valueFont);
        this.registerValue.setDisabledTextColor(Color.black);
        this.registerValue.setHorizontalAlignment(4);
        this.registerValue.setBounds(new Rectangle(36, 3, 124, 18));
        this.registerValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RegisterComponent.this.registerValue_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.registerValue, null);
        this.add((Component)this.registerName, null);
        this.setPreferredSize(new Dimension(164, 24));
        this.setSize(164, 24);
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public void registerValue_focusGained(FocusEvent focusEvent) {
        this.oldValue = this.registerValue.getText();
        this.notifyListeners();
    }

    public void registerValue_focusLost(FocusEvent focusEvent) {
        this.valueChanged();
    }

    public void registerValue_actionPerformed(ActionEvent actionEvent) {
        this.valueChanged();
    }
}

