/*
 * Decompiled with CFR 0.152.
 */
package Hack.Controller;

import Hack.ComputerParts.ComputerPartErrorEventListener;
import Hack.Controller.CommandException;
import Hack.Controller.ControllerEvent;
import Hack.Controller.ControllerEventListener;
import Hack.Controller.HackSimulatorGUI;
import Hack.Controller.ProgramException;
import Hack.Controller.VariableException;
import Hack.Events.ProgramEvent;
import Hack.Events.ProgramEventListener;
import java.io.File;
import java.util.Vector;

public abstract class HackSimulator
implements ProgramEventListener,
ComputerPartErrorEventListener {
    private Vector listeners = new Vector();
    private Vector programListeners = new Vector();
    protected File workingDir;

    public abstract String getName();

    public abstract String getValue(String var1) throws VariableException;

    public abstract void setValue(String var1, String var2) throws VariableException;

    public abstract void doCommand(String[] var1) throws CommandException, ProgramException, VariableException;

    public abstract void restart();

    public abstract void setAnimationMode(int var1);

    public abstract void setNumericFormat(int var1);

    public abstract void setAnimationSpeed(int var1);

    public abstract void refresh();

    public abstract void prepareFastForward();

    public abstract void prepareGUI();

    public abstract String[] getVariables();

    public int getInitialAnimationMode() {
        return 0;
    }

    public int getInitialNumericFormat() {
        return 0;
    }

    public int getInitialAdditionalDisplay() {
        return 3;
    }

    protected abstract HackSimulatorGUI getGUI();

    protected void loadProgram() {
        this.getGUI().loadProgram();
    }

    public void setWorkingDir(File file) {
        File file2 = file.getParentFile();
        this.workingDir = file.isDirectory() ? file : file2;
        HackSimulatorGUI hackSimulatorGUI = this.getGUI();
        if (hackSimulatorGUI != null) {
            this.getGUI().setWorkingDir(file2);
        }
    }

    protected void displayMessage(String string, boolean bl) {
        if (bl) {
            this.notifyListeners((byte)26, string);
        } else {
            this.notifyListeners((byte)25, string);
        }
    }

    protected void clearMessage() {
        this.notifyListeners((byte)25, "");
    }

    public void addListener(ControllerEventListener controllerEventListener) {
        this.listeners.addElement(controllerEventListener);
    }

    public void removeListener(ControllerEventListener controllerEventListener) {
        this.listeners.removeElement(controllerEventListener);
    }

    public void notifyListeners(byte by, Object object) {
        ControllerEvent controllerEvent = new ControllerEvent(this, by, object);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ControllerEventListener)this.listeners.elementAt(i)).actionPerformed(controllerEvent);
        }
    }

    public void addProgramListener(ProgramEventListener programEventListener) {
        this.programListeners.add(programEventListener);
    }

    public void removeProgramListener(ProgramEventListener programEventListener) {
        this.programListeners.remove(programEventListener);
    }

    protected void notifyProgramListeners(byte by, String string) {
        ProgramEvent programEvent = new ProgramEvent(this, by, string);
        for (int i = 0; i < this.programListeners.size(); ++i) {
            ((ProgramEventListener)this.programListeners.elementAt(i)).programChanged(programEvent);
        }
    }

    public void programChanged(ProgramEvent programEvent) {
        this.notifyProgramListeners(programEvent.getType(), programEvent.getProgramFileName());
    }
}

