/*
 * Decompiled with CFR 0.152.
 */
package Hack.Translators;

import Hack.ComputerParts.TextFileEvent;
import Hack.ComputerParts.TextFileEventListener;
import Hack.Translators.HackTranslatorEvent;
import Hack.Translators.HackTranslatorEventListener;
import Hack.Translators.HackTranslatorException;
import Hack.Translators.HackTranslatorGUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Timer;

public abstract class HackTranslator
implements HackTranslatorEventListener,
ActionListener,
TextFileEventListener {
    private static final int FAST_FORWARD_DELAY = 750;
    private PrintWriter writer;
    protected String sourceFileName;
    protected String destFileName;
    protected int programSize;
    protected short[] program;
    protected String[] source;
    protected HackTranslatorGUI gui;
    private Timer timer;
    private boolean singleStepLocked;
    private SingleStepTask singleStepTask;
    private FullCompilationTask fullCompilationTask;
    private FastForwardTask fastForwardTask;
    private LoadSourceTask loadSourceTask;
    protected boolean compilationStarted;
    protected int destPC;
    protected int sourcePC;
    private boolean updateGUI;
    protected Hashtable compilationMap;
    protected boolean inFullCompilation;
    protected boolean inFastForward;

    public HackTranslator(String string, int n, short s, boolean bl) throws HackTranslatorException {
        if (string.indexOf(".") < 0) {
            string = string + "." + this.getSourceExtension();
        }
        this.checkSourceFile(string);
        this.source = new String[0];
        this.init(n, s);
        this.loadSource(string);
        this.fullCompilation();
        if (bl) {
            this.save();
        }
    }

    public HackTranslator(HackTranslatorGUI hackTranslatorGUI, int n, short s, String string) throws HackTranslatorException {
        this.gui = hackTranslatorGUI;
        hackTranslatorGUI.addHackTranslatorListener(this);
        hackTranslatorGUI.getSource().addTextFileListener(this);
        hackTranslatorGUI.setTitle(this.getName() + HackTranslator.getVersionString());
        this.singleStepTask = new SingleStepTask();
        this.fullCompilationTask = new FullCompilationTask();
        this.fastForwardTask = new FastForwardTask();
        this.loadSourceTask = new LoadSourceTask();
        this.timer = new Timer(750, this);
        this.init(n, s);
        File file = this.loadWorkingDir();
        hackTranslatorGUI.setWorkingDir(file);
        if (string == null) {
            hackTranslatorGUI.disableSingleStep();
            hackTranslatorGUI.disableFastForward();
            hackTranslatorGUI.disableStop();
            hackTranslatorGUI.disableRewind();
            hackTranslatorGUI.disableFullCompilation();
            hackTranslatorGUI.disableSave();
            hackTranslatorGUI.enableLoadSource();
            hackTranslatorGUI.disableSourceRowSelection();
        } else {
            this.loadSource(string);
            hackTranslatorGUI.setSourceName(string);
        }
    }

    protected abstract String getSourceExtension();

    protected abstract String getDestinationExtension();

    protected abstract String getName();

    private static String getVersionString() {
        return " (2.5)";
    }

    protected int[] compileLineAndCount(String string) throws HackTranslatorException {
        int[] nArray = null;
        int n = this.destPC;
        this.compileLine(string);
        int n2 = this.destPC - n;
        if (n2 > 0) {
            nArray = new int[]{n, this.destPC - 1};
        }
        return nArray;
    }

    protected abstract void compileLine(String var1) throws HackTranslatorException;

    protected void init(int n, short s) {
        this.program = new short[n];
        for (int i = 0; i < n; ++i) {
            this.program[i] = s;
        }
        this.programSize = 0;
    }

    private void checkSourceFile(String string) throws HackTranslatorException {
        if (!string.endsWith("." + this.getSourceExtension())) {
            throw new HackTranslatorException(string + " is not a ." + this.getSourceExtension() + " file");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new HackTranslatorException("file " + string + " does not exist");
        }
    }

    private void checkDestinationFile(String string) throws HackTranslatorException {
        if (!string.endsWith("." + this.getDestinationExtension())) {
            throw new HackTranslatorException(string + " is not a ." + this.getDestinationExtension() + " file");
        }
    }

    protected void restartCompilation() {
        this.compilationMap = new Hashtable();
        this.sourcePC = 0;
        this.destPC = 0;
        if (this.gui != null) {
            this.compilationStarted = false;
            this.gui.getDestination().reset();
            this.hidePointers();
            this.gui.enableSingleStep();
            this.gui.enableFastForward();
            this.gui.disableStop();
            this.gui.enableRewind();
            this.gui.enableFullCompilation();
            this.gui.disableSave();
            this.gui.enableLoadSource();
            this.gui.disableSourceRowSelection();
        }
    }

    private void loadSource(String string) throws HackTranslatorException {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = null;
        String string2 = null;
        try {
            String string3;
            if (this.gui != null) {
                this.gui.disableSingleStep();
                this.gui.disableFastForward();
                this.gui.disableStop();
                this.gui.disableRewind();
                this.gui.disableFullCompilation();
                this.gui.disableSave();
                this.gui.disableLoadSource();
                this.gui.disableSourceRowSelection();
                this.gui.displayMessage("Please wait...", false);
            }
            this.checkSourceFile(string);
            this.sourceFileName = string;
            vector2 = new Vector<String>();
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.sourceFileName));
            while ((string3 = bufferedReader.readLine()) != null) {
                vector.addElement(string3);
                if (this.gui == null) continue;
                vector2.addElement(string3);
            }
            bufferedReader.close();
            this.source = new String[vector.size()];
            vector.toArray(this.source);
            if (this.gui != null) {
                String[] stringArray = new String[vector2.size()];
                vector2.toArray(stringArray);
                this.gui.getSource().setContents(stringArray);
            }
            this.destFileName = this.sourceFileName.substring(0, this.sourceFileName.indexOf(46)) + "." + this.getDestinationExtension();
            this.initSource();
            this.restartCompilation();
            this.resetProgram();
            if (this.gui != null) {
                this.gui.setDestinationName(this.destFileName);
                this.gui.displayMessage("", false);
            }
        }
        catch (HackTranslatorException hackTranslatorException) {
            string2 = hackTranslatorException.getMessage();
        }
        catch (IOException iOException) {
            string2 = "error reading from file " + this.sourceFileName;
        }
        if (string2 != null) {
            if (this.gui != null) {
                this.gui.enableLoadSource();
            }
            throw new HackTranslatorException(string2);
        }
    }

    protected abstract void initSource() throws HackTranslatorException;

    protected void resetProgram() {
        this.programSize = 0;
        if (this.gui != null) {
            this.gui.getDestination().reset();
        }
    }

    protected abstract void initCompilation() throws HackTranslatorException;

    protected abstract void finalizeCompilation();

    protected void successfulCompilation() throws HackTranslatorException {
        if (this.gui != null) {
            this.gui.displayMessage("File compilation succeeded", false);
        }
    }

    private void fullCompilation() throws HackTranslatorException {
        try {
            this.inFullCompilation = true;
            this.initCompilation();
            if (this.gui != null) {
                this.gui.disableSingleStep();
                this.gui.disableFastForward();
                this.gui.disableRewind();
                this.gui.disableFullCompilation();
                this.gui.disableLoadSource();
                this.gui.getSource().setContents(this.sourceFileName);
            }
            this.updateGUI = false;
            while (this.sourcePC < this.source.length) {
                int[] nArray = this.compileLineAndCount(this.source[this.sourcePC]);
                if (nArray != null) {
                    this.compilationMap.put(new Integer(this.sourcePC), nArray);
                }
                ++this.sourcePC;
            }
            this.successfulCompilation();
            this.finalizeCompilation();
            this.programSize = this.destPC;
            if (this.gui != null) {
                this.showProgram(this.programSize);
                this.gui.getDestination().clearHighlights();
                this.gui.enableRewind();
                this.gui.enableLoadSource();
                this.gui.enableSave();
                this.gui.enableSourceRowSelection();
            }
            this.inFullCompilation = false;
        }
        catch (HackTranslatorException hackTranslatorException) {
            this.inFullCompilation = false;
            throw new HackTranslatorException(hackTranslatorException.getMessage());
        }
    }

    protected abstract String getCodeString(short var1, int var2, boolean var3);

    protected void addCommand(short s) throws HackTranslatorException {
        if (this.destPC >= this.program.length) {
            throw new HackTranslatorException("Program too large");
        }
        this.program[this.destPC++] = s;
        if (this.updateGUI) {
            this.gui.getDestination().addLine(this.getCodeString(s, this.destPC - 1, true));
        }
    }

    protected void replaceCommand(int n, short s) {
        this.program[n] = s;
        if (this.updateGUI) {
            this.gui.getDestination().setLineAt(n, this.getCodeString(s, n, true));
        }
    }

    protected void showProgram(int n) {
        this.gui.getDestination().reset();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.getCodeString(this.program[i], i, true);
        }
        this.gui.getDestination().setContents(stringArray);
    }

    protected void fastForward() {
        this.gui.disableSingleStep();
        this.gui.disableFastForward();
        this.gui.enableStop();
        this.gui.disableRewind();
        this.gui.disableFullCompilation();
        this.gui.disableLoadSource();
        this.inFastForward = true;
        this.timer.start();
    }

    private void singleStep() {
        this.singleStepLocked = true;
        try {
            this.initCompilation();
            if (!this.compilationStarted) {
                this.compilationStarted = true;
            }
            this.gui.getSource().addHighlight(this.sourcePC, true);
            this.gui.getDestination().clearHighlights();
            this.updateGUI = true;
            int[] nArray = this.compileLineAndCount(this.source[this.sourcePC]);
            if (nArray != null) {
                this.compilationMap.put(new Integer(this.sourcePC), nArray);
            }
            ++this.sourcePC;
            if (this.sourcePC == this.source.length) {
                this.successfulCompilation();
                this.programSize = this.destPC;
                this.gui.enableSave();
                this.gui.enableSourceRowSelection();
                this.end(false);
            }
            this.finalizeCompilation();
        }
        catch (HackTranslatorException hackTranslatorException) {
            this.gui.displayMessage(hackTranslatorException.getMessage(), true);
            this.end(false);
        }
        this.singleStepLocked = false;
    }

    protected void hidePointers() {
        this.gui.getSource().clearHighlights();
        this.gui.getDestination().clearHighlights();
        this.gui.getSource().hideSelect();
        this.gui.getDestination().hideSelect();
    }

    protected void end(boolean bl) {
        this.timer.stop();
        this.gui.disableSingleStep();
        this.gui.disableFastForward();
        this.gui.disableStop();
        this.gui.enableRewind();
        this.gui.disableFullCompilation();
        this.gui.enableLoadSource();
        this.inFastForward = false;
        if (bl) {
            this.hidePointers();
        }
    }

    protected void stop() {
        this.timer.stop();
        this.gui.enableSingleStep();
        this.gui.enableFastForward();
        this.gui.disableStop();
        this.gui.enableRewind();
        this.gui.enableLoadSource();
        this.gui.enableFullCompilation();
        this.inFastForward = false;
    }

    protected void rewind() {
        this.restartCompilation();
        this.resetProgram();
    }

    private void save() throws HackTranslatorException {
        try {
            this.writer = new PrintWriter(new FileWriter(this.destFileName));
            this.dumpToFile();
            this.writer.close();
        }
        catch (IOException iOException) {
            throw new HackTranslatorException("could not create file " + this.destFileName);
        }
    }

    public short[] getProgram() {
        return this.program;
    }

    private void dumpToFile() {
        for (int n = 0; n < this.programSize; n = (int)((short)(n + 1))) {
            this.writer.println(this.getCodeString(this.program[n], n, false));
        }
        this.writer.close();
    }

    protected void clearMessage() {
        this.gui.displayMessage("", false);
    }

    protected int[] rowIndexToRange(int n) {
        Integer n2 = new Integer(n);
        return (int[])this.compilationMap.get(n2);
    }

    protected File loadWorkingDir() {
        String string = ".";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("bin/" + this.getName() + ".dat"));
            string = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new File(string);
    }

    protected void saveWorkingDir(File file) {
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter("bin/" + this.getName() + ".dat"));
            printWriter.println(file.getAbsolutePath());
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.gui.setWorkingDir(file);
    }

    public void rowSelected(TextFileEvent textFileEvent) {
        int n = textFileEvent.getRowIndex();
        int[] nArray = this.rowIndexToRange(n);
        this.gui.getSource().addHighlight(n, true);
        this.gui.getSource().hideSelect();
        if (nArray != null) {
            this.gui.getDestination().clearHighlights();
            for (int i = nArray[0]; i <= nArray[1]; ++i) {
                this.gui.getDestination().addHighlight(i, false);
            }
        } else {
            this.gui.getDestination().clearHighlights();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.singleStepLocked) {
            this.singleStep();
        }
    }

    protected void error(String string) throws HackTranslatorException {
        throw new HackTranslatorException(string, this.sourcePC);
    }

    public void actionPerformed(HackTranslatorEvent hackTranslatorEvent) {
        switch (hackTranslatorEvent.getAction()) {
            case 7: {
                String string = (String)hackTranslatorEvent.getData();
                File file = new File(string);
                this.saveWorkingDir(file);
                this.gui.setTitle(this.getName() + HackTranslator.getVersionString() + " - " + string);
                this.loadSourceTask.setFileName(string);
                Thread thread = new Thread(this.loadSourceTask);
                thread.start();
                break;
            }
            case 6: {
                this.clearMessage();
                String string = (String)hackTranslatorEvent.getData();
                try {
                    this.checkDestinationFile(string);
                    this.destFileName = string;
                    File file = new File(string);
                    this.saveWorkingDir(file);
                    this.gui.setTitle(this.getName() + HackTranslator.getVersionString() + " - " + string);
                    this.save();
                }
                catch (HackTranslatorException hackTranslatorException) {
                    this.gui.setDestinationName("");
                    this.gui.displayMessage(hackTranslatorException.getMessage(), true);
                }
                break;
            }
            case 1: {
                this.clearMessage();
                if (this.sourceFileName == null) {
                    this.gui.displayMessage("No source file specified", true);
                    break;
                }
                if (this.destFileName == null) {
                    this.gui.displayMessage("No destination file specified", true);
                    break;
                }
                Thread thread = new Thread(this.singleStepTask);
                thread.start();
                break;
            }
            case 2: {
                this.clearMessage();
                Thread thread = new Thread(this.fastForwardTask);
                thread.start();
                break;
            }
            case 3: {
                this.stop();
                break;
            }
            case 4: {
                this.clearMessage();
                this.rewind();
                break;
            }
            case 5: {
                this.clearMessage();
                Thread thread = new Thread(this.fullCompilationTask);
                thread.start();
            }
        }
    }

    class LoadSourceTask
    implements Runnable {
        private String fileName;

        LoadSourceTask() {
        }

        public void run() {
            try {
                HackTranslator.this.loadSource(this.fileName);
            }
            catch (HackTranslatorException hackTranslatorException) {
                HackTranslator.this.gui.setSourceName("");
                HackTranslator.this.gui.displayMessage(hackTranslatorException.getMessage(), true);
            }
        }

        public void setFileName(String string) {
            this.fileName = string;
        }
    }

    class FastForwardTask
    implements Runnable {
        FastForwardTask() {
        }

        public void run() {
            HackTranslator.this.fastForward();
        }
    }

    class SingleStepTask
    implements Runnable {
        SingleStepTask() {
        }

        public void run() {
            if (!HackTranslator.this.singleStepLocked) {
                HackTranslator.this.singleStep();
            }
        }
    }

    class FullCompilationTask
    implements Runnable {
        FullCompilationTask() {
        }

        public void run() {
            HackTranslator.this.gui.displayMessage("Please wait...", false);
            try {
                HackTranslator.this.restartCompilation();
                HackTranslator.this.fullCompilation();
            }
            catch (HackTranslatorException hackTranslatorException) {
                HackTranslator.this.end(false);
                HackTranslator.this.gui.getSource().addHighlight(HackTranslator.this.sourcePC, true);
                HackTranslator.this.gui.displayMessage(hackTranslatorException.getMessage(), true);
            }
        }
    }
}

