/*
 * Decompiled with CFR 0.152.
 */
package Hack.Translators;

import Hack.Translators.HackTranslatorException;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;

public class LineTokenizer
extends StreamTokenizer {
    public LineTokenizer(String string) throws IOException {
        super(new StringReader(string));
        this.slashSlashComments(true);
    }

    public void advance(boolean bl) throws IOException, HackTranslatorException {
        this.nextToken();
        if (bl && this.ttype == -1) {
            throw new HackTranslatorException("Unexpected end of line", this.lineno());
        }
    }

    public String token() {
        String string = null;
        switch (this.ttype) {
            case -2: {
                string = String.valueOf((int)this.nval);
                break;
            }
            case -3: {
                string = this.sval;
                break;
            }
            default: {
                string = String.valueOf((char)this.ttype);
            }
        }
        return string;
    }

    public int number() {
        if (this.ttype == -2) {
            return (int)this.nval;
        }
        return 0;
    }

    public char symbol() {
        if (this.ttype > 0) {
            return (char)this.ttype;
        }
        return '\u0000';
    }

    public boolean isToken(String string) {
        return this.token().equalsIgnoreCase(string);
    }

    public boolean isWord() {
        return this.ttype == -3;
    }

    public boolean isNumber() {
        return this.ttype == -2;
    }

    public boolean isSymbol() {
        return this.ttype > 0;
    }

    public boolean isEnd() {
        return this.ttype == -1;
    }

    public void ensureEnd() throws HackTranslatorException, IOException {
        this.advance(false);
        if (!this.isEnd()) {
            throw new HackTranslatorException("end of line expected, '" + this.token() + "' is found");
        }
    }

    public boolean contains(String string) throws IOException {
        boolean bl = false;
        while (!bl && !this.isEnd()) {
            bl = this.token().equals(string);
            if (bl) continue;
            try {
                this.advance(false);
            }
            catch (HackTranslatorException hackTranslatorException) {}
        }
        return bl;
    }
}

