/*
 * Decompiled with CFR 0.152.
 */
package Hack.Utilities;

public class Conversions {
    private static final String ZEROS = "0000000000000000000000000000000000000000";
    private static final int[] powersOf2 = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000, 0x200000, 0x400000, 0x800000, 0x1000000, 0x2000000, 0x4000000, 0x8000000, 0x10000000, 0x20000000, 0x40000000, Integer.MIN_VALUE};
    private static final int[] powersOf16 = new int[]{1, 16, 256, 4096, 65536, 0x100000, 0x1000000, 0x10000000};

    public static String toDecimalForm(String string) {
        if (string.startsWith("%B")) {
            string = String.valueOf(Conversions.binaryToInt(string.substring(2)));
        } else if (string.startsWith("%X")) {
            string = string.length() == 6 ? String.valueOf(Conversions.hex4ToInt(string.substring(2))) : String.valueOf(Conversions.hexToInt(string.substring(2)));
        } else if (string.startsWith("%D")) {
            string = string.substring(2);
        } else {
            try {
                int n = Integer.parseInt(string);
                string = String.valueOf(n);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return string;
    }

    public static int binaryToInt(String string) throws NumberFormatException {
        int n = 0;
        int n2 = string.length() - 1;
        int n3 = 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (c == '1') {
                n = (short)(n | n3);
            } else if (c != '0') {
                throw new NumberFormatException();
            }
            --n2;
            n3 <<= 1;
        }
        return n;
    }

    public static int hexToInt(String string) throws NumberFormatException {
        int n = 0;
        int n2 = 1;
        int n3 = string.length() - 1;
        while (n3 >= 0) {
            char c = string.charAt(n3);
            if (c >= '0' && c <= '9') {
                n += (c - 48) * n2;
            } else if (c >= 'a' && c <= 'f') {
                n += (c - 97 + 10) * n2;
            } else if (c >= 'A' && c <= 'F') {
                n += (c - 65 + 10) * n2;
            } else {
                throw new NumberFormatException();
            }
            --n3;
            n2 *= 16;
        }
        return n;
    }

    public static int hex4ToInt(String string) throws NumberFormatException {
        int n = Conversions.hexToInt(string);
        if (n > Short.MAX_VALUE) {
            n -= 65536;
        }
        return n;
    }

    public static String decimalToBinary(int n, int n2) {
        String string = Integer.toBinaryString(n &= powersOf2[n2] - 1);
        if (string.length() < n2) {
            string = ZEROS.substring(0, n2 - string.length()) + string;
        }
        return string;
    }

    public static String decimalToHex(int n, int n2) {
        String string = Integer.toHexString(n &= powersOf16[n2] - 1);
        if (string.length() < n2) {
            string = ZEROS.substring(0, n2 - string.length()) + string;
        }
        return string;
    }
}

