/*
 * Decompiled with CFR 0.152.
 */
package HackGUI;

import Hack.ComputerParts.LabeledPointedMemoryGUI;
import HackGUI.MemoryComponent;
import HackGUI.PointedMemoryComponent;
import HackGUI.Utilities;
import java.awt.Color;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class LabeledMemoryComponent
extends PointedMemoryComponent
implements LabeledPointedMemoryGUI {
    protected String[] labels;
    private int labelFlashIndex = -1;

    public LabeledMemoryComponent() {
        this.searchButton.setLocation(199, 2);
        this.clearButton.setLocation(168, 2);
        this.memoryTable.setGridColor(Color.lightGray);
        this.labels = new String[0];
    }

    public int getTableWidth() {
        return 233;
    }

    protected int getValueColumnIndex() {
        return 2;
    }

    public void setLabel(int n, String string) {
        this.labels[n] = string + ":";
        this.repaint();
    }

    public void clearLabels() {
        for (int i = 0; i < this.labels.length; ++i) {
            if (this.labels[i] == null) continue;
            this.labels[i] = null;
        }
        this.repaint();
    }

    public void labelFlash(int n) {
        this.labelFlashIndex = n;
        this.repaint();
    }

    public void hideLabelFlash() {
        this.labelFlashIndex = -1;
        this.repaint();
    }

    public void setContents(short[] sArray) {
        String[] stringArray = this.labels;
        this.labels = new String[sArray.length];
        System.arraycopy(stringArray, 0, this.labels, 0, Math.min(stringArray.length, this.labels.length));
        super.setContents(sArray);
    }

    protected TableModel getTableModel() {
        return new LabeledMemoryTableModel();
    }

    protected DefaultTableCellRenderer getCellRenderer() {
        return new LabeledPointedMemoryTableCellRenderer();
    }

    protected void determineColumnWidth() {
        TableColumn tableColumn = null;
        for (int i = 0; i < 2; ++i) {
            tableColumn = this.memoryTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setMinWidth(1);
                tableColumn.setPreferredWidth(1);
                continue;
            }
            if (i != 1) continue;
            tableColumn.setMinWidth(1);
            tableColumn.setPreferredWidth(1);
        }
    }

    public class LabeledPointedMemoryTableCellRenderer
    extends PointedMemoryComponent.PointedMemoryTableCellRenderer {
        public LabeledPointedMemoryTableCellRenderer() {
            super(LabeledMemoryComponent.this);
        }

        public void setRenderer(int n, int n2) {
            super.setRenderer(n, n2 - 1);
            if (n2 == 0) {
                this.setHorizontalAlignment(4);
                this.setFont(Utilities.boldValueFont);
                this.setBackground(Color.lightGray);
                if (n == LabeledMemoryComponent.this.labelFlashIndex) {
                    this.setBackground(Color.orange);
                }
            }
        }
    }

    class LabeledMemoryTableModel
    extends MemoryComponent.MemoryTableModel {
        LabeledMemoryTableModel() {
            super(LabeledMemoryComponent.this);
        }

        public int getColumnCount() {
            return 3;
        }

        public Object getValueAt(int n, int n2) {
            String string = "";
            string = n2 == 0 ? LabeledMemoryComponent.this.labels[n] : (String)super.getValueAt(n, n2 - 1);
            return string;
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                return false;
            }
            return super.isCellEditable(n, n2 - 1);
        }
    }
}

