/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import Hack.HardwareSimulator.GateInfoGUI;
import HackGUI.Utilities;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.SystemColor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class GateInfoComponent
extends JPanel
implements GateInfoGUI {
    private JLabel chipNameLbl = new JLabel();
    private JLabel timeLbl = new JLabel();
    private JTextField chipNameTxt = new JTextField();
    private JTextField timeTxt = new JTextField();
    private boolean clockUp;
    private String chipName;

    public GateInfoComponent() {
        this.jbInit();
    }

    public void setChip(String string) {
        this.chipName = string;
        this.chipNameTxt.setText(string);
    }

    public void setClock(boolean bl) {
        this.clockUp = bl;
        if (bl) {
            this.timeTxt.setText(this.timeTxt.getText() + "+");
        }
    }

    public void setClocked(boolean bl) {
        if (bl) {
            this.chipNameTxt.setText(this.chipName + " (Clocked) ");
        } else {
            this.chipNameTxt.setText(this.chipName);
        }
    }

    public void setTime(int n) {
        if (this.clockUp) {
            this.timeTxt.setText(String.valueOf(n) + "+");
        } else {
            this.timeTxt.setText(String.valueOf(n));
        }
    }

    public void reset() {
        this.chipNameTxt.setText("");
        this.timeTxt.setText("0");
    }

    public void enableTime() {
        this.timeLbl.setEnabled(true);
        this.timeTxt.setEnabled(true);
    }

    public void disableTime() {
        this.timeLbl.setEnabled(false);
        this.timeTxt.setEnabled(false);
    }

    private void jbInit() {
        this.setLayout(null);
        this.chipNameLbl.setText("Chip Name :");
        this.chipNameLbl.setBounds(new Rectangle(11, 7, 74, 21));
        this.timeLbl.setBounds(new Rectangle(341, 8, 42, 21));
        this.timeLbl.setText("Time :");
        this.chipNameTxt.setBackground(SystemColor.info);
        this.chipNameTxt.setFont(Utilities.thinBigLabelsFont);
        this.chipNameTxt.setEditable(false);
        this.chipNameTxt.setHorizontalAlignment(2);
        this.chipNameTxt.setBounds(new Rectangle(89, 8, 231, 20));
        this.timeTxt.setBackground(SystemColor.info);
        this.timeTxt.setFont(Utilities.thinBigLabelsFont);
        this.timeTxt.setEditable(false);
        this.timeTxt.setBounds(new Rectangle(388, 8, 69, 20));
        this.add((Component)this.chipNameTxt, null);
        this.add((Component)this.chipNameLbl, null);
        this.add((Component)this.timeLbl, null);
        this.add((Component)this.timeTxt, null);
        this.setSize(483, 37);
        this.setBorder(BorderFactory.createEtchedBorder());
    }
}

