/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import Hack.ComputerParts.ComputerPartEvent;
import Hack.ComputerParts.ComputerPartEventListener;
import Hack.ComputerParts.ComputerPartGUI;
import Hack.Events.ErrorEvent;
import Hack.Events.ErrorEventListener;
import Hack.Gates.PinInfo;
import Hack.HardwareSimulator.PinsGUI;
import HackGUI.Format;
import HackGUI.Utilities;
import SimulatorsGUI.BinaryComponent;
import SimulatorsGUI.PinValueEvent;
import SimulatorsGUI.PinValueListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class PinsComponent
extends JPanel
implements PinsGUI,
MouseListener,
PinValueListener {
    protected BinaryComponent binary;
    protected JTable pinsTable;
    private PinInfo[] pins;
    private String[] valueStr;
    protected int dataFormat = 0;
    private Vector listeners;
    private Vector errorEventListeners;
    protected JScrollPane scrollPane;
    protected int flashIndex = -1;
    protected Vector highlightIndex;
    protected Point topLevelLocation;
    private PinsTableCellRenderer renderer = new PinsTableCellRenderer();
    private JLabel nameLbl = new JLabel();
    private boolean isEnabled = true;
    protected short nullValue;
    protected boolean hideNullValue;
    protected int startEnabling;
    protected int endEnabling;
    private int lastSelectedRow;

    public PinsComponent() {
        JTextField jTextField = new JTextField();
        jTextField.setFont(Utilities.bigBoldValueFont);
        jTextField.setBorder(null);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(jTextField);
        this.startEnabling = -1;
        this.endEnabling = -1;
        this.pins = new PinInfo[0];
        this.valueStr = new String[0];
        this.listeners = new Vector();
        this.errorEventListeners = new Vector();
        this.highlightIndex = new Vector();
        this.binary = new BinaryComponent();
        this.pinsTable = new JTable(this.getTableModel());
        this.pinsTable.setDefaultRenderer(this.pinsTable.getColumnClass(0), this.renderer);
        this.pinsTable.getColumnModel().getColumn(this.getValueColumn()).setCellEditor(defaultCellEditor);
        this.jbInit();
    }

    public void setNullValue(short s, boolean bl) {
        this.nullValue = s;
        this.hideNullValue = bl;
    }

    public void enableUserInput() {
        this.isEnabled = true;
    }

    public void disableUserInput() {
        this.isEnabled = false;
    }

    public void setDimmed(boolean bl) {
        this.pinsTable.setEnabled(!bl);
    }

    protected int getValueColumn() {
        return 1;
    }

    protected TableModel getTableModel() {
        return new PinsTableModel();
    }

    public void setPinsName(String string) {
        this.nameLbl.setText(string);
    }

    public void addErrorListener(ErrorEventListener errorEventListener) {
        this.errorEventListeners.addElement(errorEventListener);
    }

    public void removeErrorListener(ErrorEventListener errorEventListener) {
        this.errorEventListeners.removeElement(errorEventListener);
    }

    public void notifyErrorListeners(String string) {
        ErrorEvent errorEvent = new ErrorEvent((Object)this, string);
        for (int i = 0; i < this.errorEventListeners.size(); ++i) {
            ((ErrorEventListener)this.errorEventListeners.elementAt(i)).errorOccured(errorEvent);
        }
    }

    public void addListener(ComputerPartEventListener computerPartEventListener) {
        this.listeners.addElement(computerPartEventListener);
    }

    public void removeListener(ComputerPartEventListener computerPartEventListener) {
        this.listeners.removeElement(computerPartEventListener);
    }

    public void notifyListeners(int n, short s) {
        ComputerPartEvent computerPartEvent = new ComputerPartEvent((ComputerPartGUI)this, n, s);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ComputerPartEventListener)this.listeners.elementAt(i)).valueChanged(computerPartEvent);
        }
    }

    public void notifyListeners() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ComputerPartEventListener)this.listeners.elementAt(i)).guiGainedFocus();
        }
    }

    public void pinValueChanged(PinValueEvent pinValueEvent) {
        this.pinsTable.setEnabled(true);
        if (pinValueEvent.getIsOk()) {
            this.pins[this.lastSelectedRow].value = this.translateValueToShort(pinValueEvent.getValueStr());
            this.valueStr[this.lastSelectedRow] = this.translateValueToString(this.pins[this.lastSelectedRow].value, this.pins[this.lastSelectedRow].width);
        }
        this.notifyListeners(this.lastSelectedRow, this.pins[this.lastSelectedRow].value);
    }

    public void flash(int n) {
        this.flashIndex = n;
        Utilities.tableCenterScroll((JPanel)this, (JTable)this.pinsTable, (int)n);
    }

    public void hideFlash() {
        this.flashIndex = -1;
        this.repaint();
    }

    public void highlight(int n) {
        this.highlightIndex.addElement(new Integer(n));
        this.repaint();
    }

    public void hideHighlight() {
        this.highlightIndex.removeAllElements();
        this.repaint();
    }

    public void setEnabledRange(int n, int n2, boolean bl) {
        this.startEnabling = n;
        this.endEnabling = n2;
    }

    public String getValueAsString(int n) {
        return this.valueStr[n];
    }

    public void setValueAt(int n, short s) {
        this.pins[n].value = s;
        this.valueStr[n] = this.translateValueToString(s, this.pins[n].width);
    }

    public Point getCoordinates(int n) {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        Rectangle rectangle = this.pinsTable.getCellRect(n, 1, true);
        this.pinsTable.scrollRectToVisible(rectangle);
        return new Point((int)(rectangle.getX() + this.topLevelLocation.getX()), (int)(rectangle.getY() + this.topLevelLocation.getY() - (double)jScrollBar.getValue()));
    }

    public Point getLocation(int n) {
        Rectangle rectangle = this.pinsTable.getCellRect(n, 0, true);
        Point point = Utilities.getTopLevelLocation((Component)this, (Component)this.pinsTable);
        return new Point((int)(rectangle.getX() + point.getX()), (int)(rectangle.getY() + point.getY()));
    }

    public void reset() {
        this.pinsTable.clearSelection();
        this.repaint();
        this.hideFlash();
        this.hideHighlight();
    }

    public void setContents(PinInfo[] pinInfoArray) {
        this.pins = new PinInfo[pinInfoArray.length];
        this.valueStr = new String[pinInfoArray.length];
        System.arraycopy(pinInfoArray, 0, this.pins, 0, pinInfoArray.length);
        for (int i = 0; i < pinInfoArray.length; ++i) {
            this.valueStr[i] = this.translateValueToString(pinInfoArray[i].value, pinInfoArray[i].width);
        }
        this.pinsTable.clearSelection();
        this.pinsTable.revalidate();
        this.repaint();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isEnabled && (mouseEvent.getModifiers() & 0x10) != 0) {
            if (this.binary.isVisible()) {
                this.binary.hideBinary();
                this.pinsTable.setEnabled(true);
                this.pinsTable.changeSelection(this.pinsTable.rowAtPoint(mouseEvent.getPoint()), this.pinsTable.columnAtPoint(mouseEvent.getPoint()), false, false);
                this.pinsTable.grabFocus();
            }
            if (mouseEvent.getClickCount() == 2 && this.dataFormat == 2) {
                this.pinsTable.setEnabled(false);
                this.binary.setLocation((int)this.getLocation(this.pinsTable.getSelectedRow() + 1).getX(), (int)this.getLocation(this.pinsTable.getSelectedRow() + 1).getY());
                this.binary.setValue(this.pins[this.pinsTable.getSelectedRow()].value);
                this.binary.setNumOfBits(this.pins[this.pinsTable.getSelectedRow()].width);
                this.binary.showBinary();
            }
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void setTopLevelLocation(Component component) {
        this.topLevelLocation = Utilities.getTopLevelLocation((Component)component, (Component)this.pinsTable);
    }

    protected void determineColumnWidth() {
        TableColumn tableColumn = null;
        for (int i = 0; i < 2; ++i) {
            tableColumn = this.pinsTable.getColumnModel().getColumn(i);
            if (i == 0) {
                tableColumn.setPreferredWidth(116);
                continue;
            }
            tableColumn.setPreferredWidth(124);
        }
    }

    public void setNumericFormat(int n) {
        this.dataFormat = n;
        for (int i = 0; i < this.pins.length; ++i) {
            this.valueStr[i] = this.translateValueToString(this.pins[i].value, this.pins[i].width);
        }
        this.repaint();
    }

    protected short translateValueToShort(String string) {
        return Format.translateValueToShort((String)string, (int)this.dataFormat);
    }

    protected String translateValueToString(short s, int n) {
        String string = null;
        if (s == this.nullValue && this.hideNullValue) {
            string = "";
        } else {
            string = Format.translateValueToString((short)s, (int)this.dataFormat);
            if (this.dataFormat == 2) {
                string = string.substring(string.length() - n, string.length());
            }
        }
        return string;
    }

    public void setVisibleRows(int n) {
        int n2 = n * this.pinsTable.getRowHeight();
        this.scrollPane.setSize(this.getTableWidth(), n2 + 3);
        this.setPreferredSize(new Dimension(this.getTableWidth(), n2 + 30));
        this.setSize(this.getTableWidth(), n2 + 30);
    }

    public int getTableWidth() {
        return 241;
    }

    private void jbInit() {
        this.pinsTable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                PinsComponent.this.pinsTable_focusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                PinsComponent.this.pinsTable_focusLost(focusEvent);
            }
        });
        this.pinsTable.addMouseListener(this);
        this.pinsTable.getTableHeader().setReorderingAllowed(false);
        this.pinsTable.getTableHeader().setResizingAllowed(false);
        this.setLayout(null);
        this.scrollPane = new JScrollPane(this.pinsTable);
        this.scrollPane.setLocation(0, 27);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.binary.setSize(new Dimension(240, 52));
        this.binary.setLayout(null);
        this.binary.setVisible(false);
        this.binary.addListener(this);
        this.determineColumnWidth();
        this.nameLbl.setText("Name :");
        this.nameLbl.setBounds(new Rectangle(3, 3, 102, 21));
        this.nameLbl.setFont(Utilities.labelsFont);
        this.pinsTable.setFont(Utilities.valueFont);
        this.add((Component)this.binary, null);
        this.add((Component)this.scrollPane, null);
        this.add((Component)this.nameLbl, null);
    }

    public void pinsTable_focusGained(FocusEvent focusEvent) {
        this.notifyListeners();
    }

    public void pinsTable_focusLost(FocusEvent focusEvent) {
        this.lastSelectedRow = this.pinsTable.getSelectedRow();
        this.pinsTable.clearSelection();
    }

    class PinsTableCellRenderer
    extends DefaultTableCellRenderer {
        PinsTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            this.setEnabled(jTable == null || jTable.isEnabled());
            if (n2 == 0) {
                this.setHorizontalAlignment(0);
                this.setForeground(null);
                this.setBackground(null);
            } else {
                this.setHorizontalAlignment(4);
                for (int i = 0; i < PinsComponent.this.highlightIndex.size(); ++i) {
                    if (n == (Integer)PinsComponent.this.highlightIndex.elementAt(i)) {
                        this.setForeground(Color.blue);
                        break;
                    }
                    this.setForeground(null);
                }
                if (n == PinsComponent.this.flashIndex) {
                    this.setBackground(Color.orange);
                } else {
                    this.setBackground(null);
                }
            }
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            return this;
        }
    }

    class PinsTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Name", "Value"};

        PinsTableModel() {
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return PinsComponent.this.pins.length;
        }

        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return ((PinsComponent)PinsComponent.this).pins[n].name + (((PinsComponent)PinsComponent.this).pins[n].width > 1 ? "[" + ((PinsComponent)PinsComponent.this).pins[n].width + "]" : "");
            }
            return PinsComponent.this.valueStr[n];
        }

        public boolean isCellEditable(int n, int n2) {
            return PinsComponent.this.isEnabled && n2 == 1 && PinsComponent.this.dataFormat != 2 && (PinsComponent.this.endEnabling == -1 || n >= PinsComponent.this.startEnabling && n <= PinsComponent.this.endEnabling);
        }

        public void setValueAt(Object object, int n, int n2) {
            String string = (String)object;
            if (!PinsComponent.this.valueStr[n].equals(string)) {
                try {
                    ((PinsComponent)PinsComponent.this).valueStr[n] = string;
                    ((PinsComponent)PinsComponent.this).pins[n].value = string.equals("") && PinsComponent.this.hideNullValue ? PinsComponent.this.nullValue : Format.translateValueToShort((String)string, (int)PinsComponent.this.dataFormat);
                    PinsComponent.this.notifyListeners((short)n, ((PinsComponent)PinsComponent.this).pins[n].value);
                }
                catch (NumberFormatException numberFormatException) {
                    PinsComponent.this.notifyErrorListeners("Illegal value");
                    ((PinsComponent)PinsComponent.this).valueStr[n] = Format.translateValueToString((short)((PinsComponent)PinsComponent.this).pins[n].value, (int)PinsComponent.this.dataFormat);
                }
                PinsComponent.this.repaint();
            }
        }
    }
}

