/*
 * Decompiled with CFR 0.152.
 */
package SimulatorsGUI;

import Hack.VMEmulator.CalculatorGUI;
import HackGUI.Format;
import HackGUI.Utilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class StackCalculator
extends JPanel
implements CalculatorGUI {
    private JTextField firstInput = new JTextField();
    private JTextField command = new JTextField();
    private JTextField secondInput = new JTextField();
    private JTextField output = new JTextField();
    private static final BasicStroke wideStroke = new BasicStroke(3.0f);
    private static final BasicStroke regularStroke = new BasicStroke(1.0f);
    protected short nullValue;
    protected boolean hideNullValue;

    public StackCalculator() {
        this.jbInit();
    }

    public void disableUserInput() {
    }

    public void enableUserInput() {
    }

    public void setNullValue(short s, boolean bl) {
        this.nullValue = s;
        this.hideNullValue = bl;
    }

    protected String translateValueToString(short s) {
        if (this.hideNullValue) {
            if (s == this.nullValue) {
                return "";
            }
            return Format.translateValueToString((short)s, (int)0);
        }
        return Format.translateValueToString((short)s, (int)0);
    }

    public void hideCalculator() {
        this.setVisible(false);
    }

    public void showCalculator() {
        this.setVisible(true);
    }

    public void hideLeftInput() {
        this.firstInput.setVisible(false);
    }

    public void showLeftInput() {
        this.firstInput.setVisible(true);
    }

    public void setOperator(char c) {
        this.command.setText(String.valueOf(c));
    }

    public void hideFlash() {
        this.firstInput.setBackground(UIManager.getColor("Button.background"));
        this.secondInput.setBackground(UIManager.getColor("Button.background"));
        this.output.setBackground(UIManager.getColor("Button.background"));
    }

    public void flash(int n) {
        switch (n) {
            case 0: {
                this.firstInput.setBackground(Color.orange);
                break;
            }
            case 1: {
                this.secondInput.setBackground(Color.orange);
                break;
            }
            case 2: {
                this.output.setBackground(Color.orange);
            }
        }
    }

    public void hideHighlight() {
        this.firstInput.setForeground(Color.black);
        this.secondInput.setForeground(Color.black);
        this.output.setForeground(Color.black);
    }

    public void highlight(int n) {
        switch (n) {
            case 0: {
                this.firstInput.setForeground(Color.blue);
                break;
            }
            case 1: {
                this.secondInput.setForeground(Color.blue);
                break;
            }
            case 2: {
                this.output.setForeground(Color.blue);
            }
        }
    }

    public String getValueAsString(int n) {
        switch (n) {
            case 0: {
                return this.firstInput.getText();
            }
            case 1: {
                return this.secondInput.getText();
            }
            case 2: {
                return this.output.getText();
            }
        }
        return "";
    }

    public void reset() {
        this.firstInput.setText(this.translateValueToString(this.nullValue));
        this.secondInput.setText(this.translateValueToString(this.nullValue));
        this.output.setText(this.translateValueToString(this.nullValue));
        this.hideFlash();
        this.hideHighlight();
    }

    public Point getCoordinates(int n) {
        Point point = this.getLocation();
        switch (n) {
            case 0: {
                return new Point((int)(point.getX() + this.firstInput.getLocation().getX()), (int)(point.getY() + this.firstInput.getLocation().getY()));
            }
            case 1: {
                return new Point((int)(point.getX() + this.secondInput.getLocation().getX()), (int)(point.getY() + this.secondInput.getLocation().getY()));
            }
            case 2: {
                return new Point((int)(point.getX() + this.output.getLocation().getX()), (int)(point.getY() + this.output.getLocation().getY()));
            }
        }
        return null;
    }

    public void setValueAt(int n, short s) {
        String string = this.translateValueToString(s);
        switch (n) {
            case 0: {
                this.firstInput.setText(string);
                break;
            }
            case 1: {
                this.secondInput.setText(string);
                break;
            }
            case 2: {
                this.output.setText(string);
            }
        }
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(Color.black);
        graphics2D.setStroke(wideStroke);
        graphics2D.draw(new Line2D.Double(18.0, 60.0, 142.0, 60.0));
        graphics2D.setStroke(regularStroke);
    }

    public void setNumericFormat(int n) {
    }

    private void jbInit() {
        this.setLayout(null);
        this.firstInput.setHorizontalAlignment(4);
        this.firstInput.setBounds(new Rectangle(18, 8, 124, 19));
        this.firstInput.setBackground(UIManager.getColor("Button.background"));
        this.firstInput.setFont(Utilities.valueFont);
        this.command.setFont(Utilities.bigLabelsFont);
        this.command.setHorizontalAlignment(0);
        this.command.setBounds(new Rectangle(2, 34, 13, 19));
        this.command.setBackground(UIManager.getColor("Button.background"));
        this.command.setBorder(null);
        this.secondInput.setHorizontalAlignment(4);
        this.secondInput.setBounds(new Rectangle(18, 34, 124, 19));
        this.secondInput.setBackground(UIManager.getColor("Button.background"));
        this.secondInput.setFont(new Font("Courier New", 0, 12));
        this.output.setHorizontalAlignment(4);
        this.output.setBounds(new Rectangle(18, 70, 124, 19));
        this.output.setBackground(UIManager.getColor("Button.background"));
        this.output.setFont(Utilities.valueFont);
        this.add((Component)this.secondInput, null);
        this.add((Component)this.firstInput, null);
        this.add((Component)this.output, null);
        this.add((Component)this.command, null);
    }
}

