/*
 * Decompiled with CFR 0.152.
 */
package Hack.Assembler;

import Hack.Assembler.AssemblerException;
import Hack.Assembler.AssemblyLineTokenizer;
import Hack.Assembler.HackAssemblerGUI;
import Hack.Assembler.HackAssemblerTranslator;
import Hack.ComputerParts.TextFileEvent;
import Hack.ComputerParts.TextFileGUI;
import Hack.Translators.HackTranslator;
import Hack.Translators.HackTranslatorEvent;
import Hack.Translators.HackTranslatorException;
import Hack.Translators.HackTranslatorGUI;
import Hack.Utilities.Conversions;
import Hack.Utilities.Definitions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;

public class HackAssembler
extends HackTranslator {
    private BufferedReader comparisonReader;
    private String comparisonFileName;
    private Hashtable symbolTable;
    private short[] comparisonProgram;
    private HackAssemblerTranslator translator;
    private short varIndex;

    public HackAssembler(String string, int n, short s, boolean bl) throws HackTranslatorException {
        super(string, n, s, bl);
    }

    public HackAssembler(HackAssemblerGUI hackAssemblerGUI, int n, short s, String string) throws HackTranslatorException {
        super((HackTranslatorGUI)hackAssemblerGUI, n, s, string);
        hackAssemblerGUI.enableLoadComparison();
        hackAssemblerGUI.hideComparison();
    }

    protected String getSourceExtension() {
        return "asm";
    }

    protected String getDestinationExtension() {
        return "hack";
    }

    protected String getName() {
        return "Assembler";
    }

    protected void init(int n, short s) {
        super.init(n, s);
        this.translator = HackAssemblerTranslator.getInstance();
    }

    private void checkComparisonFile(String string) throws HackTranslatorException {
        if (!string.endsWith("." + this.getDestinationExtension())) {
            throw new HackTranslatorException(string + " is not a ." + this.getDestinationExtension() + " file");
        }
        File file = new File(string);
        if (!file.exists()) {
            throw new HackTranslatorException("File " + string + " does not exist");
        }
    }

    protected void restartCompilation() {
        super.restartCompilation();
        this.varIndex = (short)16;
        if (this.gui != null) {
            ((HackAssemblerGUI)this.gui).enableLoadComparison();
        }
    }

    private void resetComparisonFile() throws HackTranslatorException {
        try {
            this.comparisonReader = new BufferedReader(new FileReader(this.comparisonFileName));
            if (this.gui != null) {
                TextFileGUI textFileGUI = ((HackAssemblerGUI)this.gui).getComparison();
                textFileGUI.reset();
                textFileGUI.setContents(this.comparisonFileName);
                this.comparisonProgram = new short[textFileGUI.getNumberOfLines()];
                for (int i = 0; i < textFileGUI.getNumberOfLines(); ++i) {
                    if (textFileGUI.getLineAt(i).length() != 16) {
                        throw new HackTranslatorException("Error in file " + this.comparisonFileName + ": Line " + i + " does not contain exactly " + 16 + " characters");
                    }
                    try {
                        this.comparisonProgram[i] = (short)Conversions.binaryToInt((String)textFileGUI.getLineAt(i));
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new HackTranslatorException("Error in file " + this.comparisonFileName + ": Line " + i + " does not contain only 1/0 characters");
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new HackTranslatorException("Error reading from file " + this.comparisonFileName);
        }
    }

    protected void initSource() throws HackTranslatorException {
        this.generateSymbolTable();
    }

    private void generateSymbolTable() throws HackTranslatorException {
        this.symbolTable = Definitions.getInstance().getAddressesTable();
        short s = 0;
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.sourceFileName));
            while ((string = bufferedReader.readLine()) != null) {
                AssemblyLineTokenizer assemblyLineTokenizer = new AssemblyLineTokenizer(string);
                if (assemblyLineTokenizer.isEnd()) continue;
                if (assemblyLineTokenizer.isToken("(")) {
                    assemblyLineTokenizer.advance(true);
                    String string2 = assemblyLineTokenizer.token();
                    assemblyLineTokenizer.advance(true);
                    if (!assemblyLineTokenizer.isToken(")")) {
                        this.error("')' expected");
                    }
                    assemblyLineTokenizer.ensureEnd();
                    this.symbolTable.put(string2, new Short(s));
                    continue;
                }
                if (assemblyLineTokenizer.contains("[")) {
                    s = (short)(s + 2);
                    continue;
                }
                s = (short)(s + 1);
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            throw new HackTranslatorException("Error reading from file " + this.sourceFileName);
        }
    }

    protected void initCompilation() throws HackTranslatorException {
        if (this.gui != null && (this.inFullCompilation || !this.compilationStarted)) {
            ((HackAssemblerGUI)this.gui).disableLoadComparison();
        }
    }

    protected void successfulCompilation() throws HackTranslatorException {
        if (this.comparisonReader == null) {
            super.successfulCompilation();
        } else if (this.gui != null) {
            ((HackAssemblerGUI)this.gui).displayMessage("File compilation & comparison succeeded", false);
        }
    }

    protected int[] compileLineAndCount(String string) throws HackTranslatorException {
        int[] nArray = super.compileLineAndCount(string);
        if (nArray != null && this.comparisonReader != null) {
            int n = nArray[1] - nArray[0] + 1;
            boolean bl = this.compare(nArray);
            if (this.inFullCompilation) {
                if (!bl && this.gui != null) {
                    this.programSize = this.destPC + n - 1;
                    this.showProgram(this.programSize);
                    this.gui.getSource().addHighlight(this.sourcePC, true);
                    this.gui.getDestination().addHighlight(this.destPC - 1, true);
                    ((HackAssemblerGUI)this.gui).getComparison().addHighlight(this.destPC - 1, true);
                    this.gui.enableRewind();
                    this.gui.enableLoadSource();
                }
            } else if (bl) {
                ((HackAssemblerGUI)this.gui).getComparison().addHighlight(this.destPC + n - 2, true);
            } else {
                this.gui.getDestination().addHighlight(this.destPC - 1, true);
                ((HackAssemblerGUI)this.gui).getComparison().addHighlight(this.destPC - 1, true);
            }
            if (!bl) {
                throw new HackTranslatorException("Comparison failure");
            }
        }
        return nArray;
    }

    private boolean compare(int[] nArray) {
        boolean bl = true;
        int n = nArray[1] - nArray[0] + 1;
        for (int i = 0; i < n && bl; ++i) {
            bl = this.program[nArray[0] + i] == this.comparisonProgram[nArray[0] + i];
        }
        return bl;
    }

    protected String getCodeString(short s, int n, boolean bl) {
        return Conversions.decimalToBinary((int)s, (int)16);
    }

    protected void fastForward() {
        ((HackAssemblerGUI)this.gui).disableLoadComparison();
        super.fastForward();
    }

    protected void hidePointers() {
        super.hidePointers();
        if (this.comparisonReader != null) {
            ((HackAssemblerGUI)this.gui).getComparison().clearHighlights();
        }
    }

    protected void end(boolean bl) {
        super.end(bl);
        ((HackAssemblerGUI)this.gui).disableLoadComparison();
    }

    protected void stop() {
        super.stop();
        ((HackAssemblerGUI)this.gui).disableLoadComparison();
    }

    protected void rewind() {
        super.rewind();
        if (this.comparisonReader != null) {
            ((HackAssemblerGUI)this.gui).getComparison().clearHighlights();
            ((HackAssemblerGUI)this.gui).getComparison().hideSelect();
        }
    }

    protected void compileLine(String string) throws HackTranslatorException {
        block13: {
            try {
                AssemblyLineTokenizer assemblyLineTokenizer = new AssemblyLineTokenizer(string);
                if (assemblyLineTokenizer.isEnd() || assemblyLineTokenizer.isToken("(")) break block13;
                if (assemblyLineTokenizer.isToken("@")) {
                    assemblyLineTokenizer.advance(true);
                    boolean bl = true;
                    String string2 = assemblyLineTokenizer.token();
                    assemblyLineTokenizer.ensureEnd();
                    try {
                        Short.parseShort(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        bl = false;
                    }
                    if (!bl) {
                        Short s = (Short)this.symbolTable.get(string2);
                        if (s == null) {
                            short s2 = this.varIndex;
                            this.varIndex = (short)(s2 + 1);
                            s = new Short(s2);
                            this.symbolTable.put(string2, s);
                        }
                        this.addCommand(this.translator.textToCode("@" + s));
                    } else {
                        this.addCommand(this.translator.textToCode(string));
                    }
                    break block13;
                }
                try {
                    this.addCommand(this.translator.textToCode(string));
                }
                catch (AssemblerException assemblerException) {
                    int n = string.indexOf("[");
                    if (n >= 0) {
                        int n2 = string.lastIndexOf("[");
                        int n3 = string.indexOf("]");
                        if (n != n2 || n > n3 || n + 1 == n3) {
                            throw new AssemblerException("Illegal use of the [] notation");
                        }
                        String string3 = string.substring(n + 1, n3);
                        this.compileLine("@" + string3);
                        this.compileLine(string.substring(0, n).concat(string.substring(n3 + 1)));
                        break block13;
                    }
                    throw new AssemblerException(assemblerException.getMessage());
                }
            }
            catch (IOException iOException) {
                throw new HackTranslatorException("Error reading from file " + this.sourceFileName);
            }
            catch (AssemblerException assemblerException) {
                throw new HackTranslatorException(assemblerException.getMessage(), this.sourcePC);
            }
        }
    }

    protected void finalizeCompilation() {
    }

    public void rowSelected(TextFileEvent textFileEvent) {
        super.rowSelected(textFileEvent);
        int[] nArray = this.rowIndexToRange(textFileEvent.getRowIndex());
        if (nArray != null) {
            if (this.comparisonReader != null) {
                ((HackAssemblerGUI)this.gui).getComparison().select(nArray[0], nArray[1]);
            }
        } else if (this.comparisonReader != null) {
            ((HackAssemblerGUI)this.gui).getComparison().hideSelect();
        }
    }

    public void actionPerformed(HackTranslatorEvent hackTranslatorEvent) {
        super.actionPerformed(hackTranslatorEvent);
        switch (hackTranslatorEvent.getAction()) {
            case 7: {
                this.comparisonFileName = "";
                this.comparisonReader = null;
                ((HackAssemblerGUI)this.gui).setComparisonName("");
                ((HackAssemblerGUI)this.gui).hideComparison();
                break;
            }
            case 9: {
                this.clearMessage();
                String string = (String)hackTranslatorEvent.getData();
                try {
                    this.checkComparisonFile(string);
                    this.comparisonFileName = string;
                    this.saveWorkingDir(new File(string));
                    this.resetComparisonFile();
                    ((HackAssemblerGUI)this.gui).showComparison();
                    break;
                }
                catch (HackTranslatorException hackTranslatorException) {
                    this.gui.displayMessage(hackTranslatorException.getMessage(), true);
                }
            }
        }
    }
}

