/*
 * Decompiled with CFR 0.152.
 */
package Hack.Assembler;

import Hack.Assembler.AssemblerException;
import Hack.Assembler.AssemblyLineTokenizer;
import Hack.Assembler.HackAssembler;
import Hack.Translators.HackTranslatorException;
import Hack.Utilities.Conversions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;

public class HackAssemblerTranslator {
    public static final short NOP = Short.MIN_VALUE;
    private static final Short ZERO = new Short(-5504);
    private static final Short ONE = new Short(-4160);
    private static final Short MINUS_ONE = new Short(-4480);
    private static final Short EXP_D = new Short(-7424);
    private static final Short NOT_D = new Short(-7360);
    private static final Short EXP_M = new Short(-1024);
    private static final Short EXP_A = new Short(-5120);
    private static final Short NOT_M = new Short(-960);
    private static final Short NOT_A = new Short(-5056);
    private static final Short MINUS_D = new Short(-7232);
    private static final Short MINUS_M = new Short(-832);
    private static final Short MINUS_A = new Short(-4928);
    private static final Short D_PLUS_ONE = new Short(-6208);
    private static final Short M_PLUS_ONE = new Short(-576);
    private static final Short A_PLUS_ONE = new Short(-4672);
    private static final Short D_MINUS_ONE = new Short(-7296);
    private static final Short M_MINUS_ONE = new Short(-896);
    private static final Short A_MINUS_ONE = new Short(-4992);
    private static final Short D_PLUS_M = new Short(-3968);
    private static final Short D_PLUS_A = new Short(-8064);
    private static final Short D_MINUS_M = new Short(-2880);
    private static final Short D_MINUS_A = new Short(-6976);
    private static final Short M_MINUS_D = new Short(-3648);
    private static final Short A_MINUS_D = new Short(-7744);
    private static final Short D_AND_M = new Short(-4096);
    private static final Short D_AND_A = new Short(-8192);
    private static final Short D_OR_M = new Short(-2752);
    private static final Short D_OR_A = new Short(-6848);
    private static final Short A = new Short(32);
    private static final Short M = new Short(8);
    private static final Short D = new Short(16);
    private static final Short AM = new Short(40);
    private static final Short AD = new Short(48);
    private static final Short MD = new Short(24);
    private static final Short AMD = new Short(56);
    private static final Short JMP = new Short(7);
    private static final Short JMP_LESS_THEN = new Short(4);
    private static final Short JMP_EQUAL = new Short(2);
    private static final Short JMP_GREATER_THEN = new Short(1);
    private static final Short JMP_NOT_EQUAL = new Short(5);
    private static final Short JMP_LESS_EQUAL = new Short(6);
    private static final Short JMP_GREATER_EQUAL = new Short(3);
    private static HackAssemblerTranslator instance;
    private Hashtable expToCode;
    private Hashtable destToCode;
    private Hashtable jmpToCode;
    private Hashtable expToText;
    private Hashtable destToText;
    private Hashtable jmpToText;

    private HackAssemblerTranslator() {
        instance = this;
        this.initExp();
        this.initDest();
        this.initJmp();
    }

    public static HackAssemblerTranslator getInstance() {
        if (instance == null) {
            new HackAssemblerTranslator();
        }
        return instance;
    }

    public short getExpByText(String string) throws AssemblerException {
        Short s = (Short)this.expToCode.get(string);
        if (s == null) {
            throw new AssemblerException("Illegal exp: " + string);
        }
        return s;
    }

    public String getExpByCode(short s) throws AssemblerException {
        String string = (String)this.expToText.get(new Short(s));
        if (string == null) {
            throw new AssemblerException("Illegal exp: " + s);
        }
        return string;
    }

    public short getDestByText(String string) throws AssemblerException {
        Short s = (Short)this.destToCode.get(string);
        if (s == null) {
            throw new AssemblerException("Illegal dest: " + string);
        }
        return s;
    }

    public String getDestByCode(short s) throws AssemblerException {
        String string = (String)this.destToText.get(new Short(s));
        if (string == null) {
            throw new AssemblerException("Illegal dest: " + s);
        }
        return string;
    }

    public short getJmpByText(String string) throws AssemblerException {
        Short s = (Short)this.jmpToCode.get(string);
        if (s == null) {
            throw new AssemblerException("Illegal jmp: " + string);
        }
        return s;
    }

    public String getJmpByCode(short s) throws AssemblerException {
        String string = (String)this.jmpToText.get(new Short(s));
        if (string == null) {
            throw new AssemblerException("Illegal jmp: " + s);
        }
        return string;
    }

    public short textToCode(String string) throws AssemblerException {
        short s;
        block12: {
            s = 0;
            short s2 = 0;
            int n = 0;
            short s3 = 0;
            try {
                Short s4;
                AssemblyLineTokenizer assemblyLineTokenizer = new AssemblyLineTokenizer(string);
                if (assemblyLineTokenizer.isToken("@")) {
                    assemblyLineTokenizer.advance(true);
                    try {
                        s = Short.parseShort(assemblyLineTokenizer.token());
                        break block12;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new AssemblerException("A numeric value is expected");
                    }
                }
                String string2 = assemblyLineTokenizer.token();
                assemblyLineTokenizer.advance(false);
                if (assemblyLineTokenizer.isToken("=")) {
                    s4 = (Short)this.destToCode.get(string2);
                    if (s4 == null) {
                        throw new AssemblerException("Destination expected");
                    }
                    s3 = s4;
                    assemblyLineTokenizer.advance(true);
                }
                if ((s4 = !string2.equals("=") && s3 == 0 ? (Short)this.expToCode.get(string2) : (Short)this.expToCode.get(assemblyLineTokenizer.token())) == null) {
                    throw new AssemblerException("Expression expected");
                }
                s2 = s4;
                assemblyLineTokenizer.advance(false);
                if (assemblyLineTokenizer.isToken(";")) {
                    assemblyLineTokenizer.advance(false);
                }
                if (!assemblyLineTokenizer.isEnd()) {
                    Short s5 = (Short)this.jmpToCode.get(assemblyLineTokenizer.token());
                    if (s5 == null) {
                        throw new AssemblerException("Jump directive expected");
                    }
                    n = s5.shortValue();
                    assemblyLineTokenizer.ensureEnd();
                }
                s = (short)(s3 + s2 + n);
            }
            catch (IOException iOException) {
                throw new AssemblerException("Error while parsing assembly line");
            }
            catch (HackTranslatorException hackTranslatorException) {
                throw new AssemblerException(hackTranslatorException.getMessage());
            }
        }
        return s;
    }

    public String codeToText(short s) throws AssemblerException {
        StringBuffer stringBuffer = new StringBuffer();
        if (s != Short.MIN_VALUE) {
            if ((s & 0x8000) == 0) {
                stringBuffer.append('@');
                stringBuffer.append(s);
            } else {
                short s2 = (short)(s & 0xFFC0);
                short s3 = (short)(s & 0x38);
                short s4 = (short)(s & 7);
                String string = this.getExpByCode(s2);
                if (!string.equals("")) {
                    if (s3 != 0) {
                        stringBuffer.append(this.getDestByCode(s3));
                        stringBuffer.append('=');
                    }
                    stringBuffer.append(string);
                    if (s4 != 0) {
                        stringBuffer.append(';');
                        stringBuffer.append(this.getJmpByCode(s4));
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    public static short[] loadProgram(String string, int n, short s) throws AssemblerException {
        short[] sArray = null;
        File file = new File(string);
        if (!file.exists()) {
            throw new AssemblerException(string + " doesn't exist");
        }
        if (string.endsWith(".hack")) {
            sArray = new short[n];
            for (int i = 0; i < n; ++i) {
                sArray[i] = s;
            }
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                int n2 = 0;
                while ((string2 = bufferedReader.readLine()) != null) {
                    short s2 = 0;
                    if (n2 >= n) {
                        throw new AssemblerException("Program too large");
                    }
                    try {
                        s2 = (short)Conversions.binaryToInt((String)string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new AssemblerException("Illegal character");
                    }
                    sArray[n2++] = s2;
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                throw new AssemblerException("IO error while reading " + string);
            }
        }
        if (string.endsWith(".asm")) {
            try {
                HackAssembler hackAssembler = new HackAssembler(string, n, s, false);
                sArray = hackAssembler.getProgram();
            }
            catch (HackTranslatorException hackTranslatorException) {
                throw new AssemblerException(hackTranslatorException.getMessage());
            }
        } else {
            throw new AssemblerException(string + " is not a .hack or .asm file");
        }
        return sArray;
    }

    private void initExp() {
        this.expToCode = new Hashtable();
        this.expToText = new Hashtable();
        this.expToCode.put("0", ZERO);
        this.expToCode.put("1", ONE);
        this.expToCode.put("-1", MINUS_ONE);
        this.expToCode.put("D", EXP_D);
        this.expToCode.put("!D", NOT_D);
        this.expToCode.put("NOTD", NOT_D);
        this.expToCode.put("M", EXP_M);
        this.expToCode.put("A", EXP_A);
        this.expToCode.put("!M", NOT_M);
        this.expToCode.put("NOTM", NOT_M);
        this.expToCode.put("!A", NOT_A);
        this.expToCode.put("NOTA", NOT_A);
        this.expToCode.put("-D", MINUS_D);
        this.expToCode.put("-M", MINUS_M);
        this.expToCode.put("-A", MINUS_A);
        this.expToCode.put("D+1", D_PLUS_ONE);
        this.expToCode.put("M+1", M_PLUS_ONE);
        this.expToCode.put("A+1", A_PLUS_ONE);
        this.expToCode.put("D-1", D_MINUS_ONE);
        this.expToCode.put("M-1", M_MINUS_ONE);
        this.expToCode.put("A-1", A_MINUS_ONE);
        this.expToCode.put("D+M", D_PLUS_M);
        this.expToCode.put("M+D", D_PLUS_M);
        this.expToCode.put("D+A", D_PLUS_A);
        this.expToCode.put("A+D", D_PLUS_A);
        this.expToCode.put("D-M", D_MINUS_M);
        this.expToCode.put("D-A", D_MINUS_A);
        this.expToCode.put("M-D", M_MINUS_D);
        this.expToCode.put("A-D", A_MINUS_D);
        this.expToCode.put("D&M", D_AND_M);
        this.expToCode.put("M&D", D_AND_M);
        this.expToCode.put("D&A", D_AND_A);
        this.expToCode.put("A&D", D_AND_A);
        this.expToCode.put("D|M", D_OR_M);
        this.expToCode.put("M|D", D_OR_M);
        this.expToCode.put("D|A", D_OR_A);
        this.expToCode.put("A|D", D_OR_A);
        this.expToText.put(ZERO, "0");
        this.expToText.put(ONE, "1");
        this.expToText.put(MINUS_ONE, "-1");
        this.expToText.put(EXP_D, "D");
        this.expToText.put(NOT_D, "!D");
        this.expToText.put(EXP_M, "M");
        this.expToText.put(EXP_A, "A");
        this.expToText.put(NOT_M, "!M");
        this.expToText.put(NOT_A, "!A");
        this.expToText.put(MINUS_D, "-D");
        this.expToText.put(MINUS_M, "-M");
        this.expToText.put(MINUS_A, "-A");
        this.expToText.put(D_PLUS_ONE, "D+1");
        this.expToText.put(M_PLUS_ONE, "M+1");
        this.expToText.put(A_PLUS_ONE, "A+1");
        this.expToText.put(D_MINUS_ONE, "D-1");
        this.expToText.put(M_MINUS_ONE, "M-1");
        this.expToText.put(A_MINUS_ONE, "A-1");
        this.expToText.put(D_PLUS_M, "D+M");
        this.expToText.put(D_PLUS_A, "D+A");
        this.expToText.put(D_MINUS_M, "D-M");
        this.expToText.put(D_MINUS_A, "D-A");
        this.expToText.put(M_MINUS_D, "M-D");
        this.expToText.put(A_MINUS_D, "A-D");
        this.expToText.put(D_AND_M, "D&M");
        this.expToText.put(D_AND_A, "D&A");
        this.expToText.put(D_OR_M, "D|M");
        this.expToText.put(D_OR_A, "D|A");
    }

    private void initDest() {
        this.destToCode = new Hashtable();
        this.destToText = new Hashtable();
        this.destToCode.put("A", A);
        this.destToCode.put("M", M);
        this.destToCode.put("D", D);
        this.destToCode.put("AM", AM);
        this.destToCode.put("AD", AD);
        this.destToCode.put("MD", MD);
        this.destToCode.put("AMD", AMD);
        this.destToText.put(A, "A");
        this.destToText.put(M, "M");
        this.destToText.put(D, "D");
        this.destToText.put(AM, "AM");
        this.destToText.put(AD, "AD");
        this.destToText.put(MD, "MD");
        this.destToText.put(AMD, "AMD");
    }

    private void initJmp() {
        this.jmpToCode = new Hashtable();
        this.jmpToText = new Hashtable();
        this.jmpToCode.put("JMP", JMP);
        this.jmpToCode.put("JLT", JMP_LESS_THEN);
        this.jmpToCode.put("JEQ", JMP_EQUAL);
        this.jmpToCode.put("JGT", JMP_GREATER_THEN);
        this.jmpToCode.put("JNE", JMP_NOT_EQUAL);
        this.jmpToCode.put("JLE", JMP_LESS_EQUAL);
        this.jmpToCode.put("JGE", JMP_GREATER_EQUAL);
        this.jmpToText.put(JMP, "JMP");
        this.jmpToText.put(JMP_LESS_THEN, "JLT");
        this.jmpToText.put(JMP_EQUAL, "JEQ");
        this.jmpToText.put(JMP_GREATER_THEN, "JGT");
        this.jmpToText.put(JMP_NOT_EQUAL, "JNE");
        this.jmpToText.put(JMP_LESS_EQUAL, "JLE");
        this.jmpToText.put(JMP_GREATER_EQUAL, "JGE");
    }
}

