/*
 * Decompiled with CFR 0.152.
 */
package Hack.Compiler;

import Hack.Compiler.IdentifierProperties;
import Hack.Compiler.JackException;
import java.util.HashMap;

public class SymbolTable {
    public static final int KIND_STATIC = 0;
    public static final int KIND_FIELD = 1;
    public static final int KIND_PARAMETER = 2;
    public static final int KIND_LOCAL = 3;
    public static final int SUBROUTINE_TYPE_UNDEFINED = 0;
    public static final int SUBROUTINE_TYPE_METHOD = 1;
    public static final int SUBROUTINE_TYPE_FUNCTION = 2;
    public static final int SUBROUTINE_TYPE_CONSTRUCTOR = 3;
    private static short staticsNumbering;
    private static short fieldsNumbering;
    private static short parametersNumbering;
    private static short localsNumbering;
    private String className;
    private String subroutineName;
    private int subroutineType;
    private String returnType;
    private HashMap fields;
    private HashMap parameters;
    private HashMap locals;
    private HashMap statics;

    public SymbolTable(String string) {
        this.className = string;
        this.fields = new HashMap();
        this.statics = new HashMap();
        this.parameters = new HashMap();
        this.locals = new HashMap();
        fieldsNumbering = 0;
        staticsNumbering = 0;
        localsNumbering = 0;
        parametersNumbering = 1;
        this.subroutineType = 0;
    }

    public void startMethod(String string, String string2) {
        this.startSubroutine(string, 1, string2, (short)1);
    }

    public void startFunction(String string, String string2) {
        this.startSubroutine(string, 2, string2, (short)0);
    }

    public void startConstructor(String string) {
        this.startSubroutine(string, 3, this.className, (short)0);
    }

    public void endSubroutine() {
        this.parameters.clear();
        this.locals.clear();
        localsNumbering = 0;
        parametersNumbering = 1;
        this.subroutineType = 0;
        this.subroutineName = null;
        this.returnType = null;
    }

    private void startSubroutine(String string, int n, String string2, short s) {
        this.endSubroutine();
        this.subroutineName = string;
        this.subroutineType = n;
        this.returnType = string2;
        parametersNumbering = s;
    }

    public void define(String string, String string2, int n) {
        switch (n) {
            case 0: {
                this.statics.put(string, new IdentifierProperties(string2, staticsNumbering));
                staticsNumbering = (short)(staticsNumbering + 1);
                break;
            }
            case 1: {
                this.fields.put(string, new IdentifierProperties(string2, fieldsNumbering));
                fieldsNumbering = (short)(fieldsNumbering + 1);
                break;
            }
            case 2: {
                this.parameters.put(string, new IdentifierProperties(string2, parametersNumbering));
                parametersNumbering = (short)(parametersNumbering + 1);
                break;
            }
            case 3: {
                this.locals.put(string, new IdentifierProperties(string2, localsNumbering));
                localsNumbering = (short)(localsNumbering + 1);
            }
        }
    }

    public int getKindOf(String string) throws JackException {
        int n;
        if (this.parameters.containsKey(string)) {
            n = 2;
        } else if (this.locals.containsKey(string)) {
            n = 3;
        } else if (this.subroutineType != 2 && this.fields.containsKey(string)) {
            n = 1;
        } else if (this.statics.containsKey(string)) {
            n = 0;
        } else {
            throw new JackException(string);
        }
        return n;
    }

    public String getTypeOf(String string) throws JackException {
        return this.getIdentifierProperties(string).getType();
    }

    public short getIndexOf(String string) throws JackException {
        return this.getIdentifierProperties(string).getIndex();
    }

    public short getNumberOfIdentifiers(int n) {
        short s = -1;
        switch (n) {
            case 0: {
                s = staticsNumbering;
                break;
            }
            case 1: {
                s = fieldsNumbering;
                break;
            }
            case 2: {
                s = (short)(parametersNumbering - 1);
                break;
            }
            case 3: {
                s = localsNumbering;
            }
        }
        return s;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSubroutineName() {
        return this.subroutineName;
    }

    public String getReturnType() {
        return this.returnType;
    }

    private IdentifierProperties getIdentifierProperties(String string) throws JackException {
        IdentifierProperties identifierProperties = null;
        switch (this.getKindOf(string)) {
            case 2: {
                identifierProperties = (IdentifierProperties)this.parameters.get(string);
                break;
            }
            case 3: {
                identifierProperties = (IdentifierProperties)this.locals.get(string);
                break;
            }
            case 1: {
                identifierProperties = (IdentifierProperties)this.fields.get(string);
                break;
            }
            case 0: {
                identifierProperties = (IdentifierProperties)this.statics.get(string);
            }
        }
        return identifierProperties;
    }
}

