/*
 * Decompiled with CFR 0.152.
 */
package Hack.Controller;

import Hack.Controller.Breakpoint;
import Hack.Controller.Command;
import Hack.Controller.CommandException;
import Hack.Controller.ControllerEvent;
import Hack.Controller.ControllerEventListener;
import Hack.Controller.ControllerException;
import Hack.Controller.ControllerGUI;
import Hack.Controller.HackSimulator;
import Hack.Controller.ProgramException;
import Hack.Controller.Script;
import Hack.Controller.ScriptCondition;
import Hack.Controller.ScriptException;
import Hack.Controller.VariableException;
import Hack.Controller.VariableFormat;
import Hack.Events.ProgramEvent;
import Hack.Events.ProgramEventListener;
import Hack.Utilities.Conversions;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.StringCharacterIterator;
import java.util.Vector;
import javax.swing.Timer;

public class HackController
implements ControllerEventListener,
ActionListener,
ProgramEventListener {
    public static final int NUMBER_OF_SPEED_UNITS = 5;
    public static final float[] SPEED_FUNCTION = new float[]{0.0f, 0.35f, 0.63f, 0.87f, 1.0f};
    public static final int[] FASTFORWARD_SPEED_FUNCTION = new int[]{500, 1000, 2000, 4000, 15000};
    public static final int DISPLAY_CHANGES = 0;
    public static final int ANIMATION = 1;
    public static final int NO_DISPLAY_CHANGES = 2;
    public static final int DECIMAL_FORMAT = 0;
    public static final int HEXA_FORMAT = 1;
    public static final int BINARY_FORMAT = 2;
    public static final int SCRIPT_ADDITIONAL_DISPLAY = 0;
    public static final int OUTPUT_ADDITIONAL_DISPLAY = 1;
    public static final int COMPARISON_ADDITIONAL_DISPLAY = 2;
    public static final int NO_ADDITIONAL_DISPLAY = 3;
    private static final String INITIAL_SCRIPT_DIR = "scripts";
    private static final int MAX_MS = 2500;
    private static final int MIN_MS = 25;
    private static final int INITIAL_SPEED_UNIT = 3;
    private static final String SPACES = "                                        ";
    protected ControllerGUI gui;
    private File currentScriptFile;
    private String currentOutputName;
    private String currentComparisonName;
    private Script script;
    protected HackSimulator simulator;
    private int currentSpeedUnit;
    private int animationMode;
    private int currentCommandIndex;
    private PrintWriter output;
    private BufferedReader comparisonFile;
    private int loopCommandIndex;
    private int repeatCounter;
    private ScriptCondition whileCondititon;
    private VariableFormat[] varList;
    private Vector breakpoints;
    private int compareLinesCounter;
    private int outputLinesCounter;
    private Timer timer;
    protected boolean singleStepLocked;
    private SingleStepTask singleStepTask;
    private FastForwardTask fastForwardTask;
    private SetAnimationModeTask setAnimationModeTask;
    private SetNumericFormatTask setNumericFormatTask;
    private boolean fastForwardRunning;
    private boolean singleStepRunning;
    private boolean scriptEnded;
    private boolean programHalted;
    private int[] delays;
    private boolean comparisonFailed;
    private int comparisonFailureLine;
    private String lastEcho;
    private File defaultScriptFile;

    public HackController(HackSimulator hackSimulator, String string) {
        File file = new File(string);
        if (!file.exists()) {
            this.displayMessage(string + " doesn't exist", true);
        }
        this.simulator = hackSimulator;
        this.animationMode = 2;
        hackSimulator.setAnimationMode(this.animationMode);
        hackSimulator.addListener(this);
        this.breakpoints = new Vector();
        try {
            this.loadNewScript(file, false);
            this.saveWorkingDir(file);
        }
        catch (ScriptException scriptException) {
            this.displayMessage(scriptException.getMessage(), true);
        }
        catch (ControllerException controllerException) {
            this.displayMessage(controllerException.getMessage(), true);
        }
        this.fastForwardRunning = true;
        while (this.fastForwardRunning) {
            this.singleStep();
        }
    }

    public HackController(ControllerGUI controllerGUI, HackSimulator hackSimulator, String string) throws ScriptException, ControllerException {
        this.gui = controllerGUI;
        this.simulator = hackSimulator;
        this.singleStepTask = new SingleStepTask();
        this.fastForwardTask = new FastForwardTask();
        this.setAnimationModeTask = new SetAnimationModeTask();
        this.setNumericFormatTask = new SetNumericFormatTask();
        hackSimulator.addListener(this);
        hackSimulator.addProgramListener(this);
        this.breakpoints = new Vector();
        this.defaultScriptFile = new File(string);
        this.loadNewScript(this.defaultScriptFile, false);
        this.delays = new int[5];
        for (int i = 0; i < 5; ++i) {
            this.delays[i] = (int)(2500.0f - SPEED_FUNCTION[i] * 2475.0f);
        }
        this.currentSpeedUnit = 3;
        this.animationMode = hackSimulator.getInitialAnimationMode();
        hackSimulator.setAnimationMode(this.animationMode);
        hackSimulator.setAnimationSpeed(3);
        hackSimulator.setNumericFormat(hackSimulator.getInitialNumericFormat());
        this.timer = new Timer(this.delays[this.currentSpeedUnit - 1], this);
        controllerGUI.setSimulator(hackSimulator.getGUI());
        controllerGUI.setTitle(hackSimulator.getName() + HackController.getVersionString());
        File file = this.loadWorkingDir();
        hackSimulator.setWorkingDir(file);
        controllerGUI.setWorkingDir(file);
        controllerGUI.addControllerListener(this);
        controllerGUI.setSpeed(this.currentSpeedUnit);
        controllerGUI.setAnimationMode(this.animationMode);
        controllerGUI.setNumericFormat(hackSimulator.getInitialNumericFormat());
        controllerGUI.setAdditionalDisplay(hackSimulator.getInitialAdditionalDisplay());
        controllerGUI.setVariables(hackSimulator.getVariables());
        this.stopMode();
        hackSimulator.prepareGUI();
    }

    private void rewind() {
        try {
            if (this.scriptEnded || this.programHalted) {
                this.gui.enableSingleStep();
                this.gui.enableFastForward();
            }
            this.scriptEnded = false;
            this.programHalted = false;
            int n = this.animationMode;
            this.setAnimationMode(0);
            this.simulator.restart();
            this.refreshSimulator();
            this.setAnimationMode(n);
            if (this.output != null) {
                this.resetOutputFile();
            }
            if (this.comparisonFile != null) {
                this.resetComparisonFile();
            }
            this.lastEcho = "";
            this.currentCommandIndex = 0;
            this.gui.setCurrentScriptLine(this.script.getLineNumberAt(0));
        }
        catch (ControllerException controllerException) {
            this.displayMessage(controllerException.getMessage(), true);
        }
    }

    private void stopMode() {
        if (this.fastForwardRunning) {
            if (this.gui != null) {
                this.timer.stop();
                this.gui.enableLoadProgram();
                this.gui.enableSpeedSlider();
            }
            this.fastForwardRunning = false;
        }
        this.singleStepRunning = false;
        if (this.gui != null) {
            this.gui.enableSingleStep();
            this.gui.enableFastForward();
            this.gui.enableScript();
            this.gui.enableRewind();
            this.gui.disableStop();
            this.gui.enableAnimationModes();
            if (this.animationMode == 2) {
                this.gui.setCurrentScriptLine(this.script.getLineNumberAt(this.currentCommandIndex));
            }
            this.refreshSimulator();
        }
    }

    private void fastForward() {
        this.gui.enableStop();
        this.gui.disableSingleStep();
        this.gui.disableRewind();
        this.gui.disableScript();
        this.gui.disableFastForward();
        this.gui.disableAnimationModes();
        this.gui.disableLoadProgram();
        this.fastForwardRunning = true;
        this.simulator.prepareFastForward();
        if (this.animationMode != 2) {
            this.timer.start();
        } else {
            this.displayMessage("Running...", false);
            this.gui.disableSpeedSlider();
            Thread thread = new Thread(this.fastForwardTask);
            thread.start();
        }
    }

    private synchronized void singleStep() {
        this.singleStepLocked = true;
        try {
            byte by;
            this.singleStepRunning = true;
            while ((by = this.miniStep()) == 1 && this.singleStepRunning) {
            }
            this.singleStepRunning = false;
            if (by == 3) {
                this.displayMessage("Script reached a '!' terminator", false);
                this.stopMode();
            }
            for (int i = 0; i < this.breakpoints.size(); ++i) {
                Breakpoint breakpoint = (Breakpoint)this.breakpoints.elementAt(i);
                String string = this.simulator.getValue(breakpoint.getVarName());
                if (string.equals(breakpoint.getValue())) {
                    if (breakpoint.isReached()) continue;
                    breakpoint.on();
                    this.gui.setBreakpoints(this.breakpoints);
                    this.displayMessage("Breakpoint reached", false);
                    this.gui.showBreakpoints();
                    this.stopMode();
                    continue;
                }
                if (!breakpoint.isReached()) continue;
                breakpoint.off();
                this.gui.setBreakpoints(this.breakpoints);
            }
        }
        catch (ControllerException controllerException) {
            this.stopWithError(controllerException);
        }
        catch (ProgramException programException) {
            this.stopWithError(programException);
        }
        catch (CommandException commandException) {
            this.stopWithError(commandException);
        }
        catch (VariableException variableException) {
            this.stopWithError(variableException);
        }
        this.singleStepLocked = false;
        this.notifyAll();
    }

    private void stopWithError(Exception exception) {
        this.displayMessage(exception.getMessage(), true);
        this.stopMode();
    }

    private byte miniStep() throws ControllerException, ProgramException, CommandException, VariableException {
        Command command;
        boolean bl;
        do {
            command = this.script.getCommandAt(this.currentCommandIndex);
            bl = false;
            switch (command.getCode()) {
                case 1: {
                    this.simulator.doCommand((String[])command.getArg());
                    break;
                }
                case 2: {
                    this.doOutputFileCommand(command);
                    break;
                }
                case 3: {
                    this.doCompareToCommand(command);
                    break;
                }
                case 4: {
                    this.doOutputListCommand(command);
                    break;
                }
                case 5: {
                    this.doOutputCommand(command);
                    break;
                }
                case 13: {
                    this.doEchoCommand(command);
                    break;
                }
                case 14: {
                    this.doClearEchoCommand(command);
                    break;
                }
                case 6: {
                    this.doBreakpointCommand(command);
                    break;
                }
                case 7: {
                    this.doClearBreakpointsCommand(command);
                    break;
                }
                case 8: {
                    this.repeatCounter = (Integer)command.getArg();
                    this.loopCommandIndex = this.currentCommandIndex + 1;
                    bl = true;
                    break;
                }
                case 10: {
                    this.whileCondititon = (ScriptCondition)command.getArg();
                    this.loopCommandIndex = this.currentCommandIndex + 1;
                    if (!this.whileCondititon.compare(this.simulator)) {
                        while (this.script.getCommandAt(this.currentCommandIndex).getCode() != 11) {
                            ++this.currentCommandIndex;
                        }
                    }
                    bl = true;
                    break;
                }
                case 12: {
                    this.scriptEnded = true;
                    this.stopMode();
                    if (this.gui != null) {
                        this.gui.disableSingleStep();
                        this.gui.disableFastForward();
                    }
                    try {
                        if (this.output != null) {
                            this.output.close();
                        }
                        if (this.comparisonFile != null) {
                            if (this.comparisonFailed) {
                                this.displayMessage("End of script - Comparison failure at line " + this.comparisonFailureLine, true);
                            } else {
                                this.displayMessage("End of script - Comparison ended successfully", false);
                            }
                            this.comparisonFile.close();
                            break;
                        }
                        this.displayMessage("End of script", false);
                        break;
                    }
                    catch (IOException iOException) {
                        throw new ControllerException("Could not read comparison file");
                    }
                }
            }
            if (command.getCode() == 12) continue;
            ++this.currentCommandIndex;
            Command command2 = this.script.getCommandAt(this.currentCommandIndex);
            if (command2.getCode() == 9) {
                this.currentCommandIndex = this.repeatCounter == 0 || --this.repeatCounter > 0 ? this.loopCommandIndex : ++this.currentCommandIndex;
            } else if (command2.getCode() == 11) {
                this.currentCommandIndex = this.whileCondititon.compare(this.simulator) ? this.loopCommandIndex : ++this.currentCommandIndex;
            }
            if (this.animationMode == 2) continue;
            this.gui.setCurrentScriptLine(this.script.getLineNumberAt(this.currentCommandIndex));
        } while (bl);
        return command.getTerminator();
    }

    private void doOutputFileCommand(Command command) throws ControllerException {
        this.currentOutputName = this.currentScriptFile.getParent() + "/" + (String)command.getArg();
        this.resetOutputFile();
        if (this.gui != null) {
            this.gui.setOutputFile(this.currentOutputName);
        }
    }

    private void doCompareToCommand(Command command) throws ControllerException {
        this.currentComparisonName = this.currentScriptFile.getParent() + "/" + (String)command.getArg();
        this.resetComparisonFile();
        if (this.gui != null) {
            this.gui.setComparisonFile(this.currentComparisonName);
        }
    }

    private void doOutputListCommand(Command command) throws ControllerException {
        if (this.output == null) {
            throw new ControllerException("No output file specified");
        }
        this.varList = (VariableFormat[])command.getArg();
        StringBuffer stringBuffer = new StringBuffer("|");
        for (int i = 0; i < this.varList.length; ++i) {
            int n = this.varList[i].padL + this.varList[i].padR + this.varList[i].len;
            String string = this.varList[i].varName.length() > n ? this.varList[i].varName.substring(0, n) : this.varList[i].varName;
            int n2 = (n - string.length()) / 2;
            int n3 = n - n2 - string.length();
            stringBuffer.append(SPACES.substring(0, n2) + string + SPACES.substring(0, n3) + '|');
        }
        this.outputAndCompare(stringBuffer.toString());
    }

    private void doOutputCommand(Command command) throws ControllerException, VariableException {
        if (this.output == null) {
            throw new ControllerException("No output file specified");
        }
        StringBuffer stringBuffer = new StringBuffer("|");
        for (int i = 0; i < this.varList.length; ++i) {
            int n;
            String string = this.simulator.getValue(this.varList[i].varName);
            if (this.varList[i].format != 'S') {
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new VariableException("Variable is not numeric", this.varList[i].varName);
                }
                if (this.varList[i].format == 'X') {
                    string = Conversions.decimalToHex(n, 4);
                } else if (this.varList[i].format == 'B') {
                    string = Conversions.decimalToBinary(n, 16);
                }
            }
            if (string.length() > this.varList[i].len) {
                string = string.substring(string.length() - this.varList[i].len);
            }
            n = this.varList[i].padL + (this.varList[i].format == 'S' ? 0 : this.varList[i].len - string.length());
            int n2 = this.varList[i].padR + (this.varList[i].format == 'S' ? this.varList[i].len - string.length() : 0);
            stringBuffer.append(SPACES.substring(0, n) + string + SPACES.substring(0, n2) + '|');
        }
        this.outputAndCompare(stringBuffer.toString());
    }

    private void doEchoCommand(Command command) throws ControllerException {
        this.lastEcho = (String)command.getArg();
        if (this.gui != null) {
            this.gui.displayMessage(this.lastEcho, false);
        }
    }

    private void doClearEchoCommand(Command command) throws ControllerException {
        this.lastEcho = "";
        if (this.gui != null) {
            this.gui.displayMessage("", false);
        }
    }

    private void doBreakpointCommand(Command command) throws ControllerException {
        Breakpoint breakpoint = (Breakpoint)command.getArg();
        if (!this.breakpointExists(this.breakpoints, breakpoint)) {
            this.breakpoints.addElement(breakpoint);
            this.gui.setBreakpoints(this.breakpoints);
        }
    }

    private void doClearBreakpointsCommand(Command command) throws ControllerException {
        this.breakpoints.removeAllElements();
        this.gui.setBreakpoints(this.breakpoints);
    }

    private static boolean compareLineWithTemplate(String string, String string2) {
        if (string.length() != string2.length()) {
            return false;
        }
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        StringCharacterIterator stringCharacterIterator2 = new StringCharacterIterator(string2);
        stringCharacterIterator.first();
        stringCharacterIterator2.first();
        while (stringCharacterIterator.current() != '\uffff') {
            if (stringCharacterIterator2.current() != '*' && stringCharacterIterator.current() != stringCharacterIterator2.current()) {
                return false;
            }
            stringCharacterIterator.next();
            stringCharacterIterator2.next();
        }
        return true;
    }

    private void outputAndCompare(String string) throws ControllerException {
        this.output.println(string);
        this.output.flush();
        if (this.gui != null) {
            this.gui.outputFileUpdated();
            this.gui.setCurrentOutputLine(this.outputLinesCounter);
        }
        ++this.outputLinesCounter;
        if (this.comparisonFile != null) {
            try {
                String string2 = this.comparisonFile.readLine();
                if (this.gui != null) {
                    this.gui.setCurrentComparisonLine(this.compareLinesCounter);
                }
                ++this.compareLinesCounter;
                if (!HackController.compareLineWithTemplate(string, string2)) {
                    this.comparisonFailed = true;
                    this.comparisonFailureLine = this.compareLinesCounter;
                    this.displayMessage("Comparison failure at line " + this.comparisonFailureLine, true);
                    this.stopMode();
                }
            }
            catch (IOException iOException) {
                throw new ControllerException("Could not read comparison file");
            }
        }
    }

    protected void loadNewScript(File file, boolean bl) throws ControllerException, ScriptException {
        this.currentScriptFile = file;
        this.script = new Script(file.getPath());
        this.breakpoints.removeAllElements();
        this.currentCommandIndex = 0;
        this.output = null;
        this.currentOutputName = "";
        this.comparisonFile = null;
        this.currentComparisonName = "";
        if (this.gui != null) {
            this.gui.setOutputFile("");
            this.gui.setComparisonFile("");
            this.gui.setBreakpoints(this.breakpoints);
            this.gui.setScriptFile(file.getPath());
            this.gui.setCurrentScriptLine(this.script.getLineNumberAt(0));
        }
        if (bl) {
            this.displayMessage("New script loaded: " + file.getPath(), false);
        }
    }

    private void resetOutputFile() throws ControllerException {
        try {
            this.output = new PrintWriter(new FileWriter(this.currentOutputName));
            this.outputLinesCounter = 0;
            if (this.gui != null) {
                this.gui.setCurrentOutputLine(-1);
            }
        }
        catch (IOException iOException) {
            throw new ControllerException("Could not create output file " + this.currentOutputName);
        }
        if (this.gui != null) {
            this.gui.setOutputFile(this.currentOutputName);
        }
    }

    private void resetComparisonFile() throws ControllerException {
        try {
            this.comparisonFile = new BufferedReader(new FileReader(this.currentComparisonName));
            this.compareLinesCounter = 0;
            this.comparisonFailed = false;
            if (this.gui != null) {
                this.gui.setCurrentComparisonLine(-1);
            }
        }
        catch (IOException iOException) {
            throw new ControllerException("Could not open comparison file " + this.currentComparisonName);
        }
    }

    private void setSpeed(int n) {
        this.currentSpeedUnit = n;
        this.timer.setDelay(this.delays[this.currentSpeedUnit - 1]);
        this.simulator.setAnimationSpeed(n);
    }

    private void setAnimationMode(int n) {
        this.simulator.setAnimationMode(n);
        if (this.animationMode == 2 && n != 2) {
            this.simulator.refresh();
            this.gui.setCurrentScriptLine(this.script.getLineNumberAt(this.currentCommandIndex));
        }
        this.gui.setAnimationMode(n);
        this.animationMode = n;
    }

    private void setNumericFormat(int n) {
        this.simulator.setNumericFormat(n);
        this.gui.setNumericFormat(n);
    }

    private void setAdditionalDisplay(int n) {
        switch (n) {
            case 3: {
                this.simulator.getGUI().setAdditionalDisplay(null);
                break;
            }
            case 0: {
                this.simulator.getGUI().setAdditionalDisplay(this.gui.getScriptComponent());
                break;
            }
            case 1: {
                this.simulator.getGUI().setAdditionalDisplay(this.gui.getOutputComponent());
                break;
            }
            case 2: {
                this.simulator.getGUI().setAdditionalDisplay(this.gui.getComparisonComponent());
            }
        }
        this.gui.setAdditionalDisplay(n);
    }

    private void setBreakpoints(Vector vector) {
        this.breakpoints = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            Breakpoint breakpoint = (Breakpoint)vector.elementAt(i);
            if (this.breakpointExists(this.breakpoints, breakpoint)) continue;
            this.breakpoints.addElement(breakpoint);
        }
    }

    private boolean breakpointExists(Vector vector, Breakpoint breakpoint) {
        boolean bl = false;
        for (int i = 0; i < vector.size() && !bl; ++i) {
            Breakpoint breakpoint2 = (Breakpoint)vector.elementAt(i);
            if (!breakpoint.getVarName().equals(breakpoint2.getVarName()) || !breakpoint.getValue().equals(breakpoint2.getValue())) continue;
            bl = true;
        }
        return bl;
    }

    private void refreshSimulator() {
        if (this.animationMode == 2) {
            this.simulator.setAnimationMode(0);
            this.simulator.refresh();
            this.simulator.setAnimationMode(2);
        }
    }

    private void displayMessage(String string, boolean bl) {
        if (this.gui != null) {
            this.gui.displayMessage(string, bl);
        } else if (bl) {
            System.err.println(string);
            System.exit(-1);
        } else {
            System.out.println(string);
        }
    }

    protected File loadWorkingDir() {
        String string = ".";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("bin/" + this.simulator.getName() + ".dat"));
            string = bufferedReader.readLine();
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new File(string);
    }

    protected void saveWorkingDir(File file) {
        File file2 = file.getParentFile();
        if (this.gui != null) {
            this.gui.setWorkingDir(file2);
        }
        this.simulator.setWorkingDir(file);
        File file3 = file.isDirectory() ? file : file2;
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter("bin/" + this.simulator.getName() + ".dat"));
            printWriter.println(file3.getAbsolutePath());
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getVersionString() {
        return " (2.5)";
    }

    protected void reloadDefaultScript() {
        if (!this.currentScriptFile.equals(this.defaultScriptFile)) {
            this.gui.setAdditionalDisplay(3);
            try {
                this.loadNewScript(this.defaultScriptFile, false);
                this.rewind();
            }
            catch (ScriptException scriptException) {
            }
            catch (ControllerException controllerException) {
                // empty catch block
            }
        }
    }

    protected void updateProgramFile(String string) {
        this.gui.setTitle(this.simulator.getName() + HackController.getVersionString() + " - " + string);
        File file = new File(string);
        this.saveWorkingDir(file);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.singleStepLocked) {
            Thread thread = new Thread(this.singleStepTask);
            thread.start();
        }
    }

    public void programChanged(ProgramEvent programEvent) {
        switch (programEvent.getType()) {
            case 2: {
                this.updateProgramFile(programEvent.getProgramFileName());
                break;
            }
            case 1: {
                this.updateProgramFile(programEvent.getProgramFileName());
                if (this.singleStepLocked) break;
                this.reloadDefaultScript();
                break;
            }
            case 3: {
                this.gui.setTitle(this.simulator.getName() + HackController.getVersionString());
            }
        }
    }

    public void actionPerformed(ControllerEvent controllerEvent) {
        try {
            switch (controllerEvent.getAction()) {
                case 1: {
                    this.displayMessage(this.lastEcho, true);
                    this.gui.disableSingleStep();
                    this.gui.disableFastForward();
                    this.gui.disableScript();
                    this.gui.disableRewind();
                    this.gui.enableStop();
                    Thread thread = new Thread(this.singleStepTask);
                    thread.start();
                    break;
                }
                case 2: {
                    this.displayMessage(this.lastEcho, true);
                    this.fastForward();
                    break;
                }
                case 4: {
                    if (this.animationMode == 2) {
                        this.displayMessage("", false);
                    }
                    this.stopMode();
                    break;
                }
                case 9: {
                    this.displayMessage("Script restarted", false);
                    this.rewind();
                    break;
                }
                case 3: {
                    this.setSpeed((Integer)controllerEvent.getData());
                    break;
                }
                case 5: {
                    this.setBreakpoints((Vector)controllerEvent.getData());
                    break;
                }
                case 6: {
                    File file = (File)controllerEvent.getData();
                    this.loadNewScript(file, true);
                    this.setAdditionalDisplay(0);
                    this.saveWorkingDir(file);
                    this.rewind();
                    break;
                }
                case 10: {
                    this.setAnimationModeTask.setMode((Integer)controllerEvent.getData());
                    Thread thread = new Thread(this.setAnimationModeTask);
                    thread.start();
                    break;
                }
                case 11: {
                    this.setNumericFormatTask.setFormat((Integer)controllerEvent.getData());
                    Thread thread = new Thread(this.setNumericFormatTask);
                    thread.start();
                    break;
                }
                case 12: {
                    this.setAdditionalDisplay((Integer)controllerEvent.getData());
                    break;
                }
                case 15: {
                    this.gui.disableAnimationModes();
                    break;
                }
                case 16: {
                    this.gui.enableAnimationModes();
                    break;
                }
                case 17: {
                    this.gui.disableSingleStep();
                    break;
                }
                case 18: {
                    this.gui.enableSingleStep();
                    break;
                }
                case 19: {
                    this.gui.disableFastForward();
                    break;
                }
                case 20: {
                    this.gui.enableFastForward();
                    break;
                }
                case 27: {
                    this.simulator.loadProgram();
                    break;
                }
                case 21: {
                    this.displayMessage("End of program", false);
                    this.programHalted = true;
                    if (this.fastForwardRunning) {
                        this.stopMode();
                    }
                    this.gui.disableSingleStep();
                    this.gui.disableFastForward();
                    break;
                }
                case 22: {
                    if (this.programHalted) {
                        this.programHalted = false;
                        this.gui.enableSingleStep();
                        this.gui.enableFastForward();
                    }
                    break;
                }
                case 23: {
                    this.gui.disableSingleStep();
                    this.gui.disableFastForward();
                    this.gui.disableRewind();
                    break;
                }
                case 24: {
                    this.gui.enableSingleStep();
                    this.gui.enableFastForward();
                    this.gui.enableRewind();
                    break;
                }
                case 25: {
                    this.displayMessage((String)controllerEvent.getData(), false);
                    break;
                }
                case 26: {
                    if (this.timer.isRunning()) {
                        this.stopMode();
                    }
                    this.displayMessage((String)controllerEvent.getData(), true);
                    break;
                }
                default: {
                    this.doUnknownAction(controllerEvent.getAction(), controllerEvent.getData());
                    break;
                }
            }
        }
        catch (ScriptException scriptException) {
            this.displayMessage(scriptException.getMessage(), true);
            this.stopMode();
        }
        catch (ControllerException controllerException) {
            this.displayMessage(controllerException.getMessage(), true);
            this.stopMode();
        }
    }

    protected void doUnknownAction(byte by, Object object) throws ControllerException {
    }

    class SetNumericFormatTask
    implements Runnable {
        private int numericFormat;

        SetNumericFormatTask() {
        }

        public void setFormat(int n) {
            this.numericFormat = n;
        }

        public void run() {
            HackController.this.setNumericFormat(this.numericFormat);
        }
    }

    class SetAnimationModeTask
    implements Runnable {
        private int animationMode;

        SetAnimationModeTask() {
        }

        public void setMode(int n) {
            this.animationMode = n;
        }

        public void run() {
            HackController.this.setAnimationMode(this.animationMode);
        }
    }

    class FastForwardTask
    implements Runnable {
        FastForwardTask() {
        }

        public synchronized void run() {
            try {
                System.runFinalization();
                System.gc();
                this.wait(300L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            int n = 0;
            int n2 = FASTFORWARD_SPEED_FUNCTION[HackController.this.currentSpeedUnit - 1];
            while (HackController.this.fastForwardRunning) {
                HackController.this.singleStep();
                if (n == n2) {
                    n = 0;
                    try {
                        this.wait(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                ++n;
            }
        }
    }

    class SingleStepTask
    implements Runnable {
        SingleStepTask() {
        }

        public void run() {
            HackController.this.singleStep();
            if (!HackController.this.fastForwardRunning) {
                if (!HackController.this.scriptEnded && !HackController.this.programHalted) {
                    HackController.this.gui.enableSingleStep();
                    HackController.this.gui.enableFastForward();
                    HackController.this.gui.disableStop();
                }
                HackController.this.gui.enableScript();
                HackController.this.gui.enableRewind();
            }
            if (HackController.this.animationMode == 2) {
                HackController.this.refreshSimulator();
                HackController.this.gui.setCurrentScriptLine(HackController.this.script.getLineNumberAt(HackController.this.currentCommandIndex));
            }
        }
    }
}

