/*
 * Decompiled with CFR 0.152.
 */
package Hack.CPUEmulator;

import Hack.CPUEmulator.ALU;
import Hack.CPUEmulator.CPU;
import Hack.CPUEmulator.CPUEmulatorGUI;
import Hack.CPUEmulator.Keyboard;
import Hack.CPUEmulator.PointerAddressRegisterAdapter;
import Hack.CPUEmulator.RAM;
import Hack.CPUEmulator.ROM;
import Hack.CPUEmulator.ScreenGUI;
import Hack.ComputerParts.Bus;
import Hack.ComputerParts.ComputerPartErrorEvent;
import Hack.ComputerParts.ComputerPartErrorEventListener;
import Hack.ComputerParts.Register;
import Hack.Controller.CommandException;
import Hack.Controller.HackSimulator;
import Hack.Controller.HackSimulatorGUI;
import Hack.Controller.ProgramException;
import Hack.Controller.VariableException;
import Hack.Events.ProgramEvent;
import Hack.Events.ProgramEventListener;
import Hack.Utilities.Conversions;

public class CPUEmulator
extends HackSimulator
implements ComputerPartErrorEventListener {
    private static final String VAR_A = "A";
    private static final String VAR_D = "D";
    private static final String VAR_PC = "PC";
    private static final String VAR_RAM = "RAM";
    private static final String VAR_ROM = "ROM";
    private static final String VAR_TIME = "time";
    private static final String COMMAND_TICKTOCK = "ticktock";
    private static final String COMMAND_ROMLOAD = "load";
    private static final String COMMAND_SETVAR = "set";
    private CPU cpu;
    private CPUEmulatorGUI gui;
    private String[] vars;
    private Keyboard keyboard;
    private int animationMode;

    public CPUEmulator() {
        RAM rAM = new RAM(null, null, null);
        rAM.reset();
        ROM rOM = new ROM(null);
        rOM.reset();
        PointerAddressRegisterAdapter pointerAddressRegisterAdapter = new PointerAddressRegisterAdapter(null, rAM);
        pointerAddressRegisterAdapter.reset();
        Register register = new Register(null);
        register.reset();
        PointerAddressRegisterAdapter pointerAddressRegisterAdapter2 = new PointerAddressRegisterAdapter(null, rOM);
        pointerAddressRegisterAdapter2.reset();
        this.keyboard = new Keyboard(rAM, null);
        this.keyboard.reset();
        ALU aLU = new ALU(null);
        aLU.reset();
        Bus bus = new Bus(null);
        bus.reset();
        this.cpu = new CPU(rAM, rOM, pointerAddressRegisterAdapter, register, pointerAddressRegisterAdapter2, aLU, bus);
        this.init();
    }

    public CPUEmulator(CPUEmulatorGUI cPUEmulatorGUI) {
        this.gui = cPUEmulatorGUI;
        RAM rAM = new RAM(cPUEmulatorGUI.getRAM(), null, cPUEmulatorGUI.getScreen());
        rAM.addErrorListener(this);
        rAM.reset();
        ROM rOM = new ROM(cPUEmulatorGUI.getROM());
        rOM.addErrorListener(this);
        rOM.addProgramListener((ProgramEventListener)this);
        rOM.reset();
        PointerAddressRegisterAdapter pointerAddressRegisterAdapter = new PointerAddressRegisterAdapter(cPUEmulatorGUI.getA(), rAM);
        pointerAddressRegisterAdapter.addErrorListener(this);
        pointerAddressRegisterAdapter.reset();
        Register register = new Register(cPUEmulatorGUI.getD());
        register.addErrorListener((ComputerPartErrorEventListener)this);
        register.reset();
        PointerAddressRegisterAdapter pointerAddressRegisterAdapter2 = new PointerAddressRegisterAdapter(cPUEmulatorGUI.getPC(), rOM);
        pointerAddressRegisterAdapter2.addErrorListener(this);
        pointerAddressRegisterAdapter2.reset();
        this.keyboard = new Keyboard(rAM, cPUEmulatorGUI.getKeyboard());
        this.keyboard.reset();
        ALU aLU = new ALU(cPUEmulatorGUI.getALU());
        aLU.reset();
        Bus bus = new Bus(cPUEmulatorGUI.getBus());
        bus.reset();
        this.cpu = new CPU(rAM, rOM, pointerAddressRegisterAdapter, register, pointerAddressRegisterAdapter2, aLU, bus);
        this.init();
    }

    private void init() {
        this.vars = new String[]{VAR_A, VAR_D, VAR_PC, "RAM[]", "ROM[]", VAR_TIME};
    }

    public String getName() {
        return "CPU Emulator";
    }

    public String getValue(String string) throws VariableException {
        if (string.equals(VAR_A)) {
            return String.valueOf(this.cpu.getA().get());
        }
        if (string.equals(VAR_D)) {
            return String.valueOf(this.cpu.getD().get());
        }
        if (string.equals(VAR_PC)) {
            return String.valueOf(this.cpu.getPC().get());
        }
        if (string.equals(VAR_TIME)) {
            return String.valueOf(this.cpu.getTime());
        }
        if (string.startsWith("RAM[")) {
            short s = CPUEmulator.getRamIndex(string);
            return String.valueOf(this.cpu.getRAM().getValueAt(s));
        }
        if (string.startsWith("ROM[")) {
            short s = CPUEmulator.getRomIndex(string);
            return String.valueOf(this.cpu.getROM().getValueAt(s));
        }
        throw new VariableException("Unknown variable", string);
    }

    public void setValue(String string, String string2) throws VariableException {
        block8: {
            try {
                string2 = Conversions.toDecimalForm((String)string2);
                if (string.equals(VAR_A)) {
                    int n = Integer.parseInt(string2);
                    this.check_ram_address(string, n);
                    this.cpu.getA().store((short)n);
                    break block8;
                }
                if (string.equals(VAR_D)) {
                    int n = Integer.parseInt(string2);
                    this.check_value(string, n);
                    this.cpu.getD().store((short)n);
                    break block8;
                }
                if (string.equals(VAR_PC)) {
                    int n = Integer.parseInt(string2);
                    this.check_rom_address(string, n);
                    this.cpu.getPC().store((short)n);
                    break block8;
                }
                if (string.equals(VAR_TIME)) {
                    throw new VariableException("Read Only variable", string);
                }
                if (string.startsWith("RAM[")) {
                    short s = CPUEmulator.getRamIndex(string);
                    int n = Integer.parseInt(string2);
                    this.check_value(string, n);
                    this.cpu.getRAM().setValueAt(s, (short)n, false);
                    break block8;
                }
                if (string.startsWith("ROM[")) {
                    short s = CPUEmulator.getRomIndex(string);
                    int n = Integer.parseInt(string2);
                    this.check_value(string, n);
                    this.cpu.getROM().setValueAt(s, (short)n, false);
                    break block8;
                }
                throw new VariableException("Unknown variable", string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new VariableException("'" + string2 + "' is not a legal value for variable", string);
            }
        }
    }

    public void doCommand(String[] stringArray) throws CommandException, ProgramException, VariableException {
        if (stringArray.length == 0) {
            throw new CommandException("Empty command", stringArray);
        }
        if (this.animationMode != 2) {
            this.hideHighlightes();
        }
        if (stringArray[0].equals(COMMAND_TICKTOCK)) {
            if (stringArray.length != 1) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            this.cpu.executeInstruction();
        } else if (stringArray[0].equals(COMMAND_SETVAR)) {
            if (stringArray.length != 3) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            this.setValue(stringArray[1], stringArray[2]);
        } else if (stringArray[0].equals(COMMAND_ROMLOAD)) {
            if (stringArray.length != 2) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            String string = this.workingDir.getAbsolutePath() + "/" + stringArray[1];
            this.cpu.getROM().loadProgram(string);
            int n = this.animationMode;
            this.setAnimationMode(0);
            this.cpu.initProgram();
            this.setAnimationMode(n);
        } else {
            throw new CommandException("Unknown simulator command", stringArray);
        }
    }

    private void hideHighlightes() {
        this.cpu.getRAM().hideHighlight();
        this.cpu.getROM().hideHighlight();
        this.cpu.getA().hideHighlight();
        this.cpu.getD().hideHighlight();
        this.cpu.getPC().hideHighlight();
        this.cpu.getALU().hideHighlight();
    }

    public void restart() {
        this.cpu.initProgram();
    }

    public void setAnimationMode(int n) {
        if (this.gui != null) {
            ScreenGUI screenGUI;
            if (n == 2 && this.animationMode != 2) {
                this.cpu.getRAM().disableUserInput();
                this.cpu.getROM().disableUserInput();
                this.cpu.getA().disableUserInput();
                this.cpu.getD().disableUserInput();
                this.cpu.getPC().disableUserInput();
                screenGUI = this.gui.getScreen();
                if (screenGUI != null) {
                    screenGUI.startAnimation();
                }
            }
            if (n != 2 && this.animationMode == 2) {
                this.cpu.getRAM().enableUserInput();
                this.cpu.getROM().enableUserInput();
                this.cpu.getA().enableUserInput();
                this.cpu.getD().enableUserInput();
                this.cpu.getPC().enableUserInput();
                screenGUI = this.gui.getScreen();
                if (screenGUI != null) {
                    screenGUI.stopAnimation();
                }
            }
        }
        this.animationMode = n;
        boolean bl = this.animationMode == 1;
        this.cpu.getBus().setAnimate(bl);
        this.cpu.getRAM().setAnimate(bl);
        this.cpu.getROM().setAnimate(bl);
        this.cpu.getA().setAnimate(bl);
        this.cpu.getD().setAnimate(bl);
        this.cpu.getPC().setAnimate(bl);
        this.cpu.getALU().setAnimate(bl);
        boolean bl2 = this.animationMode != 2;
        this.cpu.getRAM().setDisplayChanges(bl2);
        this.cpu.getROM().setDisplayChanges(bl2);
        this.cpu.getA().setDisplayChanges(bl2);
        this.cpu.getD().setDisplayChanges(bl2);
        this.cpu.getPC().setDisplayChanges(bl2);
        this.cpu.getALU().setDisplayChanges(bl2);
    }

    public void setNumericFormat(int n) {
        this.cpu.getRAM().setNumericFormat(n);
        this.cpu.getA().setNumericFormat(n);
        this.cpu.getD().setNumericFormat(n);
        this.cpu.getPC().setNumericFormat(n);
        this.cpu.getALU().setNumericFormat(n);
    }

    public void setAnimationSpeed(int n) {
        this.cpu.getBus().setAnimationSpeed(n);
    }

    public int getInitialAnimationMode() {
        return 0;
    }

    public int getInitialNumericFormat() {
        return 0;
    }

    public void refresh() {
        this.cpu.getBus().refreshGUI();
        this.cpu.getRAM().refreshGUI();
        this.cpu.getROM().refreshGUI();
        this.cpu.getA().refreshGUI();
        this.cpu.getD().refreshGUI();
        this.cpu.getPC().refreshGUI();
        this.cpu.getALU().refreshGUI();
        ScreenGUI screenGUI = this.gui.getScreen();
        if (screenGUI != null) {
            screenGUI.refresh();
        }
    }

    public void prepareFastForward() {
        this.gui.requestFocus();
        this.keyboard.requestFocus();
    }

    public void prepareGUI() {
    }

    public String[] getVariables() {
        return this.vars;
    }

    protected HackSimulatorGUI getGUI() {
        return this.gui;
    }

    public void programChanged(ProgramEvent programEvent) {
        super.programChanged(programEvent);
        if (programEvent.getType() == 1) {
            int n = this.animationMode;
            this.setAnimationMode(0);
            this.refresh();
            this.notifyListeners((byte)24, null);
            this.cpu.initProgram();
            this.setAnimationMode(n);
        }
    }

    public void computerPartErrorOccured(ComputerPartErrorEvent computerPartErrorEvent) {
        this.displayMessage(computerPartErrorEvent.getErrorMessage(), true);
    }

    private static short getRamIndex(String string) throws VariableException {
        if (string.indexOf("]") == -1) {
            throw new VariableException("Missing ']'", string);
        }
        String string2 = string.substring(string.indexOf("[") + 1, string.indexOf("]"));
        int n = Integer.parseInt(string2);
        if (n < 0 || n >= 24577) {
            throw new VariableException("Illegal variable index", string);
        }
        return (short)n;
    }

    private static short getRomIndex(String string) throws VariableException {
        if (string.indexOf("]") == -1) {
            throw new VariableException("Missing ']'", string);
        }
        String string2 = string.substring(string.indexOf("[") + 1, string.indexOf("]"));
        int n = Integer.parseInt(string2);
        if (n < 0 || n >= 32768) {
            throw new VariableException("Illegal variable index", string);
        }
        return (short)n;
    }

    private void check_value(String string, int n) throws VariableException {
        if (n < Short.MIN_VALUE || n >= 32768) {
            throw new VariableException(n + " is an illegal value for variable", string);
        }
    }

    private void check_ram_address(String string, int n) throws VariableException {
        if (n < 0 || n >= 24577) {
            throw new VariableException(n + " is an illegal value for", string);
        }
    }

    private void check_rom_address(String string, int n) throws VariableException {
        if (n < 0 || n >= 32768) {
            throw new VariableException(n + " is an illegal value for", string);
        }
    }
}

