/*
 * Decompiled with CFR 0.152.
 */
package Hack.Gates;

import Hack.Gates.BuiltInGateWithGUI;
import Hack.Gates.GateErrorEventListener;
import Hack.Gates.GatesPanelGUI;
import java.io.File;
import java.util.Vector;

public class GatesManager {
    private static GatesManager singleton;
    private File workingDir;
    private File builtInDir;
    private GatesPanelGUI gatesPanel;
    private GateErrorEventListener errorHandler;
    private Vector chips = new Vector();
    private boolean updateChipsGUI = true;

    private GatesManager() {
    }

    public static GatesManager getInstance() {
        if (singleton == null) {
            singleton = new GatesManager();
        }
        return singleton;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File file) {
        this.workingDir = file;
    }

    public File getBuiltInDir() {
        return this.builtInDir;
    }

    public void setBuiltInDir(File file) {
        this.builtInDir = file;
    }

    public BuiltInGateWithGUI[] getChips() {
        BuiltInGateWithGUI[] builtInGateWithGUIArray = new BuiltInGateWithGUI[this.chips.size()];
        this.chips.toArray(builtInGateWithGUIArray);
        return builtInGateWithGUIArray;
    }

    public void addChip(BuiltInGateWithGUI builtInGateWithGUI) {
        this.chips.add(builtInGateWithGUI);
        builtInGateWithGUI.addErrorListener(this.errorHandler);
        builtInGateWithGUI.setParent(builtInGateWithGUI);
        if (this.gatesPanel != null) {
            this.gatesPanel.addGateComponent(builtInGateWithGUI.getGUIComponent());
        }
    }

    public void removeChip(BuiltInGateWithGUI builtInGateWithGUI) {
        this.chips.remove(builtInGateWithGUI);
        builtInGateWithGUI.removeErrorListener(this.errorHandler);
        if (this.gatesPanel != null) {
            this.gatesPanel.removeGateComponent(builtInGateWithGUI.getGUIComponent());
        }
    }

    public void removeAllChips() {
        for (int i = 0; i < this.chips.size(); ++i) {
            ((BuiltInGateWithGUI)this.chips.elementAt(i)).removeErrorListener(this.errorHandler);
        }
        this.chips.removeAllElements();
        if (this.gatesPanel != null) {
            this.gatesPanel.removeAllGateComponents();
        }
    }

    public void setGatesPanel(GatesPanelGUI gatesPanelGUI) {
        this.gatesPanel = gatesPanelGUI;
    }

    public GateErrorEventListener getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(GateErrorEventListener gateErrorEventListener) {
        this.errorHandler = gateErrorEventListener;
    }

    public String getHDLFileName(String string) {
        String string2 = null;
        String string3 = string + ".hdl";
        File file = new File(this.workingDir, string3);
        if (file.exists()) {
            string2 = file.getAbsolutePath();
        } else {
            file = new File(this.builtInDir, string3);
            if (file.exists()) {
                string2 = file.getAbsolutePath();
            }
        }
        return string2;
    }

    public boolean isChipsGUIEnabled() {
        return this.updateChipsGUI;
    }

    public void enableChipsGUI(boolean bl) {
        this.updateChipsGUI = bl;
    }
}

