/*
 * Decompiled with CFR 0.152.
 */
package Hack.HardwareSimulator;

import Hack.ComputerParts.ComputerPartGUI;
import Hack.ComputerParts.ValueComputerPart;
import Hack.Gates.CompositeGateClass;
import Hack.Gates.Gate;
import Hack.Gates.GateClass;
import Hack.Gates.Node;
import Hack.Gates.PinInfo;
import Hack.HardwareSimulator.NodePartPinsAdapter;
import Hack.HardwareSimulator.PartPinInfo;
import Hack.HardwareSimulator.PartPinsGUI;
import Hack.HardwareSimulator.SubNodePartPinsAdapter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PartPins
extends ValueComputerPart {
    private PartPinsGUI gui;
    private Vector partPins;
    private Gate gate;
    private GateClass partGateClass;
    private Hashtable nodes;

    public PartPins(PartPinsGUI partPinsGUI) {
        super(partPinsGUI != null);
        this.gui = partPinsGUI;
        this.partPins = new Vector();
        this.nodes = new Hashtable();
        this.clearGate();
    }

    private void clearGate() {
        this.gate = null;
        this.clearPart();
    }

    private void clearPart() {
        this.partPins.removeAllElements();
        this.partGateClass = null;
        Enumeration enumeration = this.nodes.keys();
        while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            Node node2 = (Node)this.nodes.get(node);
            node.removeListener(node2);
        }
        this.refreshGUI();
    }

    public void setGate(Gate gate) {
        this.clearGate();
        this.gate = gate;
    }

    public void setPart(GateClass gateClass, String string) {
        this.clearPart();
        this.partGateClass = gateClass;
        if (this.hasGUI) {
            this.gui.setPartName(string);
        }
    }

    public void addPin(String string, String string2) {
        if (this.gate != null && this.partGateClass != null) {
            Object object;
            Node node;
            String string3 = string;
            String string4 = string2;
            if (string.indexOf("[") >= 0) {
                string3 = string.substring(0, string.indexOf("["));
            }
            if (string2.indexOf("[") >= 0) {
                string4 = string2.substring(0, string2.indexOf("["));
            }
            PinInfo pinInfo = this.partGateClass.getPinInfo(string3);
            PartPinInfo partPinInfo = new PartPinInfo();
            partPinInfo.partPinName = pinInfo.name;
            try {
                partPinInfo.partPinSubBus = CompositeGateClass.getSubBus(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean bl = false;
            if (string4.equals(CompositeGateClass.TRUE_NODE_INFO.name)) {
                node = Gate.TRUE_NODE;
                partPinInfo.gatePinName = CompositeGateClass.TRUE_NODE_INFO.name;
                bl = true;
            } else if (string4.equals(CompositeGateClass.FALSE_NODE_INFO.name)) {
                node = Gate.FALSE_NODE;
                partPinInfo.gatePinName = CompositeGateClass.FALSE_NODE_INFO.name;
                bl = true;
            } else if (string4.equals(CompositeGateClass.CLOCK_NODE_INFO.name)) {
                node = Gate.CLOCK_NODE;
                partPinInfo.gatePinName = CompositeGateClass.CLOCK_NODE_INFO.name;
            } else {
                node = this.gate.getNode(string4);
                object = this.gate.getGateClass().getPinInfo(string4);
                partPinInfo.gatePinName = ((PinInfo)object).name;
            }
            if (bl) {
                partPinInfo.gatePinSubBus = new byte[]{0, (byte)(pinInfo.width - 1)};
            } else {
                try {
                    partPinInfo.gatePinSubBus = CompositeGateClass.getSubBus(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            object = null;
            object = partPinInfo.gatePinSubBus == null ? new NodePartPinsAdapter(this, this.partPins.size()) : new SubNodePartPinsAdapter(partPinInfo.gatePinSubBus[0], partPinInfo.gatePinSubBus[1], this, this.partPins.size());
            node.addListener((Node)object);
            this.nodes.put(node, object);
            this.partPins.addElement(partPinInfo);
            this.refreshGUI();
            ((Node)object).set(node.get());
            this.reset();
        }
    }

    public ComputerPartGUI getGUI() {
        return this.gui;
    }

    public short getValueAt(int n) {
        return ((PartPinInfo)this.partPins.elementAt((int)n)).value;
    }

    public void refreshGUI() {
        if (this.displayChanges) {
            this.gui.setContents(this.partPins);
        }
    }

    public void setValueAt(int n, short s, boolean bl) {
        if (this.getValueAt(n) != s) {
            super.setValueAt(n, s, bl);
        }
    }

    public void doSetValueAt(int n, short s) {
    }
}

