/*
 * Decompiled with CFR 0.152.
 */
package Hack.VMEmulator;

import Hack.Controller.ProgramException;
import Hack.VMEmulator.BuiltInVMClass;
import Hack.VMEmulator.CPU;
import Hack.VMEmulator.TerminateVMProgramThrowable;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class BuiltInFunctionsRunner
implements Runnable {
    private static final int CALL_REQUEST = 0;
    private static final int RETURN_REQUEST = 1;
    private static final int END_PROGRAM_REQUEST = 2;
    private static final int THROW_PROGRAM_EXCEPTION_REQUEST = 3;
    private static final int INFINITE_LOOP_REQUEST = 4;
    private BuiltInToProgramRequest builtInToProgram;
    private ProgramToBuiltInRequest programToBuiltIn;
    private Thread thread;
    private CPU cpu;
    private File builtInDir;

    private synchronized void continueOtherThread() {
        this.notify();
        while (true) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuiltInFunctionsRunner(CPU cPU, File file) {
        this.cpu = cPU;
        this.builtInDir = file;
        this.builtInToProgram = new BuiltInToProgramRequest();
        this.programToBuiltIn = new ProgramToBuiltInRequest();
        this.thread = new Thread(this);
        BuiltInFunctionsRunner builtInFunctionsRunner = this;
        synchronized (builtInFunctionsRunner) {
            this.thread.start();
            this.continueOtherThread();
        }
    }

    public void killAllRunningBuiltInFunctions() {
        this.programToBuiltIn.request = 2;
        this.continueOtherThread();
    }

    public void returnToBuiltInFunction(short s) throws ProgramException {
        this.programToBuiltIn.request = 1;
        this.programToBuiltIn.returnValue = s;
        this.sendBuiltInRequestAndWaitForAnswer();
    }

    public void callBuiltInFunction(String string, short[] sArray) throws ProgramException {
        Method method;
        boolean bl;
        Class<?> clazz;
        int n = string.indexOf(".");
        if (n == -1) {
            throw new ProgramException("Illegal function name: " + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        if (string3.equals("new")) {
            string3 = "NEW";
        }
        try {
            clazz = Class.forName(this.builtInDir + "." + string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ProgramException("Can't find " + string2 + ".vm or a built-in implementation for class " + string2);
        }
        Class<?> clazz2 = clazz;
        while (!(bl = (clazz2 = clazz2.getSuperclass()).getName().equals("Hack.VMEmulator.BuiltInVMClass")) && !clazz2.getName().equals("java.lang.Object")) {
        }
        if (!bl) {
            throw new ProgramException("Built-in implementation for " + string2 + " is not a subclass of BuiltInVMClass");
        }
        Class[] classArray = new Class[sArray.length];
        Object[] objectArray = new Object[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            objectArray[i] = new Short(sArray[i]);
            classArray[i] = Short.TYPE;
        }
        try {
            method = clazz.getDeclaredMethod(string3, classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ProgramException("Can't find " + string2 + ".vm or a built-in implementation for function " + string3 + " in class " + string2 + " taking " + sArray.length + " argument" + (sArray.length == 1 ? "" : "s") + ".");
        }
        Class<?> clazz3 = method.getReturnType();
        if (clazz3 != Short.TYPE && clazz3 != Void.TYPE && clazz3 != Character.TYPE && clazz3 != Boolean.TYPE) {
            throw new ProgramException("Can't find " + string2 + ".vm and the built-in implementation for " + string + " taking " + sArray.length + " arguments doesn't return short/char/void/boolean.");
        }
        this.programToBuiltIn.request = 0;
        this.programToBuiltIn.params = objectArray;
        this.programToBuiltIn.functionObject = method;
        this.sendBuiltInRequestAndWaitForAnswer();
    }

    private void sendBuiltInRequestAndWaitForAnswer() throws ProgramException {
        this.continueOtherThread();
        switch (this.builtInToProgram.request) {
            case 0: {
                this.cpu.callFunctionFromBuiltIn(this.builtInToProgram.details, this.builtInToProgram.params);
                break;
            }
            case 1: {
                this.cpu.returnFromBuiltInFunction(this.builtInToProgram.returnValue);
                break;
            }
            case 4: {
                this.cpu.infiniteLoopFromBuiltIn(this.builtInToProgram.details);
                break;
            }
            case 3: {
                throw new ProgramException(this.builtInToProgram.details);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        BuiltInFunctionsRunner builtInFunctionsRunner = this;
        synchronized (builtInFunctionsRunner) {
            BuiltInVMClass.associateForThread(this);
            while (true) {
                try {
                    this.builtInFunctionRequestsCall(null, null);
                }
                catch (TerminateVMProgramThrowable terminateVMProgramThrowable) {
                    continue;
                }
                break;
            }
            return;
        }
    }

    public short builtInFunctionRequestsCall(String string, short[] sArray) throws TerminateVMProgramThrowable {
        this.builtInToProgram.request = 0;
        this.builtInToProgram.details = string;
        this.builtInToProgram.params = sArray;
        this.continueOtherThread();
        while (this.programToBuiltIn.request == 0) {
            try {
                Class<?> clazz = this.programToBuiltIn.functionObject.getReturnType();
                string = this.programToBuiltIn.functionObject.getName();
                Object object = this.programToBuiltIn.functionObject.invoke(null, this.programToBuiltIn.params);
                this.builtInToProgram.request = 1;
                this.builtInToProgram.returnValue = clazz == Short.TYPE ? (Short)object : (clazz == Character.TYPE ? (short)((Character)object).charValue() : (clazz == Boolean.TYPE ? (((Boolean)object).booleanValue() ? (short)-1 : (short)0) : (short)0));
            }
            catch (IllegalAccessException illegalAccessException) {
                this.builtInToProgram.request = 3;
                this.builtInToProgram.details = "Error trying to run the built-in implementation of " + string;
            }
            catch (InvocationTargetException invocationTargetException) {
                try {
                    throw (TerminateVMProgramThrowable)invocationTargetException.getTargetException();
                }
                catch (ClassCastException classCastException) {
                    this.builtInToProgram.request = 3;
                    this.builtInToProgram.details = "The built-in implementation of " + string + " caused an exception: " + invocationTargetException.getTargetException().toString();
                }
            }
            this.continueOtherThread();
        }
        if (this.programToBuiltIn.request == 1) {
            return this.programToBuiltIn.returnValue;
        }
        throw new TerminateVMProgramThrowable();
    }

    private void checkMemoryAddress(short s) throws TerminateVMProgramThrowable {
        if (!(s >= 2048 && s <= 16383 || s >= 16384 && s <= 24576 || s == 0)) {
            this.builtInToProgram.request = 3;
            this.builtInToProgram.details = "A built-in function tried to access memory outside the Heap or Screen range";
            this.continueOtherThread();
            throw new TerminateVMProgramThrowable();
        }
    }

    public void builtInFunctionRequestsInfiniteLoop(String string) throws TerminateVMProgramThrowable {
        this.builtInToProgram.request = 4;
        this.builtInToProgram.details = string;
        this.continueOtherThread();
        throw new TerminateVMProgramThrowable();
    }

    public void builtInFunctionRequestsMemoryWrite(short s, short s2) throws TerminateVMProgramThrowable {
        this.checkMemoryAddress(s);
        this.cpu.getRAM().setValueAt(s, s2, false);
    }

    public short builtInFunctionRequestsMemoryRead(short s) throws TerminateVMProgramThrowable {
        this.checkMemoryAddress(s);
        return this.cpu.getRAM().getValueAt(s);
    }

    private class ProgramToBuiltInRequest {
        int request;
        Method functionObject;
        Object[] params;
        short returnValue;

        private ProgramToBuiltInRequest() {
        }
    }

    private class BuiltInToProgramRequest {
        int request;
        String details;
        short[] params;
        short returnValue;

        private BuiltInToProgramRequest() {
        }
    }
}

