/*
 * Decompiled with CFR 0.152.
 */
package Hack.VMEmulator;

import Hack.CPUEmulator.Keyboard;
import Hack.CPUEmulator.RAM;
import Hack.CPUEmulator.ScreenGUI;
import Hack.ComputerParts.AbsolutePointedMemorySegment;
import Hack.ComputerParts.Bus;
import Hack.ComputerParts.ComputerPartErrorEvent;
import Hack.ComputerParts.ComputerPartErrorEventListener;
import Hack.ComputerParts.LabeledPointedMemoryGUI;
import Hack.ComputerParts.Memory;
import Hack.ComputerParts.MemorySegment;
import Hack.ComputerParts.PointedMemoryGUI;
import Hack.ComputerParts.TrimmedAbsoluteMemorySegment;
import Hack.Controller.CommandException;
import Hack.Controller.HackSimulator;
import Hack.Controller.HackSimulatorGUI;
import Hack.Controller.ProgramException;
import Hack.Controller.VariableException;
import Hack.Events.ProgramEvent;
import Hack.Events.ProgramEventListener;
import Hack.Utilities.Conversions;
import Hack.VMEmulator.CPU;
import Hack.VMEmulator.Calculator;
import Hack.VMEmulator.CallStack;
import Hack.VMEmulator.VMEmulatorGUI;
import Hack.VMEmulator.VMProgram;
import java.io.File;

public class VMEmulator
extends HackSimulator
implements ComputerPartErrorEventListener {
    private static final File INITIAL_BUILTIN_DIR = new File("builtInVMCode");
    private static final String VAR_SP = "sp";
    private static final String VAR_RAM = "RAM";
    private static final String VAR_LOCAL = "local";
    private static final String VAR_ARGUMENT = "argument";
    private static final String VAR_THIS = "this";
    private static final String VAR_THAT = "that";
    private static final String VAR_TEMP = "temp";
    private static final String VAR_LINE = "line";
    private static final String VAR_CURRENT_FUNCTION = "currentFunction";
    private static final String COMMAND_VMSTEP = "vmstep";
    private static final String COMMAND_ROMLOAD = "load";
    private static final String COMMAND_ROMLOAD_BI = "loadbi";
    private static final String COMMAND_ROMLOAD_BIX = "loadbix";
    private static final String COMMAND_SETVAR = "set";
    private CPU cpu;
    private VMEmulatorGUI gui;
    private String[] vars;
    private Keyboard keyboard;
    private int animationMode;

    public VMEmulator() {
        VMProgram vMProgram = new VMProgram(null);
        MemorySegment[][] memorySegmentArrayArray = new MemorySegment[24577][];
        RAM rAM = new RAM(null, memorySegmentArrayArray, null);
        rAM.addErrorListener(this);
        rAM.reset();
        AbsolutePointedMemorySegment absolutePointedMemorySegment = new AbsolutePointedMemorySegment((Memory)rAM, null);
        TrimmedAbsoluteMemorySegment trimmedAbsoluteMemorySegment = new TrimmedAbsoluteMemorySegment((Memory)rAM, null);
        MemorySegment memorySegment = new MemorySegment((Memory)rAM, null);
        MemorySegment memorySegment2 = new MemorySegment((Memory)rAM, null);
        MemorySegment memorySegment3 = new MemorySegment((Memory)rAM, null);
        MemorySegment memorySegment4 = new MemorySegment((Memory)rAM, null);
        MemorySegment memorySegment5 = new MemorySegment((Memory)rAM, null);
        MemorySegment memorySegment6 = new MemorySegment((Memory)rAM, null);
        absolutePointedMemorySegment.reset();
        absolutePointedMemorySegment.addErrorListener((ComputerPartErrorEventListener)this);
        absolutePointedMemorySegment.setEnabledRange(256, 2047, true);
        trimmedAbsoluteMemorySegment.reset();
        trimmedAbsoluteMemorySegment.addErrorListener((ComputerPartErrorEventListener)this);
        trimmedAbsoluteMemorySegment.setEnabledRange(256, 2047, true);
        memorySegment.reset();
        memorySegment.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment2.reset();
        memorySegment2.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment3.reset();
        memorySegment3.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment4.reset();
        memorySegment4.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment5.reset();
        memorySegment5.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment6.reset();
        memorySegment6.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment6.setStartAddress(5);
        memorySegment6.setEnabledRange(5, 12, true);
        memorySegmentArrayArray[0] = new MemorySegment[]{absolutePointedMemorySegment, trimmedAbsoluteMemorySegment};
        memorySegmentArrayArray[1] = new MemorySegment[]{memorySegment2};
        memorySegmentArrayArray[2] = new MemorySegment[]{memorySegment3};
        memorySegmentArrayArray[3] = new MemorySegment[]{memorySegment4};
        memorySegmentArrayArray[4] = new MemorySegment[]{memorySegment5};
        this.keyboard = new Keyboard(rAM, null);
        this.keyboard.reset();
        CallStack callStack = new CallStack(null);
        callStack.reset();
        Calculator calculator = new Calculator(null);
        calculator.reset();
        Bus bus = new Bus(null);
        bus.reset();
        this.cpu = new CPU(vMProgram, rAM, callStack, calculator, bus, absolutePointedMemorySegment, trimmedAbsoluteMemorySegment, memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5, memorySegment6, INITIAL_BUILTIN_DIR);
        this.cpu.boot();
        this.init();
    }

    public VMEmulator(VMEmulatorGUI vMEmulatorGUI) {
        this.gui = vMEmulatorGUI;
        VMProgram vMProgram = new VMProgram(vMEmulatorGUI.getProgram());
        vMProgram.addErrorListener(this);
        vMProgram.addProgramListener((ProgramEventListener)this);
        MemorySegment[][] memorySegmentArrayArray = new MemorySegment[24577][];
        RAM rAM = new RAM((PointedMemoryGUI)vMEmulatorGUI.getRAM(), memorySegmentArrayArray, vMEmulatorGUI.getScreen());
        rAM.addErrorListener(this);
        rAM.reset();
        LabeledPointedMemoryGUI labeledPointedMemoryGUI = vMEmulatorGUI.getRAM();
        labeledPointedMemoryGUI.setLabel(0, "SP");
        labeledPointedMemoryGUI.setLabel(1, "LCL");
        labeledPointedMemoryGUI.setLabel(2, "ARG");
        labeledPointedMemoryGUI.setLabel(3, "THIS");
        labeledPointedMemoryGUI.setLabel(4, "THAT");
        labeledPointedMemoryGUI.setLabel(5, "Temp0");
        labeledPointedMemoryGUI.setLabel(6, "Temp1");
        labeledPointedMemoryGUI.setLabel(7, "Temp2");
        labeledPointedMemoryGUI.setLabel(8, "Temp3");
        labeledPointedMemoryGUI.setLabel(9, "Temp4");
        labeledPointedMemoryGUI.setLabel(10, "Temp5");
        labeledPointedMemoryGUI.setLabel(11, "Temp6");
        labeledPointedMemoryGUI.setLabel(12, "Temp7");
        labeledPointedMemoryGUI.setLabel(13, "R13");
        labeledPointedMemoryGUI.setLabel(14, "R14");
        labeledPointedMemoryGUI.setLabel(15, "R15");
        AbsolutePointedMemorySegment absolutePointedMemorySegment = new AbsolutePointedMemorySegment((Memory)rAM, vMEmulatorGUI.getStack());
        TrimmedAbsoluteMemorySegment trimmedAbsoluteMemorySegment = new TrimmedAbsoluteMemorySegment((Memory)rAM, vMEmulatorGUI.getWorkingStack());
        MemorySegment memorySegment = new MemorySegment((Memory)rAM, vMEmulatorGUI.getStaticSegment());
        MemorySegment memorySegment2 = new MemorySegment((Memory)rAM, vMEmulatorGUI.getLocalSegment());
        MemorySegment memorySegment3 = new MemorySegment((Memory)rAM, vMEmulatorGUI.getArgSegment());
        MemorySegment memorySegment4 = new MemorySegment((Memory)rAM, vMEmulatorGUI.getThisSegment());
        MemorySegment memorySegment5 = new MemorySegment((Memory)rAM, vMEmulatorGUI.getThatSegment());
        MemorySegment memorySegment6 = new MemorySegment((Memory)rAM, vMEmulatorGUI.getTempSegment());
        absolutePointedMemorySegment.reset();
        absolutePointedMemorySegment.setEnabledRange(256, 2047, true);
        absolutePointedMemorySegment.addErrorListener((ComputerPartErrorEventListener)this);
        trimmedAbsoluteMemorySegment.reset();
        trimmedAbsoluteMemorySegment.setEnabledRange(256, 2047, true);
        trimmedAbsoluteMemorySegment.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment.reset();
        memorySegment.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment2.reset();
        memorySegment2.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment3.reset();
        memorySegment3.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment4.reset();
        memorySegment4.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment5.reset();
        memorySegment5.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegment6.reset();
        memorySegment6.setStartAddress(5);
        memorySegment6.setEnabledRange(5, 12, true);
        memorySegment6.addErrorListener((ComputerPartErrorEventListener)this);
        memorySegmentArrayArray[0] = new MemorySegment[]{absolutePointedMemorySegment, trimmedAbsoluteMemorySegment};
        memorySegmentArrayArray[1] = new MemorySegment[]{memorySegment2};
        memorySegmentArrayArray[2] = new MemorySegment[]{memorySegment3};
        memorySegmentArrayArray[3] = new MemorySegment[]{memorySegment4};
        memorySegmentArrayArray[4] = new MemorySegment[]{memorySegment5};
        this.keyboard = new Keyboard(rAM, vMEmulatorGUI.getKeyboard());
        this.keyboard.reset();
        CallStack callStack = new CallStack(vMEmulatorGUI.getCallStack());
        callStack.reset();
        Calculator calculator = new Calculator(vMEmulatorGUI.getCalculator());
        calculator.hideCalculator();
        calculator.reset();
        Bus bus = new Bus(vMEmulatorGUI.getBus());
        bus.reset();
        this.cpu = new CPU(vMProgram, rAM, callStack, calculator, bus, absolutePointedMemorySegment, trimmedAbsoluteMemorySegment, memorySegment, memorySegment2, memorySegment3, memorySegment4, memorySegment5, memorySegment6, INITIAL_BUILTIN_DIR);
        this.cpu.boot();
        this.init();
    }

    private void init() {
        this.vars = new String[]{VAR_SP, VAR_CURRENT_FUNCTION, VAR_LINE, "RAM[]", VAR_LOCAL, "local[]", VAR_ARGUMENT, "argument[]", VAR_THIS, "this[]", VAR_THAT, "that[]", "temp[]", "RAM[]"};
    }

    public String getName() {
        return "Virtual Machine Emulator";
    }

    public String getValue(String string) throws VariableException {
        if (string.equals(VAR_LOCAL)) {
            return String.valueOf(this.cpu.getRAM().getValueAt(1));
        }
        if (string.equals(VAR_ARGUMENT)) {
            return String.valueOf(this.cpu.getRAM().getValueAt(2));
        }
        if (string.equals(VAR_THIS)) {
            return String.valueOf(this.cpu.getRAM().getValueAt(3));
        }
        if (string.equals(VAR_THAT)) {
            return String.valueOf(this.cpu.getRAM().getValueAt(4));
        }
        if (string.equals(VAR_SP)) {
            return String.valueOf(this.cpu.getSP());
        }
        if (string.equals(VAR_CURRENT_FUNCTION)) {
            return this.cpu.getCallStack().getTopFunction();
        }
        if (string.equals(VAR_LINE)) {
            return String.valueOf(this.cpu.getCallStack().getTopFunction() + "." + this.cpu.getCurrentInstruction().getIndexInFunction());
        }
        if (string.startsWith("local[")) {
            short s = VMEmulator.getRamIndex(string);
            return String.valueOf(this.cpu.getSegmentAt((short)0, s));
        }
        if (string.startsWith("argument[")) {
            short s = VMEmulator.getRamIndex(string);
            return String.valueOf(this.cpu.getSegmentAt((short)1, s));
        }
        if (string.startsWith("this[")) {
            short s = VMEmulator.getRamIndex(string);
            return String.valueOf(this.cpu.getSegmentAt((short)2, s));
        }
        if (string.startsWith("that[")) {
            short s = VMEmulator.getRamIndex(string);
            return String.valueOf(this.cpu.getSegmentAt((short)3, s));
        }
        if (string.startsWith("temp[")) {
            short s = VMEmulator.getRamIndex(string);
            return String.valueOf(this.cpu.getSegmentAt((short)4, s));
        }
        if (string.startsWith("RAM[")) {
            short s = VMEmulator.getRamIndex(string);
            return String.valueOf(this.cpu.getRAM().getValueAt(s));
        }
        throw new VariableException("Unknown variable", string);
    }

    public void setValue(String string, String string2) throws VariableException {
        block20: {
            try {
                string2 = Conversions.toDecimalForm((String)string2);
                if (string.equals(VAR_LOCAL)) {
                    int n = Integer.parseInt(string2);
                    this.check_address(string, n);
                    this.cpu.getRAM().setValueAt(1, (short)n, false);
                    if (this.gui != null) {
                        this.gui.getLocalSegment().setEnabledRange(n, 2047, true);
                    }
                    break block20;
                }
                if (string.equals(VAR_ARGUMENT)) {
                    int n = Integer.parseInt(string2);
                    this.check_address(string, n);
                    this.cpu.getRAM().setValueAt(2, (short)n, false);
                    if (this.gui != null) {
                        this.gui.getArgSegment().setEnabledRange(n, 2047, true);
                    }
                    break block20;
                }
                if (string.equals(VAR_THIS)) {
                    int n = Integer.parseInt(string2);
                    this.check_address(string, n);
                    this.cpu.getRAM().setValueAt(3, (short)n, false);
                    if (this.gui != null) {
                        this.gui.getThisSegment().setEnabledRange(n, 16383, true);
                    }
                    break block20;
                }
                if (string.equals(VAR_THAT)) {
                    int n = Integer.parseInt(string2);
                    this.check_address(string, n);
                    this.cpu.getRAM().setValueAt(4, (short)n, false);
                    if (this.gui != null) {
                        this.gui.getThatSegment().setEnabledRange(n, 24576, true);
                    }
                    break block20;
                }
                if (string.equals(VAR_SP)) {
                    int n = Integer.parseInt(string2);
                    this.check_address(string, n);
                    this.cpu.setSP((short)n);
                    break block20;
                }
                if (string.equals(VAR_CURRENT_FUNCTION)) {
                    throw new VariableException("Read Only variable", string);
                }
                if (string.equals(VAR_LINE)) {
                    int n = Integer.parseInt(string2);
                    if (n >= this.cpu.getProgram().getSize()) {
                        throw new VariableException("Line " + string2 + "is not within the program range", string);
                    }
                    this.cpu.getProgram().setPC((short)n);
                    break block20;
                }
                if (string.startsWith("local[")) {
                    short s = VMEmulator.getRamIndex(string);
                    int n = Integer.parseInt(string2);
                    this.check_value(string, n);
                    this.cpu.setSegmentAt((short)0, s, (short)n);
                    break block20;
                }
                if (string.startsWith("argument[")) {
                    short s = VMEmulator.getRamIndex(string);
                    int n = Integer.parseInt(string2);
                    this.check_value(string, n);
                    this.cpu.setSegmentAt((short)1, s, (short)n);
                    break block20;
                }
                if (string.startsWith("this[")) {
                    short s = VMEmulator.getRamIndex(string);
                    int n = Integer.parseInt(string2);
                    this.check_value(string, n);
                    this.cpu.setSegmentAt((short)2, s, (short)n);
                    break block20;
                }
                if (string.startsWith("that[")) {
                    short s = VMEmulator.getRamIndex(string);
                    int n = Integer.parseInt(string2);
                    this.check_value(string, n);
                    this.cpu.setSegmentAt((short)3, s, (short)n);
                    break block20;
                }
                if (string.startsWith("temp[")) {
                    short s = VMEmulator.getRamIndex(string);
                    int n = Integer.parseInt(string2);
                    this.check_value(string, n);
                    this.cpu.setSegmentAt((short)4, s, (short)n);
                    break block20;
                }
                if (string.startsWith("RAM[")) {
                    short s = VMEmulator.getRamIndex(string);
                    int n = Integer.parseInt(string2);
                    this.check_address(string, s);
                    this.cpu.getRAM().setValueAt(s, (short)n, false);
                    break block20;
                }
                throw new VariableException("Unknown variable", string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new VariableException("'" + string2 + "' is not a legal value for variable", string);
            }
        }
    }

    public void doCommand(String[] stringArray) throws CommandException, ProgramException, VariableException {
        if (stringArray.length == 0) {
            throw new CommandException("Empty command", stringArray);
        }
        if (this.animationMode != 2) {
            this.hideHighlightes();
        }
        if (stringArray[0].equals(COMMAND_VMSTEP)) {
            if (stringArray.length != 1) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            this.cpu.executeInstruction();
        } else if (stringArray[0].equals(COMMAND_SETVAR)) {
            if (stringArray.length != 3) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            this.setValue(stringArray[1], stringArray[2]);
        } else if (stringArray[0].equals(COMMAND_ROMLOAD)) {
            if (stringArray.length != 1 && stringArray.length != 2) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            String string = this.workingDir + (stringArray.length == 1 ? "" : "/" + stringArray[1]);
            this.cpu.getProgram().loadProgram(string, 0, 0);
            this.cpu.boot();
        } else if (stringArray[0].equals(COMMAND_ROMLOAD_BIX)) {
            if (stringArray.length != 1 && stringArray.length != 2) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            String string = this.workingDir + (stringArray.length == 1 ? "" : "/" + stringArray[1]);
            this.cpu.getProgram().loadProgram(string, 1, 1);
            this.cpu.boot();
        } else if (stringArray[0].equals(COMMAND_ROMLOAD_BI)) {
            if (stringArray.length != 1 && stringArray.length != 2) {
                throw new CommandException("Illegal number of arguments to command", stringArray);
            }
            String string = this.workingDir + (stringArray.length == 1 ? "" : "/" + stringArray[1]);
            this.cpu.getProgram().loadProgram(string, 1, 0);
            this.cpu.boot();
        } else {
            throw new CommandException("Unknown simulator command", stringArray);
        }
    }

    private void hideHighlightes() {
        this.cpu.getRAM().hideHighlight();
        this.cpu.getStack().hideHighlight();
        this.cpu.getWorkingStack().hideHighlight();
        this.cpu.getCalculator().hideHighlight();
        this.cpu.getStaticSegment().hideHighlight();
        MemorySegment[] memorySegmentArray = this.cpu.getMemorySegments();
        for (int i = 0; i < memorySegmentArray.length; ++i) {
            memorySegmentArray[i].hideHighlight();
        }
    }

    public void restart() {
        this.cpu.getRAM().reset();
        this.cpu.getCallStack().reset();
        this.cpu.getProgram().restartProgram();
        this.cpu.getStack().reset();
        this.cpu.getWorkingStack().reset();
        this.cpu.getCalculator().hideCalculator();
        this.cpu.getCalculator().reset();
        this.cpu.getStaticSegment().reset();
        MemorySegment[] memorySegmentArray = this.cpu.getMemorySegments();
        for (int i = 0; i < memorySegmentArray.length; ++i) {
            memorySegmentArray[i].reset();
        }
        this.cpu.boot();
    }

    public void setAnimationMode(int n) {
        if (this.gui != null) {
            ScreenGUI screenGUI;
            MemorySegment[] memorySegmentArray;
            if (n == 2 && this.animationMode != 2) {
                this.cpu.getRAM().disableUserInput();
                this.cpu.getStack().disableUserInput();
                this.cpu.getWorkingStack().disableUserInput();
                this.cpu.getStaticSegment().disableUserInput();
                memorySegmentArray = this.cpu.getMemorySegments();
                for (int i = 0; i < memorySegmentArray.length; ++i) {
                    memorySegmentArray[i].disableUserInput();
                }
                screenGUI = this.gui.getScreen();
                if (screenGUI != null) {
                    screenGUI.startAnimation();
                }
            }
            if (n != 2 && this.animationMode == 2) {
                this.cpu.getRAM().enableUserInput();
                this.cpu.getStack().enableUserInput();
                this.cpu.getWorkingStack().enableUserInput();
                this.cpu.getStaticSegment().enableUserInput();
                memorySegmentArray = this.cpu.getMemorySegments();
                for (int i = 0; i < memorySegmentArray.length; ++i) {
                    memorySegmentArray[i].enableUserInput();
                }
                screenGUI = this.gui.getScreen();
                if (screenGUI != null) {
                    screenGUI.stopAnimation();
                }
            }
        }
        this.animationMode = n;
        boolean bl = this.animationMode == 1;
        this.cpu.getBus().setAnimate(bl);
        this.cpu.getRAM().setAnimate(bl);
        this.cpu.getCallStack().setAnimate(bl);
        this.cpu.getProgram().setAnimate(bl);
        this.cpu.getStack().setAnimate(bl);
        this.cpu.getWorkingStack().setAnimate(bl);
        this.cpu.getCalculator().setAnimate(bl);
        this.cpu.getStaticSegment().setAnimate(bl);
        boolean bl2 = this.animationMode != 2;
        this.cpu.getRAM().setDisplayChanges(bl2);
        this.cpu.getCallStack().setDisplayChanges(bl2);
        this.cpu.getProgram().setDisplayChanges(bl2);
        this.cpu.getStack().setDisplayChanges(bl2);
        this.cpu.getWorkingStack().setDisplayChanges(bl2);
        this.cpu.getCalculator().setDisplayChanges(bl2);
        this.cpu.getStaticSegment().setDisplayChanges(bl2);
        MemorySegment[] memorySegmentArray = this.cpu.getMemorySegments();
        for (int i = 0; i < memorySegmentArray.length; ++i) {
            memorySegmentArray[i].setDisplayChanges(bl2);
            memorySegmentArray[i].setAnimate(bl);
        }
    }

    public int getInitialAnimationMode() {
        return 0;
    }

    public int getInitialNumericFormat() {
        return 0;
    }

    public void setNumericFormat(int n) {
        this.cpu.getRAM().setNumericFormat(n);
        this.cpu.getStack().setNumericFormat(n);
        this.cpu.getWorkingStack().setNumericFormat(n);
        this.cpu.getCalculator().setNumericFormat(n);
    }

    public void setAnimationSpeed(int n) {
        this.cpu.getBus().setAnimationSpeed(n);
    }

    public void refresh() {
        this.cpu.getRAM().refreshGUI();
        this.cpu.getCallStack().refreshGUI();
        this.cpu.getProgram().refreshGUI();
        this.cpu.getStack().refreshGUI();
        this.cpu.getWorkingStack().refreshGUI();
        this.cpu.getCalculator().refreshGUI();
        this.cpu.getStaticSegment().refreshGUI();
        MemorySegment[] memorySegmentArray = this.cpu.getMemorySegments();
        for (int i = 0; i < memorySegmentArray.length; ++i) {
            memorySegmentArray[i].refreshGUI();
        }
    }

    public void prepareFastForward() {
        this.gui.requestFocus();
        this.keyboard.requestFocus();
    }

    public void prepareGUI() {
    }

    public String[] getVariables() {
        return this.vars;
    }

    protected HackSimulatorGUI getGUI() {
        return this.gui;
    }

    public void computerPartErrorOccured(ComputerPartErrorEvent computerPartErrorEvent) {
        this.displayMessage(computerPartErrorEvent.getErrorMessage(), true);
    }

    public void programChanged(ProgramEvent programEvent) {
        super.programChanged(programEvent);
        if (programEvent.getType() == 1) {
            int n = this.animationMode;
            this.setAnimationMode(0);
            this.refresh();
            this.notifyListeners((byte)24, null);
            this.restart();
            this.setAnimationMode(n);
        }
    }

    private static short getRamIndex(String string) throws VariableException {
        if (string.indexOf("]") == -1) {
            throw new VariableException("Missing ']'", string);
        }
        String string2 = string.substring(string.indexOf("[") + 1, string.indexOf("]"));
        int n = Integer.parseInt(string2);
        if (n < 0 || n >= 24577) {
            throw new VariableException("Illegal variable index", string);
        }
        return (short)n;
    }

    private void check_value(String string, int n) throws VariableException {
        if (n < Short.MIN_VALUE || n >= 32768) {
            throw new VariableException(n + " is an illegal value for variable", string);
        }
    }

    private void check_address(String string, int n) throws VariableException {
        if (n < 0 || n >= 24577) {
            throw new VariableException(n + " is an illegal value for", string);
        }
    }
}

