<?php
// Allow all origins
header("Access-Control-Allow-Origin: *");

// Allow common HTTP methods
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

// Allow common headers
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");
?>
<?php

// Ensure this is a POST request
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['ok' => false, 'error' => 'Invalid request method']);
    exit();
}

// Read and decode JSON request body
$input = json_decode(file_get_contents('php://input'), true);
$client_id = $input['client_id'] ?? '';
$client_secret = $input['client_secret'] ?? '';

// Validate input
if (empty($client_id) || empty($client_secret)) {
    echo json_encode(['ok' => false, 'error' => 'Missing API credentials']);
    exit();
}

$curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => 'https://pay.xbase.digital/identity/api/Authentication/connect/token',
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_CUSTOMREQUEST => 'POST',
  CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id='.$client_id.'&client_secret='.$client_secret,
  CURLOPT_HTTPHEADER => array(
    'Content-Type: application/x-www-form-urlencoded'
  ),
));
$response = curl_exec($curl);
curl_close($curl);
// echo $response;

$resDecode = json_decode($response, true);
if($resDecode["access_token"]){
    $access_token = $resDecode["access_token"];
    //echo $access_token;
    $curl = curl_init();
    curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://pay.xbase.digital/api/External/pos/currencies',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'GET',
    CURLOPT_HTTPHEADER => array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $access_token
    ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    echo $response;
}