<?php
// Enable error logging
error_reporting(E_ALL);
ini_set('log_errors', 1);
ini_set('error_log', 'php_errors.log');

// Allow all origins
header("Access-Control-Allow-Origin: *");

// Allow common HTTP methods
header("Access-Control-Allow-Methods: GET, OPTIONS");

// Allow common headers
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Handle preflight requests (CORS preflight)
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit();
}

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    // Get raw POST data
    $json = file_get_contents("php://input");

    // Decode JSON data
    $data = json_decode($json, true);

    if ($data === null) {
        echo json_encode(["ok" => false, "error" => "Invalid JSON"]);
        exit;
    }

    // ✅ Extract dynamic credentials from request
    $client_id = $data["client_id"] ?? null;
    $client_secret = $data["client_secret"] ?? null;
    $orderId = $data["orderId"] ?? null;

    if (!$client_id || !$client_secret || !$orderId) {
        echo json_encode(["ok" => false, "error" => "Missing required fields"]);
        exit;
    }

    // 🔑 Auth request (copied from original file)
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://pay.xbase.digital/identity/api/Authentication/connect/token',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id='.$client_id.'&client_secret='.$client_secret,
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/x-www-form-urlencoded'
        ),
    ));

    $response = curl_exec($curl);
    curl_close($curl);

    $tokenData = json_decode($response, true);
    if (!isset($tokenData['access_token'])) {
        echo json_encode(["ok" => false, "error" => "Failed to get access token"]);
        exit;
    }

    $access_token = $tokenData['access_token'];

    // 📦 Poll order status
    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => "https://pay.xbase.digital/api/orders/{$orderId}",
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
        CURLOPT_HTTPHEADER => array(
            'Authorization: Bearer ' . $access_token,
            'Accept: application/json'
        ),
    ));

    $response = curl_exec($curl);
    $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
    curl_close($curl);

    if ($httpCode === 200) {
        $orderData = json_decode($response, true);
        echo json_encode(["ok" => true, "data" => $orderData]);
    } else {
        echo json_encode(["ok" => false, "error" => "https://pay.xbase.digital/api/orders/{$orderId}"]);
    }
} else {
    echo json_encode(["ok" => false, "error" => "Invalid request method"]);
}
