<?php
// Enable error logging
error_reporting(E_ALL);
ini_set('log_errors', 1);
ini_set('error_log', 'php_errors.log'); // Logs to a file

// Allow all origins
header("Access-Control-Allow-Origin: *");

// Allow common HTTP methods
header("Access-Control-Allow-Methods: GET, POST, OPTIONS");

// Allow common headers
header("Access-Control-Allow-Headers: Content-Type, Authorization, X-Requested-With");

// Handle preflight requests (CORS preflight)
if ($_SERVER['REQUEST_METHOD'] == 'OPTIONS') {
    http_response_code(200);
    exit();
}
?>

<?php
if ($_SERVER["REQUEST_METHOD"] === "POST") {
                        
    // Get raw POST data
    $json = file_get_contents("php://input");

    // Decode JSON data
    $data = json_decode($json, true);

    // Check if decoding was successful
    if ($data === null) {
        echo json_encode(["ok" => false, "error" => "Invalid JSON"]);
        exit;
    }
    // Variables
    $dollarAmount = $data["amount"] ?? null;
    $cryptoCurrency = $data["cryptoCurrency"] ?? null;
    $anonymous = $data["anonymous"] ?? null;
    $client_id = $data["client_id"] ?? null;
    $client_secret = $data["client_secret"] ?? null;
    $merchantLocationId = $data["merchant_location_id"] ?? null;
    
    
    // Validate input
    if (!$dollarAmount || !$cryptoCurrency) {
        echo json_encode(["ok" => false, "error" => "Missing required fields"]);
        exit;
    }

    $merchantOrderId = $data["merchantOrderId"] ?? null;  

    if(isset($anonymous) && $anonymous == "yes"){
        $donorNote = $data["donorNote"] ?? null;
        $customerName = "Anonymous Donor";
        $email = "anonymous.donation@xbd.group";
        $description = "Anonymous Donation-" . $merchantOrderId . ". <br><br> Donor Note: " . $donorNote;
    }

    if(isset($anonymous) && $anonymous == "no"){
        $donorNote = $data["donorNote"] ?? null;
        $customerName = trim(($data["firstName"] ?? '') . " " . ($data["lastName"] ?? '')) ?: "Anonymous Donor";
        $email = !empty($data["email"]) ? $data["email"] : "anonymous.donation@xbd.group";
        $description = $customerName . " Donation-" . $merchantOrderId . ".<br> Donor Type: " . $data["donation_type"] . "<br> Donor Country: " . $data["country"] . "<br><br> Donor Note: " . $donorNote;
    }
    
    $title = "Donation";
    $amount = $dollarAmount;
    $currency = "GBP";

    $acceptUrl = "https://us.helpyateem.org/accept?order_id=e-" . $merchantOrderId;
    $cancelUrl = "https://us.helpyateem.org/cancel";
    $callbackUrl = "https://us.helpyateem.org/callback?order_id=e-" . $merchantOrderId;

    $itemName = "Donation - Order-#".$merchantOrderId;
    $price = $dollarAmount;
    $quantity = 1;

    $curl = curl_init();
    curl_setopt_array($curl, array(
    CURLOPT_URL => 'https://pay.xbase.digital/identity/api/Authentication/connect/token',
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_ENCODING => '',
    CURLOPT_MAXREDIRS => 10,
    CURLOPT_TIMEOUT => 0,
    CURLOPT_FOLLOWLOCATION => true,
    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
    CURLOPT_CUSTOMREQUEST => 'POST',
    CURLOPT_POSTFIELDS => 'grant_type=client_credentials&client_id='.$client_id.'&client_secret='.$client_secret,
    CURLOPT_HTTPHEADER => array(
        'Content-Type: application/x-www-form-urlencoded'
    ),
    ));
    $response = curl_exec($curl);
    curl_close($curl);
    // echo $response;

    $resDecode = json_decode($response, true);
    if($resDecode["access_token"]){
        $access_token = $resDecode["access_token"];
        //echo $access_token;

        //Authorize order
        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://pay.xbase.digital/api/orders/authorize',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'PUT',
        CURLOPT_POSTFIELDS => json_encode([
            "merchantLocationId" => $merchantLocationId,
            "merchantOrderId" => $merchantOrderId,
            "title" => $title,
            "description" => $description,
            "amount" => $amount,
            "currency" => $currency,
            "email" => $email,
            "acceptUrl" => $acceptUrl,
            "cancelUrl" => $cancelUrl,
            "callbackUrl" => $callbackUrl
        ]),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json',
            'Authorization: Bearer ' . $access_token
        ),
        ));
        $resOrder = curl_exec($curl);
        curl_close($curl);
        //echo $resOrder . "<br><br>";
        //{"orderId":"981d977e-6cb6-406d-b200-0176fdf85d38","paymentRedirectUrl":"https://pay.xbase.digital?orderId=981d977e-6cb6-406d-b200-0176fdf85d38"}

        $resOrderDecoded = json_decode($resOrder, true);
        if($resOrderDecoded["orderId"]){
            //Generate QR
            $orderId = $resOrderDecoded["orderId"];
            $curl = curl_init();

            curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://pay.xbase.digital/api/External/pos/purchase/generate/qr',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode([
                "locationId" => $merchantLocationId,
                "orderId" => $orderId,
                "amount" => $amount,
                "currency" => $currency,
                "cryptoCurrency" => $cryptoCurrency,
                "cart" => [
                    [
                        "id" => $orderId,
                        "name" => $itemName,
                        "price" => $price,
                        "quantity" => $quantity
                    ]
                ],
                "customerInfo" => [
                    "name" => $customerName,
                    "email" => $email
                ]
            ]),
            
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json',
                'Authorization: Bearer ' . $access_token
            ),
            ));

            $response = curl_exec($curl);
            $httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            curl_close($curl);
            $orderData = json_decode($response, true);

            if ($httpCode === 200) {
                
                if ($orderData) {
                    echo json_encode(["ok" => true, "data" => $orderData, "internal" => $resOrderDecoded]);
                } else {
                    echo json_encode(["ok" => false, "error" => "Failed to parse order data"]);
                }
            } else {
              
                echo json_encode([
                    "ok" => false, 
                    "error" => "Order request failed with code " . json_encode($orderData) . ", " . json_encode($resOrderDecoded)
                ]);
            }


           
            // echo json_encode(["ok" => true, "data" => { "res":  $response , "internal": $resOrder }]);

            //{"ok":true,"result":{"totalAmount":"0.00058773","currency":"GBP","cryptoCurrency":"ETH","id":"4b9eda70-99cf-4bd4-96fc-2dcadbcc712c","meta":{"offerId":"2ff1ec4d-75ce-4fda-88fa-b06bfea01a92","receiverAddress":"0x47F874d2F4Afe77682D14Da6BD285B8625344036","qrString":"ethereum:0x47F874d2F4Afe77682D14Da6BD285B8625344036?value=0.00058773"}},"tracingId":"dcdbf526-0bf1-4936-b000-b3dbb5917bf8#1740755074939"}
        }

    }
} else {
    echo json_encode(["ok" => false, "error" => "Invalid request method"]);
}