<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}

// Add settings menu to the WordPress admin dashboard
function crypto_donation_add_admin_menu() {
    add_menu_page(
        'Crypto Donation Settings',
        'Crypto Donation',
        'manage_options',
        'crypto-donation-settings',
        'crypto_donation_settings_page',
        'dashicons-admin-generic',
        90
    );
}
add_action('admin_menu', 'crypto_donation_add_admin_menu');

// Settings page content
function crypto_donation_settings_page() {
    if (isset($_POST['save_api_keys']) && check_admin_referer('crypto_donation_settings_action', 'crypto_donation_nonce')) {
        update_option('crypto_donation_client_id', sanitize_text_field($_POST['client_id']));
        update_option('crypto_donation_client_secret', sanitize_text_field($_POST['client_secret']));
        update_option('crypto_donation_merchant_location_id', sanitize_text_field($_POST['merchant_location_id']));
        echo '<div class="updated"><p>Settings saved.</p></div>';
    }

    // Retrieve saved options
    $client_id = get_option('crypto_donation_client_id', '');
    $client_secret = get_option('crypto_donation_client_secret', '');
    $merchant_location_id = get_option('crypto_donation_merchant_location_id', '');
    ?>

    <div class="wrap">
        <h1>Crypto Donation Settings</h1>
        <form method="post">
            <?php wp_nonce_field('crypto_donation_settings_action', 'crypto_donation_nonce'); ?>
            <table class="form-table">
                <tr>
                    <th><label for="client_id">Client ID</label></th>
                    <td><input type="text" id="client_id" name="client_id" value="<?php echo esc_attr($client_id); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th><label for="client_secret">Client Secret</label></th>
                    <td><input type="text" id="client_secret" name="client_secret" value="<?php echo esc_attr($client_secret); ?>" class="regular-text"></td>
                </tr>
                <tr>
                    <th><label for="merchant_location_id">Merchant Location ID</label></th>
                    <td><input type="text" id="merchant_location_id" name="merchant_location_id" value="<?php echo esc_attr($merchant_location_id); ?>" class="regular-text"></td>
                </tr>
            </table>
            <?php submit_button('Save API Keys', 'primary', 'save_api_keys'); ?>
        </form>
    </div>
    <?php
}

// Function to retrieve stored API keys securely
function crypto_donation_get_api_keys() {
    return [
        'client_id' => get_option('crypto_donation_client_id', ''),
        'client_secret' => get_option('crypto_donation_client_secret', ''),
        'merchant_location_id' => get_option('crypto_donation_merchant_location_id', ''),
    ];
}
