<?php
/**
 * Plugin Name: Crypto Donation
 * Description: A plugin for Crypto Donation form.
 * Version: 1.0
 * License: GPL2
 */
 
if (!defined('ABSPATH')) {
    exit; // Prevent direct access.
}

// Define constants for plugin paths and URLs
define('CRYPTO_DONATION_DIR', plugin_dir_path(__FILE__));
define('CRYPTO_DONATION_URL', plugin_dir_url(__FILE__));

define('BRAND_LOGO', CRYPTO_DONATION_URL . 'assets/Help-Yateem.png');
define('QR_PLACEHOLDER', CRYPTO_DONATION_URL . 'assets/qr-placeholder.png');
define('GET_WALLET_FILE', CRYPTO_DONATION_DIR . 'includes/getWallet.php');
define('GET_STATUS', CRYPTO_DONATION_DIR . 'includes/getStatus.php');
define('GET_CURRENCIES_FILE', CRYPTO_DONATION_DIR . 'includes/getCurrencies.php');

/**
 * Plugin Activation Hook
 * Ensures required files exist.
 */
function crypto_donation_install() {
    $plugin_dir = plugin_dir_path(__FILE__);

    // Check if required files exist
    if (!file_exists($plugin_dir . 'assets/qr-placeholder.png') ||
        !file_exists($plugin_dir . 'includes/getWallet.php') ||
        !file_exists($plugin_dir . 'includes/getStatus.php') ||
        !file_exists($plugin_dir . 'includes/getCurrencies.php')) {
        wp_die('Error: Required files are missing from the plugin folder.');
    }
}
register_activation_hook(__FILE__, 'crypto_donation_install');

if (is_admin()) {
    require_once plugin_dir_path(__FILE__) . 'admin/settings.php';
}

//Passing API Keys to JS
function crypto_donation_enqueue_scripts() {
    wp_enqueue_script('jquery');

    // Register an empty script for inline JS attachment
    wp_register_script('crypto-donation-script', '', [], null, true);
    wp_enqueue_script('crypto-donation-script');

    // Prepare API keys for inline JS
    $js_data = "
        var cryptoDonationData = {
            client_id: '" . esc_js(get_option('crypto_donation_client_id', '')) . "',
            client_secret: '" . esc_js(get_option('crypto_donation_client_secret', '')) . "',
            merchant_location_id: '" . esc_js(get_option('crypto_donation_merchant_location_id', '')) . "'
        };
    ";

    wp_add_inline_script('crypto-donation-script', $js_data, 'before');
}
add_action('wp_enqueue_scripts', 'crypto_donation_enqueue_scripts');

/**
 * Shortcode to display the donation form
 */
    
function donation_form_shortcode() {
    ob_start();
    ?>
    <div id="multi-step-form">
        <div  class="plugin-box w-full p-6 bg-white rounded-lg shadow-lg flex flex-col items-center">
            <img id="logo" src="<?php echo BRAND_LOGO; ?>" style="width:250px; height:50px;" alt="QR Code" class="rounded">
            <!-- Your entire HTML form structure goes here -->
        
            <div id="box1" class="form-box active w-full max-w-sm bg-white ">
                      
                    <h2 
                        style="font-size: 15px;padding-top: 4px;"
                        class=" font-bold text-left mb-4">
                        Make a Donation
                    </h2>
                        <!-- Search & Selection Input -->
                        <div class="relative mb-2">
                            <div class="flex items-center border rounded p-2 bg-white" style="border: solid 1px #dedede;">
                                <img id="selectedCoinLogo" src="" class="w-6 h-6 rounded-full mr-2 hidden" alt="">
                                <input 
                                type="text" id="searchInput" class="w-full border-none outline-none bg-transparent" placeholder="Search or select a coin" oninput="filterCrypto()" onclick="this.value=''; filterCrypto();" 
                                style="cursor: pointer;border: solid 0px !important">
                                <span class="text-gray-500">▼</span>
                            </div>
                            <ul 
                            id="suggestions" 
                            style="padding-left: 0px !important;"
                            class="bg-white border rounded shadow-md hidden max-h-40 overflow-y-auto absolute z-10 w-full mt-1"></ul>
                        </div>
                        <!-- Crypto Conversion Inputs -->
                        <!-- <div class="flex items-center space-x-2 mb-4"> -->
                            <!-- <input 
                            style="width: 50%"
                            type="number" id="cryptoQty" class="p-2 border rounded text-left" placeholder="Qty" step="any" value="1" min="0"> -->
                            <!-- <span class="text-gray-600 text-lg">£</span>
                            <input 
                            style="width: 100%"
                            type="text" id="dollarAmount" class="p-2 border rounded text-left" placeholder="amount" step="any">
                        </div> -->

                        <div class="relative w-full mb-4">
                            <div class="absolute inset-y-0 left-0 flex items-center pl-3">
                                <span class="text-gray-500 text-xlg">£</span>
                            </div>
                            <input 
                                style="padding-left: 21px;"
                                type="text"
                                id="dollarAmount"
                                class="pl-8 pr-4 py-2 w-full border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:border-blue-500 focus:ring-1 focus:ring-blue-500 text-gray-900 text-lg"
                                placeholder="Enter amount"
                            />
                        </div>

                        <!-- Current Rate Input -->
                        <input type="hidden" id="currentRate" class="w-full p-2 border rounded hidden" placeholder="Current Rate" readonly>
                        <input type="hidden" id="cryptoCurrency">
                        <input type="hidden" id="kytNetwork">
                
                        <!-- Checkbox for adding a note -->
                        <!-- <div class="flex items-center mt-3">
                            <input type="checkbox" id="addNote" class="mr-2">
                            <label for="addNote" class="text-sm text-gray-600">Add a note to your donation</label>
                        </div> -->
                        <div class="flex items-center mt-3">
                                <!-- Address 2 -->
                            <select id="donation_type" placeholder="Donation Type *" class="w-full p-2 border rounded mb-3 pinfo">
                            <option value="">Donation Type</option>
                            <option value="General Donation">General Donation</option>
                            <option value="Zakat">Zakat</option>
                            <option value="Sadaqah">Sadaqah</option>
                            <option value="Lillah">Lillah</option>
                            </select>
                        </div> 
                
                        <!-- Note Textarea (Initially Hidden) -->
                        <textarea id="noteTextarea" class="w-full p-2 border border-gray-400 rounded hidden mt-2 h-32" placeholder="Enter your note here..."></textarea>
                
                        <!-- Next Button -->
                        <div class="btn-container">
                            <button class="hidden">Back</button>
                            <button onclick="nextBox(1)"
                            class="w-full bg-black text-white py-2 rounded-lg font-semibold hover:bg-cyan-500" id="nextStep">Donate</button>
                        </div>
    
    
            </div>
    
            <div id="box2" class="form-box bg-white w-96 p-6 relative" style="padding: 0px !important">
        
                <div class="flex items-center gap-2  mb-4">
                    <button onclick="prevBox(2)" class=" left-4 top-1 text-4xl text-gray-600 hover:text-gray-800">
                        &#8592;
                    </button>
            
                    <h2 
                    style="font-size: 15px;padding-top: 4px;"
                    class=" font-bold text-left"
                    >Personal Info</h2>
                </div>
                <!-- Make donation anonymous -->
                <!-- <div class="flex items-center space-x-2 mb-4">
                    <input type="checkbox" id="anonymousCheckbox" onclick="toggleFields()" class="w-4 h-4">
                    <label for="anonymousCheckbox" class="text-sm">Make donation anonymous</label>
                </div> -->
        
                <!-- First Name & Last Name -->
                <div class="flex space-x-2 mb-3">
                    <input type="text" id="firstName" placeholder="First name *" class="w-1/2 p-2 border rounded pinfo">
                    <input type="text" id="lastName" placeholder="Last name *" class="w-1/2 p-2 border rounded pinfo">
                </div>
        
                <div class="pb-2">
                    <!-- Email -->
                    <input type="email" id="email" placeholder="Email *" class="w-full p-2 border rounded mb-3 pinfo">
                </div>
                <div class="pb-2">
                <!-- Address 1 -->
                 <input type="text" id="country" placeholder="Country *" class="w-full p-2 border rounded mb-3 pinfo">
                </div>
        
        
                <!-- Mailing List Checkbox -->
                <!-- <div class="flex items-center space-x-2 mb-4">
                    <input type="checkbox" id="subscribe" class="w-4 h-4 pinfo">
                    <label for="subscribe" class="text-sm">Join our mailing list for news and updates</label>
                </div> -->
        
                <!-- Next Button -->
                <button onclick="paymentBox(2)" class="w-full bg-black text-white py-2 rounded-lg font-semibold hover:bg-cyan-500">
                    Next
                </button>
        
                <!-- Footer -->
                <p class="text-xs text-gray-500 text-center mt-4">
                    By proceeding you agree with terms and conditions.
                </p>
            </div>
        
        
            <div id="box3" class="form-box bg-white w-96 p-6 relative"  style="padding-left: 0px !important; padding-right: 0px !important">
        

                <div class="flex items-center gap-2  mb-4">
                    <button onclick="prevBox(3)" class=" left-4 top-1 text-4xl text-gray-600 hover:text-gray-800">
                        &#8592;
                    </button>
                    <h3 
                    style="font-size: 15px;padding-top: 4px;"
                    class=" font-bold text-left"
                    >Awaiting Payment  ( <span id="countdown" class="text-red-500 ml-2"></span> )</h3>
                </div>
                <div id="dAmount" style="border: solid 1px grey; padding: 6px 3px;"></div>
                <p 
                style="font-size: 12px; text-align: left; padding-top: 5px;"
                class="text-gray-600 mb-4">Use the address below to make a donation from your wallet.</p>
        
                <!-- QR Code -->
                <div class="flex justify-center mb-2 mt-2">
                    <canvas id="qrcode" style="width:150px; height:150px;"></canvas>
                    <!-- <img id="qrCode" src="<?php echo QR_PLACEHOLDER; ?>" style="width:150px; height:150px;" alt="QR Code" class="rounded"> -->
                </div>
        
                <!-- Wallet Address with Copy Icon -->
                <div class="relative flex items-center border rounded-lg p-2 bg-gray-100" style="padding-right: 28px !important;">
                    <input 
                    style="
                        font-size: 10px;
                        padding: 2px 6px;
                        margin: 0px 0px;
                    "
                    type="text" id="walletAddress"  value="Loading..." class="w-full bg-transparent text-center text-gray-800 font-medium outline-none" readonly>
                    <button onclick="copyToClipboard()" class="absolute right-2 text-gray-500 hover:text-gray-700">
                        📋
                    </button>
                </div>
        
                <!-- Donate with MetaMask Button -->
                <!-- <button onclick="donateWithMetaMask()" class="mt-4 flex items-center justify-center w-full border border-gray-400 text-gray-700 py-2 rounded-lg shadow-md hover:bg-gray-100">
                    <img src="https://github.com/MetaMask/brand-resources/raw/master/SVG/SVG_MetaMask_Icon_Color.svg" style="height: 25px;" alt="MetaMask Logo" class="h-5 mr-2">
                    Donate with MetaMask
                </button> -->
        
                <!-- Warning Text -->
                <p class="text-xs text-red-600 mt-4 mb-4">
                    Send only <span id="cryptoName">USDC (ERC-20)</span> to this address using the <span id="cryptoNet">Ethereum</span> blockchain. Sending other tokens or NFTs may result in loss of donation. The address expires after 180 days if unused.
                </p>
        
             
        
            </div>

            <div id="box4" class="form-box  bg-white w-96 p-6 relative"  style="padding-left: 0px !important; padding-right: 0px !important">
                <div>
                    <h2 
                        id="statusMessage"
                        style="font-size: 18px;padding-top: 4px;"
                        class=" font-bold text-center mb-4">
                        
                    </h2>
                    <p 
                        style="font-size: 14px; text-align: left; padding-top: 5px;"
                        id="statusMessageBody">
                      
                    </p>
                    <!-- Start Over Button -->
                    <button onclick="startOver()" class="w-full bg-black text-white py-2 rounded-lg font-semibold hover:bg-cyan-500">
                        Start Over
                    </button>
                </div>
            </div>
          

        </div>

    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/qrcode-generator/1.4.4/qrcode.min.js"></script>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .plugin-box{
            padding: 20px;
            box-shadow: 0px 4px 6px rgba(0, 0, 0, 0.1);
            border: 1px solid #ddd;
            border-radius: 8px;
        }
        .form-box {
            display: none;
            /* Hide all boxes by default */
            width: 350px;
            max-width: 95%;
            text-align: center;
            margin: 0px 0px;
        }
        
        
        .active {
            display: block;
            /* Show active box */
        }
        
        .btn-container {
            margin-top: 10px;
            display: flex;
            justify-content: space-between;
        }
        
        .hidden {
            visibility: hidden;
        }
    </style>

    <script>
        function copyToClipboard() {
            const addressField = document.getElementById("walletAddress");
            navigator.clipboard.writeText(addressField.value).then(() => {
                alert("Address copied!");
            });
        }

        function donateWithMetaMask() {
            alert("MetaMask donation flow to be implemented.");
        }

        function startOver() {
            window.location.reload();
        }
    </script>

    <script>
        function goBack() {
            window.history.back();
        }

        function toTitleCase(str) {
            return str
                .toLowerCase() // Convert the string to lowercase first
                .replace(/\b\w/g, char => char.toUpperCase()); // Capitalize first letter of each word
        }

        function uniqid(prefix = "", moreEntropy = false) {
            let id = prefix + Date.now().toString(16);
            if (moreEntropy) {
                id += Math.floor((Math.random() * 100000000)).toString(16);
            }
            return id;
        }

        async function startBox(current) {
            document.getElementById("box" + current).classList.remove("active"); // Hide current box
            document.getElementById("box3").classList.remove("active"); // Hide current box
            document.getElementById("box1").classList.add("active"); // Show next box
        }

        async function nextBox(current) {
            document.getElementById("box" + current).classList.remove("active"); // Hide current box
            document.getElementById("box" + (current + 1)).classList.add("active"); // Show next box

            if (current == 2) {
                // const cryptoQty = document.getElementById("cryptoQty").value;
                const cryptoCurrency = document.getElementById("cryptoCurrency").value;
                const kytNetwork = document.getElementById("kytNetwork").value;
                const dollarAmount =  String(document.getElementById("dollarAmount").value);
                let numericAmount = Number(dollarAmount.replace(/[^0-9.]/g, ""));
                let formattedAmount = numericAmount.toFixed(2);

               
                document.getElementById("cryptoName").innerHTML = `${cryptoCurrency} (${toTitleCase(kytNetwork)})`;
                document.getElementById("cryptoNet").innerHTML = toTitleCase(kytNetwork);

                const merchantOrderId = uniqid("order_", true);

                let donorNote = ""; // Declare variable for donor note
                let postData = {}; // Declare postData before if-else
                const firstName = document.getElementById("firstName").value;
                const lastName = document.getElementById("lastName").value;
                const email = document.getElementById("email").value;
                const country = document.getElementById("country").value;
                const donation_type = document.getElementById("donation_type").value;
                postData = {
                    amount: dollarAmount,
                    cryptoCurrency: cryptoCurrency,
                    anonymous: "no",
                    firstName: firstName,
                    lastName: lastName,
                    email: email,
                    country: country,
                    donation_type: donation_type,
                    // subscribe: subscribe,
                    donorNote: donorNote,
                    client_id: cryptoDonationData.client_id,
                    client_secret: cryptoDonationData.client_secret,
                    merchant_location_id: cryptoDonationData.merchant_location_id,
                    merchantOrderId: merchantOrderId
                };

                try {
                    const response = await fetch("<?php echo plugins_url('includes/getWallet.php', __FILE__); ?>", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json"
                        },
                        body: JSON.stringify(postData)
                    });

                    const res = await response.json();
                    const data = res.data;

                    console.log('testing response()111111', res)
                    if (data.ok) {
                        // document.getElementById("dAmount").innerHTML = `${cryptoQty} ${cryptoCurrency} (${kytNetwork}) ≈ $${formattedAmount}`;
                        document.getElementById("dAmount").innerHTML = `Amount: ${data.result.totalAmount}  ${cryptoCurrency} `;
                        const walletAddress = data.result.meta.receiverAddress;
                        const qrString = data.result.meta.qrString;
                        generateQRCode(data.result.meta.qrString)
                        document.getElementById("walletAddress").value = walletAddress;
                        // Start countdown for 20 seconds
                        startCountdown(20);
                        console.log("cryptoDonationData:", cryptoDonationData);
                      
                        // Start polling getStatus.php every second
                        startPollingStatus(res.internal.orderId, cryptoDonationData.client_id, cryptoDonationData.client_secret, cryptoDonationData.merchant_location_id );
                    }
                } catch (error) {
                    console.log('ss',error  )
                    alert("Too many wallet requests. Please try again later.");
                    startBox(2);
                }
            }
        }


        async function paymentBox(current) {
          
            if (current == 2) {
                // const cryptoQty = document.getElementById("cryptoQty").value;
                const cryptoCurrency = document.getElementById("cryptoCurrency").value;
                const kytNetwork = document.getElementById("kytNetwork").value;
                const dollarAmount =  String(document.getElementById("dollarAmount").value);
                let numericAmount = Number(dollarAmount.replace(/[^0-9.]/g, ""));
                let formattedAmount = numericAmount.toFixed(2);

               
                document.getElementById("cryptoName").innerHTML = `${cryptoCurrency} (${toTitleCase(kytNetwork)})`;
                document.getElementById("cryptoNet").innerHTML = toTitleCase(kytNetwork);

                const merchantOrderId = uniqid("order_", true);

                let donorNote = ""; // Declare variable for donor note
                let postData = {}; // Declare postData before if-else
                const firstName = document.getElementById("firstName").value;
                const lastName = document.getElementById("lastName").value;
                const email = document.getElementById("email").value;
                const country = document.getElementById("country").value;
                const donation_type = document.getElementById("donation_type").value;
                postData = {
                    amount: dollarAmount,
                    cryptoCurrency: cryptoCurrency,
                    anonymous: "no",
                    firstName: firstName,
                    lastName: lastName,
                    email: email,
                    country: country,
                    donation_type: donation_type,
                    // subscribe: subscribe,
                    donorNote: donorNote,
                    client_id: cryptoDonationData.client_id,
                    client_secret: cryptoDonationData.client_secret,
                    merchant_location_id: cryptoDonationData.merchant_location_id,
                    merchantOrderId: merchantOrderId
                };

                try {
                    const response = await fetch("<?php echo plugins_url('includes/getWallet.php', __FILE__); ?>", {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json"
                        },
                        body: JSON.stringify(postData)
                    });

                    const res = await response.json();
                    const data = res.data;

                    console.log('testing response()111111', res)
                    if (data.ok) {
                        // document.getElementById("dAmount").innerHTML = `${cryptoQty} ${cryptoCurrency} (${kytNetwork}) ≈ $${formattedAmount}`;
                        document.getElementById("dAmount").innerHTML = `Amount: ${data.result.totalAmount}  ${cryptoCurrency} `;
                        const walletAddress = data.result.meta.receiverAddress;
                        const qrString = data.result.meta.qrString;
                        generateQRCode(data.result.meta.qrString)
                        document.getElementById("walletAddress").value = walletAddress;
                        // Start countdown for 20 seconds
                        startCountdown(20);
                        console.log("cryptoDonationData:", cryptoDonationData);
                      
                        // Start polling getStatus.php every second
                        startPollingStatus(res.internal.orderId, cryptoDonationData.client_id, cryptoDonationData.client_secret, cryptoDonationData.merchant_location_id );
                    }
                    document.getElementById("box" + current).classList.remove("active"); // Hide current box
                    document.getElementById("box" + (current + 1)).classList.add("active"); // Show next box

                } catch (error) {
                    console.log('ss',error.error  )
                    alert("Too many wallet requests. Please try again later.");
                    startBox(2);
                }
            }
        }

        function startCountdown(minutes) {
            const countdownElement = document.getElementById('countdown');
            let timeLeft = minutes * 60;

            function updateCountdown() {
                let minutes = Math.floor(timeLeft / 60);
                let seconds = timeLeft % 60;
                countdownElement.textContent = `${minutes}:${seconds < 10 ? '0' : ''}${seconds}`;
                
                if (timeLeft > 0) {
                    timeLeft--;
                    setTimeout(updateCountdown, 1000);
                } else {
                    countdownElement.textContent = 'Expired';
                }
            }

            updateCountdown();
        }


        function generateQRCode(input) {
            // const input = document.getElementById("text-input").value;
            const canvas = document.getElementById("qrcode");
            const ctx = canvas.getContext("2d");

            if (!input.trim()) {
                alert("Please enter a valid text or URL");
                return;
            }

            // QR Code size
            const size = 256;
            canvas.width = size;
            canvas.height = size;
            ctx.clearRect(0, 0, size, size);

            // Generate QR code using qrcode.js
            const qr = qrcode(0, 'L'); // Error correction level L (low)
            qr.addData(input);
            qr.make();

            const cellSize = size / qr.getModuleCount();

            for (let row = 0; row < qr.getModuleCount(); row++) {
                for (let col = 0; col < qr.getModuleCount(); col++) {
                    ctx.fillStyle = qr.isDark(row, col) ? "#000" : "#fff";
                    ctx.fillRect(col * cellSize, row * cellSize, cellSize, cellSize);
                }
            }
        }

     



        let pollingInterval;
        let pollingTimeout;

        function startPollingStatus(orderId,  client_id,client_secret, merchant_location_id) {
            // Clear any existing intervals to prevent duplicates
            clearInterval(pollingInterval);
            clearTimeout(pollingTimeout);
            pollingInterval = setInterval(async () => {
                try {
                    const response = await fetch(`<?php echo plugins_url('includes/getStatus.php', __FILE__); ?>`, {
                        method: "POST",
                        headers: {
                            "Content-Type": "application/json"
                        },
                        body: JSON.stringify({
                            orderId: orderId,
                            client_id: client_id,
                            client_secret: client_secret,
                            merchant_location_id: merchant_location_id,
                        })
                    });

                    const data = await response.json();
                    console.log("Polling response:", data.data);

                    
                    if (data.data.status === "Paid") {
                        nextBox(3)
                        document.getElementById("statusMessage").innerHTML = "Payment successful!";
                        document.getElementById("statusMessageBody").innerHTML = "Thank you for your donation. Your payment has been successfully processed.";
                        clearInterval(pollingInterval);
                    }
                    if (data.data.status === "PaymentDeclined") {
                        nextBox(3)
                        document.getElementById("statusMessage").innerHTML = "Payment failed.";
                        document.getElementById("statusMessageBody").innerHTML = "There was an issue with your payment. Please try again.";
                        clearInterval(pollingInterval);
                    }
                  

                } catch (error) {
                    console.error("Error while polling status:", error);
                }
            }, 3000); // Poll every 1 second

            // Optional: Stop polling after 60 seconds (to avoid endless loops)
            pollingTimeout = setTimeout(() => {
                clearInterval(pollingInterval);
                console.warn("Polling timed out after 60 seconds.");
                document.getElementById("statusMessage").innerHTML = "Payment status check timed out.";
            }, 20 * 60 * 1000); // 60 seconds
        }


        function prevBox(current) {
            document.getElementById("box" + current).classList.remove("active"); // Hide current box
            document.getElementById("box" + (current - 1)).classList.add("active"); // Show previous box
        }
    </script>

    <script>
        // function toggleFields() {
        //     let isChecked = document.getElementById("anonymousCheckbox").checked;
        //     let inputs = document.querySelectorAll("input.pinfo[type='text'], input.pinfo[type='email'], input.pinfo[type='checkbox'], select.pinfo");

        //     inputs.forEach(input => {
        //         input.disabled = isChecked;
        //         input.classList.toggle("bg-gray-200", isChecked); // Add gray background when disabled
        //     });
        // }
    </script>

    <script>
        let cryptoData = {};

        async function waitForCryptoData() {
            return new Promise((resolve) => {
                const checkData = setInterval(() => {
                    if (typeof cryptoDonationData !== "undefined") {
                        clearInterval(checkData);
                        resolve(cryptoDonationData);
                    }
                }, 100); // Check every 100ms
            });
        }
        
        async function fetchCryptoData() {
            try {
                // Ensure cryptoDonationData is available before proceeding
                await waitForCryptoData();
        
                console.log("cryptoDonationData:", cryptoDonationData);
        
                const client_id = cryptoDonationData.client_id;
                const client_secret = cryptoDonationData.client_secret;
        
                const response = await fetch("<?php echo plugins_url('includes/getCurrencies.php', __FILE__); ?>", {
                    method: "POST",
                    headers: { "Content-Type": "application/json" },
                    body: JSON.stringify({
                        client_id: client_id,
                        client_secret: client_secret
                    })
                });
             
                const data = await response.json();
                console.log('testing response()', data)

                if (data.ok) {
                    cryptoData = data.result.reduce((acc, coin) => {
                        acc[coin.id] = {
                            id: coin.id,
                            fullTitle: coin.fullTitle,
                            rate: coin.currentRate,
                            logo: coin.logo,
                            kytNetwork: coin.kytNetwork
                        };
                        return acc;
                    }, {});
                } else {
                    console.error("Error fetching crypto data:", data.error);
                }
            } catch (error) {
                console.error("Error fetching crypto data:", error);
            }
        }
        
        // Run function after DOM is fully loaded
        document.addEventListener("DOMContentLoaded", () => {
            fetchCryptoData();
        });


        function toggleDropdown(show) {
            document.getElementById("suggestions").classList.toggle("hidden", !show);
        }

        function filterCrypto() {
            const input = document.getElementById("searchInput").value.toLowerCase();
            const suggestionsList = document.getElementById("suggestions");
            suggestionsList.innerHTML = "";

            Object.values(cryptoData).forEach(coin => {
                if (coin.fullTitle.toLowerCase().includes(input) || coin.id.toLowerCase().includes(input)) {
                    const li = document.createElement("li");
                    li.classList.add("p-2", "cursor-pointer", "hover:bg-gray-200", "flex", "items-center");

                    const img = document.createElement("img");
                    img.src = coin.logo;
                    img.classList.add("w-6", "h-6", "rounded-full", "mr-2");

                    li.appendChild(img);
                    li.appendChild(document.createTextNode(`${coin.fullTitle} (${coin.id})`));

                    li.onclick = () => selectCrypto(coin.id);
                    suggestionsList.appendChild(li);
                }
            });

            toggleDropdown(true);
        }

        //{"id":"USDT","fullTitle":"Tether","decimals":6,"currentRate":"0.999755","symbol":"","isPayment":true,"isFiat":false,"fiatEquivalent":null,"sort":null,"isEnabled":true,"logo":"https://rocketfuel-assets.s3.amazonaws.com/assets/prod/coins/usdt.svg","mobileLogo":"https://rocketfuel-assets.s3.amazonaws.com/assets/prod/coins/mobile/currencies/usdt.png","isStableCoin":true,"isTopCoin":false,"network":"","fasterConfirmation":true,"upliftPercentage":"0","provider":["cryptoapis-test","coinbase","copper-test","cryptoapis"],"kytNetwork":"ETHEREUM","isMultipleNetwork":true,"chains":null,"networkMsg":""}

        function selectCrypto(coinId) {
            const selectedCoin = cryptoData[coinId];
            if (!selectedCoin) return;

            document.getElementById("searchInput").value = `${selectedCoin.fullTitle} (${selectedCoin.id})`;
            document.getElementById("cryptoCurrency").value = `${selectedCoin.id}`;
            document.getElementById("kytNetwork").value = `${selectedCoin.kytNetwork}`;
            document.getElementById("currentRate").value = selectedCoin.rate || "";
            // document.getElementById("dollarAmount").value = `$${selectedCoin.rate || ""}`;
            // document.getElementById("cryptoQty").value = 1;
            document.getElementById("selectedCoinLogo").src = selectedCoin.logo;
            document.getElementById("selectedCoinLogo").classList.remove("hidden");

            toggleDropdown(false);
        }

        document.getElementById("nextStep").addEventListener("click", function() {
            const selectedCoin = document.getElementById("searchInput").value;
            if (!selectedCoin) {
                alert("Please select a cryptocurrency.");
                return;
            }

            // Update modal content
            /*
            document.getElementById("modalCoinLogo").src = document.getElementById("selectedCoinLogo").src;
            document.getElementById("modalCoinLabel").textContent = selectedCoin;
            document.getElementById("modalRate").textContent = document.getElementById("currentRate").value || "N/A";

            const note = document.getElementById("noteTextarea").value.trim();
            if (note) {
                document.getElementById("modalNote").classList.remove("hidden");
                document.getElementById("modalNoteText").textContent = note;
            } else {
                document.getElementById("modalNote").classList.add("hidden");
            }

            document.getElementById("modal").classList.remove("hidden");
            */
        });

        function closeModal() {
            document.getElementById("modal").classList.add("hidden");
        }

        // document.getElementById("addNote").addEventListener("change", function() {
        //     document.getElementById("noteTextarea").classList.toggle("hidden", !this.checked);
        // });

        // document.querySelectorAll(".crypto-btn").forEach(button => {
        //     button.addEventListener("click", function() {
        //         document.querySelectorAll(".crypto-btn").forEach(btn => btn.classList.remove("border-yellow-500")); // Remove border from others
        //         this.classList.add("border-yellow-500"); // Add border to selected button
        //         selectCrypto(this.dataset.coin);
        //     });
        // });


        // Make updateValues globally accessible
        function updateValues() {
            let cryptoQtyInput = document.getElementById("cryptoQty");
            // let dollarAmountInput = document.getElementById("dollarAmount");
            let currentRateInput = document.getElementById("currentRate");

            if (!cryptoQtyInput  || !currentRateInput) return;

            let qty = parseFloat(cryptoQtyInput.value) || 0;
            let currentRate = parseFloat(currentRateInput.value) || 1;

            // Disable for now currnecy conversion
            // if (document.activeElement === cryptoQtyInput) {
            //     let calculatedAmount = (qty * currentRate).toFixed(8);
            //     dollarAmountInput.value = `$${calculatedAmount}`;
            // } else if (document.activeElement === dollarAmountInput) {
            //     let amount = parseFloat(dollarAmountInput.value.replace(/[^0-9.]/g, "")) || 0; // Remove any non-numeric characters
            //     cryptoQtyInput.value = (amount / currentRate).toFixed(8);
            // }
        }

        document.addEventListener("DOMContentLoaded", function() {
            
            let cryptoQtyInput = document.getElementById("cryptoQty");
            let dollarAmountInput = document.getElementById("dollarAmount");
            let currentRateInput = document.getElementById("currentRate");

            // // Ensure $ is always present on focus and blur
            // dollarAmountInput.addEventListener("focus", function() {
            //     if (!this.value.startsWith("$")) {
            //         this.value = "$";
            //     }
            // });

            // dollarAmountInput.addEventListener("blur", function() {
            //     if (this.value === "$") {
            //         this.value = ""; // Clears empty $ sign when blurred
            //     }
            // });

            // dollarAmountInput.addEventListener("input", function() {
            //     // Remove any non-numeric characters except "." and digits
            //     let amount = this.value.replace(/[^0-9.]/g, "");

            //     // Ensure it starts with $
            //     this.value = "$" + amount;
            // });

            function selectCrypto(coinId) {
                fetchCryptoData().then(() => {
                    highlightSelectedButton(coinId);
                    updateCurrentRate(coinId);
                });
            }

            function updateCurrentRate(coinId) {
                let rateElement = document.querySelector(`[data-rate="${coinId}"]`);
                if (rateElement) {
                    let currentRate = parseFloat(rateElement.value) || 1;
                    currentRateInput.value = currentRate;

                    // Ensure updateValues() runs after current rate is set
                    setTimeout(updateValues, 100);
                }
            }

            // cryptoQtyInput.addEventListener("input", updateValues);
            // dollarAmountInput.addEventListener("input", updateValues);

            // Ensure fetchCryptoData is resolved before selecting BTC
            // fetchCryptoData().then(() => {
            //     selectCrypto("BTC"); // Preselect BTC on load
            //     highlightSelectedButton("BTC"); // Ensure BTC button has yellow border

            //     // Wait a bit to ensure current rate is populated, then update values
            //     setTimeout(updateValues, 100);
            // });

            // document.querySelectorAll(".crypto-btn").forEach(button => {
            //     button.addEventListener("click", function() {
            //         const coinId = this.getAttribute("data-coin");
            //         selectCrypto(coinId);
            //     });
            // });

            // Call updateValues() explicitly after a short delay in case rate isn't set yet
            // setTimeout(updateValues, 500);
        });

        // You can now call updateValues() anywhere:
        setTimeout(updateValues, 2000); // Example: Call it after 2 seconds


        function highlightSelectedButton(selectedCoinId) {
            // document.querySelectorAll(".crypto-btn").forEach(button => {
            //     if (button.getAttribute("data-coin") === selectedCoinId) {
            //         button.classList.add("border-yellow-400", "border-2");
            //     } else {
            //         button.classList.remove("border-yellow-400", "border-2");
            //     }
            // });
        }


        fetchCryptoData().then(() => {
            if (cryptoData["BTC"]) {
                selectCrypto("BTC");
            }
        });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('donation_form', 'donation_form_shortcode');
    
/**
 * Initialize Plugin
 */
function crypto_donation_init() {
    // Ensure files are available
    if (!file_exists(GET_WALLET_FILE) || !file_exists(GET_CURRENCIES_FILE)) {
        error_log('Required plugin files missing.');
    }
}

add_action('init', 'crypto_donation_init');

